/****************************************************************************
** Name:  ldasm86.h
**
** Description:  This is the low level 80386 disassembler routines
**
** $Log:   S:/tbird/mt2_amd/dad186/ldasm86.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:57:56   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 15:16:00   Judy
** Initial revision.
** 
**    Rev 1.0   25 May 1994 14:18:56   nghia
** Initial revision.
**
** $Header:   S:/tbird/mt2_amd/dad186/ldasm86.h_v   1.0   20 Mar 1998 10:57:56   Eric  $
**
** Copyright (C) 1994  Microtek International.  All rights reserved.
****************************************************************************/
#define _LDASM86_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define MAX_DISPLAY_LINES 4          /* Max lines displayed per instruction */

#define CODE_FIELD 14
#define OP_PFX_FIELD 8
#define OPRND_FIELD 40

#define MAX_DASM_TEXT (OP_PFX_FIELD*3)+(OPRND_FIELD*MAX_DISPLAY_LINES)+\
                    MAX_DISPLAY_LINES+3

/* Control codes for PutText routine */
#define PREFIX  0
#define OPCODE  1
#define OPRND   2


/* structure for control flags */
typedef struct {
      BOOLEAN ErrorOccured;                                 /* Error flag */
      BOOLEAN SegPfxSet   ;                       /* Segment prefix found */
      BOOLEAN OprndPfxSet ;                       /* Operand prefix found */
      BOOLEAN AddrPfxSet  ;
      BOOLEAN LockPfxSet  ;
      BOOLEAN RepnePfxSet ;
      BOOLEAN RepPfxSet   ;
      BOOLEAN Oprnd32     ;                      /* Operand_32 byte found */
      BOOLEAN Addr32      ;                      /* Address_32 byte found */
      BOOLEAN ModrmFetched;                        /* modr/m byte fetched */
      BOOLEAN SibFetched  ;                           /* sib byte fetched */
      BOOLEAN PtrOpCode   ;
      BOOLEAN JmpOpCode   ;
      BOOLEAN Wait387     ;
   } FLAGS;

#define BYTE_SIZE ((U8) 1)
#define WORD_SIZE ((U8) 2)
#define LONG_SIZE ((U8) 4)
#define NIBBLE_SIZE ((U8) 5)

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/******************************** E O F ************************************/

