/****************************************************************************
**
**  Name:  libmai16.c
**
**  Description:
**     Contains the main entry/exit point of the Disassembly/Assembly/
**     Dequeuer DLL (DASM16.DLL).
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/dad186/libmai16.cpv  $
** 
**    Rev 1.0   20 Mar 1998 10:53:22   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 15:13:52   Judy
** Initial revision.
** 
**    Rev 1.1   08 Apr 1993 10:30:34   doug
** change dll to proper name
** 
**    Rev 1.0   08 Apr 1993 09:42:56   doug
** Initial revision.
** 
**    Rev 1.1   30 Mar 1993 16:13:00   ernie
** (for mindy): added symbol support
** 
**    Rev 1.0   12 Mar 1993 09:51:18   mindy
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/dad186/libmai16.cpv   1.0   20 Mar 1998 10:53:22   Eric  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _ASM16_
#include "asm16.h"
#endif

#ifndef _DADDEF16_
#include "daddef16.h"
#endif

/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
HANDLE hLib;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of DASM16.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {

    RETCODE err;

    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);
    hLib = hInstance;
    ErrInitDLL(MODULE_DISASSEMBLY,"dasm16.dll");
    err = AsmInit();
    if (GOOD != err) ErrDisplayError(err, FORCE_POPUP);
    err = DadInit();
    if (GOOD != err) ErrDisplayError(err, FORCE_POPUP);
    return(TRUE);
}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**	Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
void FAR PASCAL WEP(int nParam) {

   switch(nParam) {
      case WEP_SYSTEMEXIT:
         /* System shutdown in progress. Respond accordingly */
         break;
      case WEP_FREE_DLL:
         /* The DLL use count is 0 */
         break;
      default:
         /* Undefined value - ignore */
         break;
   }
   return(TRUE);
}
#endif

/******************************** E O F ***********************************/
