/***************************************************************************
**
**    Name:    daddef86.h
**
**    Description:
**        Internal definitions for the DAD server.
**
**    $Log:   S:/tbird/mt2_amd/dasm/daddef86.h_v  $
** 
**    Rev 1.0   20 Mar 1998 11:28:38   Eric
** Initial revision.
** 
**    Rev 1.1   03 Apr 1997 15:06:30   Judy
** No change.
** 
**    Rev 1.0   16 Dec 1996 16:43:34   Judy
** Initial revision.
** 
**    Rev 1.7   18 Oct 1994 10:41:54   steve
** changed data type of the first parameter in AsmInst()
** 
**    Rev 1.6   11 Oct 1994 11:17:34   ernie
** Changed DAD_STATE cache members.
** 
**    Rev 1.5   07 Oct 1994 13:32:32   steve
** changed MAX_CODE_LENGTH to be 16
** 
**    Rev 1.4   20 Sep 1994 11:52:36   marilyn
** Updated DAD struct to contain its own cache.
** 
**    Rev 1.3   26 Jul 1994 09:07:00   steve
** Kevin's ASM changes for 386 build 9
** 
**    Rev 1.2   13 Jun 1994 18:42:54   marilyn
** Modified external interface.  However, this interface is NOT
** exported in the def file and does not appear to currently be in use.
** 
**    Rev 1.1   03 Jun 1994 08:49:52   steve
** Kevin's changes for pv 386 build 3
** 
**    Rev 1.0   25 May 1994 14:18:52   nghia
** Initial revision.
**
**    $Header:   S:/tbird/mt2_amd/dasm/daddef86.h_v   1.0   20 Mar 1998 11:28:38   Eric  $
*****************************************************************************/

#define _DADDEF86_


                        /********************
                        **                 **
                        **  Includes       **
                        **                 **
                        ********************/

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _SDTEMPL_
#include "sdtempl.h"
#endif

#ifndef __STRING_H_
#include <string.h>
#endif

#ifndef _PDASM86_
#include "pdasm86.h"
#endif

                        /**********************
                        **                   **
                        **  Definitions      **
                        **                   **
                        **********************/

#define UNSIZED         0
#define TB              1
#define TW              2
#define TL              4
#define TQ              8
#define TS              16
#define TD              32
#define TX              64
#define TP              128
#define TWL             6
#define TBW             3
#define TBWL            7
#define TBWLSDXP        247
#define TWLQ            14
#define LINE            0x10

#define MAX_MNEMONIC_SIZE  16
#define MAX_CODE_LENGTH    16
#define MAX_NUM_INST       265
#define MAX_NUM_CO_INST    123
#define MAX_INST_PER_LINE  6     /* bytes */
#define MAX_LINE_LENGTH    256u   /* bytes */
#define MAX_INST_PER_BUFFER 250u  /* max insts per 64KB buffer */
#define MAX_LINE_PER_INST  3
#define MAX_OPSTRING       256
#define MAX_OPERAND        30

#define FULL_EXTENSION  0x0100
#define BRIEF_EXTENSION 0x0000

// Cache Buffer
#define PAGE_SIZE 256
#define MAX_INST_SIZE 16

typedef struct dadstate {
    struct dadstate FAR *next;  // keep the sessions in a linked list
    DESCRIPTOR startAddr;
    ADDR_OP_SIZE addrOpSize;
    PMODE  mode;
    DESCRIPTOR cacheAddress;    // address range of cached data
    U8 memCacheBuf[PAGE_SIZE];
} DAD_STATE;

                    /**************************
                    **                       **
                    **   Prototypes          **
                    **                       **
                    **************************/


RETCODE IsCallOrRTS(DAD_STATE FAR *dasmState, DESCRIPTOR calledAddr,
                    CALL_TYPE *type);

RETCODE GetDasmInst(DAD_STATE FAR* dasmState, U16 numInst, LPSTR *buffer,
                    BOOLEAN DasmSymbol);

RETCODE GetDasmInstNoAlloc(DAD_STATE FAR *dasmState, LPSTR buffer,
                    BOOLEAN DasmSymbol);

RETCODE CheckDasmInst(DESCRIPTOR startAddr,DAD_STATE FAR *dasmState,
                    BOOLEAN DasmSymbol, U8 *instLen, BOOLEAN *instValid);

RETCODE GetDasmInstByLine(DAD_STATE FAR *dasmState, U16 *lines,
                    LPSTR *buffer, BOOLEAN DasmSymbol);

S8      FindString(U8 Count, CHAR **Source, CHAR *Search);

RETCODE AsmInst(DESCRIPTOR id, LPSTR inInst, LPSTR *outInst, 
                    LPWORD numBytes, LPSTR OpCode);

RETCODE GetBits(U16 Value, U8 BitStart,U8 Length);

RETCODE DummyGetAsmLine(LPSTR buffer);

RETCODE SendCliMessage(HANDLE cliHandle, LPSTR msgPtr);

RETCODE IsTransfer(DAD_STATE FAR *dasmState,DESCRIPTOR transferAddr,
      TRANSFER_TYPE *transfer);

/*********************************** E O F ***********************************/
