/****************************************************************************
**
**  Name:  dq86.c
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _DAD_SERVER_
#include "dasm.h"
#endif

#ifndef _DADDEF86_
#include "daddef86.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef _DQ186_
#include "dq186.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _TRACE_
#include "trace.h"
#endif

#ifndef __STDLIB_H_
#include <stdlib.h>
#endif


                       /****************************
                        *                          *
                        *     EXTERNALS            *
                        *                          *
                        ****************************/

extern U8 *SymSet[];

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/


extern HANDLE  cliServerHandle;
STATIC DESCRIPTOR cliDqId=0;

                        /***************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ***************************/

                        /***************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ***************************/

/****************************************************************************
**
**  Name:  DadDqOpen
**
****************************************************************************/
RETCODE EXPORT DadDqOpen(DESCRIPTOR FAR *id, DESCRIPTOR traceId) {

   DQ_STATE FAR *dqState;
   RETCODE err;
   U32 numFrames;

   if ((dqState = (DQ_STATE FAR *)TMalloc(sizeof(DQ_STATE))) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;

   *id = (DESCRIPTOR)dqState;
   dqState->DqFilter   = NO_FILTER;
   dqState->Search     = OFF;
   dqState->Offset     = 0;
   dqState->traceId    = traceId;

   if((err=TrcNumFramesGet(dqState->traceId, &numFrames))!=GOOD)
      return(err);
   if( !numFrames ) {
      TFree((LPSTR)dqState);
      return(ER_DQ_NO_FRAMES_AVAILABLE); /* no frames just get out! */
   }

   if ((dqState->dqFrame = (FRAME_TYPE FAR *)TMalloc(sizeof(FRAME_TYPE)))
         == NULL)
      return ER_OUT_OF_MEMORY;
   if ((err = AdrCreateAddress(&dqState->dqFrame->frameAddr)) != GOOD)
      return err;
   if ((err = AdrSetAddrOffset(dqState->dqFrame->frameAddr,0)) != GOOD)
      return err;
   dqState->dqFrame->frameNo = 0;
   dqState->dqFrame->synched = FALSE;
   dqState->dqFrame->frameValid = FALSE;
   //CreateDqStateTable(*id);
   //Eric 2/3/98 for Bug ID#199
   if((err=CreateDqStateTable(*id)) != GOOD) {
      return(ER_DQ_NO_FRAMES_AVAILABLE); /* no frames just get out! */
   }
   //eof Eric 2/3/98

   return(GOOD);
}

/****************************************************************************
**
** Name:  DadSetDqOffset
**
****************************************************************************/
RETCODE EXPORT DadSetDqOffset(DESCRIPTOR id, U16 offset) {

   if (id == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   ((DQ_STATE FAR *)id)->Offset = offset;
   return(GOOD);
}

/****************************************************************************
**
**  Name:  DadGetDqOffset
**
****************************************************************************/
RETCODE EXPORT DadGetDqOffset(DESCRIPTOR id, U16 FAR *offset) {

   if (id == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   *offset = ((DQ_STATE FAR *)id)->Offset;
   return(GOOD);
}

/****************************************************************************
**
** Name:  DadDqClose
**
****************************************************************************/
RETCODE EXPORT DadDqClose(DESCRIPTOR id) {
   DQ_STATE FAR  *dqState;
   RETCODE err;


   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   if ((err = AdrDestroyAddress(dqState->dqFrame->frameAddr)) != GOOD)
      return err;
   if ((err = TFree((LPSTR)dqState->dqFrame)) != GOOD)
      return err;
   if ((err = TFree((LPSTR)dqState)) != GOOD)
      return err;
   return(GOOD);
}

/***************************************************************************
**
**  DqCliOpen
**
**************************************************************************/
RETCODE DqCliOpen(void) {
   RETCODE err;
   DESCRIPTOR traceId;

   if((err=TrcGetCliId(&traceId))!=GOOD) return(err);
   if((err=DadDqOpen(&cliDqId,traceId)) != GOOD) return(err);
   return(err);
}

/***************************************************************************
**
**  DadCliDqOffset
**
**************************************************************************/
RETCODE EXPORT DadCliDqOffset(LPSTR cmdString, U32 argc, U32 argv[]) {

   U16 offset;
   S8 resultBuff[128];
   RETCODE err;
   S8 *endptr;

   if (argc > 2) return (ER_CLI_SYNTAX);
   if( !cliDqId ) {
      if((err=DqCliOpen())!=GOOD) return(err);
   }
   if( argc == 2 ) {
      offset = (U16)strtoul(&cmdString[(U16)argv[1]],&endptr,16);
      if((err=DadSetDqOffset(cliDqId,offset))!=GOOD) return(err);
   }
   if( (err=DadGetDqOffset(cliDqId,&offset)) != GOOD ) return(err);
   wsprintf(resultBuff,"dq offset: %x", offset);
   return(SendCliMessage(cliServerHandle,resultBuff));
}

/*************************************************************************
**
** DadCliGetDqInst
**
***************************************************************************/
RETCODE EXPORT DadCliGetDqInst(LPSTR cmdString, U32 argc, U32 argv[]) {
   RETCODE err;
   LPSTR buffer;
   S32 end,start;
   S8 *endptr;
   U16 len;
   U32 numInst = 1;
   DQ_STATE FAR *dqState;
   DESCRIPTOR *addrDesc=NULL;

   if (!cliDqId) {
      if((err=DqCliOpen())!=GOOD)
         return(err);
   }
   if (argc == 2)
      numInst = strtoul(&cmdString[(U16)argv[1]],&endptr,16);
   if ((err=DadForwardDqInst(cliDqId,numInst,&start,&end,&buffer,&len,
                             &addrDesc))!=GOOD)
      return(err);

   if((dqState=(DQ_STATE FAR *)cliDqId)==NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
//   if((err=TrcReadFrameSet(dqState->traceId,end+1))!=GOOD) return(err);
   
   err = SendCliMessage(cliServerHandle,buffer);
   TFree(buffer);
   return(err);
}
/**************************** E O F ***************************************/
