/***************************************************************************
**
** Name:  ldtext86.h
**
** Desciption:  Function prototypes for ldtext86.c
**
** $Log:   S:/tbird/mt2_amd/dasm/ldtext86.h_v  $
** 
**    Rev 1.0   20 Mar 1998 11:28:40   Eric
** Initial revision.
** 
**    Rev 1.1   03 Apr 1997 15:06:36   Judy
** No change.
** 
**    Rev 1.0   16 Dec 1996 16:43:38   Judy
** Initial revision.
** 
**    Rev 1.0   25 May 1994 14:18:58   nghia
** Initial revision.
**
** $Header:   S:/tbird/mt2_amd/dasm/ldtext86.h_v   1.0   20 Mar 1998 11:28:40   Eric  $
**
** Copyright (C) 1994  Microtek International.  All rights reserved.
**
****************************************************************************/

#define _LDTEXT86_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _PDASM86_
#include "pdasm86.h"
#endif

                       /****************************
                        *                          *
                        *       DEFINITIONS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**  InitText
**  purpose: Sets up temporary buffer and pointers
**
**  MemData(in):
**  TextBuffer(out): address of output text buffer
****************************************************************************/
RETCODE InitText(CHAR *MemData, CHAR *TextBuffer);

/****************************************************************************
**  PutText
**  purpose:  puts formatted text data in output buffer
**
**  Prefix (in):
**  Text  (out):
****************************************************************************/
RETCODE PutText(U8 Prefix, CHAR *Text);

/****************************************************************************
**  PutData
**  purpose: puts formatted hex data into output buffer
**
**  Size (in):  Size of data item
**  Code (out): pointer to data item
****************************************************************************/
RETCODE PutData(U8 Size, VOID *Code);

/****************************************************************************
**  dbError
**  purpose: return errors as 'db' strings
**
**  Info (in):
****************************************************************************/
RETCODE dbError(DASM_INFO *Info);

/******************************** E O F ************************************/

 