/****************************************************************************
**
**  Name:  libmai86.c
**
**  Description:
**     Contains the main entry/exit point of the Disassembly/Assembly/
**     Dequeuer DLL (DASM86.DLL).
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/dasm/libmai86.c_v  $
** 
**    Rev 1.0   20 Mar 1998 11:28:38   Eric
** Initial revision.
** 
**    Rev 1.1   03 Apr 1997 15:06:30   Judy
** No change.
** 
**    Rev 1.0   16 Dec 1996 16:43:34   Judy
** Initial revision.
** 
**    Rev 1.0   25 May 1994 14:18:46   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/dasm/libmai86.c_v   1.0   20 Mar 1998 11:28:38   Eric  $
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
HANDLE hLib;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

extern RETCODE DadInit(VOID);

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of DASM32.DLL
**
** Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {

    RETCODE err;

    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);
    hLib = hInstance;
    ErrInitDLL(MODULE_DISASSEMBLY,"dasm86.dll");

    err = DadInit();
    if (GOOD != err)
        ErrDisplayError(err, FORCE_POPUP);
    return(TRUE);
}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
** Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
void FAR PASCAL WEP(int nParam) {

   switch(nParam) {
      case WEP_SYSTEMEXIT:
         /* System shutdown in progress. Respond accordingly */
         break;
      case WEP_FREE_DLL:
         /* The DLL use count is 0 */
         break;
      default:
         /* Undefined value - ignore */
         break;
   }
   return(TRUE);
}
#endif

/******************************** E O F ***********************************/
