/***************************************************************************
**
**  Name:  dgtlib.h
**
**  Description:
**     Michelle library routines.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/mt2_amd/diag_amd/dgtlib.h_v  $
** 
**    Rev 1.0   20 May 1998 10:39:24   Eric
** Initial revision.
** 
**    Rev 1.0   14 Jan 1997 10:39:30   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 16:11:32   jacky
** Get file from ATL. V1.3
** 
** 
**  $Header:   S:/tbird/mt2_amd/diag_amd/dgtlib.h_v   1.0   20 May 1998 10:39:24   Eric  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

#define _DGT_LIB_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _DGT_BASE_TYPES_
#include "dgttypes.h"
#endif

                       /****************************
			*                          *
			*     LOCAL DEFINITIONS    *
			*                          *
			****************************/
#define IncreaseEven(x)  if ((x) % 2)  (x)++
#define ReduceEven(x)    if ((x) % 2)  (x)--
#define IncreaseQuad(x)  if ((x) % 4)  (x) = (((x) >> 2) << 2) + 4
#define ReduceQuad(x)    if ((x) % 4)  (x) = ((x) >> 2) << 2
#define HighWord(x)      ((U16)((U32)(x) >> 16))
#define LowWord(x)       ((U16)(x))
#define HighByte(x)      ((U8)((U16)(x) >> 8))
#define LowByte(x)       ((U8)(x))
#define LinearToPhysical(x)   ((U32)HighWord(x) << 4) + LowWord(x)
#define CheckBrOver()    (brOver)
#define maskBit          0x0001
#define maskBit2         0x0003

#define OutEnd() \
           outputStream[outputStreamLen++] = 0x00

#define OutLength(len) \
           outputStream[outputStreamLen++] = len

/****************************************************************************
**
**  OutData
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutData(U8 dataLen, VOID *data, BOOLEAN lenFlag);

/****************************************************************************
**
**  OutMultipleData
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutMultipleData(U8 dataLen, VOID *data, U8 times);

/****************************************************************************
**
**  AddSegAddr
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
U32 AddSegAddr(U32 addr, U32 len);

/****************************************************************************
**
**  OutputStatus
**
**  Description: output the status of executive FW to outputStream
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutputStatus(STATUS status,U8 endData);

/***************************************************************************
**
**  OutputErrorMessage
**
**  Description:
**
**  Parameters:
**     input:
**     output:
**
****************************************************************************/
VOID OutputErrorMessage(VOID *errorData, U8 len);

/****************************************************************************
*
*  GetBits
*
*  Description:
*
*  Parameters:
*    input:
*      value     :
*      bitStart  :
*      length    :
*    output:
*      return value :
*
*****************************************************************************/
U16 GetBits(U16 value, U8 bitStart,U8 length);

/****************************************************************************
*
*  BitNo
*
*  Description:
*
*  Parameters:
*    input:
*      sizeNo:
*    output:
*      return:
*
*****************************************************************************/
U8 BitNo(U8 sizeNo);

/****************************************************************************
*
*  BitNo
*
*  Description:
*
*  Parameters:
*    input:
*      sizeNo:
*    output:
*      return:
*
*****************************************************************************/
VOID GetHWMode(void);

/****************************************************************************
*
*  BitNo
*
*  Description:
*
*  Parameters:
*    input:
*      sizeNo:
*    output:
*      return:
*
*****************************************************************************/
VOID SwitchFlash(void);

/******************************** E O F ***********************************/

