/****************************************************************************
**
**  Name:  dgtmain.c
**
**  Description:
**     Michelle main(base) function routine. Include the control procedure.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/mt2_amd/diag_amd/dgtmain.c_v  $
** 
**    Rev 1.1   29 Jul 1998 14:05:44   Eric
** Add TEST_SEQ_RAM function.
** 
**    Rev 1.0   20 May 1998 10:39:24   Eric
** Initial revision.
** 
**    Rev 1.2   22 Jan 1997 09:13:28   gene
** 
**    Rev 1.1   16 Jan 1997 14:29:46   gene
** modified main(), added a instruction "mov bp,sp" to change sp value
** 
**    Rev 1.0   14 Jan 1997 10:39:22   gene
** Initial revision.
** 
**    Rev 1.0   11 Dec 1996 15:06:56   jacky
** MCE16C+MTAT
** 
**    Rev 1.0   10 May 1996 16:11:36   jacky
** Get file from ATL. V1.3
**
**
**  $Header:   S:/tbird/mt2_amd/diag_amd/dgtmain.c_v   1.1   29 Jul 1998 14:05:44   Eric  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

           /****************************
            *                          *
            *       INCLUDE FILES      *
            *                          *
            ****************************/

#ifndef _DGT_BASE_TYPES_
#include "dgttypes.h"
#endif

#ifndef _DGT_LIB_
#include "dgtlib.h"
#endif

#ifndef _DGT_GLOBAL_
#include "dgtglb.h"
#endif

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#ifndef _COMM_DATA_
#include "commdata.h"
#endif

#ifndef _DGT_LLFW_
#include "dgtllfw.h"
#endif

#ifndef _DIAGMCE_H
#include "diagmce.h"
#endif

#ifndef _TRCDIAG_
#include "trcdiag.h"
#endif

#ifndef _TRCLIB_
#include "trclib.h"
#endif

#ifndef _TRCERROR_
#include "trcerror.h"
#endif

#include <conio.h>
#include <string.h>

U32 memSize;
extern BOOLEAN mtatExist;
//extern U16 errorFlag; //Eric remove 5/11/98
//extern mapBuf[];      //Eric remove 5/11/98
           /****************************
            *                          *
            *     LOCAL DEFINITIONS    *
            *                          *
            ****************************/
#define     MCR     0XF004
#define     P82552B 0XF141

            /****************************
             *                          *
             *    EXTERNAL VARIABLES    *
             *                          *
             ****************************/

            /****************************
             *                          *
             *     LOCAL PROTOTYPES     *
             *                          *
             ****************************/
STATUS InitFwControl(VOID);
VOID InitDataBase(VOID);
RETCODE ReceiveInputCommand(VOID);
RETCODE DispatchCommand(U16 *ac, U8 *av[], U8 *cmdStream);
RETCODE ProcessCommand(U16 ac, U8 *av[]);
RETCODE TestBCBus(COMMAND_ID comID,U32 *errData,U8 *retID) ;
RETCODE TestTrcBufBus(COMMAND_ID cmdID,U32 *errData,U8 *retID) ;

            /****************************
             *                          *
             *      EXECUTABLE CODE     *
             *                          *
             ****************************/

#define DMA1SL      0xFFD0
#define DMA1SH      0xFFD2
#define DMA1DL      0xFFD4
#define DMA1DH      0xFFD6
#define DMA1TC      0xFFD8
#define DMA1CW      0xFFDA
#define MK_FP(seg, ofs) ((VOID _far *) ((((U32) seg) << 16) | ((U16) ofs)))
#define FP_SEG(fp) (*((unsigned _far *)(fp)+1))
#define FP_OFF(fp) (*((unsigned _far *)(fp)))

VOID DgtReturnNormal(VOID) {
U8 brokeData[10],lp;
U32 dataAddress,tempAddress;

   tempAddress = *(U32*)brokeData; // gene
   dataAddress = (U16)(tempAddress);
   dataAddress += (tempAddress >> 16) << 4;

 //outp(DMA1SL,0x400);
 //outp(DMA1SH,0);
 //outp(DMA1DL,LowWord(dataAddress));
 //outp(DMA1DH,HighWord(dataAddress));
 //outp(DMA1TC,10);
 //outp(DMA1CW,0xB626);
 //
 //for (lp =0; lp < 10; lp++)
 //   brokeData[lp] = (U8)(~brokeData[lp]);

   for (lp =0; lp < 10; lp++)
      brokeData[lp] = 0;

   outp(P82552B,((U8)inp(P82552B) | 0X80)); //set WRPRAM=H to write Program RAM
   outp(DMA1SL,LowWord(dataAddress));
   outp(DMA1SH,HighWord(dataAddress));
   outp(DMA1DL,0x400);
   outp(DMA1DH,0);
   outp(DMA1TC,10);
   outp(DMA1CW,0xB626);
   outp(P82552B,((U8)inp(P82552B) & 0X7F)); //set WRPRAM=L to write protected Program RAM

   FwReset();
}

/***************************************************************************
**
**  main()
**
**  Description: Michelle main routine, with its linear control process
**               sequence. We always think this fw process with one single
**               task.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
****************************************************************************/
U16 argc;
U8 *argv[10];
RETCODE errNo;
U32 retAddress;
STATUS initialStatus;
main() {
   /*Eric remove 5/12/98
   _asm{
        mov sp,1000
   };
   retAddress = DataMemoryTest();
   _asm{
       push ax
       mov ax,[0ffeh]
       mov ss:[0fffeh],ax
       pop ax
       mov sp,0fffeh
       mov bp,sp
   };
   */
   initialStatus = GOOD;
   InitDataBase(); /* all data sets setting or default value. */
   initialStatus = InitFwControl(); // Initial hardware and firmware
   //if (retAddress) initialStatus |= DATA_MEMORY_FAIL;//Eric remove 5/12/98
   // copy status and retAddress to return data


   while (TRUE) {
      ReceiveStream(); /* read the input commands stream. */
      DispatchCommand(&argc, argv, commandStream); /* parser the input commands stream. */
      errNo = ProcessCommand(argc,argv); /* case switching the command tasks */
      if (errNo == DIAGNOSTIC_END)  {
//         if (mtatExist) EndDiagTest();
         TransmitStream();
         outp(MCR,0);
         break;
      }
      if (errNo == RESTART) {
        TransmitStream();
        FwReset();
        return(GOOD);
      }
      else
        if (errNo != OK) OutputStatus(errNo,ON);
      TransmitStream();
//      outp(MCR,0);
   }
   //DgtReturnNormal();//Eric remove 5/12/98
   return(GOOD);
}

/***************************************************************************
**
**  DgtGetID
**
**  Description: Michelle setup-group routine, to get the emulator's ID to
**               make sure that driver program has connected to a correct
**               emulator.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**        return data -- "length" + "ID"
**
****************************************************************************/
VOID DgtGetID(VOID) {
U8 dataLen;

   OutputStatus(GOOD,OFF);
   dataLen = MAX_ID;
   // get probe,trace,cp board info from llfw and save to idData
   OutData(dataLen,idData,ON);
 //outputStream[outputStreamLen++] = dataLen;
 //memcpy(&outputStream[outputStreamLen],idData,dataLen);
 //outputStreamLen += dataLen;
   OutEnd();
 //outputStream[outputStreamLen++] = 0x00; /* Output stream length */
}

STATUS InitFwControl(VOID) {
STATUS status;

   status = GOOD;
   idData[0] = 'D';     // This is a diagnostic firmware.
   idData[1] = 0x10;    // diagnostic firmware version 1.1.
   InitCpPort();
   //if (errorFlag) status |= MCE_8255_FAIL; //Eric remove 5/11/98
// InitialTraceMachine(MODE_16BIT);
// ProgramXlxForDiag(&xlxDone);
   InitialMTAT2();
   if (mtatExist) {
      status |= MTAT_EXIST;
//      if (xlxDone & 0x100) status |= TMAN_EXIST;
//      if (xlxDone & 0x10) status |= EREC1_EXIST;
//      if (xlxDone & 0x1) status |= EREC2_EXIST;
   }
   InitEpPort();
   //if (errorFlag) status |= DOWNLOAD_4003_FAIL; //Eric remove 5/11/98
   //InitialMceDiag();//Eric removed 5/11/98
   if (memSize = ((U32)InitEm() & 0xff) * 0x80000L) memSize--;
   EnEmDisViol();
   return(status);

}

VOID InitDataBase(VOID) {

   noUse = C_OFF = 0;
   C_ON = 1;
   noUseByte = 0;
}

RETCODE ReceiveInputCommand(VOID) { /* Receive data from communication port */
   ReceiveStream();
   return(GOOD);
}

/***************************************************************************
**
**  DispatchCommand
**
**  Description: Dispath the input command stream.
**         Note: Please refer input command protocol format.
**
**  Parameters:
**     input:
**        commandStream : input command stream.
**     output:
**        ac      : argument counter.
**        av      : argument position.
**
****************************************************************************/
RETCODE DispatchCommand(U16 *ac, U8 *av[], U8 *cmdStream) {

   *ac = 1;   /* Initial argument. */
   av[0] = cmdStream;
   cmdStream++;
   while ((*cmdStream) && (*cmdStream != 0xff)){
      av[(*ac)++] = cmdStream;
      cmdStream += *cmdStream + 1;
   }
   return(GOOD);
}

/***************************************************************************
**
**  ProcessCommand
**
**  Description: Idnetidy then command ID and call FW function.
**
**  Parameters:
**     input:
**        commandStream : input command stream.
**        ac            : argument counter.
**        av            : argument position.
**     output:
**        outputStream  : the message of executive result.
**
****************************************************************************/
RETCODE ProcessCommand(U16 ac, U8 *av[]) {
STATUS status;
U16 dataLen;
U32 data[10],errData=0;
U8 retID;//Eric remove 5/11/98 structLen,
LOOP_VAR lp;
/* Eric remove 5/11/98
ErrorMceOpenShort mceOpenShort;
ErrorMcePullhigh mcePullhigh;
ErrorMceMemTest  mceMemTest ;
U8 TrMceConnFg=0;
*/
//ErrorMceConnTest mceConnTest;

   for (lp = 1; lp < (LOOP_VAR)ac; lp++) {
      dataLen = *(av[lp]);
      switch (dataLen) {
         case 1 : /* byte */
            data[lp] = *(U8 *)(av[lp]+1);
            break;
         case 2 : /* word */
            data[lp] = *(U16 *)(av[lp]+1);
            break;
         case 3 : /* 3 byte */
            data[lp] = *(U32 *)(av[lp]+1) & 0x00ffffff;
            break;
         case 4 : /* long */
            data[lp] = *(U32 *)(av[lp]+1);
            break;
         case 0xff : /* more than 255 */
            data[lp] = *(U16 *)(av[lp]+1);
            break;
         default : /* do nothing */
            data[lp] = 0;
            break;
      }
   }

   if (!ac) return(FALSE);

   switch ((COMMAND_ID)(*av[0])) {
      case GET_ID :
         DgtGetID();
         break;
      case INITIAL_TEST :
         //OutputStatus(initialStatus,OFF);//Eric remove 5/12/98
         OutputStatus(GOOD,OFF);
         OutData(4,&retAddress,ON);
         OutEnd();
       //outputStream[outputStreamLen++] = 4;
       //memcpy (&outputStream[outputStreamLen+1],&retAddress,4);
       //outputStreamLen += 4;
       //outputStream[outputStreamLen++] = 0x00; /* Output stream length */
         break;
      case MCE_OPEN_SHORT_TEST :
         /* Eric remove 5/11/98
         MceOpenShortTest(&mceOpenShort);
         structLen = sizeof(mceOpenShort);
         OutputErrorMessage((void *)&mceOpenShort,structLen);
         */
         break;
      case MCE_PULL_HIGH_TEST :
         /* Eric remove 5/11/98
         McePullhighTest(&mcePullhigh);
         structLen = sizeof(mcePullhigh);
         OutputErrorMessage((void *)&mcePullhigh,structLen);
         */
         break;
      case MCE_MAP_TEST :
         /* Eric remove 5/11/98
         if (MapTest()) {
            OutputStatus(!GOOD,ON);
            break;
         }
         else OutputStatus(GOOD,ON);
         mapBuf[0] = 0xaa55; // set map data to map buffer 
         InitMapCtr();
         MapSet(0x0470,0xff,0x80);
         MapSet(0x0570,0x7f,0);
         MapSet(0x0670,0x17f,0x100);
         MapSet(0x0770,0x1ff,0x180);
         SetMapTbl();
         */
         break;
      case MCE_MEMORY_TEST :
         /* Eric remove 5/11/98
         if (memSize > 0) {
            outp(0xf200,0xad);
            MceMemoryTest(memSize,&mceMemTest);
            outp(0xf200,0x7f);
            if (mceMemTest.MemoryError) {
               OutputStatus(mceMemTest.MemoryError,OFF);
               structLen = sizeof(mceMemTest.address);
               OutData(structLen,&mceMemTest,ON);
               OutEnd();
             //outputStream[outputStreamLen++] = structLen;
             //memcpy (&outputStream[outputStreamLen+1],&mceMemTest.address,structLen);
             //outputStreamLen += structLen;
             //outputStream[outputStreamLen++] = 0x00;
            }
            else OutputStatus(mceMemTest.MemoryError,ON);
         }
         else OutputStatus(NO_EMM,ON);
         */
         break;
      case MCE_CONNECT_TEST :
//         status = MceConnectorTest(&mceConnTest);
//         dataLen = sizeof(mceConnTest);
//         OutputStatus(status,OFF);
//         outputStream[outputStreamLen] = 96;
//         memcpy (&outputStream[outputStreamLen+1],&mceConnTest,dataLen);
//         outputStreamLen += (dataLen+1);
//         outputStream[outputStreamLen++] = 0x00; /* Output stream length */
//         outputStream[outputStreamLen] = 48;
//         if ( !TrMceConnFg ) {
//            memcpy (&outputStream[outputStreamLen+1],&mceConnTest,dataLen/2);
//            outputStreamLen += (dataLen/2+1);
//            outputStream[outputStreamLen++] = 0x00; /* Output stream length */
//         }
//         else {
//            memcpy (&outputStream[outputStreamLen+1],&mceConnTest[(dataLen/2)],dataLen/2);
//            outputStreamLen += (dataLen/2+1);
//            outputStream[outputStreamLen++] = 0x00; /* Output stream length */
//         };
         OutputStatus(GOOD,ON);
         break;
      case TEST_BC_RDATA_BUS :
      case TEST_BC_SDATA_BUS :
      case TEST_BC_TDATA_BUS :
      case TEST_BC_UDATA_BUS :
      case TEST_BC_VDATA_BUS :
      case TEST_BC_WDATA_BUS :
      case TEST_BC_RADDR_BUS :
      case TEST_BC_SADDR_BUS :
      case TEST_BC_TADDR_BUS :
      case TEST_BC_UADDR_BUS :
      case TEST_BC_VADDR_BUS :
      case TEST_BC_WADDR_BUS :
         status = TestBCBus((COMMAND_ID)(*av[0]),&errData,&retID);
         OutputStatus(status,OFF);
         OutData(4,&errData,ON); 
         //OutData(1,&retID,ON);   //Eric remove 5/13/98
         OutEnd();
         break;
      case TEST_TB_RSDATA_BUS :
      case TEST_TB_TUDATA_BUS :
      case TEST_TB_TPDATA_BUS :
      case TEST_TB_VWDATA_BUS :
      case TEST_TB_TSDATA_BUS :
      case TEST_TB_EVDATA_BUS :
      case TEST_TB_RSADDR_BUS :
      case TEST_TB_TUADDR_BUS :
      case TEST_TB_TPADDR_BUS :
      case TEST_TB_VWADDR_BUS :
      case TEST_TB_TSADDR_BUS :
      case TEST_TB_EVADDR_BUS :
         status = TestTrcBufBus((COMMAND_ID)(*av[0]),&errData,&retID) ;
         OutputStatus(status,OFF);
         OutData(4,&errData,ON); 
         //OutData(1,&retID,ON);   //Eric remove 5/13/98
         OutEnd();
         break;
      case TEST_SEQ_RAM :
         status = TestSeqRAM();
         //OutputStatus(status,ON);
         OutputStatus(status,OFF);
         OutData(4,&errData,ON); 
         break;
      case GET_HW_MODE :
         GetHWMode();
         break;
      case SWITCH_FLASH:
         SwitchFlash();
         return RESTART;
         break;
      case REPEAT_DIAG :
         OutputStatus(GOOD,ON);
         TransmitStream();
         outp(MCR,0);
         FwReset();
      case END_DIAG :
         OutputStatus(GOOD,ON);
         return(DIAGNOSTIC_END);
      default :
         OutputStatus(COMMAND_ERROR,ON);
   } /* end switch *data[0]. */
   return(GOOD);
}

RETCODE TestBCBus(COMMAND_ID cmdID,U32 *errData,U8 *retID) {
//   RETCODE status;

   *retID = 0;
   switch (cmdID) {
   case TEST_BC_RDATA_BUS :
      return(TestRportDataBus(errData));
   case TEST_BC_SDATA_BUS :
      return(TestSportDataBus(errData));
   case TEST_BC_TDATA_BUS :
      return(TestTportDataBus(errData));
   case TEST_BC_UDATA_BUS :
      return(TestUportDataBus(errData));
   case TEST_BC_VDATA_BUS :
      return(TestVportDataBus(errData));
   case TEST_BC_WDATA_BUS :
      return(TestWportDataBus(errData));
   case TEST_BC_RADDR_BUS :
      return(TestRportAddrBus(errData));
   case TEST_BC_SADDR_BUS :
      return(TestSportAddrBus(errData));
   case TEST_BC_TADDR_BUS :
      return(TestTportAddrBus(errData));
   case TEST_BC_UADDR_BUS :
      return(TestUportAddrBus(errData));
   case TEST_BC_VADDR_BUS :
      return(TestVportAddrBus(errData));
   case TEST_BC_WADDR_BUS :
      return(TestWportAddrBus(errData));
   }
}

RETCODE TestTrcBufBus(COMMAND_ID cmdID,U32 *errData,U8 *retID) {
//   RETCODE status;

   *retID = 0;
   switch (cmdID) {
   case TEST_TB_RSDATA_BUS :
      return(TestRSTrcBufDataBus(errData));
   case TEST_TB_TUDATA_BUS :
      return(TestTUTrcBufDataBus(errData));
   case TEST_TB_TPDATA_BUS :
      return(TestTPTrcBufDataBus(errData));
   case TEST_TB_VWDATA_BUS :
      return(TestVWTrcBufDataBus(errData));
   case TEST_TB_TSDATA_BUS :
      return(TestTSTrcBufDataBus(errData));
   case TEST_TB_EVDATA_BUS :
      return(TestEventTrcBufDataBus(errData));
   case TEST_TB_RSADDR_BUS :
      return(TestRSTrcBufAddrBus(errData));
   case TEST_TB_TUADDR_BUS :
      return(TestTUTrcBufAddrBus(errData));
   case TEST_TB_TPADDR_BUS :
      return(TestTPTrcBufAddrBus(errData));
   case TEST_TB_VWADDR_BUS :
      return(TestVWTrcBufAddrBus(errData));
   case TEST_TB_TSADDR_BUS :
      return(TestTSTrcBufAddrBus(errData));
   case TEST_TB_EVADDR_BUS :
      return(GOOD);
   }
}
/******************************** E O F ***********************************/

