/****************************************************************************
**
**  Name:  diagmce.c
**
**  Description:
**     MIcePack MCE16A diagnostic functions.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/mt2_amd/diag_amd/diagmce.c_v  $
** 
**    Rev 1.0   20 May 1998 10:39:24   Eric
** Initial revision.
** 
**    Rev 1.0   14 Jan 1997 10:39:20   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 16:11:10   jacky
** Get file from ATL. V1.3
**
**
**  $Header:   S:/tbird/mt2_amd/diag_amd/diagmce.c_v   1.0   20 May 1998 10:39:24   Eric  $
**
** Copyright (C) 1993 Microtek International, Inc.
**
*****************************************************************************/

           /****************************
            *                          *
            *       INCLUDE FILES      *
            *                          *
            ****************************/

#ifndef _DGT_BASE_TYPES_
#include "dgttypes.h"
#endif


#ifndef _DGT_LLFW_
#include "dgtllfw.h"
#endif

#include "cpmio.def"
#include "cpm.equ"

#include "conio.h"

#ifndef _TRCDIAG_
#include "trcdiag.h"
#endif

extern U32 bankSize;
extern BOOLEAN mtatExist;


           /****************************
            *                          *
            *     LOCAL DEFINITIONS    *
            *                          *
            ****************************/
/*
  MCE16A DIAGNOSTIC ERROR FLAG:
    InitCpPort(errorFlag):
    0001h -- 8255 port A fail
    0002h -- 8255 port B fail
    DataMemoryTest(code in errorFlag,error address return):
    0003h -- data memory fail
    InitEpPort(errorFlag):
    0004h -- XILINX INIT fail
    0005h -- XILINX DONE fail
    MapTest:
    0100h -- Mapping RAM fail
    MceOpenShortTest(return error code,0 is OK,not 0 fail
                     error in structure ErrorMceOpenShort):
    0101h -- Open/Short EA0 fail
    0102h -- Open/Short EA1 fail
    0103h -- Open/Short EA2 fail
    0104h -- Open/Short EA3 fail
    0105h -- Open/Short EA4 fail
    0106h -- Open/Short EA5 fail
    0107h -- Open/Short EA6 fail
    0108h -- Open/Short EA7 fail
    0109h -- Open/Short EA8 fail
    010Ah -- Open/Short EA9 fail
    010Bh -- Open/Short EA10 fail
    010Ch -- Open/Short EA11 fail
    010Dh -- Open/Short EA12 fail
    010Eh -- Open/Short EA13 fail
    010Fh -- Open/Short EA14 fail
    0110h -- Open/Short EA15 fail
    0111h -- Open/Short EA16 fail
    0112h -- Open/Short EA17 fail
    0113h -- Open/Short EA18 fail
    0114h -- Open/Short EA19 fail
    0115h -- Open/Short EA20 fail
    0116h -- Open/Short EA21 fail
    0117h -- Open/Short EA22 fail
    0118h -- Open/Short EA23 fail
    0119h -- Open/Short EA24 fail
    011Ah -- Open/Short EA25 fail
    011Bh -- Open/Short EA26 fail
    011Ch -- Open/Short EA27 fail
    011Dh -- Open/Short EA28 fail
    011Eh -- Open/Short EA29 fail
    011Fh -- Open/Short EA30 fail
    0120h -- Open/Short EA31 fail
    0121h -- Open/Short EA32 fail
    0122h -- Open/Short ED0 fail
    0123h -- Open/Short ED1 fail
    0124h -- Open/Short ED2 fail
    0125h -- Open/Short ED3 fail
    0126h -- Open/Short ED4 fail
    0127h -- Open/Short ED5 fail
    0128h -- Open/Short ED6 fail
    0129h -- Open/Short ED7 fail
    012Ah -- Open/Short ED8 fail
    012Bh -- Open/Short ED9 fail
    012Ch -- Open/Short ED10 fail
    012Dh -- Open/Short ED11 fail
    012Eh -- Open/Short ED12 fail
    012Fh -- Open/Short ED13 fail
    0130h -- Open/Short ED14 fail
    0131h -- Open/Short ED15 fail
    0132h -- Open/Short ED16 fail
    0133h -- Open/Short ED17 fail
    0134h -- Open/Short ED18 fail
    0135h -- Open/Short ED19 fail
    0136h -- Open/Short ED20 fail
    0137h -- Open/Short ED21 fail
    0138h -- Open/Short ED22 fail
    0139h -- Open/Short ED23 fail
    013Ah -- Open/Short ED24 fail
    013Bh -- Open/Short ED25 fail
    013Ch -- Open/Short ED26 fail
    013Dh -- Open/Short ED27 fail
    013Eh -- Open/Short ED28 fail
    013Fh -- Open/Short ED29 fail
    0140h -- Open/Short ED30 fail
    0141h -- Open/Short ED31 fail
    0142h -- Open/Short ES0 fail
    0143h -- Open/Short ES1 fail
    0144h -- Open/Short ES2 fail
    0145h -- Open/Short ES3 fail
    0146h -- Open/Short ES4 fail
    0147h -- Open/Short ES5 fail
    0148h -- Open/Short ES6 fail
    0149h -- Open/Short ES7 fail
    014Ah -- Open/Short ES8 fail
    014Bh -- Open/Short ES9 fail
    014Ch -- Open/Short ES10 fail
    014Dh -- Open/Short ES11 fail
    014Eh -- Open/Short ES12 fail
    014Fh -- Open/Short ES13 fail
    0150h -- Open/Short ES14 fail
    0151h -- Open/Short ES15 fail
    0152h -- Open/Short IO00 fail (NHALT)
    0153h -- Open/Short IO01 fail (NEPRUN)
    0154h -- Open/Short IO02 fail (NRDY_DATA)
    0155h -- Open/Short IO03 fail (NCODCOVGE)
    0156h -- Open/Short IO04 fail (SSO)
    0157h -- Open/Short IO05 fail (ICERDY)
    0158h -- Open/Short IO06 fail (NICENOTRDY)
    0159h -- Open/Short IO07 fail (NINIT)
    015Ah -- Open/Short IO08 fail (NEPBRK)
    015Bh -- Open/Short IO09 fail (ENNMI)
    015Ch -- Open/Short IO10 fail (EPSTOP)
    015Dh -- Open/Short IO11 fail (EMON)
    015Eh -- Open/Short IO12 fail (NMHERE)
    015Fh -- Open/Short IO13 fail (NSTROBE)
    0160h -- Open/Short IO14 fail (EMUSPACE)
    0161h -- Open/Short IO15 fail (NADVALID)

    structure ErrorMceOpenShort

         E  EEEEEEEE EEEEEEEE EEEEEEEE EEEEEEEE EEEEEEEE EEEEEEEE
         R  AAAAAAAA AAAAAAAA AAAAAAAA DDDDDDDD DDDDDDDD SSSSSSSS
         R  22221111 11111100 00000000 11111100 00000000 00000000
            32109876 54321098 76543210 54321098 76543210 76543210
EA23 W1 

    McePullhighTest(return error code,0 is OK,not 0 fail
                    error in structure ErrorMcePullhigh):
    0201h -- Pullhigh ES0 fail
    0202h -- Pullhigh ES1 fail
    0203h -- Pullhigh ES2 fail
    0204h -- Pullhigh ES3 fail
    0205h -- Pullhigh ES4 fail
    0206h -- Pullhigh ES5 fail
    0207h -- Pullhigh ES6 fail
    0208h -- Pullhigh ES7 fail
    0209h -- Pullhigh ES8 fail
    020Ah -- Pullhigh ES9 fail
    020Bh -- Pullhigh ES10 fail
    020Ch -- Pullhigh ES11 fail
    020Dh -- Pullhigh ES12 fail
    020Eh -- Pullhigh ES13 fail
    020Fh -- Pullhigh ES14 fail
    0210h -- Pullhigh ES15 fail
    MceMemoryTest(return error code,0 is OK,not 0 fail
                  return error address in ErrorMceMemTest):
    2000h -- Overlap Memory fail
    MceConnectorTest:(return error code,0 is OK,not 0 fail
                      error in structure ErrorMceConnTest)
    3000h -- TRACE BOARD FAIL
    3001h -- MCE16A/MTAT EA23 working 1 fail
    3002h -- MCE16A/MTAT EA22 working 1 fail
    3003h -- MCE16A/MTAT EA21 working 1 fail
    3004h -- MCE16A/MTAT EA20 working 1 fail
    3005h -- MCE16A/MTAT EA19 working 1 fail
    3006h -- MCE16A/MTAT EA18 working 1 fail
    3007h -- MCE16A/MTAT EA17 working 1 fail
    3008h -- MCE16A/MTAT EA16 working 1 fail
    3009h -- MCE16A/MTAT EA15 working 1 fail
    300Ah -- MCE16A/MTAT EA14 working 1 fail
    300Bh -- MCE16A/MTAT EA13 working 1 fail
    300Ch -- MCE16A/MTAT EA12 working 1 fail
    300Dh -- MCE16A/MTAT EA11 working 1 fail
    300Eh -- MCE16A/MTAT EA10 working 1 fail
    300Fh -- MCE16A/MTAT EA09 working 1 fail
    3010h -- MCE16A/MTAT EA08 working 1 fail
    3011h -- MCE16A/MTAT EA07 working 1 fail
    3012h -- MCE16A/MTAT EA06 working 1 fail
    3013h -- MCE16A/MTAT EA05 working 1 fail
    3014h -- MCE16A/MTAT EA04 working 1 fail
    3015h -- MCE16A/MTAT EA03 working 1 fail
    3016h -- MCE16A/MTAT EA02 working 1 fail
    3017h -- MCE16A/MTAT EA01 working 1 fail
    3018h -- MCE16A/MTAT EA00 working 1 fail
    3019h -- MCE16A/MTAT ED15 working 1 fail
    301Ah -- MCE16A/MTAT ED14 working 1 fail
    301Bh -- MCE16A/MTAT ED13 working 1 fail
    301Ch -- MCE16A/MTAT ED12 working 1 fail
    301Dh -- MCE16A/MTAT ED11 working 1 fail
    301Eh -- MCE16A/MTAT ED10 working 1 fail
    301Fh -- MCE16A/MTAT ED09 working 1 fail
    3020h -- MCE16A/MTAT ED08 working 1 fail
    3021h -- MCE16A/MTAT ED07 working 1 fail
    3022h -- MCE16A/MTAT ED06 working 1 fail
    3023h -- MCE16A/MTAT ED05 working 1 fail
    3024h -- MCE16A/MTAT ED04 working 1 fail
    3025h -- MCE16A/MTAT ED03 working 1 fail
    3026h -- MCE16A/MTAT ED02 working 1 fail
    3027h -- MCE16A/MTAT ED01 working 1 fail
    3028h -- MCE16A/MTAT ED00 working 1 fail
    3029h -- MCE16A/MTAT ES07 working 1 fail
    302Ah -- MCE16A/MTAT ES06 working 1 fail
    302Bh -- MCE16A/MTAT ES05 working 1 fail
    302Ch -- MCE16A/MTAT ES04 working 1 fail
    302Dh -- MCE16A/MTAT ES03 working 1 fail
    302Eh -- MCE16A/MTAT ES02 working 1 fail
    302Fh -- MCE16A/MTAT ES01 working 1 fail
    3030h -- MCE16A/MTAT ES00 working 1 fail
    3031h -- MCE16A/MTAT EA23 working 0 fail
    3032h -- MCE16A/MTAT EA22 working 0 fail
    3033h -- MCE16A/MTAT EA21 working 0 fail
    3034h -- MCE16A/MTAT EA20 working 0 fail
    3035h -- MCE16A/MTAT EA19 working 0 fail
    3036h -- MCE16A/MTAT EA18 working 0 fail
    3037h -- MCE16A/MTAT EA17 working 0 fail
    3038h -- MCE16A/MTAT EA16 working 0 fail
    3039h -- MCE16A/MTAT EA15 working 0 fail
    303Ah -- MCE16A/MTAT EA14 working 0 fail
    303Bh -- MCE16A/MTAT EA13 working 0 fail
    303Ch -- MCE16A/MTAT EA12 working 0 fail
    303Dh -- MCE16A/MTAT EA11 working 0 fail
    303Eh -- MCE16A/MTAT EA10 working 0 fail
    303Fh -- MCE16A/MTAT EA09 working 0 fail
    3040h -- MCE16A/MTAT EA08 working 0 fail
    3041h -- MCE16A/MTAT EA07 working 0 fail
    3042h -- MCE16A/MTAT EA06 working 0 fail
    3043h -- MCE16A/MTAT EA05 working 0 fail
    3044h -- MCE16A/MTAT EA04 working 0 fail
    3045h -- MCE16A/MTAT EA03 working 0 fail
    3046h -- MCE16A/MTAT EA02 working 0 fail
    3047h -- MCE16A/MTAT EA01 working 0 fail
    3048h -- MCE16A/MTAT EA00 working 0 fail
    3049h -- MCE16A/MTAT ED15 working 0 fail
    304Ah -- MCE16A/MTAT ED14 working 0 fail
    304Bh -- MCE16A/MTAT ED13 working 0 fail
    304Ch -- MCE16A/MTAT ED12 working 0 fail
    304Dh -- MCE16A/MTAT ED11 working 0 fail
    304Eh -- MCE16A/MTAT ED10 working 0 fail
    304Fh -- MCE16A/MTAT ED09 working 0 fail
    3050h -- MCE16A/MTAT ED08 working 0 fail
    3051h -- MCE16A/MTAT ED07 working 0 fail
    3052h -- MCE16A/MTAT ED06 working 0 fail
    3053h -- MCE16A/MTAT ED05 working 0 fail
    3054h -- MCE16A/MTAT ED04 working 0 fail
    3055h -- MCE16A/MTAT ED03 working 0 fail
    3056h -- MCE16A/MTAT ED02 working 0 fail
    3057h -- MCE16A/MTAT ED01 working 0 fail
    3058h -- MCE16A/MTAT ED00 working 0 fail
    3059h -- MCE16A/MTAT ES07 working 0 fail
    305Ah -- MCE16A/MTAT ES06 working 0 fail
    305Bh -- MCE16A/MTAT ES05 working 0 fail
    305Ch -- MCE16A/MTAT ES04 working 0 fail
    305Dh -- MCE16A/MTAT ES03 working 0 fail
    305Eh -- MCE16A/MTAT ES02 working 0 fail
    305Fh -- MCE16A/MTAT ES01 working 0 fail
    3060h -- MCE16A/MTAT ES00 working 0 fail

structure ErrorMceConnTest:

         E  EEEEEEEE EEEEEEEE EEEEEEEE EEEEEEEE EEEEEEEE EEEEEEEE
         R  AAAAAAAA AAAAAAAA AAAAAAAA DDDDDDDD DDDDDDDD SSSSSSSS
         R  22221111 11111100 00000000 11111100 00000000 00000000
            32109876 54321098 76543210 54321098 76543210 76543210
EA23 W1 
EA22 W1
EA21 W1  X  00010000 00000000 00000000 00001000 00000000 00000000
EA20 W1
EA19 W1
EA18 W1   --> means EA18 working ONE,others ZERO,to test EA23-0,
EA17 W1       ED15-0,ES7-0,ERR "X" means error in that pattern,
EA16 W1       bit "1" is error,"0" is OK
EA15 W1
EA14 W1
EA13 W1 
EA12 W1
EA11 W1
EA10 W1
EA09 W1
EA08 W1 
EA07 W1
EA06 W1
EA05 W1
EA04 W1
EA03 W1 
EA02 W1
EA01 W1
EA00 W1
ED15 W1
ED14 W1
ED13 W1 
ED12 W1
ED11 W1
ED10 W1
ED09 W1
ED08 W1 
ED07 W1
ED06 W1
ED05 W1
ED04 W1
ED03 W1 
ED02 W1
ED01 W1
ED00 W1
ES07 W1
ES06 W1
ES05 W1
ES04 W1
ES03 W1 
ES02 W1
ES01 W1
ES00 W1
EA23 W0 
EA22 W0
EA21 W0
EA20 W0
EA19 W0
EA18 W0   --> means EA18 working ZERO,others ONE,to test EA23-0,
EA17 W0       ED15-0,ES7-0,ERR "X" means error in that pattern,
EA16 W0       bit "1" is error,"0" is OK
EA15 W0
EA14 W0
EA13 W0 
EA12 W0
EA11 W0
EA10 W0
EA09 W0
EA08 W0 
EA07 W0
EA06 W0
EA05 W0
EA04 W0
EA03 W0 
EA02 W0
EA01 W0
EA00 W0
ED15 W0
ED14 W0
ED13 W0 
ED12 W0
ED11 W0
ED10 W0
ED09 W0
ED08 W0 
ED07 W0
ED06 W0
ED05 W0
ED04 W0
ED03 W0 
ED02 W0
ED01 W0
ED00 W0
ES07 W0
ES06 W0
ES05 W0
ES04 W0
ES03 W0 
ES02 W0
ES01 W0
ES00 W0
*/
#define FP_MAK(seg, ofs) ((void far *)(((unsigned long)(seg) << 16) | (unsigned)(ofs)))

typedef struct {
   STATUS OpenShortError;
   U8 EpAddress[4];
   U8 EpData[4];
   U8 EpStatus[2];
   U8 IOSignals[2];
} ErrorMceOpenShort;

typedef struct {
   STATUS MemoryError;
   U32 address;
} ErrorMceMemTest;

typedef struct {
   STATUS WorkingError;
   U8 EpAddress[4];
   U8 EpData[4];
   U8 EpStatus[2];
} ErrorMceWorkTest;

typedef struct {
   STATUS ConnectorError;
   ErrorMceWorkTest Working[96];
} ErrorMceConnTest;

typedef struct {
   STATUS PullhighError;
   U8 EpStatus[2];
} ErrorMcePullhigh;


            /****************************
             *                          *
             *    EXTERNAL VARIABLES    *
             *                          *
             ****************************/

            /****************************
             *                          *
             *     LOCAL PROTOTYPES     *
             *                          *
             ****************************/

            /****************************
             *                          *
             *      EXECUTABLE CODE     *
             *                          *
             ****************************/



/***************************************************************************
**
** InitialDiagnostic          
**
**  Description: initialize MicePack MCE16A for diagnostic
**
**  Parameters:
**     input:
**        none
**
**     output:
**
****************************************************************************/
VOID SetMode(U8 CaseValue) {

  switch( CaseValue ) {
    case 0:
      /* set Xilinx internal access mode */
      outp( SYSPA,( (U8) inp(SYSPA) ) & ~(X1CS_CLK | NX0CS_TG) );
      break;
    case 1:
      /* set Xilinx EA(0:7),ED(0:7) output mode   */
      outp( SYSPA,( ( (U8) inp(SYSPA) ) & ~NX0CS_TG) | X1CS_CLK );
      break;
    case 2:
      /* set Xilinx access EMM  mode   */
      outp( SYSPA,( ( (U8) inp(SYSPA) ) & ~X1CS_CLK) | NX0CS_TG );
      break;
    case 3:
      /* set Xilinx load counter  mode   */
      outp(SYSPA,( (U8) inp(SYSPA)) | (X1CS_CLK | NX0CS_TG) );
      break;
    default:
      break;
  }
}

VOID GlobalOutput(VOID) {

   /* set Xilinx global output enabled   */
   outp(SYSPB,( (U8) inp(SYSPB)) & ~NFORCERDY );

}

VOID GlobalOutputDisable(VOID) {

   /* set Xilinx global output disabled   */
   outp(SYSPB,( (U8) inp(SYSPB)) | NFORCERDY );

}

VOID IncreaseCount(VOID) {

   /* set Xilinx global output enabled   */
   outp(SYSPB,( (U8) inp(SYSPB)) | HLDC );
   outp(SYSPB,( (U8) inp(SYSPB)) & ~HLDC );

}

VOID InitialMceDiag(VOID) {

   /* set Xilinx global output disabled   */
   outp(SYSPB,( (U8) inp(SYSPB)) | NFORCERDY );
   /* set Xilinx internal access mode */
   outp( SYSPA,( (U8) inp(SYSPA) ) & ~(X1CS_CLK | NX0CS_TG) );

}

RETCODE Loop4ErrorCode(U8 loopArray[],STATUS *errCode) {
  U8 loopcnt,tmpcnt,tmpValue;
  tmpValue=0x01;
    for (loopcnt=0;loopcnt<=3;loopcnt++) {
      for (tmpcnt=0;tmpcnt<=7;tmpcnt++) {
        if (loopArray[loopcnt] & (U8) (tmpValue<<tmpcnt)) {
          return(1);
          break;
        }
        else 
          *errCode=*errCode+1;
      }
    }
    return(0);
}

RETCODE Loop2ErrorCode(U8 loopArray[],STATUS *errCode) {
  U8 loopcnt,tmpcnt,tmpValue;
  tmpValue=0x01;
    for (loopcnt=0;loopcnt<=1;loopcnt++) {
      for (tmpcnt=0;tmpcnt<=7;tmpcnt++) {
        if (loopArray[loopcnt] & (U8) (tmpValue<<tmpcnt)) {
          return(1);
          break;
        }
        else 
          *errCode=*errCode+1;
      }
    }
    return(0);
}

RETCODE MceOpenShortTest(ErrorMceOpenShort *Value) {

  U8 far *port;
  U8 echo,loopcnt,address,testType,tmpcnt;
  U32 ShiftPattern;
  U8 far *portAdrh,far *portAdrm,far *portDatah,far *portStatus;
  U8 loadAdr[4],loadData[4],loadStatus[2];
  U8 tmpValue;
  STATUS errCode;

  /* initialize flags */
  Value->OpenShortError = GOOD;
  for (tmpcnt=0;tmpcnt<=3;tmpcnt++) {
    Value->EpAddress[tmpcnt]=0;
    Value->EpData[tmpcnt]=0;
  }
  for (tmpcnt=0;tmpcnt<=1;tmpcnt++) {
    Value->EpStatus[tmpcnt]=0;
    Value->IOSignals[tmpcnt]=0;
  }

  /* global output enabled */
  GlobalOutput();

  /* test EA(0:7) ,ED(0:7) open/short */
  SetMode(0);  /* set XILINX to access internal mode  */
  tmpValue=0x80;
  for (testType=0;testType<=1;testType++) {
    for (loopcnt=0; loopcnt <=7 ; loopcnt++) {
      if (testType == 0) 
        /* working one */
        address  =(U8) ((tmpValue  >> loopcnt) | 0x80);
      else
        /* working zero */
        address=(U8) ( ~(tmpValue >> loopcnt) | 0x80);
      port = (U8 far *) FP_MAK(0xd000, address);
      echo=*port;
      if (echo != address) {
        Value->OpenShortError=!GOOD;
        Value->EpData[0]=Value->EpData[0] | (address ^ echo);
        Value->EpAddress[0]=Value->EpAddress[0] | (address ^ echo);
      }
    }
  }

  /* test EA(8:23),ED(8:15),ES(0:7) open/short */
  portAdrh = (U8 far *) FP_MAK(0xd000, 0x0008);
  portAdrm = (U8 far *) FP_MAK(0xd000, 0x0006);
  portDatah = (U8 far *) FP_MAK(0xd000, 0x0002);
  portStatus = (U8 far *) FP_MAK(0xd000, 0x000a);
  for (testType=0;testType<=1;testType++) {
    for (ShiftPattern=1; ShiftPattern !=0; ShiftPattern <<= 1) {
      SetMode(0);  /* set XILINX to access internal mode  */
      loadAdr[2] = (U8) ((ShiftPattern >> 24) & 0x000000ff);
      loadAdr[1] = (U8) ((ShiftPattern >> 16) & 0x000000ff);
      loadData[1] = (U8) ((ShiftPattern >> 8) & 0x000000ff);
      loadStatus[0] = (U8) (ShiftPattern & 0x000000ff);
      if (testType == 1) {
        /* working zero */
        loadAdr[2]  = (U8) ~loadAdr[2];
        loadAdr[1]  = (U8) ~loadAdr[1];
        loadData[1] = (U8) ~loadData[1]; 
        loadStatus[0]= (U8) ~loadStatus[0];
      }
      /* write pattern */
      *portAdrh= loadAdr[2];
      *portAdrm= loadAdr[1];
      SetMode(3);  /* set XILINX to load counter mode  */
      IncreaseCount(); /* load to output */
      SetMode(0);  /* set XILINX to access internal mode  */
      *portDatah= loadData[1];
      *portStatus= loadStatus[0];
      /* read pattern */
      if (*portAdrh != loadAdr[2]) {
         Value->OpenShortError=!GOOD;
         Value->EpAddress[2]=(Value->EpAddress[2] | (loadAdr[2]^*portAdrh));
      }
      if (*portAdrm != loadAdr[1]) {
         Value->OpenShortError=!GOOD;
         Value->EpAddress[1]=(Value->EpAddress[1] | (loadAdr[1]^*portAdrm));
      }
      if (*portDatah != loadData[1]) {
         Value->OpenShortError=!GOOD;
         Value->EpData[1]=(Value->EpData[1] | (loadData[1]^*portDatah));
      }
      if (*portStatus != loadStatus[0]) {
         Value->OpenShortError=!GOOD;
         Value->EpStatus[0]=(Value->EpStatus[0] | (loadStatus[0]^*portStatus));
      }
    }
  }

  /* test IO1(0:7)  open/short */
  SetMode(0);  /* set XILINX to access internal mode  */
  port = (U8 far *) FP_MAK(0xd000, 0x000c);
  tmpValue=0x01;
  for (testType=0;testType<=1;testType++) {
    for (loopcnt=0; loopcnt <=7 ; loopcnt++) {
      if (testType == 0) 
        /* working one */
        address= (U8) ((tmpValue << loopcnt));
      else
        /* working zero */
        address= (U8) (~(tmpValue << loopcnt));
      *port=address;
      echo=*port;
      if (echo != address) {
        Value->OpenShortError=!GOOD;
        Value->IOSignals[0]=Value->IOSignals[0] | (address^echo);
      }
    }
  }

  /* test IO2(0:7)  open/short */
  port = (U8 far *) FP_MAK(0xd000, 0x000e);
  echo=*port;
  if ( (echo & 0x04) == 0 )
        Value->IOSignals[1]=(U8) (Value->IOSignals[1] | 0x04);
  if ( (echo | 0xfd) == 0xff )
        Value->IOSignals[1]=(U8) (Value->IOSignals[1] | 0x02);
  if ( (echo & 0x01) == 0 )
        Value->IOSignals[1]=(U8) (Value->IOSignals[1] | 0x01);

  /* global output disabled */
  GlobalOutputDisable();

  /* error code setting */
  errCode=1;
  if (Value->OpenShortError!=GOOD) {
    if (Loop4ErrorCode(Value->EpAddress,&errCode)==0) {
      if (Loop4ErrorCode(Value->EpData,&errCode)==0) {
        if (Loop2ErrorCode(Value->EpStatus,&errCode)==0) {
          Loop2ErrorCode(Value->IOSignals,&errCode);
        }
      }
    }
    Value->OpenShortError=errCode+0x0100;
  }
  return(Value->OpenShortError);
}

RETCODE MceMemoryTest(U32 adrLength,ErrorMceMemTest *Value) {
/*  U8 far *portAdrh,far *portAdrm,far *memArea;
  U8 adrlh,adrll,loadData;
  U32 adrCount;
  U16 adrlCount; */
  U32 errAdr;
  U8 far *portStatus;


  /* initialize flags */
  Value->MemoryError = GOOD;
  Value->address = 0;

  /* global output enabled */
  GlobalOutput();

  /* output status S3210=1100 */
  SetMode(0);  
  portStatus = (U8 far *) FP_MAK(0xd000, 0x000a);
  *portStatus= 0x0c;
   
  if (EMMTest(adrLength,&errAdr)!=0) {
     Value->MemoryError = !GOOD;
     Value->address=errAdr; 
  }
  
/*
  adrCount=0;
  portAdrh = (U8 far *) FP_MAK(0xd000, 0x0008);
  portAdrm = (U8 far *) FP_MAK(0xd000, 0x0006);
  SetMode(0);  
  *portAdrh= 0;
  *portAdrm= 0;
  SetMode(3);  
  IncreaseCount(); 
  SetMode(0);  

  SetMode(2);  
  for (adrCount=0;adrCount<=adrLength; adrCount=adrCount+0x100) {
    adrlh = (U8) ((adrCount >> 8) & 0x000000ff);
    for (adrlCount=0;adrlCount<=0xff; adrlCount++) {
      adrll=(U8) adrlCount;
      if ( ((adrCount & 0xffffff00) == (adrLength & 0xffffff00)) &&
           (adrll > (U8) (adrLength & 0x000000ff)) ) break;
      memArea = (U8 far *) FP_MAK(0xd000, adrll);
      loadData=adrlh^adrll;   
      *memArea=loadData;      
      if (*memArea!=loadData) {
        Value->MemoryError=!GOOD;
        Value->address=adrCount+adrll; 
        break;
      }
      *memArea=(U8) (~loadData);     
    }
    IncreaseCount(); 
  }

  SetMode(0);  
  *portAdrh= 0;
  *portAdrm= 0;
  SetMode(3);  
  IncreaseCount(); 
  SetMode(0);  

  SetMode(2);  
  for (adrCount=0;adrCount<=adrLength; adrCount=adrCount+0x100) {
    adrlh = (U8) ((adrCount >> 8) & 0x000000ff);
    for (adrlCount=0;adrlCount<=0xff; adrlCount++) {
      adrll=(U8) adrlCount;
      if ( ((adrCount & 0xffffff00) == (adrLength & 0xffffff00)) &&
           (adrll > (U8) (adrLength & 0x000000ff)) ) break;
      memArea = (U8 far *) FP_MAK(0xd000, adrll);
      loadData=adrlh^adrll;   
      if (*memArea!=(U8) (~loadData)) {
        Value->MemoryError=!GOOD;
        Value->address=adrCount+adrll; 
        break;
      }
    }
    IncreaseCount(); 
  }
  SetMode(0);  
*/
  /* global output disabled */
  GlobalOutputDisable();

  /* error code setting */
  if (Value->MemoryError!=GOOD) {
    Value->MemoryError=0x2000;
  }
  return(Value->MemoryError);
}
//
//RETCODE MceConnectorTest(ErrorMceConnTest *Value) {
//  RETCODE err;
//  U8 far *portAdrh,far *portAdrm,far *portAdrl,far *portDatah,far *portDatal,far *portStatus;
//  U8 loopcnt,tmpcnt,testType,tmpValue,tmpcnt1;
//  U8 loadAdr[4],loadData[4],loadStatus[2];
//  MtatConnSignals ConnData;
//  STATUS errCode;
//  U8 tester;
//  U16 xlxDone;
//
//  if ((err = ProgramXlxForDiag(&xlxDone)) != GOOD) return(0x3000);
//  portAdrh = (U8 far *) FP_MAK(0xd000, 0x0008);
//  portAdrm = (U8 far *) FP_MAK(0xd000, 0x0006);
//  portAdrl = (U8 far *) FP_MAK(0xd000, 0x0004);
//  portDatah = (U8 far *) FP_MAK(0xd000, 0x0002);
//  portDatal = (U8 far *) FP_MAK(0xd000, 0x0000);
//  portStatus = (U8 far *) FP_MAK(0xd000, 0x000a);
//
//  /* initial flags */
//  Value->ConnectorError = GOOD;
//  for (tmpcnt1=0;tmpcnt1<=95;tmpcnt1++) {
//    Value->Working[tmpcnt1].WorkingError=GOOD;
//    for (tmpcnt=0;tmpcnt<=3;tmpcnt++) {
//      Value->Working[tmpcnt1].EpAddress[tmpcnt]=0;
//      Value->Working[tmpcnt1].EpData[tmpcnt]=0;
//    }
//      Value->Working[tmpcnt1].EpStatus[tmpcnt]=0;
//    }
//  }
//
//  /* global output enabled */
//  GlobalOutput();
//
//  if (mtatExist) {
//    /* trace board exist */
//    for (testType=0;testType<=1;testType++) {
//      for (loopcnt=0; loopcnt<=47;loopcnt++) {
//        SetMode(0);  /* set XILINX to access internal mode  */
//        for (tmpcnt=0;tmpcnt<=3;tmpcnt++) {
//          loadAdr[tmpcnt]=0;
//          loadData[tmpcnt]=0;
//        }
//        for (tmpcnt=0;tmpcnt<=1;tmpcnt++) {
//          loadStatus[tmpcnt]=0;
//        }
//        switch(loopcnt/8) {
//          case 0:
//            loadAdr[2]=(U8) (tmpValue >> loopcnt);
//            break;
//          case 1:
//            loadAdr[1]=(U8) (tmpValue >> (loopcnt-8));
//            break;
//          case 2:
//            loadAdr[0]=(U8) (tmpValue >> (loopcnt-16));
//            break;
//          case 3:
//            loadData[1]=(U8) (tmpValue >> (loopcnt-24));
//          break;
//        case 4:
//          loadData[0]=(U8) (tmpValue >> (loopcnt-32));
//          break;
//        case 5:
//          loadStatus[0]=(U8) (tmpValue >> (loopcnt-40));
//          break;
//        default:
//          break;
//      }
//      if (testType==1) {
//        /* working 0 */
//        for (tmpcnt=0;tmpcnt<=3;tmpcnt++) {
//          loadAdr[tmpcnt]=(U8) (~loadAdr[tmpcnt]);
//          loadData[tmpcnt]=(U8) (~loadData[tmpcnt]);
//        }
//        for (tmpcnt=0;tmpcnt<=1;tmpcnt++) {
//          loadStatus[tmpcnt]=(U8) (~loadStatus[tmpcnt]);
//        }
//      }
//      /* write pattern */
//      *portDatah= loadData[1];
//      *portStatus= loadStatus[0];
//      *portAdrh= loadAdr[2];
//      *portAdrm= loadAdr[1];
//      SetMode(3);  /* set XILINX to load counter mode  */
//      IncreaseCount(); /* load to output */
//      SetMode(0);  /* set XILINX to access internal mode  */
//      *portAdrl=loadAdr[0];
//      *portDatal=loadData[0];
//      SetMode(1);  /* set XILINX to access connector mode  */
//      /* read from MTAT */
//      if (MtatReadConn(&ConnData)!=0) {
//        tester=1;
//        testType=2;
//        break;
//      }
//      for (tmpcnt=0;tmpcnt<=2;tmpcnt++) {
//        if ( (ConnData.EpAddress[tmpcnt]) !=loadAdr[tmpcnt]) {
//          Value->ConnectorError=!GOOD;
//          Value->Working[48*testType+loopcnt].WorkingError=!GOOD;
//          Value->Working[48*testType+loopcnt].EpAddress[tmpcnt]=
//                Value->Working[48*testType+loopcnt].EpAddress[tmpcnt] |
//                (loadAdr[tmpcnt]^ConnData.EpAddress[tmpcnt]);
//        }
//      }
//      for (tmpcnt=0;tmpcnt<=1;tmpcnt++) {
//        if ( (ConnData.EpData[tmpcnt]) !=loadData[tmpcnt]) {
//          Value->ConnectorError=!GOOD;
//          Value->Working[48*testType+loopcnt].WorkingError=!GOOD;
//          Value->Working[48*testType+loopcnt].EpData[tmpcnt]=
//                 Value->Working[48*testType+loopcnt].EpData[tmpcnt] |
//                 (loadData[tmpcnt]^ConnData.EpData[tmpcnt]);
//        }
//      }
//      if ( (ConnData.EpStatus[0]) !=loadStatus[0]) {
//        Value->ConnectorError=!GOOD;
//        Value->Working[48*testType+loopcnt].WorkingError=!GOOD;
//        Value->Working[48*testType+loopcnt].EpStatus[0]=
//               Value->Working[48*testType+loopcnt].EpStatus[0] |
//               (loadStatus[0]^ConnData.EpStatus[0]);
//      }
//    }
//  }
//  /* error code setting */
//  if (tester==1)
//    errCode=0x3000;
//  else if (Value->ConnectorError!=GOOD) {
//    errCode=1;
//    for (tmpcnt1=0;tmpcnt1<=95;tmpcnt1++) {
//      if ((Value->Working[tmpcnt1].WorkingError) != GOOD) break;
//      errCode++;
//    }
//    Value->ConnectorError=errCode+0x3000;
//  }
//}
//
//SetMode(0);  /* set XILINX to access internal mode  */
///* global output disabled */
//GlobalOutputDisable();
//
//return(Value->ConnectorError);
//}

RETCODE McePullhighTest(ErrorMcePullhigh *Value) {

  U8 echo;
  U8 far *portStatus;
  STATUS errCode;

  portStatus = (U8 far *) FP_MAK(0xd000, 0x000a);

  /* initialize flags */
  Value->PullhighError = GOOD;
  Value->EpStatus[1]=0;
  Value->EpStatus[0]=0;

  /* test ES(0:7) pullhigh */
  SetMode(0);  /* set XILINX to access internal mode  */
  /* global output disabled */
  GlobalOutputDisable();
  *portStatus= 0;
  echo=*portStatus;
  if (echo != 0xff) {
    Value->PullhighError=!GOOD;
    Value->EpStatus[0]=(U8) (Value->EpStatus[0] | ~echo);
  }
  /* error code setting */
  errCode=0;
  if (Value->PullhighError!=GOOD) {
    if (Loop2ErrorCode(Value->EpStatus,&errCode)==0) {
      Value->PullhighError=errCode+0x0200;
    }
  }
  return(Value->PullhighError);
}
/******************************** E O F ***********************************/

