/****************************************************************************
**
**  Name:  emucomm.h
**
**  Description:
**     Michelle MICE data/command communication routines.
**     include:
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/mt2_amd/diag_amd/emucomm.h_v  $
** 
**    Rev 1.0   20 May 1998 10:39:26   Eric
** Initial revision.
** 
**    Rev 1.0   20 Mar 1998 09:20:56   Eric
** Initial revision.
** 
**    Rev 1.0   03 Dec 1996 09:27:40   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 10:03:18   jacky
** Get file from ATL. V1.3
** 
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_amd/diag_amd/emucomm.h_v   1.0   20 May 1998 10:39:26   Eric  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_COMM_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _DGT_BASE_TYPES_
#include "dgttypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
                        *                          *
                        *      DEFINITIONS         *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *       PROTOTYPES         *
                         *                          *
                         ****************************/

/****************************************************************************
**
**  ReceiveByte
**
**  Description: Receive one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
U8 ReceiveByte(VOID);


/****************************************************************************
**
**  CommRecover
**
**  Description: Initialize communication point and size.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID CommRecover(VOID);

/****************************************************************************
**
**  TransmitByte
**
**  Description: Transmit one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID TransmitByte(U8 c);

/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive data from communication and check the length and
**               checksum, the data format is :       XXXXxxx....xxxX
**                                                  length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID ReceiveStream(VOID);

/****************************************************************************
**
**  TransmitStream
**
**  Description: Transmit data(length + data + checksum) to
**               communication port.
**               the data format is :  XXXXxxx....xxxX
**                                   length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID TransmitStream(VOID);

/****************************************************************************
**
**  ReceiveEsc
**
**  Description: Receive ESC from communication
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
STATUS ReceiveEsc(VOID);
/******************************** E O F ***********************************/
