/***************************************************************************
**
** Name: prgepc.c
**
** Description:
**   Config 10K10 on MCE16E board
**
****************************************************************************/

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/
#include <conio.h>

#ifndef _TRCFLEX_
#include "trcflex.h"
#endif

                       /****************************
                        *                          *
                        *    LOCAL DEFINITIONS     *
                        *                          *
                        ****************************/

#define FLEX10K10SIZE   0x399e

/* I/O port address define */

#define SYSPA           0xF144   //I/O   Port
#define SYSPC           0xF146   //Input Port
#define EPCPort         0xF147

/* I/O port corresponding bit define */

//SYSPA :
#define nConfig10K      0x02

//SYSPC :
#define RDYnBSY         0x01
#define nStatus         0x02
#define DONE            0x04


U8 _based(_segname("_CODE")) EPCByte[] = {
#include "16eepc.ttf"
};

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/
/*****************************************************************************
**
**  LoadFPGA
**
**
**
*****************************************************************************/
U16 LoadFPGA(VOID) {
   register U16 count ;
   U8 sysBuf;

   sysBuf = (U8) inp(SYSPA);
   outp(SYSPA,(sysBuf & ~nConfig10K));   //Pull nConfig signal to low
   for (count=0; count < 100; count++);              //Delay 10us
   outp(SYSPA,(sysBuf | nConfig10K));    //Pull nConfig signal to high
   for (count=0; count < 40; count++);
   outp(EPCPort,EPCByte[0]);
   for (count = 1;count <= FLEX10K10SIZE - 1;count++) {
      while((inp(SYSPC) & RDYnBSY) != RDYnBSY) ;
      outp(EPCPort,EPCByte[count]);
      if ( (inp(SYSPC) & nStatus) != nStatus) break;
   }
   if ( (inp(SYSPC) & DONE ) == DONE)       return(GOOD);
   return(0x1) ;
}
/********************************* EOF *************************************/
