/****************************************************************************
**
** Name: trcFLEX.h
**
** Description:
**   Header file for services of Altera's reprogramming
**
****************************************************************************/

#define _TRCFLEX_
#define DIAG_BIN

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#ifdef MAIN_BIN
   #ifndef _EMU_BASE_TYPES_
   #include "emutypes.h"
   #endif
#endif

#ifdef DIAG_BIN
   #ifndef _DGT_BASE_TYPES_
   #include "dgttypes.h"
   #endif
#endif

                       /****************************
                        *                          *
                        *       DEFINITIONS        *
                        *                          *
                        ****************************/

typedef enum { P0, P1, P2, P3, P4, MN} FLEX_CHIP;
typedef enum { FLEX_PIPE, FLEX_P4, FLEX_MN } FLEX_TYPE;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
/*****************************************************************************
**
** FLEXProgram
**
** Description:
**   1.Pull the nCONFIG pin to GND,hold it for 10us,then pull it up to Vcc
**   2.Read the next byte of configuration data.
**   3.Perform a write cycle to FLEX8000 device.
**   4.Poll the RDYnBUSY signal.When it goes high,transfer the next byte of
**     configuration data by repeating step 2 through step 3.
**   5.Repeat step 2 through step 4 until the FLEX 8000 pull the CONF_DONE
**     high,which indicates that configuration is complete.
**  Parameters:
**    input:
**      type: FLEX8000 device type (FLEX_PIPE,FLEX_P4,FLEX_MN)
**      bitStreamBuffer:pointer to configuration data.
**
*****************************************************************************/
RETCODE FLEXProgram(FLEX_TYPE type,U8 _far *bitStreamBuffer);

VOID FiveWaitState(VOID) ;
VOID ZeroWaitState(VOID) ;
/********************************* EOF *************************************/
