/****************************************************************************
**
** Name: trclib.c
**
** Description:
**   Services for MTAT F/W
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/mt2_amd/diag_amd/trclib.c_v  $
** 
**    Rev 1.0   20 May 1998 10:39:36   Eric
** Initial revision.
** 
**    Rev 1.1   22 Jan 1997 09:09:02   gene
** 
**    Rev 1.0   14 Jan 1997 10:39:22   gene
** Initial revision.
** 
**    Rev 1.0   10 May 1996 16:10:24   jacky
** Get file from ATL. V1.3
**
** $Header:   S:/tbird/mt2_amd/diag_amd/trclib.c_v   1.0   20 May 1998 10:39:36   Eric  $
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#include <string.h>
#include <dos.h>
#include <conio.h>

#ifndef _TRCLIB_
#include "trclib.h"
#endif


                       /****************************
                        *                          *
                        *    LOCAL DEFINITIONS     *
                        *                          *
                        ****************************/

#define Mtat2Module  0x160C
#define NPCS5         0xF280

/* Serial EEPROM corresponding bit define */

#define PullSKHi       0xFD
#define PullSKLo       0xFC
#define PullCSHi       0x80
#define PullCSLo       0x00
#define ReadEEROM      0xF33C
#define EEROMCS        0xF36C

U8 _based(_segname("_CODE")) MNCPRWByte[] = {
#include "smain.ttf"
};

U16 _based(_segname("_CODE")) CtrlPort[6]=
{P0CtrlPort,P0CtrlPort,P1CtrlPort,P1CtrlPort,P2CtrlPort,P2CtrlPort};
U16 _based(_segname("_CODE")) ReadCtrlPort[6]=
{ReadP0CtrlPort,ReadP0CtrlPort,ReadP1CtrlPort,ReadP1CtrlPort,ReadP2CtrlPort
,ReadP2CtrlPort};
U16 _based(_segname("_CODE"))  WrByte1[6] =
{WriteP0Byte1,WriteP0Byte1,WriteP1Byte1,WriteP1Byte1,WriteP2Byte1,WriteP2Byte1};
U16 _based(_segname("_CODE"))  WrByte2[6] =
{WriteP0Byte2,WriteP0Byte2,WriteP1Byte2,WriteP1Byte2,WriteP2Byte2,WriteP2Byte2};
U16 _based(_segname("_CODE"))  WrByte3[6] =
{WriteP0Byte3,WriteP0Byte3,WriteP1Byte3,WriteP1Byte3,WriteP2Byte3,WriteP2Byte3};
U16 _based(_segname("_CODE"))  WrByte4[6] =
{WriteP0Byte4,WriteP0Byte4,WriteP1Byte4,WriteP1Byte4,WriteP2Byte4,WriteP2Byte4};
U8 _based(_segname("_CODE"))   nOE[6] =
{nOEX,nOEY,nOEX,nOEY,nOEX,nOEY};

typedef enum { SIZE_32k, SIZE_64k,SIZE_128k} TBuffer_SIZE;

U16 Mtat2VerCtrl ;
U8  FLEXConfig ;
U8  AdderBusWidth;
U32 TrcBufSize;
U8 ctrlbyte;
U8  trigBuf[4][0x800][2];
U8  SeqRamBuf[0x4000];
BOOLEAN mtatExist;

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

VOID SetBCAddr(U8 port,U16 mask,U16 set,U16 fcnt) ;
VOID SetBCData(U8 port,U16 mask,U16 set) ;
VOID ReadSerialEEPROM(U8 *ptr)  ;

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

VOID InitialMTAT2(VOID) {
   BOOLEAN checkExist1 = NO,checkExist2 = NO;
   U16 readdata[16];
   U8 *ptr;
   U8 writeSet[] = {0x55,0xAA};

   FLEXConfig = 0;

   mtatExist = YES;
   ptr = (U8 *)readdata;
   ReadSerialEEPROM(ptr);

   if (readdata[0] == 0xAA55) {
      //if(readdata[1] != Mtat2Module ) mtatExist = NO ;//Eric remove 5/12/98

      switch(readdata[2]) {
        case 0x32  :
           TrcBufSize = TB32K_SIZE  ;
           AdderBusWidth = 15;
           break ;
        case 0x64  :
           TrcBufSize = TB64K_SIZE  ;
           AdderBusWidth = 16;
           break ;
        case 0x128 :
           TrcBufSize = TB128K_SIZE ;
           AdderBusWidth = 16;
           break ;
      }
   }
   else {
      mtatExist = NO ;
   }
}

VOID WrBCMaskAddr(U8 port,U16 addrmask,U16 addrset,U16 datamask,U16 dataset,
                  U16 fcnt) {

   outp(CtrlPort[port],0);
   addrset &= addrmask ;
   SetBCAddr(port,addrmask,addrset,fcnt);
   SetBCData(port,datamask,dataset);
   outp(P4CtrlAY,port);
   ctrlbyte = (U8) inp(ReadCtrlPort[port]);
   ctrlbyte |= EnBCWr;
   outp(ChgWr,0x80);
   outp(CtrlPort[port],ctrlbyte);
   while ((inp(ReadCtrlPort[port]) & Done) != Done ) ;
   outp(CtrlPort[port],0);
   outp(ChgWr,0);
}

VOID WrBCOneAddr(U8 port,U16 addr,U16 bit,U16 data,U8 eventID) {

   switch(port) {
      case Rport : case Sport :
         outp(CtrlPort[port],FSld);
//       outp(WrByte1[port],0xFF);
//       outp(WrByte2[port],0xFF);
         outpw(WrByte1[port],0xFFFF);
         outp(CtrlPort[port],0);
//       outp(WrByte1[port],(U8) addr);
//       outp(WrByte2[port],(U8) (addr >> 8) );
         outpw(WrByte1[port],addr);
//       outp(WrByte3[port],0xFF);
//       outp(WrByte4[port],0xFF);
         outpw(WrByte3[port],0xFFFF);
         outp(CtrlPort[port],nOE[port]);
         SetBCData(port,~(bit << eventID),(data << eventID) );
         outp(P4CtrlAY,port);
         ctrlbyte = (U8) inp(ReadCtrlPort[port]);
         ctrlbyte |= EnBCWr;
         outp(ChgWr,0x80);
         outp(CtrlPort[port],ctrlbyte);
         outp(CtrlPort[port],0);
         outp(ChgWr,0);
         break;
      case Tport : case Uport : case Vport : case Wport :
         outp(CtrlPort[port],FSld);
//       outp(WrByte1[port],0xFF);
//       outp(WrByte2[port],0xFF);
         outpw(WrByte1[port],0xFFFF);
         outp(CtrlPort[port],0);
//       outp(WrByte1[port],(U8) (addr));
//       outp(WrByte2[port],(U8) (addr >> 8 ));
         outpw(WrByte1[port],addr);
//       outp(WrByte3[port],0xFF);
//       outp(WrByte4[port],0xFF);
         outpw(WrByte3[port],0xFFFF);
         outp(CtrlPort[port],nOE[port]);
         SetBCData(port,~(bit << eventID),data);
         outp(P4CtrlAY,port);
         ctrlbyte = (U8) inp(ReadCtrlPort[port]);
         ctrlbyte |= EnBCWr;
         outp(ChgWr,0x80);
         outp(CtrlPort[port],ctrlbyte);
         outp(CtrlPort[port],0);
         outp(ChgWr,0);
         break;
   }
}

VOID SetBCAddr(U8 port,U16 mask,U16 set,U16 fcnt) {

   outp(CtrlPort[port],FSld);
// outp(WrByte1[port],(U8) fcnt);
// outp(WrByte2[port],(U8) (fcnt >> 8));
   outpw(WrByte1[port],fcnt);
   outp(CtrlPort[port],0);
// outp(WrByte1[port],(U8) set);
// outp(WrByte2[port],(U8) (set >> 8 ));
   outpw(WrByte1[port],set);
// outp(WrByte3[port],0xFF);
// outp(WrByte4[port],0xFF);
   outpw(WrByte3[port],0xFFFF);
// outp(WrByte3[port],(U8) mask);
// outp(WrByte4[port],(U8) (mask >> 8 ));
   outpw(WrByte3[port],mask);
   outp(CtrlPort[port],nOE[port]);
}
VOID SetBCData(U8 port,U16 mask,U16 set) {

   switch(port) {
      case Rport :  case Sport :
         outp(MNCtrlAY,port);
//       outp(SetLo,(U8) set);
//       outp(SetHi,(U8)(set >> 8));
         outpw(SetLo,set);
//       outp(MaskLo,(U8) mask);
//       outp(MaskHi,(U8)( mask >> 8));
         outpw(MaskLo,mask);
      break ;
      case Tport : case Uport : case Vport : case Wport :
         outp(MNCtrlAY,port);
         outp(SetLo,(U8) set);
         outp(MaskLo,(U8) mask);
      break ;
   }
}

VOID Delay(U16 more) {
   register U16 i;

   for (i=0; i < more; i++);
}

/***************************************************************************
**
**  ReadSerialEEPROM
**
****************************************************************************/
VOID ReadSerialEEPROM(U8 *ptr)  {

   U8 ReadIntSet[9] ;
   U16 *dataptr,serialdata,i,j;
   U16 temp;

   dataptr = (U16 *) ptr;
   for (i=0;i<16;i++) *(dataptr+i) = 0;
   ReadIntSet[0] = 0x02 ; // Read instruction Start bit
   ReadIntSet[1] = 0x02 ; // Read instruction Op code
   ReadIntSet[2] = 0x00 ; // Read instruction Op code
   ReadIntSet[3] = 0x00 ; // A5
   ReadIntSet[4] = 0x00 ; // A4
   outp(NPCS5,PullSKLo);
   for (i = 0;i < 16; i++) {
      outp(EEROMCS,PullCSLo);
      outp(EEROMCS,PullCSHi);
      outp(NPCS5,PullSKHi);
      for (j = 0;j < 4;j++) {
         serialdata = ( i & (0x08 >> j)) ;
         if ( serialdata == 0 ) ReadIntSet[j+5] =0x00;
         else
            ReadIntSet[j+5] =0x02;
      }
      for (j = 0;j < 9; j++)  {
        outp(NPCS5,(PullSKLo | ReadIntSet[j]));
        outp(NPCS5,(PullSKHi | ReadIntSet[j]));
      }
      outp(NPCS5,PullSKLo);
      for (j=8;j>0;j--) {
         outp(NPCS5,PullSKHi);
         temp = (U16) inp(ReadEEROM) & 0x0080 ;
         *(dataptr+i) |= ( temp << j);
         outp(NPCS5,PullSKLo);
      }
      for (j=0;j<=7;j++) {
         outp(NPCS5,PullSKHi);
         temp = (U16) inp(ReadEEROM) & 0x0080;
         *(dataptr+i) |= ( temp >> j) ;
         outp(NPCS5,PullSKLo);
      }
   }
   outp(EEROMCS,PullCSLo);
}
/********************************* EOF *************************************/
