/****************************************************************************
**
**  Name:  mkerror1.h
**
**  Description:
**     This is the ONLY file to change in order to add or change error
**     definitions in PowerViews.
**
**  $Log:   S:/tbird/mt2_amd/errtext/mkerror1.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:12:28   Eric
** Initial revision.
** 
**    Rev 1.1   26 Feb 1997 11:36:06   Judy
** No change.
** 
**    Rev 1.0   16 Dec 1996 14:29:38   Judy
** Initial revision.
** 
**    Rev 1.12   20 Oct 1994 14:44:32   dennis
** Added ER_EIP_EXCEED_LIMIT error message. This error message indicates
** that the user tried to set the EIP to a value greater than the CS limit.
** 
**    Rev 1.11   18 Oct 1994 08:22:42   mindy
** added DT errors
** 
**    Rev 1.10   29 Sep 1994 09:10:50   marilyn
** Added DESC_NOT_ACTIVE error code.
** 
**    Rev 1.9   14 Sep 1994 12:45:40   dennis
** Made syntax changes to error messages, did not add any new ones.
** 
**    Rev 1.8   06 Sep 1994 10:08:40   joyce
** Add new error messages ER_OMF86_NOT_REAL and ER_OMF386_INIT_REG_FAILURE.
** 
**    Rev 1.7   29 Aug 1994 15:04:16   nghia
** Moved warning message from Actor to ERRTEXT.DLL.
** 
**    Rev 1.6   18 Aug 1994 15:58:30   dennis
** Added error codes for CPU protected mode operations. Mostly dealing with
** segment register error detection.
** 
**    Rev 1.5   18 Aug 1994 10:16:20   marilyn
** Added 3 address errors to differentiate exceeding max limit conditions.
** 
**    Rev 1.4   15 Aug 1994 13:38:28   ernie
** Added firmware error ER_PAGE_NOT_PRESENT
** 
**    Rev 1.3   10 Aug 1994 11:23:28   marilyn
** Added some more specific malloc errors.
** 
**    Rev 1.2   25 Jul 1994 11:40:02   brucea
** Added: error 1158.
** 
**    Rev 1.1   25 Jul 1994 10:19:14   brucea
** Corrected numbering error of 1050-1055 to 1150-1155
** Added 1156 and 1157.
** 
**    Rev 1.0   21 Jul 1994 16:55:52   nghia
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_amd/errtext/mkerror1.h_v   1.0   20 Mar 1998 10:12:28   Eric  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _MKERROR1_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _VRTXERRS_
#include "vrtxerrs.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
  /* Must match flash\public\error.h */
#define WW_ (0x004FL + 0x0037L + 100 + 0x40000000L)
#define ER_VRTX_BASE (0x004FL + 100 + 0x40000000L)

/*
 * Here are all the error codes for all the error types in PowerViews
 * The corresponding error text is in errtext\errtext.rc.
 *
 * ONLY MAKE CHANGES BELOW THIS LINE (in mkerrors.h)
 */
{
   "ER_PAGE_NOT_PRESENT",
   ( E_WARNING | 0L | 474L ),
   "Page requested is marked not present.",
   "HE_PAGE_NOT_PRESENT",
   LOCKED
},
{
   "ER_COMMDLG_INVALID_OBJECT",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1150L ),
   "Invalid object for the requested operation.",
   "HE_COMMDLG_INVALID_OBJECT",
   UNLOCKED
},
{
   "ER_COMMDLG_OBJECT_LIST_EMPTY",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1151L ),
   "Object list is empty.",
   "HE_COMMDLG_OBJECT_LIST_EMPTY",
   UNLOCKED
},
{
   "ER_COMMDLG_GET_FILTER_STR",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1152L ),
   "Cannot get file filter string.",
   "HE_COMMDLG_GET_FILTER_STR",
   UNLOCKED
},
{
   "ER_COMMDLG_CANNOT_FIND_OWNER",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1153L ),
   "Cannot find the owner of the current dialog box.",
   "HE_COMMDLG_CANNOT_FIND_OWNER",
   UNLOCKED
},
{
   "ER_COMMDLG_MISSING_HELP_ID",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1154L ),
   "Missing help context ID.",
   "HE_COMMDLG_MISSING_HELP_ID",
   UNLOCKED
},
{
   "ER_COMMDLG_FILE_DLG",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1155L ),
   "Windows COMMDLG File dialog error: %s.",
   "HE_COMMDLG_FILE_DLG",
   UNLOCKED
},
{
   "ER_BASENAME_NOT_FOUND",
   ( E_WARNING | 0L | 1156L ),
   "Cannot find base name.",
   "HE_BASENAME_NOT_FOUND",
   UNLOCKED
},
{
   "ER_SYM_BASEADDR_TOO_SMALL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1157L ),
   "Address being looked up is smaller than base address of symbol.",
   "HE_SYM_BASEADDR_TOO_SMALL",
   UNLOCKED
},
{
   "ER_HEAP_INVALID_CHUNK",    
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1158L ),
   "Null chunk pointer in the free chunk list.",         
   "HE_HEAP_INVALID_CHUNK",        
   UNLOCKED
},
{
   "ER_HEAP_INVALID_TAG",          
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1159L ),
   "Null tag pointer in located chunk.",               
   "HE_HEAP_INVALID_TAG",          
   UNLOCKED
},
{
   "ER_HEAP_FREE_LIST_CORRUPT",
   ( E_WARNING | 0L | 1160L ),
   "Found chunk for allocation is missing links to adjacent chunks.",
   "HE_HEAP_FREE_LIST_CORRUPT",
   UNLOCKED
},
{
   "ER_ADR_OFFSET_EXCEEDS_MAX",
   ( E_WARNING | 0L | 1161L ),
   "Virtual address offset is greater than the segment limit.",
   "HE_ADR_OFFSET_EXCEEDS_MAX",
   UNLOCKED
},
{
   "ER_ADR_PHYS_EXCEEDS_MAX",
   ( E_WARNING | 0L | 1162L ),
   "Physical address is greater than the target processor's maximum physical address.",
   "HE_ADR_PHYS_EXCEEDS_MAX",
   UNLOCKED
},
{
   "ER_ADR_LINEAR_EXCEEDS_MAX",
   ( E_WARNING | 0L | 1163L ),
   "Linear address is greater than the target processor's maximum linear address.",
   "HE_ADR_LINEAR_EXCEEDS_MAX",
   UNLOCKED
},
{
   "ER_SEGMENT_NOT_PRESENT",
   ( E_WARNING | 0L | 1164L ),
   "Segment selector references a descriptor marked as not present.",
   "HE_SEGMENT_NOT_PRESENT",
   UNLOCKED
},
{
   "ER_DESC_NOT_CODE",
   ( E_WARNING | 0L | 1165L ),
   "CS selector does not reference a code segment descriptor.",
   "HE_DESC_NOT_CODE",
   UNLOCKED
},
{
   "ER_DESC_NOT_DATA",
   ( E_WARNING | 0L | 1166L ),
   "SS selector does not reference a data segment descriptor.",
   "HE_DESC_NOT_DATA",
   UNLOCKED
},
{
   "ER_DESC_NOT_WRITABLE",
   ( E_WARNING | 0L | 1167L ),
   "SS selector references a data segment descriptor that is read only.",
   "HE_DESC_NOT_WRITABLE",
   UNLOCKED
},
{
   "ER_NOT_DATA_OR_CODE_READ",
   ( E_WARNING | 0L | 1168L ),
   "Selector must reference a data or readable code descriptor.",
   "HE_NOT_DATA_OR_CODE_READ",
   UNLOCKED
},
{
   "ER_RPL_GREATER_THEN_DPL",
   ( E_WARNING | 0L | 1169L ),
   "Selector RPL must be less than or equal to DPL.",
   "HE_RPL_GREATER_THEN_DPL",
   UNLOCKED
},
{
   "ER_CS_HAS_NULL_SELECTOR",
   ( E_WARNING | 0L | 1170L ),
   "Cannot set CS selector to null selector.",
   "HE_CS_HAS_NULL_SELECTOR",
   UNLOCKED
},
{
   "ER_SS_HAS_NULL_SELECTOR",
   ( E_WARNING | 0L | 1171L ),
   "Cannot set SS selector to null selector.",
   "HE_SS_HAS_NULL_SELECTOR",
   UNLOCKED
},
{
   "ER_LDTR_DESC_NOT_IN_GDT",
   ( E_WARNING | 0L | 1172L ),
   "LDTR selector table indicator bit must be 0 (GDT).",
   "HE_LDTR_DESC_NOT_IN_GDT",
   UNLOCKED
},
{
   "ER_TR_DESC_NOT_IN_GDT",
   ( E_WARNING | 0L | 1173L ),
   "TR selector table indicator bit must be 0 (GDT).",
   "HE_TR_DESC_NOT_IN_GDT",
   UNLOCKED
},
{
   "ER_LDTR_REAL_MODE_ERR",
   ( E_WARNING | 0L | 1174L ),
   "Cannot set LDTR selector value while in REAL mode.",
   "HE_LDTR_REAL_MODE_ERR",
   UNLOCKED
},
{
   "ER_TR_REAL_MODE_ERR",
   ( E_WARNING | 0L | 1175L ),
   "Cannot set TR selector value while in REAL mode.",
   "HE_TR_REAL_MODE_ERR",
   UNLOCKED
},
{
   "ER_NOT_A_TSS",
   ( E_WARNING | 0L | 1176L ),
   "TR selector does not reference a TSS descriptor.",
   "HE_NOT_A_TSS",
   UNLOCKED
},
{
   "ER_TSS_BUSY",
   ( E_WARNING | 0L | 1177L ),
   "TR selector references a busy TSS descriptor.",
   "HE_TSS_BUSY",
   UNLOCKED
},
{
   "ER_NOT_A_LDT",
   ( E_WARNING | 0L | 1178L ),
   "LDTR selector does not reference an LDT descriptor.",
   "HE_NOT_A_LDT",
   UNLOCKED
},
{
   "ER_SRC_ABORT",
   ( E_WARNING | 0L | 1179L ),
   "Abort current operation?",
   "HE_SRC_ABORT",
   UNLOCKED
},
{
   "ER_OMF86_NOT_REAL",
   ( E_WARNING | 0L | 1180L ),
   "Attempt to load an OMF86 program while the processor is not in real mode.",
   "HE_OMF86_NOT_REAL",
   UNLOCKED
},
{
   "ER_OMF386_INIT_REG_FAILURE",
   ( E_WARNING | 0L | 1181L ),
   "The OMF386 loader failed to initialize register: %s.",
   "HE_OMF386_INIT_REG_FAILURE",
   UNLOCKED
},
{
   "ER_ADR_DESC_NOT_ACTIVE",   
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1182L ),
   "Attempted to use an address descriptor that has already been destroyed and is not currently active.",
   "HE_ADR_DESC_NOT_ACTIVE",        
   UNLOCKED
},
{
   "ER_NOT_GDT_ENTRY",   
   ( E_WARNING | 0L | 1183L ),
   "Selector given is not a GDT descriptor entry.",
   "HE_NOT_GDT_ENTRY",        
   UNLOCKED
},
{
   "ER_NOT_LDT_ENTRY",   
   ( E_WARNING | 0L | 1184L ),
   "Selector given is not a LDT descriptor entry.",
   "HE_NOT_LDT_ENTRY",        
   UNLOCKED
},
{
   "ER_LIMIT_NOT_SPECIFIED",   
   ( E_WARNING | 0L | 1185L ),
   "Limit needs to be given.",
   "HE_LIMIT_NOT_SPECIFIED",        
   UNLOCKED
},
{
   "ER_INVALID_DT_ENTRIES",   
   ( E_WARNING | 0L | 1186L ),
   "Selector(s) given are out of range.",
   "HE_INVALID_DT_ENTRIES",        
   UNLOCKED
},
{
   "ER_BAD_ENTRY",   
   ( E_WARNING | 0L | 1187L ),
   "Bad Selector (out of range).",
   "HE_BAD_ENTRY",        
   UNLOCKED
},
{
   "ER_EIP_EXCEED_LIMIT",   
   ( E_WARNING | 0L | 1188L ),
   "Attempted to set EIP to value greater than its limit.",
   "HE_EIP_EXCEED_LIMIT",        
   UNLOCKED
},

/* next error code available:  1189*/
/***************************** EOF *****************************************/
