/***************************************************************************
**
**    $Header:   S:/tbird/mt2_amd/fwsetup/abidll.cpv   1.0   06 May 1998 17:18:50   Eric  $
**
**    $Log:   S:/tbird/mt2_amd/fwsetup/abidll.cpv  $
** 
**    Rev 1.0   06 May 1998 17:18:50   Eric
** Initial revision.
** 
****************************************************************************/

// ABIdll.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "abidll.h"
#include "abifn186.h"
#include "uiserial.h"
#include "abiextfn.h" //Eric 3/26/98

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Initialization of MFC Extension DLL

CBaseAbi* pAbi = NULL;
CBaseSerialAgree  *pTheCom = NULL;
ABI_INIT_OPTION g_nOption;
static int nReference = 0;  

// Exported DLL initialization is run in context of running application
BOOL WINAPI NewABIDLL(ABI_INIT_OPTION nOption)
{   
    // add other initialization here
    nReference++;
    if( pAbi!= NULL ) return TRUE;
    g_nOption = nOption;
    if(MAKE_SIMULATOR_ABI == nOption) {
        if ((pAbi = new CSimulator186Abi) == NULL) {
            nReference--;
            return FALSE;
        }   
    } else if(MAKE_REAL_186_ABI == nOption || MAKE_REAL_186_ABI_FIRSTTIME == nOption) {                   
        if ((pAbi = new C186Abi) == NULL) {
            nReference--;
            return FALSE;
        }   
        if ((pTheCom = new CWinSerialAgree_186) == NULL) {
            nReference--;
            return FALSE;
        }   
        ((C186Abi*)pAbi)->ConnectTo(pTheCom);
                            
        pTheCom->m_isRepeat = TRUE;
        if(MAKE_REAL_186_ABI_FIRSTTIME == nOption) pTheCom->m_isFirstTime = TRUE;
        if (!pTheCom->CommInit()) {                                   
            nReference--;
            AfxMessageBox("MicePack 186F/SLD communication failure!");
            return FALSE;
        }   
    } else if(MAKE_REAL_186_ABI_DIAGNOSTIC == nOption ) {  
        if ((pAbi = new C186Abi) == NULL) return FALSE;
        if ((pTheCom = new CWinSerialAgree_186_Diagnostic) == NULL) return FALSE;
        ((C186Abi*)pAbi)->ConnectTo(pTheCom);
        pTheCom->m_isRepeat = TRUE;    
        //FOR COMMUNICATION ARGUEMENT SETTINGS
//      if(MAKE_REAL_186_ABI_FIRSTTIME == nOption) pTheCom->m_isFirstTime = TRUE;
//      else pTheCom->m_isFirstTime = FALSE;
        if (!pTheCom->CommInit()) {
            AfxMessageBox("MicePack 186F/SLD communication failure!");
            return FALSE;
        }   
    } else {             
        nReference--;
        return FALSE;
    }              
    
    return TRUE;
}


BOOL WINAPI ExitABIDLL(){
    nReference--;
    if(nReference !=0) return TRUE;
    if(NULL != pAbi) delete pAbi;
    if(NULL != pTheCom) delete pTheCom;
    return TRUE;
}

CBaseAbi* WINAPI GetAbi() {
    return pAbi;
}

CBaseSerialAgree* WINAPI GetCom() {
    return pTheCom;
}

void WINAPI GetSerialBaudRateStr(CString& str) {
    if(NULL == pTheCom) str = "";
    else str = pTheCom->GetSerialBaudRateStr();
} 
void WINAPI GetSerialPortNumStr(CString& str) {
    if(NULL == pTheCom) str = "";
    else str = pTheCom->GetSerialPortNumStr();
} 

STATUS WINAPI emuGetDiagnosticMeterTimer(BYTE& bTimer) {
    if(g_nOption != MAKE_REAL_186_ABI_DIAGNOSTIC) 
        return ICE_ERR_NOT_READY_FOR_DIAGNOSTIC;
    bTimer = ((CWinSerialAgree_186_Diagnostic*)pTheCom)->m_bWaitTime;
    return ICE_OK;  
}

STATUS WINAPI emuSetDiagnosticIsStop(BOOL isStop) {
    if(g_nOption != MAKE_REAL_186_ABI_DIAGNOSTIC) 
        return ICE_ERR_NOT_READY_FOR_DIAGNOSTIC;
    ((CWinSerialAgree_186_Diagnostic*)pTheCom)->m_isStop = isStop;
    return ICE_OK;  
}

STATUS WINAPI emuReshakeHandle() {
    if(NULL != pAbi) delete pAbi;
    if(NULL != pTheCom) delete pTheCom;
    pAbi = NULL;
    pTheCom = NULL;
    if(NewABIDLL(MAKE_REAL_186_ABI)) return ICE_OK;
    else return !ICE_OK;
    
}
