/***************************************************************************
**
**    $Header:   S:/tbird/mt2_amd/fwsetup/abifn186.cpv   1.1   20 May 1998 10:29:26   Eric  $
**
**    $Log:   S:/tbird/mt2_amd/fwsetup/abifn186.cpv  $
** 
**    Rev 1.1   20 May 1998 10:29:26   Eric
** 
**    Rev 1.0   06 May 1998 17:18:50   Eric
** Initial revision.
** 
****************************************************************************/
/***************************************************************************
**
** File name : ABIFN186.CPP
** Author:john chow
** Description:
**    Descript the ABI routine for 186
**
**    Finished date: 96.10
**    modifed date:
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/


#include "stdafx.h"
#include "abifn186.h"
//implemention of class C186Abi
/* 
STATUS C186Abi::emuSetAllEvent(BUS_EVENT *event_record, EXEC_EVENT *bp_record,U16 *ext_record)
{ 
    STATUS status;
    m_Pipe.StartVar();
    m_Pipe.SaveVar(*bp_record);  
    m_Pipe.SaveVar(*ext_record);  
    m_Pipe.SetVar((BYTE*)dataContent,dataLen);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_ERROR_COM != status) {
        m_Pipe.LoadVar(*addr);
    }   
    return status;

 }      
*/
STATUS C186Abi::emuSetTimerReg(U16 settings)
{ 
    STATUS status;
    m_Pipe.StartVar(SET_TIMER_REG);
    m_Pipe.SaveVar(settings);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;

 }      

STATUS C186Abi::emuConfig(BYTE uconfigset[8], BYTE uconfigGet[8])
{ 
    STATUS status;
    m_Pipe.StartVar(CONFIG_CPU);
    m_Pipe.SetVar(uconfigset,8);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        m_Pipe.GetVar(uconfigGet,8);
    }
        
    return status;

 }      

STATUS C186Abi::emuGetConfig(BYTE uconfigset[8])  
{ 
    STATUS status;
    m_Pipe.StartVar(GET_CONFIG);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        m_Pipe.GetVar(uconfigset,8);
    }
        
    return status;

 } 
 
STATUS C186Abi::emuSetPort(U16 portNum)    
{ 
    STATUS status;
    m_Pipe.StartVar(SET_PORT);
    m_Pipe.SaveVar(portNum);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;

 } 
 
/*
STATUS C186Abi::emuCycle(U8 StepMode,WORD wNextAddrNum, ADDR* NextAddr, U8* frameNum,TRACE_INFO* traceInfo) 
{ 
    STATUS status;
    m_Pipe.StartVar(CYCLE);
    m_Pipe.SaveVar(StepMode);
    m_Pipe.SaveVar(wNextAddrNum);
    m_Pipe.SetVar((BYTE*)NextAddr,wNextAddrNum*sizeof(ADDR));
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        m_Pipe.LoadVar(*frameNum);
        m_Pipe.LoadBuffer((BYTE*)traceInfo,*frameNum);
    }
        
    return status;

 } 
*/ 
STATUS C186Abi::emuGetHWMode(U8* mode)  
{ 
    STATUS status;
    m_Pipe.StartVar(GET_HW_MODE);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        m_Pipe.LoadVar(*mode);
    }
        
    return status;

 }                                                               
/* 
STATUS C186Abi::emuStepOne(U8  StepMode ,U16 uNextAddrNum, ADDR* NextAddr)
{ 
    STATUS status;
    m_Pipe.StartVar(STEP_ONE);
    m_Pipe.SaveVar(StepMode);
    m_Pipe.SaveVar(uNextAddrNum);
    m_Pipe.SetVar((BYTE*)NextAddr,uNextAddrNum*sizeof(ADDR));
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;

 } 
*/
STATUS C186Abi::emuStepOver(U8 StepMode ,U16 uNextAddrNum, ADDR* NextAddr)
{ 
    STATUS status;
    m_Pipe.StartVar(STEP_OVER);
    m_Pipe.SaveVar(StepMode);
    m_Pipe.SaveVar(uNextAddrNum);
    m_Pipe.SetVar((BYTE*)NextAddr,uNextAddrNum*sizeof(ADDR));
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;

 }                         
 
STATUS C186Abi::emuClrTrig(U16 evId) {
    STATUS status;
    m_Pipe.StartVar(CLR_TRIG);
    m_Pipe.SaveVar(evId);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;
}   

STATUS C186Abi::emuGetAllTrig(TRIGGER *trig_record) {

    STATUS status;
    m_Pipe.StartVar(GET_TRIG);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {           
        for(int i = 0;i<4;i++)
            m_Pipe.LoadVar(trig_record[i]);
    }
    
    return status;
}

STATUS C186Abi::emuGetControl(U8 signals,U8* value) {

    STATUS status;
    m_Pipe.StartVar(GET_CONTROL);
    m_Pipe.SaveVar(signals);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        m_Pipe.LoadVar(*value);
    }
    
    return status;
}                                                  

STATUS C186Abi::emuGetEvent(BUS_EVENT* event_record,U16 *ext_record) {
    STATUS status;
    m_Pipe.StartVar(GET_EVENT);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        for(int i = 0; i<8; i++)
            m_Pipe.LoadVar(event_record[i]);
        m_Pipe.LoadVar(*ext_record);
    }
    
    return status;
}                                                                  

STATUS C186Abi::emuGetReady(U16 *readyFlag) {

    STATUS status;
    m_Pipe.StartVar(GET_READY);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        m_Pipe.LoadVar(*readyFlag);
    }
    
    return status;
}                                                

STATUS C186Abi::emuGetSync(U16 *sync) {

    STATUS status;
    m_Pipe.StartVar(GET_SYNC);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        m_Pipe.LoadVar(*sync);
    }
    
    return status;
}                           

STATUS C186Abi::emuGetTraceInfo(U16 *lastBuff, U32 *curCNT0, U32 *curCNT1, U16 *bufNO,U32* timer,U8* timerMSB) {

    STATUS status;
    m_Pipe.StartVar(GET_LAST_BUFF);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        m_Pipe.LoadVar(*lastBuff);
        m_Pipe.LoadVar(*curCNT0); 
        m_Pipe.LoadVar(*curCNT1); 
        m_Pipe.LoadVar(*bufNO); 
        m_Pipe.LoadVar(*timer);         
        m_Pipe.LoadVar(*timerMSB);      
    }
    
    return status;  
}

STATUS C186Abi::emuListTraceBuff(U32 dwStartFrame,
                            U32 dwFrameNum, QUALIFY_INFO *qualifyInfo,
                            U8 *frameLen,TRACE_INFO *traceInfo,
                            U8 * /*readEnd*/)
{ 
    STATUS status;
    m_Pipe.StartVar(LIST_TRACE);
    m_Pipe.SaveVar(dwStartFrame);  
    m_Pipe.SaveVar(dwFrameNum);   
    m_Pipe.SaveVar(*qualifyInfo);   
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        m_Pipe.LoadVar(*frameLen);
        for(int i=0;i<*frameLen;i++)
            m_Pipe.LoadVar(traceInfo[i]);
        //m_Pipe.LoadVar(*readEnd);
    }   
    return status;

 }
 
STATUS C186Abi::emuSetAllEvent(BUS_EVENT *event_record, U16 ext_record) {

    STATUS status;
    m_Pipe.StartVar(SET_ALL_EVENT);
    m_Pipe.SetVar((BYTE*)event_record,8*sizeof(BUS_EVENT));
    m_Pipe.SaveVar(ext_record);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;  

}                                     

STATUS C186Abi::emuSetControl(U8 id,U8 value) {

    STATUS status;
    m_Pipe.StartVar(SET_CONTROL);
    m_Pipe.SaveVar(id);  
    m_Pipe.SaveVar(value);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;  

 }

STATUS C186Abi::emuSetReady(U16 readyFlag) {

    STATUS status;
    m_Pipe.StartVar(SET_READY);
    m_Pipe.SaveVar(readyFlag);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;  
 }                            

STATUS C186Abi::emuSetSync(U16 syncFlag) { 

    STATUS status;
    m_Pipe.StartVar(SET_SYNC);
    m_Pipe.SaveVar(syncFlag);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;  
 }                                      
 
STATUS C186Abi::emuSetTimerCounter(U16 tcFlag, U32 tcData0, U32 tcData1) {

    STATUS status;
    m_Pipe.StartVar(SET_TIMER_COUNTER);
    m_Pipe.SaveVar(tcFlag);  
    m_Pipe.SaveVar(tcData0);  
    m_Pipe.SaveVar(tcData1);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;  
 }                                    
 
STATUS C186Abi::emuSetTraceBreak(U16 breakFull) {

    STATUS status;
    m_Pipe.StartVar(SET_TRACE_BREAK);
    m_Pipe.SaveVar(breakFull);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;  
}

STATUS C186Abi::emuSetTrig(U16 levelNo,TRIGGER* tmpTrig) {

    STATUS status;
    m_Pipe.StartVar(SET_TRIG);
    m_Pipe.SaveVar(levelNo);  
    m_Pipe.SaveVar(*tmpTrig);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;  
}                         

STATUS C186Abi::emuSetTrigOut(U16 trigOut) {   

    STATUS status;
    m_Pipe.StartVar(SET_TRIG_OUT_ACT);
    m_Pipe.SaveVar(trigOut);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;
}

STATUS C186Abi::emuTraceAction(U16 traceAct) {

    STATUS status;
    m_Pipe.StartVar(TRACE_ACTION);
    m_Pipe.SaveVar(traceAct);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;

 }
 
STATUS C186Abi::emuReadFlash(U8 *data) {

    STATUS status;
    m_Pipe.StartVar(R_FLUSH_ROM);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        m_Pipe.GetVar(data,32);
    }

    return status;
 }
 
STATUS C186Abi::emuWriteFlash(U8 *data) {

    STATUS status;
    m_Pipe.StartVar(W_FLUSH_ROM);
    m_Pipe.SetVar(data,32);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;
 }
 
STATUS C186Abi::emuSPASetRange(U8 type,U8 id,ADDR start,ADDR end) {
    STATUS status;
    m_Pipe.StartVar(SPA_SET_RANGE);
    m_Pipe.SaveVar(type);  
    m_Pipe.SaveVar(id);  
    m_Pipe.SaveVar(start);  
    m_Pipe.SaveVar(end);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;
 }
 
STATUS C186Abi::emuSPAClearRange(U8 type) {
    STATUS status;
    m_Pipe.StartVar(SPA_CLEAR_RANGE);
    m_Pipe.SaveVar(type);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;
 }
 
STATUS C186Abi::emuSPASetBkpt(U8 enable,ADDR addr) {
    STATUS status;
    m_Pipe.StartVar(SPA_SETBKPT);
    m_Pipe.SaveVar(enable);  
    m_Pipe.SaveVar(addr);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;
 }
 
STATUS C186Abi::emuSPAOpen() {
    STATUS status;
    m_Pipe.StartVar(SPA_OPEN);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;
 }
 
STATUS C186Abi::emuSPAClose() {
    STATUS status;
    m_Pipe.StartVar(SPA_CLOSE);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    return status;
 }
 
STATUS C186Abi::emuSPAGetMAInfo(U32 *totalTime,U8 *totalTimeMSB,SPA_MA_INFO_NODE *info,BOOL *flagHalt) {
    STATUS status;
    m_Pipe.StartVar(SPA_GET_MA_INFO);
    m_Pipe.EndVar(END_CODE);
    //m_Pipe.m_isCareful = TRUE;
        
    status = Start();
    
    m_Pipe.m_isCareful = FALSE;
    if(ICE_OK == status) {
        m_Pipe.LoadVar(*flagHalt);
        m_Pipe.LoadVar(*totalTime);
        m_Pipe.LoadVar(*totalTimeMSB);
        m_Pipe.GetVar((BYTE*)info,4*sizeof(SPA_MA_INFO_NODE));;
        
    }
    
    return status;
 }                                                                      
 
STATUS C186Abi::emuSPAGetTAInfo(U32 *timeStamp,U8 *timeStampMSB,U16 *info,BOOL *flagHalt) {
    STATUS status;
    m_Pipe.StartVar(SPA_GET_TA_INFO);
    m_Pipe.EndVar(END_CODE);  
    //m_Pipe.m_isCareful = TRUE;
        
    status = Start();   
                              
    m_Pipe.m_isCareful = FALSE;                          
    if(ICE_OK == status) {
        m_Pipe.LoadVar(*flagHalt);
        m_Pipe.LoadVar(timeStamp[0]);
        m_Pipe.LoadVar(timeStampMSB[0]);
        m_Pipe.LoadVar(timeStamp[1]);
        m_Pipe.LoadVar(timeStampMSB[1]);
        m_Pipe.LoadVar(timeStamp[2]);
        m_Pipe.LoadVar(timeStampMSB[2]);
        m_Pipe.GetVar((BYTE*)info,9*sizeof(U16));
    }
    
    return status;
 }
 
STATUS C186Abi::emuSPAGetCCInfo(ADDR start,U16 len,U16* retLen,U8 *buf,BOOL* flagHalt) {

    STATUS status;
    m_Pipe.StartVar(SPA_GET_CC_INFO);
    m_Pipe.SaveVar(start);     
    m_Pipe.SaveVar(len);  
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    if(ICE_OK == status) {
        m_Pipe.LoadVar(*flagHalt);
        if(*flagHalt != TRUE) return status;
        BYTE bTmp;
        m_Pipe.GetByte(bTmp);
        *retLen = bTmp;      
        m_Pipe.GetByte(bTmp);
        *retLen = *retLen + ((U16)bTmp)*256;      
        m_Pipe.GetBytes(buf,(int)(*retLen));
    }
    return status;
 }

STATUS C186Abi::emuSetBp(ADDR addr)
{ 
    STATUS status;
    m_Pipe.StartVar(SET_EX_BKPT);
    m_Pipe.SaveVar(addr);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();

    return status;
 }                                                  
 
STATUS C186Abi::emuStepRange(ADDR addr1, ADDR addr2) 
{ 
    STATUS status;
    m_Pipe.StartVar(STEP);
    m_Pipe.SaveVar(addr1);
    m_Pipe.SaveVar(addr2);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();

    return status;  
 }

  
STATUS C186Abi::emuSendAddr(DWORD dwAddr, DWORD dwLen) 
{ 
    BYTE bTmp[20];
    bTmp[0] = ':';
    memcpy(&(bTmp[1]),&dwAddr,4);
    memcpy(&(bTmp[5]),&dwLen,4);
    bTmp[9] = 0;
    for(int i=0;i<9;i++) 
        bTmp[9] = bTmp[9] + bTmp[i];
    bTmp[9] = (~bTmp[9])+1;
    m_pAgree->SetTimer(300);    
    if(!m_pAgree->SendString(bTmp,10)) 
        return !ICE_OK;
    m_pAgree->SetTimer(500);
    if(!m_pAgree->ReceiveByte(bTmp[0])) 
        return !ICE_OK;
    if(bTmp[0] != CTWAgree::ACK) 
        return !ICE_OK;
    return ICE_OK;
        
 }          
 
STATUS C186Abi::emuDownLoad186FW(CFile* fileFW,void (*fp)(int))
{                                                             
    
    BYTE* bTmp = new BYTE[2048];
    DWORD dwAddr = 0x400;      
    DWORD dwLenCheck = 0;
    //if(!emuSendAddr(0,0)) return !ICE_OK;
    
    for(DWORD i=0;i<255;i++) {   
        if( 1024 != fileFW->Read(bTmp,1024) ) break;
        dwAddr = (DWORD)0x400+1024*i;
        dwLenCheck = 1024;     
        WORD wCheck = 0;
        for(int j=0;j<1024;j++)
            wCheck += bTmp[j];
        //wCheck =(~wCheck)+1;
        int k=0;
        while((k++)<5) {
            if(ICE_OK!=emuSendAddr(dwAddr,dwLenCheck|( ((DWORD)wCheck)<<16 ) )) 
                continue;
            m_pAgree->SetTimer(2000);
            if(!m_pAgree->SendString(bTmp,1024)) 
                continue;
            m_pAgree->SetTimer(2000);
            BYTE bb;
            if(!m_pAgree->ReceiveByte(bb)) 
                continue;
            if(bb != CTWAgree::ACK) 
                continue; 
            break;
        }
        if(k>=5) 
            return !ICE_OK;
        if (NULL != fp) 
            fp(i);
    }                                    
    
    if( dwAddr != ((DWORD)0x400 + (DWORD)1024*254) ) 
        return !ICE_OK;
    if(ICE_OK!=emuSendAddr(0,0)) 
        return !ICE_OK;
    return ICE_OK;
 }

STATUS C186Abi::EmuSetTrcOffOnFull(U16 trcOffOnFull) {
    STATUS status;
    m_Pipe.StartVar(SET_TRACE_OFF_FULL);
    m_Pipe.SaveVar(trcOffOnFull);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();

    return status;  
}

STATUS C186Abi::emuGetFROM(U8 data[32]) {
    STATUS status;
    m_Pipe.StartVar(R_FLUSH_ROM);
    m_Pipe.SetVar(data,32);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();

    return status;  
}

STATUS C186Abi::emuSetFROM(U8 data[32]) {
    STATUS status;
    m_Pipe.StartVar(W_FLUSH_ROM);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();           
    if(ICE_OK == status)
        m_Pipe.GetVar(data,32);
    return status;  
}                                              

//STATUS C186Abi::emuDiagnostic186(U32 diagID,DIAGNORESULT* retVal,unsigned long nBackTimer) {
//    STATUS status;
//    m_Pipe.StartVar(DIAGNOSTIC);
//    m_Pipe.SaveVar(diagID);
//    m_Pipe.EndVar(END_CODE);
//        
//    status = Start(nBackTimer);
//    
//    if(ICE_OK == status) {
//        m_Pipe.LoadVar(*retVal);
//    }   
//    return status;  
//}
STATUS C186Abi::emuDiagnostic186(U32 diagID,U32 *retData,U8 *retID) {
    STATUS status;
    m_Pipe.StartVar(diagID);
    m_Pipe.EndVar(END_CODE);
        
    status = Start();
    
    m_Pipe.LoadVar(*retData);

    return status;
}

//only for TB download fw 
BOOL isNeedDownload;
STATUS C186Abi::emuNeedDownload() {  
    if(isNeedDownload) return ICE_OK;
    return !ICE_OK; 
} 
////////////////////////                                 
