// prostatu.cpp : implementation file
//

#include "stdafx.h"
#include "flsrom.h"
#include "flspro.h"
#include "resource.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
                                                    
#define MEM_SIZE 8192   

void DrawTransparentBitmap(HDC hdc, HBITMAP hBitmap, short xStart,
                           short yStart, COLORREF cTransparentColor)
   {
   BITMAP     bm;
   COLORREF   cColor;
   HBITMAP    bmAndBack, bmAndObject, bmAndMem, bmSave;
   HBITMAP    bmBackOld, bmObjectOld, bmMemOld, bmSaveOld;
   HDC        hdcMem, hdcBack, hdcObject, hdcTemp, hdcSave;
   POINT      ptSize;

   hdcTemp = CreateCompatibleDC(hdc);
   SelectObject(hdcTemp, hBitmap);   // Select the bitmap

   GetObject(hBitmap, sizeof(BITMAP), (LPSTR)&bm);

   ptSize.x = bm.bmWidth;            // Get width of bitmap
   ptSize.y = bm.bmHeight;           // Get height of bitmap
   DPtoLP(hdcTemp, &ptSize, 1);      // Convert from dev
   
                                     // to logical points

   // Create some DCs to hold temporary data.
   hdcBack   = CreateCompatibleDC(hdc);
   hdcObject = CreateCompatibleDC(hdc);
   hdcMem    = CreateCompatibleDC(hdc);
   hdcSave   = CreateCompatibleDC(hdc);

   // Create a bitmap for each DC. DCs are required for a number of
   // GDI functions.

   // Monochrome DC

   bmAndBack   = ::CreateBitmap(ptSize.x, ptSize.y, 1, 1, NULL);

   // Monochrome DC
   bmAndObject = ::CreateBitmap(ptSize.x, ptSize.y, 1, 1, NULL);

   bmAndMem    = ::CreateCompatibleBitmap(hdc, ptSize.x, ptSize.y);
   bmSave      = ::CreateCompatibleBitmap(hdc, ptSize.x, ptSize.y);

   // Each DC must select a bitmap object to store pixel data.
   bmBackOld   = (HBITMAP)::SelectObject(hdcBack, bmAndBack);
   bmObjectOld = (HBITMAP)::SelectObject(hdcObject, bmAndObject);
   bmMemOld    = (HBITMAP)::SelectObject(hdcMem, bmAndMem);
   bmSaveOld   = (HBITMAP)::SelectObject(hdcSave, bmSave);

   // Set proper mapping mode.
   ::SetMapMode(hdcTemp, GetMapMode(hdc));

   // Save the bitmap sent here, because it will be overwritten.
   ::BitBlt(hdcSave, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0, SRCCOPY);

   // Set the background color of the source DC to the color.
   // contained in the parts of the bitmap that should be transparent
   cColor = ::SetBkColor(hdcTemp, cTransparentColor);

   // Create the object mask for the bitmap by performing a BitBlt()
   // from the source bitmap to a monochrome bitmap.
   ::BitBlt(hdcObject, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0,
          SRCCOPY);

   // Set the background color of the source DC back to the original
   // color.
   ::SetBkColor(hdcTemp, cColor);

   // Create the inverse of the object mask.
   ::BitBlt(hdcBack, 0, 0, ptSize.x, ptSize.y, hdcObject, 0, 0,
          NOTSRCCOPY);

   // Copy the background of the main DC to the destination.
   ::BitBlt(hdcMem, 0, 0, ptSize.x, ptSize.y, hdc, xStart, yStart,
          SRCCOPY);

   // Mask out the places where the bitmap will be placed.
   ::BitBlt(hdcMem, 0, 0, ptSize.x, ptSize.y, hdcObject, 0, 0, SRCAND);

   // Mask out the transparent colored pixels on the bitmap.
   ::BitBlt(hdcTemp, 0, 0, ptSize.x, ptSize.y, hdcBack, 0, 0, SRCAND);

   // XOR the bitmap with the background on the destination DC.
   ::BitBlt(hdcMem, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0, SRCPAINT);

   // Copy the destination to the screen.
   ::BitBlt(hdc, xStart, yStart, ptSize.x, ptSize.y, hdcMem, 0, 0,
          SRCCOPY);

   // Place the original bitmap back into the bitmap sent here.
   ::BitBlt(hdcTemp, 0, 0, ptSize.x, ptSize.y, hdcSave, 0, 0, SRCCOPY);

   // Delete the memory bitmaps.
   ::DeleteObject(SelectObject(hdcBack, bmBackOld));
   ::DeleteObject(SelectObject(hdcObject, bmObjectOld));
   ::DeleteObject(SelectObject(hdcMem, bmMemOld));
   ::DeleteObject(SelectObject(hdcSave, bmSaveOld));

   // Delete the memory DCs.
   ::DeleteDC(hdcMem);
   ::DeleteDC(hdcBack);

   ::DeleteDC(hdcObject);
   ::DeleteDC(hdcSave);
   ::DeleteDC(hdcTemp);
   }

                                                
/////////////////////////////////////////////////////////////////////////////
// CProStatus dialog


CProStatus::CProStatus(CWnd* pParent /*=NULL*/)
	: CDialog(CProStatus::IDD, pParent)
{
	//{{AFX_DATA_INIT(CProStatus)
	m_nDoneRecords=0;
	m_nFilledBlank=0;
	m_nRecordDone=0;               
	m_nIcon=0;
	//}}AFX_DATA_INIT
}


void CProStatus::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CProStatus)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CProStatus, CDialog)
	//{{AFX_MSG_MAP(CProStatus)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CProStatus::DrawFrame(CDC * pdc, CRect rect)
{
	rect.InflateRect(1,1);   
	m_ProRect=rect;
    CPen* pOldPen,*pPen=new CPen;
    CPoint points[4];   
    points[0]=CPoint(rect.left,rect.bottom);
    points[1]=CPoint(rect.left,rect.top);
    points[2]=CPoint(rect.right,rect.top);
    points[3]=CPoint(rect.right,rect.bottom); 
    pdc->MoveTo(points[0]);
 	pdc->LineTo(points[1]);
 	pdc->LineTo(points[2]);
    pPen->DeleteObject();
    pPen->CreatePen(PS_SOLID,1,RGB(255,255,255) );
    pOldPen=pdc->SelectObject(pPen);
 	pdc->LineTo(points[3]);
 	pdc->LineTo(points[0]);
    pdc->SelectObject(pOldPen);
    pPen->DeleteObject();
    delete pPen;
}    

/////////////////////////////////////////////////////////////////////////////
// CProStatus message handlers

void CProStatus::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
    CRect rect,RE,re;                           
    GetClientRect(&rect);
    re=rect;
    re.InflateRect(-10,-10); 
    
    rect.InflateRect(-10,-30);
    rect.top=rect.bottom-20;
    CBrush myBrush;
    CBrush *pOldBrush,*pbrush=&myBrush;
    CPen myPen;
    CPen *pOldPen,* pPen=&myPen;
    pbrush->CreateSolidBrush(RGB(255,255,255) ); 
    pOldBrush=dc.SelectObject(pbrush);

    dc.SelectObject(pOldBrush);
	pbrush->DeleteObject();
    int per,origlen;
    CPoint point1,point2;     
	     
	char str[5]="";
	float percent; 
    
    switch (m_nRecordDone){
    case 0: {
    	DrawFrame(&dc, rect);
		dc.SetBkMode(TRANSPARENT);  
		GetClientRect(&re);
		re.InflateRect(-5,-15);      
        dc.DrawText("NOW DOWNLOADING RECORDS...",26,&re,DT_TOP|DT_LEFT );
		rect.InflateRect(-1,-1);
   		point1=rect.TopLeft();
   		point2=rect.BottomRight(); 
 	  	origlen=(int)(((float)m_nDoneRecords/((float)m_nRecordNum/20.0))*m_fstep);   
        re.SetRect(point1.x,point1.y,point1.x+origlen,point2.y );  
        RE.SetRect(point1.x+origlen,point1.y,point2.x, point2.y ); 	                             
        pbrush->CreateSolidBrush(RGB(255,0,0) );
     	dc.FillRect(&re,pbrush);
    	pbrush->DeleteObject();
    	
    	percent= ( (float)m_nDoneRecords )/m_nRecordNum*100;
	    per=(int) percent;
    	wsprintf(str,"%d%%",per);
    	dc.DrawText(str,(per>9?3:2),&rect,DT_CENTER);   
//draw icon
		CDC dcMemory;
		CBitmap bmpMyBitmap, *pbmpOld;
		BITMAP bm;
		bmpMyBitmap.LoadBitmap(IDB_ICON0);
		bmpMyBitmap.GetObject( sizeof(BITMAP), &bm);

		dcMemory.CreateCompatibleDC(&dc);
		pbmpOld = dcMemory.SelectObject(&bmpMyBitmap);

        dcMemory.SelectObject(pbmpOld); 
        bmpMyBitmap.DeleteObject();
        dc.DrawIcon(260,10,AfxGetApp()->LoadIcon(IDI_ICON6));
        dc.DrawIcon(295,35,AfxGetApp()->LoadIcon(IDI_ICON7));
        dc.DrawIcon(280,10,AfxGetApp()->LoadIcon(m_nIcon+IDI_ICON1));
		if( !dcMemory.DeleteDC()) 
		     return;; 
        m_nIcon=(++m_nIcon)%5;
//end draw   

    	break;
     }

   case 1: {
       dc.SetBkMode(TRANSPARENT);    
       dc.DrawText("NOW FILLING THE BLANKS",22,&re,DT_BOTTOM|DT_LEFT );
       dc.DrawText("PLEASE WAIT A WHILE...",22,&rect,DT_CENTER );
       dc.DrawIcon(260,10,AfxGetApp()->LoadIcon(IDI_ICON6));
       dc.DrawIcon(295,35,AfxGetApp()->LoadIcon(IDI_ICON7));
       break;
     }        

    case 2: { //Eric add 5/14/98
    	DrawFrame(&dc, rect);
		dc.SetBkMode(TRANSPARENT);  
		GetClientRect(&re);
		re.InflateRect(-5,-15);      
        //dc.DrawText("NOW DIAGNOSTIC FIRMWARE...",26,&re,DT_TOP|DT_LEFT );
        dc.DrawText(diagDisplayMTAT2[m_nDoneRecords],20,&re,DT_TOP|DT_LEFT );
		rect.InflateRect(-1,-1);
   		point1=rect.TopLeft();
   		point2=rect.BottomRight(); 
 	  	origlen=(int)(((float)m_nDoneRecords/((float)m_nRecordNum/20.0))*m_fstep);   
        re.SetRect(point1.x,point1.y,point1.x+origlen,point2.y );  
        RE.SetRect(point1.x+origlen,point1.y,point2.x, point2.y ); 	                             
        pbrush->CreateSolidBrush(RGB(0,255,0) );
     	dc.FillRect(&re,pbrush);
    	pbrush->DeleteObject();
    	
    	percent= ( (float)m_nDoneRecords )/m_nRecordNum*100;
	    per=(int) percent;
    	wsprintf(str,"%d%%",per);
    	dc.DrawText(str,(per>9?3:2),&rect,DT_CENTER);   

//draw bitmap
        CDC * pDisplayMemDC = new CDC;
        CBitmap* pBitmap = new CBitmap;
        pBitmap->LoadBitmap(IDB_BITMAP1);
        pDisplayMemDC->CreateCompatibleDC(&dc);
        pDisplayMemDC->SelectObject(pBitmap);
        dc.BitBlt(260,10,60,60,pDisplayMemDC,0,0,SRCCOPY);
        delete pDisplayMemDC;
        delete pBitmap;
//end draw   

    	break;
     }
   }      //end of switch
}

BOOL CProStatus::Create()
{
    return CDialog::Create(IDD_PROCESS);
}   
 
 
 
 
BOOL CProStatus::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CRect rect;
    CString strTitle;
    strTitle.LoadString(IDS_TITLE);
    SetWindowText((strTitle));
//Center Window.
	GetWindowRect(&rect);
	int x,y;
	x=(::GetSystemMetrics(SM_CXSCREEN)-rect.Width() )/2;
	y=(::GetSystemMetrics(SM_CYSCREEN)-rect.Height() )/2;
	SetWindowPos( &wndTop,x,y,0,0,SWP_NOSIZE);
//Set step of process bar.
	GetClientRect(&rect); 	
	ASSERT(m_nRecordNum);
//	m_fstep=( (float)( rect.Width()-16) )/((float)m_nRecordNum/50.0) ;
	m_fstep=( (float)( rect.Width()-16) )/((float)20.0) ;
	m_IconRect.top=10;
	m_IconRect.left=280;
	m_IconRect.right=310;
	m_IconRect.bottom=40;

	m_TextRect.top=15;
	m_TextRect.left=5;
	m_TextRect.right=322;
	m_TextRect.bottom=100;
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


