
/***************************************************************************
**                                                          
** File name : SERIALCM.H
** Author:john chow
** Description:
**    Descript the base function of serial communication for TW Agreement
**                                                  used in (186)
**    Finished date: 97.1
**    modifed date:
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/


#ifndef _SERIALCM_
#define _SERIALCM_

#include "stdafx.h"
#include <sys\timeb.h>
#include <string.h>

//const define
#define MAXERRORNUM 200              
#define MAX_BUFFER 2048 

// definition of CBasePipe
class CBasePipe 
{ 
//member              
public:
    BOOL m_isCareful;
protected:  
    BYTE m_buffer[MAX_BUFFER];    
    int m_nPos;
//operation
public:
    void Reflash(BOOL isInit = TRUE) { 
        m_nPos = 0; 
        if(isInit)
            memset(m_buffer,0,MAX_BUFFER);
    }
    int GetLen() { return m_nPos; }
    void AddByte(BYTE bByte);
    void AddBytes(BYTE* pByte,int nLen);
    void GetByte(BYTE& bByte);
    void GetBytes(BYTE* pByte,int nLen);
    BYTE GetAt(int nPos) { return m_buffer[nPos]; };
    BYTE* GetBuffer() { return m_buffer; };//get pipe internal buffer point
    void Copy(CBasePipe& in) {
        Reflash();
        AddBytes(in.GetBuffer(),in.GetLen());
    };
//construct
protected:
    CBasePipe() { m_nPos = 0; m_isCareful = FALSE;}     
    virtual ~CBasePipe() { };
};

// definition of CAbiPipe 
class CAbiPipe : public CBasePipe
{      
//member
private:
//function
public:
    void SetVar(BYTE* pByte,int nLen);
    BOOL GetVar(BYTE* pByte,int nLen);
    void StartVar(BYTE bByte);    
    void EndVar(BYTE bByte);
    void LoadBuffer(BYTE* pByte);
    void LoadBuffer(BYTE* pByte,BYTE& len); 
    WORD GetStatus();
public:                                               
    #define SaveVar(var) SetVar((BYTE*)(&(var)),sizeof(var))
    #define LoadVar(var) GetVar((BYTE*)(&(var)),sizeof(var))
//destructor    
public:     
    virtual ~CAbiPipe(){};
 };

// definition of CBaseCom
class CBaseCom 
{   
//member
public:
    int m_nError;
    int m_nDetailError;
    BOOL m_isCanBeUsed;                  
    
    enum { ERR_NO,ERR_NOT_REPARE,ERR_TIME_OUT,ERR_ESC,ERR_FATAL};
private:
    struct _timeb m_startTime,m_currentTime;
    unsigned long m_lTimer; 
   
//operation
public:  
    virtual BOOL SendByte(BYTE) = 0;
    virtual BOOL ReceiveByte(BYTE&) = 0;
    virtual BOOL SendString(BYTE *,int);
    virtual BOOL ReceiveString(BYTE *,int);
    virtual BOOL IsEscape() { return FALSE;}
    virtual void FlushBufferIn() {return ;}
    virtual void FlushBufferOut() {return ;}
    
    void SetTimer(unsigned long);
    void RestartTimer();
    
    BOOL IsTimeOut();
    
//construct
protected:
    CBaseCom() { 
        m_isCanBeUsed = FALSE; 
        m_nError = m_nDetailError = ERR_NO;
    };       
    virtual ~CBaseCom() {
    };              
    void TestMessage(void) {
        MSG message;
        while (::PeekMessage(&message, NULL, 0, 0, PM_REMOVE)) {
            ::TranslateMessage(&message);
            ::DispatchMessage(&message);
        }
    };
    
};

//definition of class CBaseAgree
class CBaseAgree : public CBaseCom
{
//member
public:
    BYTE m_bRelinkTimes;  
    CBasePipe* m_pPipe; 
    unsigned long nBackTime;//setted by every abi command to define the inter time
                    //between send string to fw and receive string from fw

//operation
public:
    void SetPipe(CBasePipe* pPipe) { m_pPipe = pPipe; };
    CBasePipe* GetPipe() { return m_pPipe;}
    
    virtual BOOL Do() = 0;
//construct and destruct
protected:
    CBaseAgree();
    virtual ~CBaseAgree();  
};  

//definition of class CTWAgree
class CTWAgree : public CBaseAgree
{                                 
//member
public:
    BOOL isConnected;
    //BYTE m_bRelinkTimes;  
    enum { 
        ERR_RELINKQUIT = 200,
        ERR_RECEIVE_WRONGCODE,
        ERR_NOT_CONNECTED,
        ERR_SEND_NACK,
    };
    
public:
    enum {       
        LEAD_CODE   = ':',
        ACK         = 0x06,
        NACK        = 0x15
    };      
    int m_nErrorTime;//counter of error
//operation 
public:
    virtual BOOL IsRelink() { return FALSE; }
    virtual BOOL Do();
    virtual void IsUnstable() = 0;
    BOOL Init();                  
    virtual BOOL SendCommand();
    virtual BOOL ReceiveResult();
    
protected:    
    virtual CString GetLinkerStr()  = 0; 
    virtual CString GetLinkerStr_()  = 0; 

//construct
protected:
    CTWAgree() { 
        isConnected == FALSE; 
        m_nErrorTime = 0; 
    }       
    virtual ~CTWAgree() { };
    
};
                   
//definition of class C196Agree
class C196Agree : public CBaseAgree
{                                 
//member
public:
    BOOL isConnected;
    //BYTE m_bRelinkTimes;      
    int m_nErrorTime;//counter of error
    enum { 
        ERR_RELINKQUIT = 200,
        ERR_RECEIVE_WRONGCODE,
        ERR_NOT_CONNECTED,
        ERR_RECEIVE_DOLLAR,
        ERR_RECEIVE_NACK,
        ERR_SEND_DOLLAR,
        ERR_SHAKE_HAND,
        ERR_SEND_COMMAND,
        ERR_SHAKE_HAND_,
        ERR_RECEIVE_RESULT,
    };
                    
private:
    enum {       
        LEAD_CODE   = ':',
        ACK     = 0x06,
        NACK   = 0x15
    };      
    

//operation 
public:
    virtual BOOL IsRelink() { return FALSE; }
    virtual BOOL Do();
    virtual void IsUnstable() = 0;
    BOOL Init();                  
    BOOL SendCommand();
    virtual BOOL ReceiveResult();
    BOOL Shakehand(BYTE bTimers = 10);
    BOOL Shakehand_();
    
protected:    
    virtual CString GetLinkerStr()  = 0; 
    virtual CString GetLinkerStr_()  = 0; 

//construct
protected:
    C196Agree() { 
        isConnected == FALSE; 
        m_nErrorTime = 0;
        m_bRelinkTimes = 0; 
    };       
    virtual ~C196Agree() { };

};                   

//definition of class CBaseSerialPICAgree
class CBaseSerialAgree : public CTWAgree
{                                        
//members
public:
    BOOL m_isRepeat;
    BOOL m_isFirstTime;
    enum {
        COM_PORT_1 = 0,
        COM_PORT_2,
        COM_PORT_3,
        COM_PORT_4
    };
    enum {
        BAUD_9600 = 0,
        BAUD_19200,
        BAUD_38400,
        BAUD_57600,
        BAUD_115200
    };  
        
protected:
    BYTE m_bPortNum;
    BYTE m_bBaudRate;
    BYTE m_bDefaultBaudRate;

//operation
public:
    virtual BOOL SetSerialOption() = 0;
    virtual BOOL SetSerialPortBaud(BYTE,BYTE) = 0;
    virtual BOOL CommInit() = 0;
    //1996.8 TO TEST THE ABI
    //virtual BOOL CommunicationTest(COMTESTERR* pErr) = 0;
    
    BYTE GetSerialPortNum();
    BYTE GetSerialBaudRate();
    CString GetSerialPortNumStr();
    CString GetSerialBaudRateStr();
//construct && destruct    
    CBaseSerialAgree() { 
        m_bDefaultBaudRate = BAUD_19200; 
        m_isFirstTime = FALSE;
    }
    virtual ~CBaseSerialAgree() {};
     
 };
 
#endif //serialcm 
 
