/* Create event window putting save, restore, delete, clear and new in the menu bar.  */!!

inherit(AutomaticMenu, #EventWindow, #(eventListBox  /* handle for combo box of event names. */
statusList  /* collection of status buttons */
addrNotButton
dataNotButton
editFieldList /* collection of edit fields used */
asGroupBox
asButtonList  /* collection of address space buttons */
endAddrButton
endLenButton
asButtonsActive
charHeight
charWidth
theEvent  /* event window's event server */
numEvents  /* to know if we need to refresh */
activeEdit /* id number of active edit window */
doneInitializing?
activeEventName
numStatCol  /* number of column of status fields */
errorSemaFlag /* flag used to prevent getting into an endless loop when reporting an error and event presenter re-getting focus */
maxRight /* holds the max right hand border */
maxBottom
widestSignal /* holds the size of the widest signal in the column */ ), 2, nil)!!

setClassVars(EventWindow, #())!!

now(class(EventWindow))!!

/* 7/29/1996 13:53 */

Def exists(self | handle)
{
   if TheEventPresenter
      handle := existsEventWindow(EventLibClass$Inst);
      if handle 
         setHWnd(TheEventPresenter,handle)
      else
         TheEventPresenter := nil;
      endif;
   endif;
   ^TheEventPresenter;
}!!

/* PUBLIC 
Def open(self | newInstance num)
{
  ^openWithPosAndState(self, nil, SW_SHOWNORMAL);
}*/
Def open(self)
{
   if not(exists(self))
      if not(TheEventPresenter:=new(EventWindow,nil,nil,
            "Event",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheEventPresenter));
      setHWnd(TheEventPresenter,openEventWindow(EventLibClass$Inst,
            nil, 0));
      show(TheEventPresenter,SW_SHOW);
   endif;
   ^TheEventPresenter;
}!!

/*
Def openWithPosAndState(self sizeRect showVal | newInstance)
{  
  newInstance := newStyle(EventWindow, nil, nil, "Events",
                   sizeRect, nil, style(self));
  if newInstance
    show(newInstance, showVal)
  endif;

 * if no events exist, brings up the dialog to make new event *
  if(0 = evtNumDefinedEvents(event(newInstance)))
    eventNew(newInstance);
  endif;
  ^newInstance;
} */
Def openWithPosAndState(self, sizeRect, showVal | newHWnd )
{ 
  if not(exists(self))
      if not(TheEventPresenter := new(EventWindow, nil, nil,
            "Event",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheEventPresenter));
      if ((newHWnd := openEventWindow(EventLibClass$Inst,
            sizeRect, WS_OVERLAPPEDWINDOW)) <> nil) then
         setHWnd(TheEventPresenter,newHWnd);
         show(TheEventPresenter,showVal);
      else
         ^nil;
      endif;
   endif;
   ^TheEventPresenter; 
}!!

now(EventWindow)!!

/* 7/29/1996 13:56 
 get the location rect of the window and save it to the ini file 
*/
Def saveWindowPos(self keyName| isIconic layout windRect)
{
  if (hWnd = 0)
    ^clearLayoutEntry(Window, asString(keyName));
  endif;    
  /* Save Layout for Event window:
  ** if the window is an icon - use the previous saved layout
  **    if there is no previous saved lay out set to 0 for default size
  ** else
  **    Get the current window  position to save.
  */

  /* IsIconic returns nonzero if self is minimized */
  if (Call IsIconic(hWnd) = 0) then
    isIconic := 0;
    /* get the location of the current window position */
    Call GetWindowRect(hWnd, windRect := new(Rect));
    if (width(windRect)=0 cand height(windRect)=0)
       isIconic := 2;
    endif;
  else
    /* force the nonzero return to be 1 */
    isIconic := 1;
    if not(windRect := getPos(PreLauncher, asString(keyName))) then
      windRect := init(new(Rect),0,0,0,0);
    endif;      
  endif;

  if (windRect) then   
    layout := new(String, 18);
    if (isIconic = 2)
       layout := " ";
    else
       layout := asString(left(windRect)) + "," + asString(top(windRect)) +
            "," + asString(right(windRect)) + "," +
            asString(bottom(windRect)) + "," + asString(isIconic);
    endif;
    saveProfileEntry(TheProfileInfoObj, "DefaultLayout", keyName, layout);
  endif;  
  ^GOOD;
}!!

/* PRIVATE 
Def close(self)
{
  if parent 
    childIsClosing( parent, self ) ; * notify parent *
  endif;
  show(self, SW_HIDE);
  close( self:ancestor ) ;
} */
Def close(self)
{
   if (exists(class(self)))
      closeEventWindow(EventLibClass$Inst);
      TheEventPresenter := nil;
   endif;
   ^GOOD;
}
!!

/* EventWindow Class Initialization Code */
