/* class comment */!!

inherit(ProvidedLibs, #SpaLib, nil, 2, nil)!!

now(class(SpaLib))!!

/* 8/2/1996 9:32 */

Def provide(self, path)
{ 
  ^initialize(new(self:ancestor),path);
}!!

now(SpaLib)!!

/* 11/14/1996 13:43 */

Def freeSpa(self)
{
    if pcallLock(self)
    then
      lastError := pcall( procs[#SPAQUIT]);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;

}!!

/* 8/2/1996 9:37
   Define all entry points for library as prototypes.
*/
Def addImportProcs(self)
{
  add(self, #INITCSERVER,               1, #(0, 0));
  add(self, #SPAOPENWINDOW,            1, #(0, 0, 0, 0, 0, 1, 1, 1));
  add(self, #SPACLOSEWINDOW,           1, nil);
  add(self, #SPAEXISTSWINDOW,          1, #(1));
  add(self, #SPAQUIT,                  1, nil);
}!!

/* 8/2/1996 9:36 
   Open and initialize SPA library 
*/
Def initialize(self, path)
{ 
   setName( self, path ) ;
   addImportProcs( self ) ;
   load( self ) ;
   ^self ;
}!!

/* 8/2/1996 9:35 */

Def openSpaWindow(self, rect, style |hWndPtr)
{ 
    hWndPtr := new( Struct, 4 );
    if pcallLock(self)
    then
      if (rect <> nil)
         lastError := pcall( procs[#SPAOPENWINDOW], 0, left(rect),
              top(rect), width(rect), height(rect), style, 0, hWndPtr);
      else
         lastError := pcall( procs[#SPAOPENWINDOW], 0, 0,
              0, 0, 0, style, 0, hWndPtr);
      endif;
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
    endif;
    /* 04/18/94 - Nghia - only return nil no handle or critical error */
    if ((lastError = ER_PP_WIN_CREATE_FAIL) cor
        (longAt(hWndPtr, 0) = 0)) then
      ^nil;
    endif;
    ^longAt(hWndPtr, 0);

}!!

/* 8/2/1996 9:33 */

Def closeSpaWindow(self)
{
    if pcallLock(self)
    then
      lastError := pcall( procs[#SPACLOSEWINDOW]);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;
    notify(EvNoteLibClass$Inst,EVENT_BKPT_HALTED);
    TheSpaPresenter := nil;
    ^TheSpaPresenter;

}!!

/* 8/2/1996 9:32 */

Def existsSpaWindow(self | hWndPtr)
{
    hWndPtr := new( Struct, 4 );
    if pcallLock(self)
    then
      lastError := pcall( procs[#SPAEXISTSWINDOW], hWndPtr);
      pcallUNLock(self);
    else 
      lastError := ERR_PCALL_RECURSION ;
    endif ;
    if  (lastError <> GOOD) then
      displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);    
      ^nil;
    endif ;
    if (longAt(hWndPtr, 0) <> 0)
       ^longAt(hWndPtr, 0);
    endif;
    ^nil;

}!!