/****************************************************************************
**
**  Name:  basictyp.h
**
**  Description:
**     Primary type declarations for tbird project.
**     NOTE:  This should not be included explicitly, but either by way
**            of basetype.h or basewind.h!
**
**  $Log:   S:/tbird/mt2_amd/inc/basictyp.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:07:04   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:54:20   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:26   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:43:56   Judy
   Initial revision.
**  
**     Rev 1.6   22 Mar 1994 09:17:22   tom
**  Change #ifdef's so that TRUE is always defined independent of whether
**  TRUE was initially defined.
**  
**     Rev 1.5   18 Feb 1994 15:55:10   nghia
**  Added new type declarations for the floating-point types.
**  Added string length definitions.
**  
**     Rev 1.4   22 Mar 1993 15:21:48   marilyn
**  Removed status line and updated copyright notice.
**  
**     Rev 1.3   27 Feb 1992 17:35:42   brucea
**  Added: LPU8, CHECK_ABORT()
**  
**     Rev 1.2   01 Nov 1991 17:32:58   john
**  Added _export keyword to allow impdef/implib to work properly
**  and to only add the special export prolog/epilog code to the
**  functions that are actually exported.  This saves code space and
**  execution time on non-exported functions.
** 
**    Rev 1.1   04 Jul 1991 16:22:10   TOM
** 
**    Rev 1.0   14 Jun 1991 13:37:00   jim
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/inc/basictyp.h_v   1.0   20 Mar 1998 10:07:04   Eric  $
**
**  Copyright (C) 1991-93 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _BASICTYP_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

/* none */
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/* basic definitions */
#ifndef NULL
#define NULL 0
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifdef TRUE
#undef TRUE
#endif
#define TRUE (!FALSE)

#define YES TRUE
#define NO  FALSE

#define ON  TRUE
#define OFF FALSE

#define SUCCESS 0
#define GOOD SUCCESS

/* string definitions */
#define MAX_STRING_SIZE 256
#define MAX_PATH_SIZE   128

/* Microsoft-style keywords */
#define CDECL cdecl
#define FORTRAN fortran
#define HUGE huge
#define PASCAL pascal

#define EXPORT FAR PASCAL _export
#define FAR_HANDLE VOID
#define VARIABLE_SIZED 1    /* used for defining varible length arrays */

#define STATIC static
#define PRIVATE STATIC

#define CHECK_ABORT() GetAsyncKeyState(VK_ESCAPE)

/* primary typedef's */
#define CHAR char
typedef unsigned CHAR  U8;
typedef signed   CHAR  S8;
typedef unsigned short U16;
typedef signed   short S16;
typedef unsigned long  U32;
typedef signed   long  S32;
typedef signed   int   LOOP_VAR;  /* used only as a loop index */

/* secondary typedef's */
typedef U8 BOOLEAN;
typedef unsigned CHAR * STRING;
typedef U32 RETCODE;
typedef U32 DESCRIPTOR;  /* resource designator */
typedef U8  FAR  *LPU8;  /* far pointer to unsigned byte */
typedef U16 FAR  *LPU16;
typedef U32 FAR  *LPU32;

typedef float FLOAT;
typedef double DOUBLE;
typedef FLOAT FAR *LPFLOAT;
typedef DOUBLE FAR *LPDOUBLE;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/* none */

/******************************** E O F ***********************************/
