/*
 * Name:  brkenv.h
 *
 * Description:
 *    Hardware specific break environment (information that the lowest
 *    level firmware needs in order to break out of emulation).
 *
 * $Log:   S:/tbird/mt2_amd/inc/brkenv.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:07:10   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:54:32   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:28   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:44:04   Judy
   Initial revision.
**  
**     Rev 1.1   21 Aug 1991 11:18:34   tom
**  Updated types, include file format.
 * 
 *    Rev 1.0   14 Jun 1991 13:36:12   jim
 * Initial revision.
 *
 * $Header:   S:/tbird/mt2_amd/inc/brkenv.h_v   1.0   20 Mar 1998 10:07:10   Eric  $
 */
#define _BRKENV_

#ifndef _BASEWIND_
#include "basewind.h"
#endif

typedef struct {
/* break environment needs to be determined by the hardware designer. */
/* it's specific to the hardware implementation and the chip being emulated */
   U32 dummy;
} BREAK_ENV;

RETCODE EXPORT ExecSetBreakEnvironment(BREAK_ENV env);
/*
Description:
   Set up the break environment for the processor.  This is processor and
   hardware specific.  Some chips may not require any break environment (e.g.
   a bond out chip can usually halt emulation without any break environment
   set up).  Other chips may require some environment information (e.g.
   Mice-V x86 processors required brkgdt, brkridt, brkpidt, brkpage).
Parameters:
   input:
      env:  description of environment upon breaking emulation (hardware
            specific)
   output:
      none
*/

RETCODE EXPORT ExecGetBreakEnvironment(BREAK_ENV *env);
/*
Description:
   Get the break environment.
Parameters:
   input:
      none
   output:
      env:  current setting of break environment.
*/
