/****************************************************************************
**
**  Name:  heap.h
**
**  Description:
**     Public interface to heap.DLL:  Malloc() and Free() routines.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/mt2_amd/inc/heap.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:07:02   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:54:18   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:24   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:44:42   Judy
   Initial revision.
** 
**    Rev 1.5   08 Sep 1992 09:13:32   nghia
** Added HeapDump() for Actor debug.
** 
**    Rev 1.4   29 Aug 1992 11:42:04   doug
** added heap verify function
** 
**    Rev 1.3   01 Apr 1992 23:04:52   brucea
** Added: #ifdef __cplusplus in order to use TMalloc in C++ source
** 
**    Rev 1.2   21 Mar 1992 12:25:46   kend
** added cleanup entry point.
** 
**    Rev 1.1   27 Feb 1992 17:33:42   doug
** added basewind for LPSTR definition
** 
**    Rev 1.0   19 Aug 1991 15:43:28   kend
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/inc/heap.h_v   1.0   20 Mar 1998 10:07:02   Eric  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _HEAP_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  HeapClean
**
**  Description:
**     Scrubs the Heap.  All pointers are invalidated, 
**     all memory GlobalFree()d and a new area allocated.
**
**  Parameters:
**     input:
**        none (void)
**     output:
**        SUCCESS or an error (see below)
**
**  Errors:
**        ER_OUT_OF_MEMORY  -- could not allocate initial area
**
*****************************************************************************/
RETCODE EXPORT HeapClean(VOID);

/****************************************************************************
**
**  HeapDump
**
**  Description:
**     Provides heap usage information.
**
**  Parameters:
**     input:
**        none.
**     output:
**        memAllocated:  global amountAllocated variable
**        memFree:       global amountFreed variable
**  Errors:
**     none.
**
*****************************************************************************/
RETCODE EXPORT HeapDump(U32 *memAllocated, U32 *memFreed);

/****************************************************************************
**
**  HeapVerify
**
**  Description:
**     Verify the contents of the heap.  Returns error if there is any
**     problem detected.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
**  Errors:
**        not defined
**
*****************************************************************************/
RETCODE EXPORT HeapVerify(VOID);


/****************************************************************************
**
**  TFree
**
**  Description:
**     Memory deallocator.  Frees memory associated with a pointer
**     allocated via Malloc() {see below}.
**
**     NOTA BENE:  Freeing an already Free()'ed pointer may corrupt the 
**     heap!!
**
**  Parameters:
**     input:
**        randomPointer: A pointer returned by Malloc().
**     output:
**        SUCCESS or an error (see below)
**
**  Errors:
**     ER_NOT_FOUND       -- could not find pointer info.  Is it ours?
**     ER_HEAP_CORRUPT    -- someone wrote outside of their allocation,
**                           and all over our internal data structures.
**                           This is FATAL for us!!
**
*****************************************************************************/

RETCODE EXPORT TFree( LPSTR randomPointer ) ;



/****************************************************************************
**
**  TMalloc
**
**  Description:
**     Memory ALLOCator.  Given numBytes less than 64K (current limit
**     is 65508), returns a long pointer to the allocated memory. 
**     Zero is returned on failure.  The memory is "locked" in the
**     Window's sense.  This routine should be used for allocating
**     small amounts of memory (incremental overhead is just over 
**     8 bytes per alloc).  It uses very few Window's handles.  There
**     will *never* be a handle associated with the returned pointer
**     {i.e. don't use GlobalHandle() on a pointer returned by this
**     routine}.
**
**     NOTA BENE:  Writing to memory outside the pointer+numBytes range 
**     will corrupt the heap!!
**
**  Parameters:
**     input:
**        numBytes: the number of bytes to allocate (< 64KB)
**     output:
**        return value is zero (0) or a long pointer to alloc'ed memory.
**
*****************************************************************************/

LPSTR EXPORT TMalloc( U32 numBytes ) ;   /* numBytes < 64 KB */


#ifdef __cplusplus
}
#endif
/******************************** E O F ***********************************/
