/*************************************************************************
**
** Name: list.h
**
** Description: Linked list definitions
**
** Status: coded.
**
** $Log:   S:/tbird/mt2_amd/inc/list.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:07:10   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:54:32   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:28   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:45:00   Judy
   Initial revision.
** 
**    Rev 1.1   26 Jul 1991 07:58:42   doug
** remove list has return code and other changes are format differences 
** from hyperICE (where this file came from)
** 
** $Header:   S:/tbird/mt2_amd/inc/list.h_v   1.0   20 Mar 1998 10:07:10   Eric  $
**
** COPYRIGHT (C) 1991 MICROTEK INTERNATIONAL, INC.
**/
#define _LIST_

#ifndef _BASETYPE_
#include "basetype.h"
#endif

typedef struct LENTRY {
   struct LENTRY *lNext;
   VOID const *lData;
} LENTRY;
typedef struct LIST {
   LENTRY *head;
   LENTRY *current;
} LIST;

#define InitList(list)	((list)->head = NULL)
#define EmptyList(list)	((list)->head == NULL)
#define IsTailList(list)	((list)->current == NULL)
#define HeadList(list)	((list)->current = (list)->head)
#define GetList(list)	((list)->current ? (list)->current->lData: NULL)
#define NextList(list)	((list)->current = (list)->current ? (list)->current->lNext : NULL)

RETCODE EXPORT AppendList(LIST *list, VOID const *data);
RETCODE EXPORT RemoveList(LIST *list, VOID const *data);
VOID DoList(LIST *list, VOID (*Function)(VOID const *));
VOID DoListDel(LIST *list, VOID (*Func)(VOID const*));

/********************************* E O F ***********************************/
