/****************************************************************************
**
**  Name:  LMANGLE.H
**
**  Description:
**    Declarations of routines to handle global C++ mangling services
**    (in LOADER.DLL) 
**
**  $Log:   S:/tbird/mt2_amd/inc/lmangle.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:07:02   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:54:16   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:24   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:45:04   Judy
   Initial revision.
** 
**    Rev 1.0   20 May 1994 10:01:50   nghia
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_amd/inc/lmangle.h_v   1.0   20 Mar 1998 10:07:02   Eric  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _LMANGLE_
#define _LMANGLE_

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/* Separates function 'user symbol name' from function/class signature */
#define MANGLE_DELIMETER  "__"
/* note: strstr() returns position if mangled, else NULL */
#define IS_MANGLED(pString)  (strstr(pString, MANGLE_DELIMETER))

/* class vtable prefix */
#define CPP_VTBL     "__vtbl"
/* pointer to item which will have static initializers (?) */
#define CPP_PTBL     "__ptbl"
/* static initializer prefix for module */
#define CPP_STATICI  "__sti"
/* static destructor prefix for module */
#define CPP_STATICD  "__std"
/* 'this' pointer */
#define CPP_THIS     "Xthis"
#define CPP_USERTHIS "this"
/* constructor prefix */
#define CPP_CTOR     "__ct__"
/* destructor prefix */
#define CPP_DTOR     "__dt__"

/* special leading char for dtor */
#define CPP_DTOR_CHAR   '~'

                       /****************************
                        *                          *
                        *        TYPEDEFS          *
                        *                          *
                        ****************************/
struct fnTag;
typedef struct fnTag {
   CHAR fnName[MAX_STRING_SIZE];
   struct fnTag *fnNext;
} FNNODE;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
**
**  LdrCppFixupLocal
**
**  Description:
**    Demangle local symbol name, returning user name.  Note that duplicate
**    'this' symbols are detected by the Loader (the symbol table does not
**    check for duplicate locals; this is the only case where duplicate symbols
**    can reside at the same lexical level (and is a result of the demangling
**    operation).
**
**  Parameters:
**        pname (in):       mangled name from loadfile
**        puserName (out):  pointer to user name (will be mangled if duplicate)
**
*****************************************************************************/
RETCODE EXPORT LdrCppFixupLocal(LPSTR pname, LPSTR *puserName);

/****************************************************************************
**
**  LdrCppFixupFunction
**
**  Description:
**    Demangle function symbol name, returning user name.  The Loader checks
**    for duplicate static procedures (the symbol table does not), which can
**    be created as a result of the demangling operation.
**    Future C++ support should expand the existing symbol table structure
**    to be class-oriented in views, allowing the same function member name
**    to reside in different classes.
**
**  Parameters:
**     pname (in):        mangled name from loadfile
**     puserName (out):   pointer to user name (will be mangled if duplicate)
**     firstTimeLoad(in): TRUE, if initial load
**                        FALSE, if ondemand load - do not check duplicates 
**
*****************************************************************************/
RETCODE EXPORT LdrCppFixupFunction(LPSTR pname, LPSTR *puserName,
                                   BOOLEAN firstTimeLoad);

/****************************************************************************
**
**  LdrCppFixupGlobal
**
**  Description:
**    Demangle global symbol name, returning user name.  Used also to kick
**    out unsupported global symbols (virtual table pointers and such).
**
**  Parameters:
**        pname (in):       mangled name from loadfile
**        puserName (out):  pointer to user name (will be mangled if duplicate)
**
*****************************************************************************/
RETCODE EXPORT LdrCppFixupGlobal(LPSTR pname, LPSTR *puserName);

/****************************************************************************
**
**  LdrCppFixupMember
**
**  Description:
**    Demangle a struct/union/class (data) member name, return user name.
**
**  Parameters:
**        pname (in):       mangled name from loadfile
**        puserName (out):  pointer to user name
**
*****************************************************************************/
RETCODE EXPORT LdrCppFixupMember(LPSTR pname, LPSTR *puserName);

/****************************************************************************
**
**  LdrCppClearFunctionTable
**
**  Description:
**    Clear function list constructed for module.
**
*****************************************************************************/
RETCODE EXPORT LdrCppClearFunctionTable(VOID);

#ifdef __cplusplus
}
#endif

#endif /* _LMANGLE_ */
/******************************** E O F ***********************************/
