/****************************************************************************
**
**  Name:  trig.h
**
**  Description:
**     External interface for trigger.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/mt2_amd/inc/mp_trig.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:07:12   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:54:36   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:30   Judy
** Initial revision.
** 
**    Rev 1.3   28 Jul 1993 13:19:44   ernie
** Added GetYoungestFrame() prototype
** 
**    Rev 1.2   10 Mar 1993 12:16:18   ernie
** Added support for show cycle triggering and tracing
** 
**    Rev 1.1   16 Dec 1992 15:26:42   mindy
** moved trace to fw
** 
**    Rev 1.0   09 Dec 1992 15:34:56   mindy
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/inc/mp_trig.h_v   1.0   20 Mar 1998 10:07:12   Eric  $
**
**  Copyright (C) 1992 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _MP_TRIG_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASETYPE_
#include "basetype.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
typedef enum {
   EVTREC8, EVTREC32
} EVTREC_TYPE;

typedef enum {
   GROUP_R, GROUP_S, GROUP_T, GROUP_U
} TRACE_GROUP;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
/**************************************************************************
**
** TrigInit
**
** Description:
**    Initialize trigger.  Must be called before responses to shared
**    data requests can be made.
** Parameters:
**    input:
**       none:
**    output:
**       none:
**************************************************************************/
RETCODE EXPORT TrigInit(HANDLE hLib);

/**************************************************************************
**
** SetEvtrecConfig
** GetEvtrecConfig
**
** Description:
**    Choose which raw event recognizer configuration to use.  Choices are
**     (1) a fully maskable range recognizer with a single qualifier
**         for the entire 32 bits.  Used for 32-bit address, data bus.
**     (2) a maskable identity recognizer with four qualifiers each handling
**         8 bits.  Used for processor status bits.
**
**    This routine is intended to be called once by probe-specific firmware
**    during system initialization to configure the trace system for a
**    particular probe.
**
** Parameters:
**    input:
**       group:     Which group we are setting parameters for.
**       type:      Selects whether to use 32-bit or 8-bit recognizer.
**       func1:     Function to use for determining qualifier.  Format
**                  depends on evtrec type supplied in the <type> argument.
**                  * evtrec8:  4 bits are supplied for each of the 4 required
**                     qualifiers.  The values supplied indicate the bit states
**                     for each of the 4 qualifiers (lsb of each nibble is Q0).
**                  * evtrec32: 16 bits are supplied to describe the single
**                     qualifer.  Bit 0 corresponds to the state of the group
**                     qualifier given inputs 0,0,0,0 on Q3-0.  Bit 1 is the
**                     group qualifier for inputs 0,0,0,1.  Bit 15 is for
**                     inputs 1,1,1,1.  See examples below.
**
**                       bit 15  12   8    4    0
**                         Q3 1111 1111 0000 0000
**                         Q2 1111 0000 1111 0000
**                         Q1 1100 1100 1100 1100
**                         Q0 1010 1010 1010 1010
**                       data xxxx xxxx xxxx xxxx
**                         
**       func2:     Purpose depends on type.
**                  * evtrec8: Bits set select which qualifier inputs are
**                     significant in determining the chip qualifier.  Bit
**                     assignment is the same as qualFunc.
**                  * evtrec32: 16 bits are supplied to describe the delayed
**                     qualifier contribution to the group qualifier (if
**                     useDelayed is TRUE) and to the frame qualifier.  The
**                     format of the word is the same as argument func1.  This
**                     qualifier is ORed into func1 delayed by 1 clock and
**                     is ORed into the framequal chain to generate a framequal
**                     on the cycle following the frame where func2 is true.
**      useDelayed: Used only by EVTREC32.  Indicates that the qualifier for
**                  this group should include the delayed function described
**                  by func2.  If false, func2 is used only to generate the
**                  framequal and is not used as part of the data qualifier.
**
**    output:
**       none
**
** Example 1:
**    To configure an 8-bit recognizer with 4 qualifiers:
**       Bits  0- 7:  Q0
**       Bits  8-15:  Q1
**       Bits 16-23:  Q0 and Q1
**       Bits 24-31:  !Q2
**    Call with the following parameters:
**       type = EVTREC8;
**       func1 =  (1 << 0)    (bits 0-7)
**              + (2 << 4)    (bits 8-15)
**              + (3 << 8)    (bits 16-23)
**              + (0 << 12);  (bits 24-31)
**       func2 =  (1 << 0)    (Q0 significant)
**                (2 << 4)    (Q1 significant)
**                (3 << 8)    (Q0 and Q1 significant)
**                (4 << 12);  (Q2 significant)
**       useDelayed = dont-care
** Example 2:
**    To configure a 32-bit recognizer with 1 qualifier = !Q2 or (!Q1 and Q2)
**    This corresponds to the address bus group in the 332 when recognizing
**       both regular and show cycles.
**    Call with the following parameters:
**       type = EVTREC32;
**       func1 = 0000 1111 0000 1111  (!Q2)
**             | 0011 0000 0011 0000  (!Q1 and Q2)
**             = 0011 1111 0011 1111
**             = 0x3F3F;
**       func2 = 0x3030;     ( Needed to sync framequal with other groups )
**       useDelayed = FALSE;
** Example 3:
**    To configure a recognizer with 1 qualifier = !Q2 or delayed(!Q1 and Q2)
**    This corresponds to the data bus group in the 332 when recognizing
**       both regular and show cycles.
**    Call with the following parameters:
**       type = EVTREC32;
**       func1 = 0000 1111 0000 1111  (!Q2)
**             = 0x0F0F;
**       func2 = 0011 0000 0011 0000  (!Q1 and Q2)
**             = 0x3030;
**       useDelayed = TRUE;    ( func2 participates in both data and frame )
**************************************************************************/
RETCODE EXPORT SetEvtrecConfig(TRACE_GROUP group, EVTREC_TYPE type,
                                U16 func1, U16 func2, BOOLEAN useDelayed);

RETCODE EXPORT GetEvtrecConfig(TRACE_GROUP group, EVTREC_TYPE *type,
                                U16 *func1, U16 *func2, BOOLEAN *useDelayed);

/**************************************************************************
**
** SetEvtrecFramequal
** GetEvtrecFramequal
**
** Description:
**     Choose whether frame qualifier is active high or low.
**
** Parameters:
**    input:
**       group:     Which group we are setting parameters for.
**       state:     0=active low framequal; 1=active high framequal
**    output:
**       none
**
**************************************************************************/
RETCODE EXPORT SetEvtrecFramequal(TRACE_GROUP group, U8 state);

RETCODE EXPORT GetEvtrecFramequal(TRACE_GROUP group, U8 *state);

VOID EXPORT ClearTriggerPositions(VOID);
VOID EXPORT ResetDMAPointer(VOID);

U32 EXPORT GetPhysicalFrame(U16 buffer, S32 frame);
BOOLEAN EXPORT TraceIsEmpty(U16 buffer);
BOOLEAN EXPORT TraceBufferFull(U16 buffer);
BOOLEAN EXPORT TraceStoreFull(U16 buffer);
U16 EXPORT GetTriggerSubBuffer(U16 buffer);
U32 EXPORT GetTriggerFrame(U16 buffer);
U32 EXPORT SubBufferStartOffset(U16 buffer);
U32 EXPORT MaxNumFramesPerTraceBuffer(VOID);
U32 EXPORT GetNumFramesInTraceBuffer(U16 buffer);
U32 EXPORT GetNumFramesAfterTrigger(U16 buffer);
U32 EXPORT GetNumFramesBeforeTrigger(U16 buffer);


/**************************************************************************
**
** TrigProgramEvtrec
**
** Description:
**     Load bits into event recognizer
**
** Parameters:
**    input:
**       index:     Which group we are setting parameters for (0..3)
**    output:
**       none
**
**************************************************************************/
RETCODE EXPORT TrigProgramEvtrec(MEMBER_INDEX index);

/******************************** E O F ***********************************/
