/*
 * Name:     pa.h
 * Title:    Performance Analysis Server
 * Purpose:  Routines to set up and obtain results from PA hardware
 *
 * $Log:   S:/tbird/mt2_amd/inc/pa.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:07:06   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:54:22   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:26   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:45:16   Judy
   Initial revision.
**  
**     Rev 1.1   21 Aug 1991 11:23:38   tom
**  Updated types, include file format.
 * 
 *    Rev 1.0   14 Jun 1991 13:34:38   jim
 * Initial revision.
 *
 * $Header:   S:/tbird/mt2_amd/inc/pa.h_v   1.0   20 Mar 1998 10:07:06   Eric  $
 */
#define _PA_

#ifndef _BASEWIND_
#include "basewind.h"
#endif

typedef enum {PA_RANGE, PA_PROC} PA_MODE;

RETCODE EXPORT setPAMode(PA_MODE Mode);
/*
Parameters:
   Mode (input):  selects either range or proc mode
Default:
   Range
Description:
   Set up PA tool for range or procedure measurements.  Procedure measurements
   require no other set up for the ranges (done with event recognizer setup).
   Range mode requires that setPARange be called to set up boundaries on
   ranges to measure.
*/

RETCODE EXPORT getPAMode(PA_MODE *Mode);
/*
See setPAMode for desription
*/

RETCODE EXPORT setPARange(U16 Bin, ADDRESS_RANGE Range);
/*
Parameters:
   Bin (input):    Bin number to set
   Range (input):  Address range to assign for given bin
Default:
   none
Description:
   This call assigns the address range to monitor for the specified bin.
*/

RETCODE EXPORT getPARange(U16 Bin, ADDRESS_RANGE *Range);
/*
See setPARange for description
*/


RETCODE EXPORT getPATotalTime(UINT48 *Time);
/*
Parameters:
   Time (output):  Total time spent collecting PA data
Default:
   none
Description:
   When PA is started (by sequencer or when emulation begins), a virtual timer
   is started.  The sequencer controls the pat enable which in turn gates the
   virtual timer.  The value returned is the number of processor clock ticks
   that the PA was enabled.
*/

RETCODE EXPORT getPAEntries(U16 Bin, U32 *Entries);
/*
Parameters:
   Bin (input):       Bin number selection
   Entries (output):  Number of entries into the specified procedure/range
Default:
   none
Description:
   This call returns the number of times a particular address range or
   procedure was entered.
*/

RETCODE EXPORT getPABinTime(U16 Bin, UINT48 *Time);
/*
Parameters:
   Bin (input):    Bin number selection
   Time (output):  Total time spent executing in Bin
Default:
   none
Description:
   Returns the number of processor clocks that were spent in the specified
   bin.  Dividing this by the number of entries gives the average invocation
   duration.
*/

RETCODE EXPORT getPAMinTime(U16 Bin, UINT48 *Time);
/*
Parameters:
   Bin (input):    Bin number selection
   Time (output):  Minimum time to execute one invocation of specified bin
Default:
   none
Description:
   Returns the minimum bin time sample.
*/

RETCODE EXPORT getPAMaxTime(U16 Bin, UINT48 *Time);
/*
Parameters:
   Bin (input):    Bin number selection
   Time (output):  Maximum time to execute one invocation of specified bin
Default:
   none
Description:
   Returns the maximum bin time sample.
*/
