/*
 *    Name:    pdasm.h
 *
 *    Description: 
 *       Processor specific routines for the disassembly, assembly and 
 *       dequeue support.  Note: Interface supplied for all processors
 *       but just returns error if not supported. 
 *
 *    $Log:   S:/tbird/mt2_amd/inc/pdasm.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:07:08   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:54:24   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:26   Judy
** Initial revision.
 * 
 *    Rev 1.0   14 Jun 1991 13:35:44   jim
 * Initial revision.
 *
 *    $Header:   S:/tbird/mt2_amd/inc/pdasm.h_v   1.0   20 Mar 1998 10:07:08   Eric  $
 */
#ifndef PDASM_SERVER
#define PDASM_SERVER

#include "system.h"
#include "dasm.h"

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
typedef enum {USE16, USE32} CMODE;

ERROR DasmAsmSetCmode(DESCRIPTOR id, CMODE mode);
/*
Description:
   Sets the code mode for the assembler to use when assembling Intel
   instructions.
Parameters:
   input:
      id:               id number of calling routine.
      mode:             code mode calling routine wants to use when assembling
                        instructions.
   output:
      none
 */      

ERROR DasmAsmGetCmode(DESCRIPTOR id, CMODE *mode);
/*
Description:
   Returns the code mode the assembler uses when assembling Intel
   instructions for this specific calling routine.
Parameters:
   input:
      id:               id number of calling routine.
   output:
      mode:             code mode
 */      

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
ERROR DasmDasmSetCmode(DESCRIPTOR id, CMODE mode);
/*
Description:
   Sets the code mode for the disassembler to use when disassembling Intel
   instructions.
Parameters:
   input:
      id:               id number of calling routine.
      mode:             code mode 
   output:
      none
 */      

ERROR DasmDasmGetCmode(DESCRIPTOR id, CMODE *mode);
/*
Description:
   Returns the code mode the disassembler uses when disassembling Intel
   instructions for this specific calling routine.
Parameters:
   input:
      id:               id number of calling routine.
   output:
      mode:             code mode
 */      

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
ERROR DasmDqSetCmode(DESCRIPTOR id, CMODE mode);
/*
Description:
   Sets the code mode for the dequeuer to use when dequeuing trace frames.
Parameters:
   input:
      id:               id number of calling routine.
      mode:             code mode 
   output:
      none
 */      

ERROR DasmDqGetCmode(DESCRIPTOR id, CMODE *mode);
/*
Description:
   Returns the code mode the dequeuer uses when dequeuing trace frames for 
   this specific calling routine.
Parameters:
   input:
      id:               id number of calling routine.
   output:
      mode:             code mode
 */      

#endif
