/****************************************************************************
**
**  Name:  pvtask.h
**
**  Description:
**     Background processing kernel
**
**  $Log:   S:/tbird/mt2_amd/inc/pvtask.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:07:02   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:54:18   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:24   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:45:26   Judy
   Initial revision.
** 
**    Rev 1.2   25 Jun 1993 15:57:48   paul
** Add TskCheckAbort and TskSetActiveAppState to support
** user abort via <esc> keypresses.
** 
**    Rev 1.1   09 Jun 1993 09:10:48   ernie
** Cosmetic changes
** 
**    Rev 1.0   28 May 1993 15:49:54   ernie
** Initial revision.
**  
**  $Header:   S:/tbird/mt2_amd/inc/pvtask.h_v   1.0   20 Mar 1998 10:07:02   Eric  $
**
**  Copyright (C) 1991-1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _PVTASK_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
typedef VOID (EXPORT *TASK)(VOID);

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
**
**  TaskExecute
**
**  Description:
**     Called from Application message loop when no messages are waiting
**     
**  Parameters:
**     none
**
**  Returns:
**     ER_NO_TASKS   indicates background task queue is empty and that
**                   message loop should allow Windows to idle.
**
*****************************************************************************/
RETCODE EXPORT TaskExecute(VOID);

/****************************************************************************
**
**  TaskRegister
**
**  Description:
**     Register background task to be executed when no messages are waiting.
**     
**  Parameters:
**     task      background task entry point
**     priority  determines order of execution when more than one background
**                 task is registered.  A higher number is a higher priority.
**     name      pointer to static text containing a textual representation
**                 of the task.  Used for displaying the task queue.
**
*****************************************************************************/
RETCODE EXPORT TaskRegister(TASK task, U16 priority, LPSTR name);

/****************************************************************************
**
**  TaskUnregister
**
**  Description:
**     Remove specified task from background processing list.
**     
**  Parameters:
**     task      entry point of background task to be removed.
**
*****************************************************************************/
RETCODE EXPORT TaskUnregister(TASK task);

/****************************************************************************
**
**  TaskWalk
**
**  Description:
**     Traverse task list; return text about each task.
**     
**  Parameters:
**     task      opaque pointer which retains inter-call state.  Call with
**                 state=NULL to begin at the head of the task list.  Check
**                 for state==NULL to detect end-of-list.
**     text      pointer to memory to receive textual output.
**
*****************************************************************************/
RETCODE EXPORT TaskWalk(VOID **state, LPSTR text);


/****************************************************************************
**
**  TskCheckAbort
**
**  Description:
**    Acts as replacement for Windows API function GetAsyncKeyState(VK_ESCAPE)
**    As such it should match its behavior and return type.
**    This new version only calls when the app is active, as
**    defined by the "appIsActive" flag.  This is a crude
**    indication of focus.
**
**  Parameters:
**     aborted   flag: FALSE if esc not pressed, TRUE if pressed.
**
*****************************************************************************/

RETCODE EXPORT TskCheckAbort(BOOLEAN FAR *abort);


/****************************************************************************
**
**  TskSetActiveAppState
**
**  Description:
**    Passes value of wParam of the WM_ACTIVATEAPP message
**    to local static variable.
**
**    Calls GetAsyncKeyState to reset the flag in the key state
**    array held by the driver because it may have been set
**    while the other app was active.
**
**  Parameters:
**     wParam     wParam from WM_ACIVATEAPP message.
*****************************************************************************/

RETCODE EXPORT TskSetActiveAppState(WORD wParam);


#ifdef __cplusplus
}
#endif

/******************************** E O F ***********************************/
