#define  _SDS2ABI_
#ifndef  _ABI_
#include "abi.h"
#endif
#ifndef _MP_TRACE_
#include "mp_trc.h"
#endif
#ifndef _MP_TRIG_
#include "mp_trig.h"
#endif
#ifndef  _MP_SHARE_
#include "mp_share.h"
#endif

#ifndef VERIFY_INFO_DEFINED
typedef struct {
   MEMBER_INDEX offset;
   MEMBER_INDEX space;
   MEMBER_INDEX expected;
   MEMBER_INDEX actual;
} VERIFY_INFO;
#define  VERIFY_INFO_DEFINED
#endif

#ifdef __cplusplus
extern "C" {
#endif

RETCODE EXPORT iceMapError(RETCODE status);
RETCODE EXPORT Sds2AbiSetInternalReg(S16 regId, U32 regValue);
RETCODE EXPORT Sds2AbiGetInternalReg(S16 regId, U32 *regValue);
RETCODE EXPORT SetReg(S16 regId, U32 regValue);
RETCODE EXPORT Sds2AbiSetReg(U16 regId, U32 regValue);
RETCODE EXPORT Sds2AbiFwReadMem(U32 offset, ADDR_SPACE space, U32 length,
			  ACCESS_SIZE access, U8 *data);
RETCODE EXPORT Sds2AbiFwFillMem(U32 offset, ADDR_SPACE space, U32 length,
       U32 pLength, ACCESS_SIZE access, BOOLEAN verify,
       VERIFY_INFO *verifyInfo, U8 *data);
RETCODE EXPORT Sds2AbiFillMemAction(U32 offset, ADDR_SPACE space, U32 length,
       U32 pLength, ACCESS_SIZE access, BOOLEAN verify,
       VERIFY_INFO *verifyInfo, U8 *data);
RETCODE  EXPORT Sds2AbiInitCoreMembers(VOID);
RETCODE  EXPORT Sds2AbiLoadMicePackFw(U16 port, PROBE_TYPE probeType);
RETCODE  EXPORT Sds2AbiReadMemAction(U32 offset, ADDR_SPACE space, U32 length,
			  ACCESS_SIZE access, U8 *data);
RETCODE  EXPORT Sds2AbiSetAccessSize(ACCESS_SIZE size);
RETCODE  EXPORT Sds2AbiGetAccessSize(ACCESS_SIZE *size);
RETCODE  EXPORT Sds2AbiFwPowerOn(VOID);
RETCODE  EXPORT Sds2AbiFwUnloadRegisters(BOOLEAN patchPCSP);
RETCODE  EXPORT Sds2AbiFwLoadRegisters(VOID);
RETCODE  EXPORT Sds2AbiFwGetMapGranularity(U32 *gran);
RETCODE  EXPORT Sds2AbiFwGetMapSize(U32 *size);
RETCODE  EXPORT Sds2AbiFwGetMapBlocks(U32 *block);
RETCODE  EXPORT Sds2AbiFwPingProbe(VOID);
RETCODE  EXPORT Sds2AbiMemTest(U32 offset,U32 length, BOOLEAN *result, U32 *ret);
RETCODE  EXPORT Sds2AbiMemFill(U32 offset,U32 length,U8 *data,U16 pLength, ACCESS_SIZE size);
RETCODE  EXPORT Sds2AbiMemSearch(U32 offset,U32 length,U8 *data,U16 pLength, BOOLEAN *found);
RETCODE  EXPORT Sds2AbiMemChecksum(U32 offset,U32 length,U32 *sum);
RETCODE  EXPORT Sds2AbiConvertTraceMode(TRACE_MODE traceMode, U16 *mpTraceMode);
RETCODE  EXPORT Sds2AbiSetTimerCounter(U16 id, U32 tc, U32 tc1);
RETCODE  EXPORT Sds2AbiGetTraceBufferInfo(U16 buffer, S32 *beforeFrames,
	            S32 *afterFrames, S32 *trigFrame);
RETCODE  EXPORT Sds2AbiGetTraceBufferLogicInfo(U16 buffer, S32 *start, S32 *end);
VOID     EXPORT Sds2AbiIsTraceBufferFull(U16 buffer, BOOLEAN *full);
U32      EXPORT Sds2AbiGetTriggerFrame(U16 buffer);
RETCODE  EXPORT Sds2AbiSetEvent(U16 evID, BUS_EVENT *bus);
RETCODE  EXPORT Sds2AbiClearEvent(U16 evID);
RETCODE  EXPORT Sds2AbiSetTrig(U16 trigLevel, MP_TRIGGER *trig);
RETCODE  EXPORT Sds2AbiClearTrig(U16 trigLevel);
RETCODE  EXPORT Sds2AbiGetTraceInfo(U16 *subBuf,U16 *cnt0,U16 *cnt1, U16 *maxBuf);
BOOLEAN  EXPORT Sds2AbiIsTraceBufferEmpty(U16 buffer);
RETCODE  EXPORT Sds2AbiSetNumTraceBuffers(U16 bufNo);
RETCODE  EXPORT Sds2AbiProgramMtat(VOID);
RETCODE  EXPORT Sds2AbiGetTraceFrames(U16 buffer, U32 frameNo, U32 *framesRead, TRACE_INFO *frames);
RETCODE  EXPORT Sds2AbiSetMap(DESCRIPTOR desc);
RETCODE  EXPORT Sds2AbiSetBreakOnFull(BOOLEAN enable);
RETCODE  EXPORT Sds2AbiSetControl(U16 control);
RETCODE  EXPORT Sds2AbiGetControl(U16 *control);
RETCODE  EXPORT Sds2AbiSetTimer(U16 timer);
RETCODE  EXPORT Sds2AbiGetTimer(U16 *timer);
RETCODE  EXPORT Sds2AbiSetExtEvent(U16 ext);
RETCODE  EXPORT Sds2AbiGetAllInternalRegs(U16 *internalRegBuffer);
RETCODE  EXPORT SetID(PROBE_TYPE probeType);
RETCODE  EXPORT Sds2AbiFwMemSearchAction(BOOLEAN *found);
RETCODE  EXPORT Sds2AbiMemCopy(U32 srcDesc,U32 len,BOOLEAN srcTarget,U32 destDesc);
RETCODE  EXPORT Sds2AbiMemCompare(U32 srcDesc,U32 destDesc,U32 len,BOOLEAN *result,
                U32 *retAddr1,U32 *retAddr2, U16 *retData1, U16 *retData2);
RETCODE  EXPORT Sds2AbiGetVerify(BOOLEAN *verify);
RETCODE  EXPORT Sds2AbiSetVerify(BOOLEAN verify);
RETCODE  EXPORT Sds2AbiInput(U16 addr, U16 len, U16 size, U8 *data);
RETCODE  EXPORT Sds2AbiOutput(U16 addr, U8 *data, U16 len, U16 size);
RETCODE  EXPORT Sds2AbiSetTraceBreak(U8 enableBreak);
RETCODE  EXPORT Sds2AbiSetTrigOutAction(U8 action);
RETCODE  EXPORT Sds2AbiSetTracing(U8 action);
RETCODE  EXPORT Sds2AbiSpaSetRange(U8 type, U8 id, U32 start, U32 end);
RETCODE  EXPORT Sds2AbiSpaClearRange(U8 type);
RETCODE  EXPORT Sds2AbiSpaGetMAInfo(U32 *stamp, MA_INFO_NODE *info, BOOLEAN *flag);
RETCODE  EXPORT Sds2AbiSpaGetTAInfo(U32 *stamp, U16 *info, BOOLEAN *flag);
RETCODE  EXPORT Sds2AbiSpaGetCCInfo(U32 start, U32 end, U8 *ptr, BOOLEAN *flag);
RETCODE  EXPORT Sds2AbiSpaGo(U8 type);
RETCODE  EXPORT Sds2AbiSpaClose();
RETCODE  EXPORT Sds2AbiSpaOpen();
RETCODE  EXPORT Sds2AbiReadFrameStamp(U16 bufID, U32 frameNo, U32 *stamp, U8 *stampMSB);
RETCODE  EXPORT Sds2AbiReadLastStamp(U16 bufID, U32 *stamp, U8 *stampMSB);
RETCODE  EXPORT Sds2AbiSpaSetBkpt(U8 flag, U32 addr);
RETCODE  EXPORT Sds2AbiReadFRom(U8 *data);
RETCODE  EXPORT Sds2AbiWriteFRom(U8 *data);

#ifdef __cplusplus
}
#endif
