/*
 * Name:  sexecute.h
 *
 * Description:
 *    Execution control server routines to control emulation state.
 *
 * $Log:   S:/tbird/mt2_amd/inc/sexecute.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:07:04   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:54:22   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:26   Judy
** Initial revision.
   
      Rev 1.0   23 Aug 1996 17:46:10   Judy
   Initial revision.
**  
**     Rev 1.5   05 Feb 1992 07:50:38   doug
**  emulation state is now in sd68030.h.  This should really be processor
**  independent.  The new bkptexec.h solves this problem.
**  
**     Rev 1.4   28 Jan 1992 16:50:24   jim
**  added ifndef to emulation state.
**  
**     Rev 1.3   28 Jan 1992 16:30:52   jim
**  changed emulation state to match sd68030.h. This should really be only here.
**  
**     Rev 1.2   15 Jan 1992 14:36:10   tom
**  Corrected syntax error.
**  
**     Rev 1.1   21 Aug 1991 11:24:40   tom
**  Updated types, include file format.
 * 
 *    Rev 1.0   14 Jun 1991 13:36:06   jim
 * Initial revision.
 *
 * $Header:   S:/tbird/mt2_amd/inc/sexecute.h_v   1.0   20 Mar 1998 10:07:04   Eric  $
 */
#define _SEXECUTE_

#ifndef _BASETYPE_
#include "basetype.h"
#endif

RETCODE EXPORT ExecGetEmulationStatus(EMULATION_STATE *emulState);
/*
Description:
   Get the current state of emulation.
Parameters:
   input:
      None   
   output:
      emulState:  the state of emulation at the moment this call is made
*/

RETCODE EXPORT ExecStartEmulation(VOID);
/*
Description:
   Start emulation.  Depending on the type of breakpoints set, this will
   be a free run or a step emulation.
Parameters:
   input:
      None   
   output:
      None
*/

#define STEP_FOREVER 0

RETCODE EXPORT ExecStepEmulation(U32 stepCount);
/*
Description:
   Single step at processor instruction level for a given number of steps.
   This routine starts emulation in "Stepping" mode.  Use ExecHaltEmulation
   to stop emulation before the step count is reached.  Use
   ExecGetEmulationState or ExecRegisterEmulChange to find out when step
   is complete.  NOTE:  This operation is different from Mice-V which waited
   until all the steps were complete.
   A count of STEP_FOREVER will put the emulator in a continuous stepping
   mode (infinite count).  Use ExecHaltEmulation to stop.
Parameters:
   input:
      stepCount:  number of instructions to step
   output:
      None
*/

RETCODE EXPORT ExecHaltEmulation(VOID);
/*
Description:
   Stop emulation.  This will stop emulation regardless of breakpoint and
   trigger state (asynchronous stop).
Parameters:
   input:
      None   
   output:
      None
*/

RETCODE EXPORT ExecRegisterEmulChange(RETCODE (*emulChange)(EMULATION_STATE oldState,
                                  EMULATION_STATE newState));
/*
Description:
   Caller requests to be notified when the state of emulation changes.
   The callback function will be called with the old state and the new
   (current) state.  The caller should not have to save the state since
   this call will give the old and new states so caller can test not only
   for new state but for the transition between states.
Parameters:
   input:
      emulChange:  callback function to invoke when emulation state changes;
                   function will be called with the following parameters:
         input:
            None
         output:
            oldState:  the previous state before it just changed
            newState:  the current state (what it just changed to)
   output:
      None
*/
