/****************************************************************************
**
**  Name:  wcommdlg.h
**
**  Description:
**     External interfaces to access Windows COMMDLG.DLL
**
**  $Log:   S:/tbird/mt2_amd/inc/wcommdlg.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:07:04   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:54:20   Judy
** Initial revision.
** 
**    Rev 1.0   27 Aug 1996 15:21:26   Judy
** Initial revision.
** 
**    Rev 1.0   23 Aug 1996 17:46:42   Judy
** Initial revision.
** 
**    Rev 1.2   22 Jul 1994 10:16:20   nghia
** Updated error codes.
** 
**    Rev 1.1   20 Jul 1994 10:01:18   nghia
** Added information to OPENFILE/SAVEFILE function interface.
** 
**    Rev 1.0   14 Jul 1994 11:07:16   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/inc/wcommdlg.h_v   1.0   20 Mar 1998 10:07:04   Eric  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _WCOMMDLG_
#define _WCOMMDLG_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "commdlg.h"

#ifndef _BASEWIND_
#include "basewind.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
**
**  CommDlgGetFileName
**
**  Description:
**     Open a OPENFILE/SAVEFILE dialog session.  Return the actual
**     file name in <fileName>.  Return ER_USER_ABORT if the user is
**     pressed CANCEL or CLOSE.
**     
**  Parameters:
**     input:
**        parent:       parent Window handle (HWND).
**        helpId:       help context id.
**        filterId:     file filters resource ID - See \cliulib\wdlgrsc.h
**                      for ID list.
**        initDirStr:   initial path string - NULL if not available
**        openDlg:      TRUE - use as OPENFILE, FALSE - use as SAVEFILE
**     output:
**        fileName:     buffer of MAX_STRING_SIZE to hold the returned
**                      file name.
**
******************************************************************************/
RETCODE EXPORT CommDlgGetFileName(U32 parent, U16 helpId, U16 filterId,
                                  LPSTR initDir, BOOLEAN openDlg,
                                  LPSTR fileName);

/*****************************************************************************
**
**  CommDlgFileHookProc
**
**  Description:
**     OPENFILE/SAVEFILE common dialog hook function.
**
**  Parameters:
**     input
**        hDlg          handle of the dialog.
**        msg           message to process.
**        wP            word parameter of message.
**        lP            long parameter of message.
**
******************************************************************************/
UINT CALLBACK CommDlgFileHookProc(HWND hDlg, UINT msg, WPARAM wP, LPARAM lP);  

#ifdef __cplusplus
}
#endif
  
#endif /* _WCOMMDLG_ */
/******************************** E O F *************************************/
