/****************************************************************************
**
**  Name:  ldrutil.cpp
**
**  Description:
**     Contains Loader utility routines
**
**  Status:  PRELIMINARY | CODED | REVIEWED | TESTED
**
**  $Log:   S:/tbird/mt2_amd/loader/ldrutil.cpv  $
** 
**    Rev 1.0   20 Mar 1998 11:23:14   Eric
** Initial revision.
** 
**    Rev 1.1   26 Feb 1997 11:49:52   Judy
** 
**    Rev 1.0   14 Jun 1996 17:25:46   Judy
** Initial revision.
** 
**    Rev 1.5   11 Oct 1994 10:20:54   nghia
** Fixed PPR 9841 - Loader does not report error.
** 
**    Rev 1.4   28 Sep 1994 12:50:36   nghia
** Revise LdrWarning() to filter ER_LOAD_ABORT from FW.  Added check for
** err == GOOD and reported error.
** 
**    Rev 1.3   17 Jun 1994 11:35:18   nghia
** Revised WarningEx() to LdrWarning() to provide ABORT loading when error
** occurred.
** 
**    Rev 1.2   03 Jun 1994 14:59:30   nghia
** Exported LdrSendMessageToCLI().
** 
**    Rev 1.1   20 May 1994 11:01:44   nghia
** Revised to support warning without infostring.
** 
**    Rev 1.0   18 May 1994 16:59:14   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/loader/ldrutil.cpv   1.0   20 Mar 1998 11:23:14   Eric  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _LDROBJ_
#include "ldrobj.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"            
#endif

#ifndef _LOADER_
#include "loader.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern HANDLE cliServerHandle;      // defined in LIBMAIN
extern PTLdrLauncher LoaderServer;  // define in LDROBJ

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/******************************************************************************
**
**  LdrSendMessageToCLI
**
******************************************************************************/
RETCODE EXPORT LdrSendMessageToCLI(LPSTR strMsg) {
   GLOBALHANDLE hmsgBuf;
   CSERVER_RESULTS FAR *lpmsgBuf;
   U16 msgLength;
   LOOP_VAR i;

   //
   // Send (not Post, we don't want them to get queued) text message to CLI.
   msgLength = lstrlen(strMsg);
   // note that global allocation is required 
   // also, we need to allocate for string buffer here 
   if ((hmsgBuf = GlobalAlloc(GHND, sizeof(CSERVER_RESULTS)+msgLength+1))
         == NULL) {
      /* return proper err code */
      return ER_OUT_OF_MEMORY;
   }
   lpmsgBuf = (CSERVER_RESULTS FAR *)GlobalLock(hmsgBuf);
   lpmsgBuf->target = 0;  
   lpmsgBuf->variantCode = CLI_SERVER_RESULTS;  
   lpmsgBuf->resultTextLength = msgLength;
   /* we've already allocated for buffer */
   for (i=0; i < msgLength; i++)
      lpmsgBuf->messageText[i] = *strMsg++;
   lpmsgBuf->messageText[i] = '\0'; // NULL terminate string 
   // Send resultant message to CLI
   SendMessage(cliServerHandle, CLI_SERVER_RESULTS, hmsgBuf,
	   (DWORD)CLI_SERVER_RESULTS);
   return GOOD;
}  /* LdrSendMessageToCLI */

/******************************************************************************
**
**  LdrWarning
**
******************************************************************************/
RETCODE EXPORT LdrWarning(RETCODE err, LPSTR infoStr1, LPSTR infoStr2,
                          LPSTR infoStr3) {
   RETCODE ret;
   S16 buttonID;
   
   // Do not report err if err is a warning and reportWarning flag is FALSE
   // or the err is ER_LDR_ABORT
   if ((err == GOOD) || (err == ER_LDR_ABORT) || (!E_SEVERITYID(err)) ||
       (!IsReportWarning(LoaderServer->lastLoadOptions) &&
        ((err & E_SEVERITY_MASK) == E_WARNING)) )
      return GOOD;
   
   // map FW load abort error to Host load abort error
   if (err == ER_LOAD_ABORT)
      err = ER_LDR_ABORT;
   
   // Report the error for clients
   if ((ret = ErrDisplayFormattedError(err, CHECK_MODE,
                                       infoStr1, infoStr2, infoStr3,
                                       MB_OKCANCEL,
                                       (S16 FAR *) &buttonID)) != GOOD)
      return ErrDisplayError(ret, CHECK_MODE);
   
   // If user pressed CANCEL - return ER_LDR_ABORT so client can do
   // clean up. Else return GOOD
   if (buttonID == IDCANCEL) return ER_LDR_ABORT;
   
   // Put up hourglass for loader to continue loading
   SetCursor(LoadCursor(NULL, IDC_WAIT));  
   return GOOD;
}  /* LdrWarning */

/******************************************************************************
**
**  DoAssert
**
******************************************************************************/
VOID DoAssert(const LPSTR msg, const LPSTR file, U32 line) {
   CHAR msgStr[MAX_STRING_SIZE];
   // format the message and print it out
   sprintf(msgStr, "%s @ %s - %u", msg, file, line);
   ErrDisplayString(ER_ASSERTION,(LPSTR)msgStr, FORCE_POPUP);
}

/********************************** E O F ***********************************/
