/****************************************************************************
**
**  Name:  libmain.cpp
**
**  Description:
**     Contains the main entry and exit points of the Loader DLL
**
**  $Log:   S:/tbird/mt2_amd/loader/libmain.cpv  $
** 
**    Rev 1.0   20 Mar 1998 11:23:14   Eric
** Initial revision.
** 
**    Rev 1.1   26 Feb 1997 11:49:56   Judy
** 
**    Rev 1.0   14 Jun 1996 17:25:44   Judy
** Initial revision.
** 
**    Rev 1.2   14 Jul 1994 10:44:12   nghia
** Added get processor family.
** 
**    Rev 1.1   23 May 1994 16:49:38   nghia
** Revised to report error on initializing toolchain.
** 
**    Rev 1.0   18 May 1994 16:59:30   nghia
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_amd/loader/libmain.cpv   1.0   20 Mar 1998 11:23:14   Eric  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _PROC_
#include "proc.h"
#endif

#ifndef _INIUTIL_
#include "iniutil.h"
#endif

#ifndef _LDROBJ_
#include "ldrobj.h"
#endif

#ifndef __LPROFILE__
#include "lprofile.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
/* Global Variables */
HANDLE cliServerHandle;
HANDLE hLib;
PROCESSOR_FAMILY procFamily = FAMILY_UNKNOWN;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/
extern PTLdrLauncher LoaderServer;    // defined in LDROBJ.CPP
extern CHAR selToolName[];            // defined in LPROFILE.CPP

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the base class DLL
**
**    Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
                       LPSTR lpszCmdLine) {
    RETCODE err;
    S16 buttonID;

    /* the LIBENTRY initializes the local heap by calling LocalInit() and
    ** then calls LibMain.  The LocalInit() locks the data segment of the
    ** library when initialize; therefore LibMain needs to unlock
    */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    // save the library instance handle 
    hLib = hInstance;

    // init server with ErrText Server
    ErrInitDLL(MODULE_LOADER, "LOADER.DLL");

    // get the current processor family
    ProcReturnProcFamily((PROCESSOR_FAMILY FAR*) &procFamily);
    // create a loaderServer object instance
    if ((LoaderServer = new LdrLauncher()) == NULL) 
       err = ER_OUT_OF_MEMORY;
    else
       err = LoaderServer->Status();  // last error occurs in server
    
    // report any error during initialization
    if (err != GOOD) 
       ErrDisplayFormattedError(err, FORCE_POPUP,
                                NULL, NULL, NULL,MB_OK, (S16 FAR *) &buttonID);
    // get CompilerUsed information from PWRVIEWS.INI 
    if ((err = IniGetString((LPSTR) LAPP_NAME, (LPSTR) LAPP_TOOL_USE,
         PWRVIEWS_INI_DEFAULT, (LPSTR) selToolName)) != GOOD)
       ErrDisplayFormattedError(err, FORCE_POPUP,
                                NULL, NULL, NULL,MB_OK, (S16 FAR *) &buttonID);
    else
       SetToolUse();
    return(TRUE);
}

#ifndef __BORLANDC__

/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**    Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
int FAR PASCAL WEP(int) {
   // deallocate memory
   delete loaderServer;
   return(TRUE);
}

#endif /* __BORLANDC__ */

/*****************************************************************************
**
**   InitCServer :
**   Register server with CLI.
**
******************************************************************************/
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) {
   CSERVER_NEW_REGISTRATION FAR * msgBufPtr;
   
   cliServerHandle = cliHandle;
   msgBufPtr = (CSERVER_NEW_REGISTRATION FAR *)
               TMalloc(sizeof(CSERVER_VARIABLE_VALUE));
   if (msgBufPtr == NULL) {
      return ER_OUT_OF_MEMORY;
   }
   msgBufPtr->stringResourceHandle  = dllHandle;
   msgBufPtr->serverNameIndex       = 0;  // IMPORTANT - must match LOADER.RC
   msgBufPtr->dllNameIndex          = 1;
   msgBufPtr->numberOfCommandsIndex = 2;
   msgBufPtr->commandStartIndex     = 3;
   SendMessage(cliHandle, CLI_NEW_SVR_REGISTRATION,
               CLI_NEW_SVR_REGISTRATION, (DWORD)msgBufPtr);
   return GOOD;
}  /* InitCServer */

/******************************** E O F ***********************************/
