/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the dll.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/map/libmain.c_v  $
** 
**    Rev 1.0   20 Mar 1998 10:09:36   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 14:09:34   Judy
** Initial revision.
** 
**    Rev 1.7   24 May 1994 07:39:04   tom
** Merged 1.6.1.1 onto trunk.
** 
**    Rev 1.6.1.1   19 May 1994 17:02:28   tom
** Remove redundant includes.
** 
**    Rev 1.6.1.0   15 May 1994 01:02:02   tom
** PDL Map presenter changes.
** 
**    Rev 1.6   04 Nov 1992 15:21:30   john
** removed code from WEP and #ifdef'd WEP
** 
**    Rev 1.5   23 Oct 1992 21:22:22   brucea
** Removed warning for no nParam parameter
** 
**    Rev 1.4   27 Jul 1992 13:28:44   john
** Added code to WEP to deallocate some alloc'd memory
** 
**    Rev 1.3   22 Jul 1992 13:19:32   john
** removed unnecessary global var
** 
**    Rev 1.2   22 Jul 1992 10:34:12   john
** made minor changes
**
**    Rev 1.1   14 May 1992 15:29:56   courtney
** Add call to ErrInitDLL.
** 
**    Rev 1.0   27 Feb 1992 15:28:16   doug
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_amd/map/libmain.c_v   1.0   20 Mar 1998 10:09:36   Eric  $
**
*****************************************************************************/

		       /****************************
			*                          *
			*       INCLUDE FILES      *
			*                          *
			****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _MAP_
#include "map.h"
#endif

#ifndef _MAPDLG_
#include "mapdlg.h"
#endif

		       /****************************
			*                          *
			*     LOCAL DEFINITIONS    *
			*                          *
			****************************/

#define DLL_NAME "map.dll"

			/****************************
			 *                          *
			 *    EXTERNAL VARIABLES    *
			 *                          *
			 ****************************/

			/****************************
			 *                          *
			 *     LOCAL PROTOTYPES     *
			 *                          *
			 ****************************/

			/****************************
			 *                          *
			 *      EXECUTABLE CODE     *
			 *                          *
			 ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the ENLIB.DLL
**
**      Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    /* initialize successfully */
    ErrInitDLL(MODULE_MAP, DLL_NAME);
    InitServer(); /* !!!temporary initialization */
    InitPresenter(hInstance);

    return(TRUE);
}

#ifndef __BORLANDC__
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**      Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
#pragma argsused
VOID FAR PASCAL WEP(int nParam) {
   /* if there's an error doing this there is no way of reporting it */

}
#endif

/******************************** E O F ***********************************/
