/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the dll.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/mem/libmain.c_v  $
** 
**    Rev 1.0   20 Mar 1998 10:04:40   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 13:50:12   Judy
** Initial revision.
** 
**    Rev 1.4   18 Aug 1992 18:19:58   brucea
** Added cast to MODULE_NAME
** 
**    Rev 1.3   30 Jul 1992 09:26:46   brucea
** Made hLib a public so memory.c can use it for MakeProcInstance
** 
**    Rev 1.2   21 Jul 1992 11:55:30   brucea
** Removed: #include "pmem.h", WEP code
** Added: error check and call to ErrDisplayError, #include "memlocal.h" which
**    defines MemInitServer
** 
** 
** 
**    Rev 1.1   15 May 1992 15:33:24   brucea
** Added: call to ErrInitDLL
** 
**    Rev 1.0   27 Feb 1992 17:29:26   doug
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_amd/mem/libmain.c_v   1.0   20 Mar 1998 10:04:40   Eric  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _MEMLOCAL_
#include "memlocal.h"
#endif

#define MODULE_NAME "mem.dll"

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

/* Handle of the DLL instance */
HANDLE hLib;

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the ENLIB.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
                       LPSTR lpszCmdLine) {

   RETCODE err; 

   /* the LIBENTRY initializes the local heap by calling LocalInit() and
      then calls LibMain.  The LocalInit() locks the data segment of the
      library when initialize; therefore LibMain needs to unlock */
   if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
      UnlockData(0);

   /* initialize successfully */
   hLib = hInstance;

   ErrInitDLL(MODULE_MEMORY, (LPSTR)MODULE_NAME);  /* set up for error text */

   err = MemInitServer();
   if (GOOD != err)
      ErrDisplayError(err, FORCE_POPUP);
   return(TRUE);
}

/******************************** E O F ***********************************/
