/****************************************************************************
**
**  Name: DARRAY.H
**
**  Description:
**     Contains the declaration of the generic template of Dynamic Array
**     (DArray) class.  The Dynamic Array class provide an array-liked
**     data structure to hold objects of type <T>.  
**
**  $Log:   S:/tbird/mt2_amd/omf86/darray.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:16:10   Eric
** Initial revision.
** 
**    Rev 1.0   26 Feb 1997 11:40:32   Judy
** Initial revision.
** 
**    Rev 1.0   14 Jun 1996 16:36:48   Judy
** Initial revision.
** 
**    Rev 1.0   07 Apr 1995 09:17:40   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/omf86/darray.h_v   1.0   20 Mar 1998 10:16:10   Eric  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __DARRAY_H
#define __DARRAY_H

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef __CTYPE_H
#include <ctype.h>
#endif

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HEAP_
#include "heap.h"       // provide TMalloc & TFree
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
// DArray Constant
const U16 MAX_ARRAY_SIZE = 0xFFFE;  // 64K bytes array limit
const U16 DEFAULT_ARRAY_SIZE = 512;
                          
//=============================================================================
// Class: DArray
//
// Description: DArray is an object that provides functionality of a
// one-dimemsional array data structure. However, DArray is using heap
// memory to store its <T> elements; therefore, memory allocation is
// on-demand.  The user of this template need to ensure to access
// DArray[0..size-1].
//
// IMPORTANT: a DArray<T> object does not have ownership on <T> objects
//  stored in itself.  This means the user of DArray<T> must destroy all
//  <T> objects before destroying the DArray<T>.
//============================================================================
template<class T>
class DArray { 
protected:
   T*   arrayPtr;    // pointer to array of T
   U16  availIndex;  // number of stored <T> elements.
   U16  arraySize;   // current size of DArray
   
public:
   static T BadIndex;
   static RETCODE  LastError;   // class variable holding last operation error

protected:
   RETCODE Copy(DArray<T>& srcArray);
   
public:
   // CTor & DTor
   DArray();
   DArray(U16 size = DEFAULT_ARRAY_SIZE);
   DArray(DArray<T>& srcArray);
   ~DArray();
   
   // access functions
   U16 Count(VOID) { return availIndex; }  // current number of elements
   VOID DecrementCount(VOID) { if (availIndex) --availIndex; } 
   U16 Size(VOID) { return arraySize; }
   VOID Reset(VOID) { availIndex = 0; }

   // grow DArray object to a new size
   RETCODE Grow(U16 newSize);
   // insert a <T> object into self
   RETCODE Insert(T& obj);
   
   T& operator[](const U16 index);
   DArray<T>& operator =(DArray<T>& array);

   // Allocator & Deallocator
   VOID* operator new(size_t sizeObj) { return TMalloc((U32) sizeObj); }
   VOID operator delete(VOID* p) { if (p) TFree((LPSTR) p); }
};

#endif /* __DARRAY_H */
/******************************** E O F *************************************/
