/****************************************************************************
**
**  Name:  libmain.cpp
**
**  Description:
**     Contains the main entry and exit points of the Loader DLL
**
**  $Log:   S:/tbird/mt2_amd/omf86/libmain.cpv  $
** 
**    Rev 1.0   20 Mar 1998 10:16:10   Eric
** Initial revision.
** 
**    Rev 1.0   26 Feb 1997 11:40:34   Judy
** Initial revision.
** 
**    Rev 1.0   14 Jun 1996 16:36:54   Judy
** Initial revision.
** 
**    Rev 1.4   09 May 1995 10:42:46   tom
** 10220: Disable floating point exceptions.
** 
**    Rev 1.3   20 Sep 1994 11:57:32   joyce
** Add SetupRegisterTable() to initialize the reg table for the reg var types.
**
**    Rev 1.2   14 Sep 1994 10:43:52   joyce
** Add parenthesis to seperate conditions to prevent a potential bug.
**
**    Rev 1.1   03 Aug 1994 13:25:20   steve
** Joyce's changes for 386 build 11
**
**    Rev 1.0   24 May 1994 14:48:20   joyce
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/omf86/libmain.cpv   1.0   20 Mar 1998 10:16:10   Eric  $
**
** Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _INIUTIL_
#include "iniutil.h"
#endif

#ifndef _CPU_
#include "cpu.h"
#endif

#ifndef __OMF86LDR__
#include "omf86ldr.h"
#endif

#include <float.h>

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
/* Global Variables */
HANDLE CliServerHandle;
HANDLE Hlib;
U32 StartRangeNotSet = 0xFFFFFFFFL;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the OMF86.DLL
**
**    Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
                       LPSTR lpszCmdLine) {
PROCESSOR_FAMILY procFamily;
DESCRIPTOR addrDesc;
RETCODE err;

    /* the LIBENTRY initializes the local heap by calling LocalInit() and
    ** then calls LibMain.  The LocalInit() locks the data segment of the
    ** library when initialize; therefore LibMain needs to unlock
    */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    // save the library instance handle
    Hlib = hInstance;

    // disable floating point exceptions
    _control87(MCW_EM, MCW_EM);

    // init server with ErrText Server
    ErrInitDLL(MODULE_LOADER_OMF86, "OMF86.DLL");

   /* Check to see if the processor is X86  */
   if ((ProcReturnProcFamily(&procFamily) == GOOD) &&
       (procFamily != FAMILY_X86)) {
      CHAR processorName[NAME_LEN];

      ProcReturnProcessorName(processorName);
      LdrWarning(ER_OMF86_LOADFILE_PROC_NOT_COMPATIBLE,
                 processorName, NULL, NULL);
   }

   /* Setup the register translation table for reg. var. types */
   if ((err = SetupRegisterTable()) != GOOD)
      LdrWarning(err, NULL, NULL, NULL);

   /* Get the maximum input address of the processor and use it for address
      range initialize value.                                              */
   if (CpuGetPC(&addrDesc) == GOOD) {
      AdrGetMaxInputAddrOffset(addrDesc, (U32 FAR *)&StartRangeNotSet);
      AdrDestroyAddress(addrDesc);
   }
   return(TRUE);
}

#ifndef __BORLANDC__

/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**    Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
int FAR PASCAL WEP(int) {
   return(TRUE);
}

#endif /* __BORLANDC__ */

/*****************************************************************************
**
**   InitCServer :
**   Register server with CLI.
**
******************************************************************************/
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) {
   CSERVER_NEW_REGISTRATION FAR * msgBufPtr;

   CliServerHandle = cliHandle;
   msgBufPtr = (CSERVER_NEW_REGISTRATION FAR *)
               TMalloc(sizeof(CSERVER_VARIABLE_VALUE));
   if (msgBufPtr == NULL) {
      return ER_OUT_OF_MEMORY;
   }
   msgBufPtr->stringResourceHandle  = dllHandle;
   msgBufPtr->serverNameIndex       = 0;  // IMPORTANT - must match OMF86.RC
   msgBufPtr->dllNameIndex          = 1;
   msgBufPtr->numberOfCommandsIndex = 2;
   msgBufPtr->commandStartIndex     = 3;
   SendMessage(cliHandle, CLI_NEW_SVR_REGISTRATION,
               CLI_NEW_SVR_REGISTRATION, (DWORD)msgBufPtr);
   return GOOD;
}  /* InitCServer */

/******************************** E O F ***********************************/
