/****************************************************************************
**
**  Name:  TYPE.H
**
**  Description:
**      Major header file used by OMF86 Loader.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/mt2_amd/omf86/type.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:16:14   Eric
** Initial revision.
** 
**    Rev 1.2   19 Jun 1997 17:12:18   Judy
** Support Paradigm locate extended version which accept register variables.
** 
**    Rev 1.1   18 Apr 1997 09:29:48   Judy
** 
**    Rev 1.0   26 Feb 1997 11:40:38   Judy
** Initial revision.
** 
**    Rev 1.0   14 Jun 1996 16:37:00   Judy
** Initial revision.
** 
**    Rev 1.8   10 Mar 1995 13:56:30   nghia
** Created new LIST_TYPE enum.  Added CreateListBuffer() and FreeListBuffer()
** to handle OMF86 list type genericly.
** 
**    Rev 1.7   26 Sep 1994 13:41:58   joyce
** 1. Add TFree checkings.
**
**    Rev 1.6   23 Aug 1994 14:57:10   joyce
** Numerous changes to coordinate to the new type.cpp.
**
**    Rev 1.5   03 Aug 1994 13:25:50   steve
** Joyce's changes for 386 build 11
**
**    Rev 1.4   25 Jul 1994 12:41:30   steve
** Joyce's omf changes for 386 build 9
**
**    Rev 1.3   14 Jul 1994 17:03:32   steve
** More omf86 changes for 386 build 8 from Joyce
**
**    Rev 1.1   02 Jun 1994 18:55:18   joyce
** Change the misplaced filename.
**
**    Rev 1.0   24 May 1994 14:48:44   joyce
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/omf86/type.h_v   1.0   20 Mar 1998 10:16:14   Eric  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __TYPE__
#define __TYPE__

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define MAU_BITS     8
#define LEN_MAXSCALAR    128
#define LEN_MINSCALAR      8
#define LEN_MAXINTEGER    64
#define LEN_MIN_REAL      32
#define LEN_SHORT         16
#define BITS_16_16        32
#define BITS_OFFSET       16
#define TYPE_OFFSET   0x100
#define GET_INDEX     TRUE
#define GET_NAME      FALSE
#define MAX_TYPE_INDEX 0x7FFF
#define LIST_INDEX_OFFSET 128

#define EXPAND_SMALL_PTR "ExpandSmallPtr"
#define SP_ON  "on"
#define SP_OFF "off"

typedef struct type_list {
    TYPE_INDEX typeDefIndex;
    U32 filePtr;
    struct type_list FAR *next;
} TYPE_LIST_BUF;

typedef struct hash_index {
    TYPE_INDEX typeDefIndex;
    TYPE_LIST_BUF *listPtr;
    struct hash_index FAR *next;
} HASH_BUF;

typedef struct {
    HANDLE hFile;
    U32 flags;
    U8 *typeRec;
    U16 i;
    TYPE_INDEX typeIdx;
    U16 recLen;
    TYPE_HEADER_TYPE *typeHdrInfo;
} TYPE_PARAM;

//Hera 4/3/96
typedef struct Blk_Info {
   CHAR blkName[NAME_LEN+1];
   LADDRESS base;
   struct Blk_Info *next;
}BLK_INFO;

#define OMF86_REGISTER  0x40
typedef enum {
  OMF86_SHORT_NOPOP=0x5E, // 0x5E
  OMF86_LONG_NOPOP,       // 0x5F
  OMF86_PLSTRUCTURE,      // 0x60
  OMF86_PLARRAY,          // 0x61
  OMF86_SELECTOR,         // 0x62
  OMF86_INTERRUPT,        // 0x63
  OMF86_FILE,             // 0x64
  OMF86_PACKED,           // 0x65
  OMF86_UNPACKED,         // 0x66
  OMF86_SET,              // 0x67
  OMF86_RESERVE1,         // 0x68
  OMF86_CHAMELEON,        // 0x69
  OMF86_BOOLEAN,          // 0x6A
  OMF86_TRUE,             // 0x6B
  OMF86_FALSE,            // 0x6C
  OMF86_CHAR,             // 0x6D
  OMF86_INTEGER,          // 0x6E
  OMF86_CONST,            // 0x6F
  OMF86_RESERVE2,         // 0x70
  OMF86_LABEL,            // 0x71
  OMF86_LONG,             // 0x72
  OMF86_SHORT,            // 0x73
  OMF86_PROCEDURE,        // 0x74
  OMF86_PARAMETER,        // 0x75
  OMF86_DIMENSION,        // 0x76
  OMF86_ARRAY,            // 0x77
  OMF86_RESERVE3,         // 0x78
  OMF86_STRUCTURE,        // 0x79
  OMF86_POINTER,          // 0x7A or OFFSETSIZE16
  OMF86_SCALAR,           // 0x7B
  OMF86_UNSINT,           // 0x7C
  OMF86_SGNINT,           // 0x7D
  OMF86_REAL,             // 0x7E
  OMF86_LIST,             // 0x7F
  OMF86_UNKNOWN_TYPE = 0xFF     
} OMF86_TYPE;

typedef enum {
  LEAF_NIL  = 0x80,      // 0x80
  LEAF_U16,              // 0x81
  LEAF_STRING,           // 0x82
  LEAF_INDEX,            // 0x83
  LEAF_U24,              // 0x84
  LEAF_REPEAT,           // 0x85
  LEAF_S8,               // 0x86
  LEAF_S16,              // 0x87
  LEAF_S32,              // 0x88
} OMF86_LEAF;

typedef enum {
   INDEX_LIST = LEAF_INDEX,
   NAME_LIST  = LEAF_STRING,
   VALUE_LIST = LEAF_S16
} LIST_TYPE;

                       /****************************
                        *                          *
                        *      PROTOTYPES          *
                        *                          *
                        ****************************/

RETCODE GetTypeIndex(HANDLE hFile, TYPE_INDEX *type);
RETCODE ProcessTYPDEF(OMF86_FUNC_PARA *funcPara);
RETCODE InitializeTypeInfo(VOID);
RETCODE CreateListBuffer(TYPE_LIST_BUF **, HASH_BUF **);
RETCODE FreeListBuffer(LIST_TYPE);
RETCODE ProcessRegVarExt(HANDLE hFile, U32 flags);

#endif /* __TYPE__ */
/******************************** E O F ***********************************/
