/****************************************************************************
**
**  Name:  pericli.cpp
**
**  Description:
**     Source file for peripheral server shell interface.
**
**  $Log:   S:/tbird/mt2_amd/peri/pericli.cpv  $
** 
**    Rev 1.1   09 Apr 1998 18:16:54   Eric
** 
**    Rev 1.0   16 Dec 1996 16:19:58   Judy
** Initial revision.
** 
**    Rev 1.0   11 Oct 1996 18:47:20   Judy
** Initial revision.
** 
**    Rev 1.4   19 Apr 1994 16:06:12   nghia
** Added #pragma -par and -dup to suppress compiler warnings.
** 
**    Rev 1.3   12 Oct 1993 14:42:38   ron
** checkpoint after buffer editing
** 
**    Rev 1.2   28 Sep 1993 15:29:10   ron
** revised parser (using Paul's new config format)
** 
**    Rev 1.1   01 Sep 1993 14:06:22   marilyn
** Implemented PCliOpen.
** 
**    Rev 1.0   28 Jun 1993 15:04:54   marilyn
** Initial revision.
**  
**  $Header:   S:/tbird/mt2_amd/peri/pericli.cpv   1.1   09 Apr 1998 18:16:54   Eric  $
**
**  Copyright (C) 1991-93 Microtek International.  All rights reserved.
**
*****************************************************************************/


		       /****************************
			*                          *
			*       INCLUDE FILES      *
			*                          *
			****************************/

#ifndef _PERICLI_
#include "pericli.h"
#endif

#ifndef _PERISERV_
#include "periserv.h"
#endif

#ifndef _PROC_
#include "proc.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

		       /****************************
			*                          *
			*        DEFINITIONS       *
			*                          *
			****************************/

#define PERI_WFLAGS (GMEM_MOVEABLE|GMEM_NODISCARD|GMEM_ZEROINIT)

extern PTPeriServer PeriServer;   // Peripheral server object ptr

#if defined (STRICT)
extern HWND cliServerHandle;
#else
/* Handle of the CLI instance */
extern HANDLE cliServerHandle;
#endif

		       /****************************
			*                          *
			*        PROTOTYPES        *
			*                          *
			****************************/
RETCODE PRIVATE SendCliResults(LPSTR results, HANDLE server);

#pragma warn -par -dup

//*************************************************************************
//   PCliOpen  *** Hidden shell command ***
//
//   Description:
//      Verify processor type and open and read from the appropriate
//      configuration file.  Create database of information for the
//      peripheral presenter.
//
//   Parameters:
//      cmdString (in): the shell command string
//      argc (in): number of arguments
//      argv[] (in): array of pointers to arguments
//
//   Example commands:
//      _popen
//      _popen MC68332
//      _popen MC68330
//      _popen XX99999
//      _popen MC68331
//      _popen blahblah
//
//*************************************************************************
RETCODE EXPORT PCliOpen(LPSTR cmdString, U32 argc, U32 argv[]) {
   RETCODE err = GOOD;
   S8 perifile[PERI_MAXSTR];
   FARPROC lpProc;
   DESCRIPTOR desc;
   S16 buttonID;
   CHAR buffer[PERI_MAXSTR*2];

   perifile[0] = '\0';
   if (argc > 2)
      return ER_CLI_SYNTAX;
   if (argc == 1) {
      // no params open the default
      // first we have to flush out the previous objects
      PeriServer->FlushServer();
      if ((err = ProcInsertSpecificProcessor("per%s.cfg", perifile)) != GOOD) //!!186
	 return err;
      if ((err = PeriServer->InitDictionaries((LPSTR)perifile,
	    (LPSTR) buffer,
	    FALSE)) != GOOD)
	 return err;
      strcpy(perifile,"Warning!! Default processor used.");

   }
   else {
      // a processor has been specified, do we support it?
      strcpy(perifile,&cmdString[argv[argc-1]]);
      if (stricmp(perifile,"MC68330") == GOOD)
	 strcpy(perifile,"peri330.cfg");
      else if (stricmp(perifile,"MC68331") == GOOD)
	 strcpy(perifile,"peri331.cfg");
      else if (stricmp(perifile,"MC68332") == GOOD)
	 strcpy(perifile,"peri332.cfg");
      else if (stricmp(perifile,"MC68F333") == GOOD)
	 strcpy(perifile,"perif333.cfg");
      else if (stricmp(perifile,"MC68334") == GOOD)
	 strcpy(perifile,"peri334.cfg");
      else if (stricmp(perifile,"MC68340") == GOOD)
	 strcpy(perifile,"peri340.cfg");
      else if (stricmp(perifile,"MC68360") == GOOD)
	 strcpy(perifile,"peri360.cfg");
      else if (stricmp(perifile,"MC68HC16Z1") == GOOD)
	 strcpy(perifile,"peri16z1.cfg");
      else if (stricmp(perifile,"MC68HC16Z2") == GOOD)
	 strcpy(perifile,"peri16z2.cfg");
      else if (stricmp(perifile,"MC68HC16Y1") == GOOD)
	 strcpy(perifile,"peri16y1.cfg");
      else
	 return(ER_PP_CFG_FILE_NOT_FOUND);
      PeriServer->FlushServer();
      // create the database but ignore the processor type
      if ((err = PeriServer->InitDictionaries((LPSTR)perifile, buffer,
	    TRUE)) != GOOD)
	 return err;
      strcpy(perifile,"Warning!! Specified processor may not match target processor.");
   }
   if ((err = SendCliResults((LPSTR)perifile,cliServerHandle)) != GOOD)
      return err;

   return err;
}


//************************************************************************
//   PCliRegister
//
//   Description:
//      Display a formatted register(s) to the shell.
//
//   Parameters:
//      cmdString (in): the shell command string
//      argc (in): number of arguments
//      argv[] (in): array of pointers to arguments
//************************************************************************
RETCODE EXPORT PCliRegister(LPSTR cmdString, U32 argc, U32 argv[]) {
   RETCODE err = GOOD;

   return err;

}


//************************************************************************
//   PCliPregWatch
//
//   Description:
//      Display registers in the watch list to the shell or add a
//      specified register to the list and display the registers.
//
//   Parameters:
//      cmdString (in): the shell command string
//      argc (in): number of arguments
//      argv[] (in): array of pointers to arguments
//************************************************************************
RETCODE EXPORT PCliRegWatch(LPSTR cmdString, U32 argc, U32 argv[]) {
   RETCODE err = GOOD;

   return err;

}


//*********************************************************************
//   PCliPregDelete
//
//   Description:
//      Delete all registers or the indicated register from the watch list.
//
//   Parameters:
//      cmdString (in): the shell command string
//      argc (in): number of arguments
//      argv[] (in): array of pointers to arguments
//**********************************************************************
RETCODE EXPORT PCliRegDelete(LPSTR cmdString, U32 argc, U32 argv[]) {
   RETCODE err = GOOD;

   return err;

}

/***************************************************************************
**
**   SendCliResults :
**
**************************************************************************/
RETCODE PRIVATE SendCliResults(LPSTR results, HANDLE server) {
   CSERVER_RESULTS FAR * msgBufPtr;
   DESCRIPTOR msgBufHandle;
   U16 msgTextSize;

   msgTextSize = lstrlen(results);
   if ((msgBufHandle = GlobalAlloc(PERI_WFLAGS,(sizeof(CSERVER_RESULTS) +
	 msgTextSize + 2))) == NULL)
      return(ER_OUT_OF_MEMORY);
   if((msgBufPtr=(CSERVER_RESULTS *)GlobalLock(msgBufHandle)) == NULL)
      return(ER_WINDOWS_MEMLOCK);
   msgBufPtr->target = 0;
   msgBufPtr->variantCode = 0x401;
   msgBufPtr->resultTextLength = msgTextSize;
   lstrcpy(msgBufPtr->messageText,results);
   SendMessage(server, 0x401, msgBufHandle, 0x401L);
   return(GOOD);
}

/***************************************************************************
**
**  PeriDebug
**
**  Status:  NEW
**
**  description:
**     _peridebug [on|off] to display (no parameters) or set the
**     peripheral presenter debug mode on or off.
**
**  input:
**     cmdString:  input text
**     argc:  argument count
**     argv:  offsets into cmdString where arguments start
**
**  output:
**     none
**
*****************************************************************************/
RETCODE EXPORT  PeriDebug(LPSTR cmdString, U32 argc, U32 argv[]) {
   HANDLE hMsgText;
   LPSTR lpMsgText;
   RETCODE err = GOOD;

   if (argc > 2)
      return (ER_ERCODE_NOT_FOUND);
   if ((hMsgText = GlobalAlloc(GHND, E_ERRSIZE)) == NULL)
      return (ER_OUT_OF_MEMORY);
   if ((lpMsgText = (LPSTR)GlobalLock(hMsgText)) == NULL) {
      GlobalFree(hMsgText);
      return (ER_WINDOWS_MEMLOCK);
   }
   if (argc == 1) { /* just print out the current state */
      if (PeriServer->GetDebug()) {
	 lstrcpy(lpMsgText, (LPSTR)"Peripheral Presenter debug mode is ON.");
      }
      else {
	 lstrcpy(lpMsgText, (LPSTR)"Peripheral Presenter debug mode is OFF.");
      }
   }
   else {
      if(strncmpi(&cmdString[(int)argv[1]], "on",
	    strlen(&cmdString[(int)argv[1]]))==0) {
	 PeriServer->SetDebug(TRUE);
	 lstrcpy(lpMsgText, (LPSTR)"Peripheral Presenter debug mode turned ON.");
      }
      else {
	 PeriServer->SetDebug(FALSE);
	 lstrcpy(lpMsgText, (LPSTR)"Peripheral Presenter debug mode turned OFF.");
      }
   }
   if ((err = SendCliResults((LPSTR)lpMsgText,cliServerHandle)) != GOOD)
      return err;
   GlobalUnlock(hMsgText);
   GlobalFree(hMsgText);
   return (GOOD);
}

//************************** E O F ****************************************/
