/****************************************************************************
**
**  Name:  testfunc.cpp
**
**  Description:
**     Source file for test functions used by forEach, firstThat,
**     lastThat which are the internal iterators of objects.
**
**  $Log:   S:/tbird/mt2_amd/peri/testfunc.cpv  $
** 
**    Rev 1.1   09 Apr 1998 18:16:58   Eric
** 
**    Rev 1.0   16 Dec 1996 16:20:04   Judy
** Initial revision.
** 
**    Rev 1.0   11 Oct 1996 18:47:22   Judy
** Initial revision.
** 
**    Rev 1.4   03 Nov 1993 13:47:04   ron
** ready for first build of 2.1
** 
**    Rev 1.3   04 Oct 1993 16:40:28   marilyn
** Additional matching functions.
** 
**    Rev 1.2   23 Sep 1993 11:01:20   marilyn
** Additional test functions added.
** 
**    Rev 1.1   23 Aug 1993 12:16:52   marilyn
** Added some functions for presenter.
** 
**    Rev 1.0   28 Jun 1993 15:05:26   marilyn
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/peri/testfunc.cpv   1.1   09 Apr 1998 18:16:58   Eric  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#define STRICT
#define WIN31

#ifndef _TESTFUNC_
#include "testfunc.h"
#endif

#ifndef _PERISERV_
#include "periserv.h"
#endif

#ifndef _PERIPRES_
#include "peripres.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

// BORLANDC includes
#ifndef __ASSOC_H
#include "assoc.h"
#endif


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

extern PTPeriServer PeriServer;   // Peripheral server object ptr

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/


int MatchesTGroupId(const Object& thisObject,VOID *thisId) {

   if (*((U32 *)thisId) == ((TGroup&)thisObject).GetId())
      return(TRUE);
   else
      return(FALSE);

}

int MatchesTGroupRange(const Object& thisObject,VOID *searchAddr) {
   DESCRIPTOR rangeDesc = NULL;
   BOOLEAN inRange = FALSE;

   ((TGroup&)thisObject).GetRange(&rangeDesc);
   AdrIsAddrInRange((DESCRIPTOR)searchAddr,rangeDesc,&inRange);
   if (inRange)
      return(TRUE);
   else
      return(FALSE);

}

int TGroupRangeGTAddr(const Object& thisObject,VOID *searchAddr) {
   DESCRIPTOR rangeDesc = NULL;
   ADDR_COMPARE result;

   ((TGroup&)thisObject).GetRange(&rangeDesc);
   AdrCompareAddresses((DESCRIPTOR)searchAddr,rangeDesc,&result);
   AdrDestroyAddress(rangeDesc);
   if (result == SECOND_ADDR_GREATER)
      return(TRUE);
   else
      return(FALSE);

}

int MatchesTGroupName(const Object& thisObject,VOID *groupName) {

   if (strcmpi((LPSTR)groupName,((TGroup&)thisObject).GetName()) == 0)
      return (TRUE);
   else
      return (FALSE);
}

int MatchesOrLTTRegIdByAddr(const Object& thisObject,VOID *searchAddr) {
   PTRegId regPtr;
   DESCRIPTOR regAddrDesc = NULL;
   ADDR_COMPARE result;

   regPtr = (TRegId *)&((TRegId&)thisObject);
   PeriServer->GetRegisterAddress(regPtr,&regAddrDesc);
   AdrCompareAddresses(regAddrDesc,(DESCRIPTOR)searchAddr,&result);
   AdrDestroyAddress(regAddrDesc);
   if ((result == EQUAL_ADDRS) || (result == FIRST_ADDR_GREATER))
      return (TRUE);
   else
      return (FALSE);

}

int MatchesTLineKey(const Object& thisObject,VOID *lineObject) {
   PTLine lines = (PTLine)lineObject;

   if (*lines == (TLine&)((Association&)thisObject).key())
      return(TRUE);
   else
      return(FALSE);

}

int MatchesTLineRange(const Object& thisObject,VOID *line) {
   U32 *thisLine = (U32 *)line;

   Association& assocOb = (Association&)thisObject;
   TLine& lineOb = (TLine&)(assocOb.key());
   if (lineOb.InRange(*thisLine))
      return (TRUE);
   else
      return(FALSE);

}

int MatchesTDisplayGroupId(const Object& thisObject,VOID *groupId) {
   U32 *thisGroupId = (U32 *)groupId;

   Association& assocOb = (Association&)thisObject;
   TDisplay& lineOb = (TDisplay&)(assocOb.value());
   if (lineOb.GetGroupId() == *thisGroupId)
      return (TRUE);
   else
      return(FALSE);

}

int MatchesTDisplayRegId(const Object& thisObject,VOID *regId) {

   Association& assocOb = (Association&)thisObject;
   TDisplay& lineOb = (TDisplay&)(assocOb.value());
   if (lineOb.GetRegId() == (TRegId *)regId)
      return (TRUE);
   else
      return(FALSE);

}


VOID ResetTGroupBase(Object& thisObject,VOID *base) {

   ((TGroup&)thisObject).ResetBase(*(U32 *)base);
}

VOID SetTRegisterView(Object& thisObject,VOID *view) {
   PTRegister reg;
   PTValue regPtr;

   regPtr = (TValue *)&((TValue&)((Association&)thisObject).value());
   reg = (TRegister *)(regPtr->GetValue());
   reg->SetViewMode(*((TRegister::VIEWMODE *)view));
}

VOID FreeTRegister(Object& thisObject,VOID *) {
   TRegister *reg;
   PTValue regPtr;

   regPtr = (TValue *)&((TValue&)((Association&)thisObject).value());
   reg = (TRegister *)(regPtr->GetValue());
   delete (reg);
}


VOID SetTRegisterDirty(Object& thisObject,VOID *) {
   PTRegister reg;
   PTValue regPtr;

   regPtr = (TValue *)&((TValue&)((Association&)thisObject).value());
   reg = (TRegister *)(regPtr->GetValue());
   reg->SetDirty();
}


//****************************** E O F ***********************************
