/****************************************************************************
**
**  Name:  sds2abi.c
**
**  Description:
**     Contains the main entry/exit point of the SERVERS.DLL
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/sds/sds2abi.c_v  $
** 
**    Rev 1.2   22 May 1998 17:24:56   Eric
** Modify Block size to 256 bytes.
** 
**    Rev 1.1   24 Apr 1998 08:41:14   Eric
** Added CPU Timer control function.
** 
**    Rev 1.0   20 Mar 1998 10:01:14   Eric
** Initial revision.
** 
**    Rev 1.2   11 Nov 1997 11:55:10   Liu
** 
**    Rev 1.1   17 Oct 1997 12:23:46   Liu
** 
**    Rev 1.6   26 Jun 1997 16:20:00   cjchen
** add AMD186 model by cjchen
** 
**    Rev 1.5   28 Jan 1997 15:33:22   Judy
** fixed a bug of mem compare 
** 
**    Rev 1.4   22 Jan 1997 16:10:34   Judy
** 
**    Rev 1.3   13 Jan 1997 10:51:56   Judy
** fixed a verify error report message
** 
**    Rev 1.2   20 Dec 1996 18:09:08   Judy
** 
**    Rev 1.1   16 Dec 1996 18:00:54   Judy
** To fix memory write error.
** To fix breakpoint setting error. 
** 
**    Rev 1.0   16 Dec 1996 13:46:10   Judy
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_amd/sds/sds2abi.c_v   1.2   22 May 1998 17:24:56   Eric  $
**
*****************************************************************************/

            /****************************
			*                          *
			*       INCLUDE FILES      *
			*                          *
			****************************/

/* !!! Windows */
#define _WINDOWS_

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _PROC_
#include "proc.h"
#endif

#ifndef _PVTASK_
#include "pvtask.h"
#endif

#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

#ifndef _SDPROC_
#include "sdproc.h"
#endif

#ifndef _SSHARED_
#include "sshared.h"
#endif

#ifndef _MAP_
#include "map.h"
#endif

#ifndef _SHAREDAT_
#include "sharedat.h"
#endif

#ifndef _WSCOM_
#include "wscom.h"
#endif

#ifndef __TIME_H
#include "time.h"
#endif

#ifndef _VERSIONS_
#include "versions.h"
#endif

#ifndef  _SDS2ABI_
#include "sds2abi.h"
#endif

#define loword(x)  ((U16)((x)&0xffff))
#define hiword(x)  ((U16)(((x)>>16)&0xffff))
U32 SwapDwordOrder(U32 input);
U16 SwapWordOrder(U16 input);

S16 status;

typedef enum {
   BKPT_UNLOADED, BKPT_XBRK, BKPT_SWB, BKPT_STATUS_END=0x7fff
} BKPT_STATUS;

typedef struct BKPT_ENTRY_TAG {
   struct BKPT_ENTRY_TAG *next;
   struct BKPT_ENTRY_TAG *prev;
   U16 id;
   U16 opcode;
   U32 addr;
   ADDR_SPACE space;
   BKPT_STATUS status;
} BKPT_ENTRY;

BAD_MEMORY  badAddr1;
U16   MPBreakCause;

U8 regMapTable186[] =
   {
   R_IP, R_SP, R_BP,
   R_AX, R_BX, R_CX, R_DX, R_SI, R_DI, R_FS,
   R_CS, R_DS, R_ES, 0, 0, R_SS
   }; 


/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
		       /****************************
			*                          *
			*     LOCAL DEFINITIONS    *
			*                          *
			****************************/

/* Handle of the DLL instance */
HANDLE hLib;

			/****************************
			 *                          *
			 *    EXTERNAL VARIABLES    *
			 *                          *
			 ****************************/

			/****************************
			 *                          *
			 *     LOCAL PROTOTYPES     *
			 *                          *
			 ****************************/

			/****************************
			 *                          *
			 *      EXECUTABLE CODE     *
			 *                          *
			 ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the SERVERS.DLL
**
**      Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma warn -par
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);
    ErrInitDLL(MODULE_SHARED_DATA,"sds2abi.dll");
    /* initialize successfully */
    hLib = hInstance;
    return(TRUE);
}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**      Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
void FAR PASCAL WEP(int nParam) {

   switch(nParam) {
      case WEP_SYSTEMEXIT:
	 /* System shutdown in progress. Respond accordingly */
	 break;
      case WEP_FREE_DLL:
	 /* The DLL use count is 0 */
	 break;
      default:
	 /* Undefined value - ignore */
	 break;
   }
   return(TRUE);
}
#endif

/*****************************************************************************
**
** (Probe) Interface Functions To MICEPack ABI
**
*****************************************************************************/
RETCODE EXPORT  Sds2AbiLoadMicePackFw(U16 port, PROBE_TYPE probeType)
{
INITIAL_INFO initInfo;
RETCODE err, err2;
PROBE_TYPE tmpProbeType;
BOOLEAN mtatExist;
			
	initInfo.portAddr       = port;      // I/O port address.
	initInfo.buffSize       = 0x400;     // buffer size of communication
	initInfo.testResult     = 0;         // clear data.
	initInfo.testFlag       = ON;        // do selftest.
	initInfo.timeOut        = 0xff;      // 3 second.
        if (port > 0 && port <5)
           strcpy(initInfo.fileName,"main16e.bin");
        else
           strcpy(initInfo.fileName,"main186a.bin");
	err = iceInitialize(&initInfo) ;
        if (err == GOOD) { /* Cold Start */ 
	  err = SetID(probeType);
//      err = GetID(&tmpProbeType, &mtatExist);
        }
        //Eric 4/9/98
        if (err == ICE_LINK_MICE_FAIL) return(err);
        if ((err2 = GetID(&tmpProbeType, &mtatExist)) != GOOD) return(err2); 
        if (tmpProbeType != probeType)
          return(iceMapError(ICE_INVALID_CPU));
        else
          return ( iceMapError(err) );
        //Eof Eric 4/9/98
        //return ( iceMapError(err) );//remove by Eric 4/9/98
}
/*****************************************************************************
**
** Sds2AbiFwPingProbe
**
** description:
**    Send a command (essentially NOP) to probe to see if it's alive
**
** parameters:
**    none
*****************************************************************************/
RETCODE EXPORT Sds2AbiFwPingProbe(VOID) {
   return(GOOD);
}

////////////////////////////////////////////////////////////////////////////
// Sds2AbiFwGetMapBlocks
//
// description:
//    get the maximum number of blocks user can set in Map command
//
// Parameters:
//    Input:   <none>
//    Output:  <block> map blocks.
////////////////////////////////////////////////////////////////////////////
RETCODE EXPORT Sds2AbiFwGetMapBlocks(U32 *block)
{
   *block = (U32)16;
   return(GOOD);
}

////////////////////////////////////////////////////////////////////////////
// Sds2AbiFwGetMapSize
//
// description:
//    get the size of each map blocks
//
// Parameters:
//    Input:   <none>
//    Output:  <size> block size
////////////////////////////////////////////////////////////////////////////
RETCODE GetMapSize(U32 *size)
{
U8 temp;

   iceGetMapSize(&temp);
   switch (temp)
      {
      case 0:
	 *size = (U32)0;
	 break;
      case 1:
	 *size = (U32)0x80000L;
	 break;
      case 2:
	 *size = (U32)0x100000L;
	 break;
      case 3:
	 *size = (U32)0x200000L;
	 break;
      case 4:
	 *size = (U32)0x400000L;
	 break;
      case 5:
	 *size = (U32)0x800000L;
	 break;
      }

   (*size) >>= 2;    // total memory divide by number of banks
   return(GOOD);
}

RETCODE EXPORT Sds2AbiFwGetMapSize(U32 *size)
{
RETCODE  err;

   err = GetMapSize(size);
   return(err);
}

////////////////////////////////////////////////////////////////////////////
// Sds2AbiFwGetMapGranularity
//
// description:
//    get the minimum granularity of a map block
//
// Parameters:
//    Input:   <none>
//    Output:  <gran> granularity.
////////////////////////////////////////////////////////////////////////////
RETCODE EXPORT Sds2AbiFwGetMapGranularity(U32 *gran)
{
   //*gran = (U32)0x800L;
   *gran = (U32)0x100L;//Eric modify for Am186 5/22/98
   return(GOOD);
}

/*****************************************************************************
**
** Sds2AbiFwLoadRegisters
**
** description:
**    Read register contents from shared data and write into chip.
**
** parameters:
**    none
*****************************************************************************/
RETCODE EXPORT Sds2AbiFwLoadRegisters(VOID)
{
RETCODE err;
LOOP_VAR i;
U32 reg;

   for (i=0; i<MAX_CPU_REG186_NUM; i++)  // ABI hold CCR, discard this
      {
      if (i == 0xd || i == 0xe) continue;   /* Not use in 186 */
      if ((err = SdnReadMember(SDN_EIP+i, (U8*)&reg)) != GOOD) return(err);
      if ((err = SetReg(regMapTable186[i], reg)) != GOOD) return(err);
      }
   return(GOOD);
}
/*****************************************************************************
**
** Sds2AbiFwUnloadRegisters
**
** description:
**    Extract register contents from chip and write to shared data members
**
** parameters:
**    none
*****************************************************************************/
RETCODE EXPORT Sds2AbiFwUnloadRegisters(BOOLEAN patchPCSP) {
RETCODE err;
LOOP_VAR i;
U32 reg;
U16 cpuReg[16];

   err = iceGetAllReg(&cpuReg);
   if ( (err=iceMapError(err)) != GOOD) return (err);
   for (i=0; i<MAX_CPU_REG186_NUM; i++) {
     if (i == 0xd || i == 0xe) continue;
     reg = cpuReg[regMapTable186[i]];
     SdnWriteMemberNoCallback(SDN_EIP+i,(U8*)&reg,GOOD);
     reg *= 16;
     if (i == 0xa) SdnWriteMemberNoCallback(SDN_CSBASE,(U8*)&reg,GOOD);
     if (i == 0xb) SdnWriteMemberNoCallback(SDN_DSBASE,(U8*)&reg,GOOD);
     if (i == 0xc) SdnWriteMemberNoCallback(SDN_ESBASE,(U8*)&reg,GOOD);
     if (i == 0xf) SdnWriteMemberNoCallback(SDN_SSBASE,(U8*)&reg,GOOD);
   }
   return(GOOD);
}

/*****************************************************************************
**
** Sds2AbiFwPowerOn
**
** description:
**    Called when probe sends power-on byte.  This function sends either
**    a RESET command or GR command packet, depending on SD_EMULATION_STATE.
**
** parameters:
**    none
*****************************************************************************/
RETCODE EXPORT Sds2AbiFwPowerOn(VOID) {
   RETCODE err;
   EMULATION_STATE iceState;
   if ((err = SdnReadMember(SDN_EMULATION_STATE,(U8*)&iceState)) != GOOD)
      return(err);
   if (iceState == EM_HALTED) return(Sds2AbiFwReset(RESET_CPU_AND_UPDATE_STATUS));
   else return(Sds2AbiFwGr(&iceState));
}

/**************************************************************************
**
** Sds2AbiFwFillMem
**
**************************************************************************/
RETCODE EXPORT Sds2AbiFwFillMem(U32 offset, ADDR_SPACE space, U32 length,
       U32 pLength, ACCESS_SIZE access, BOOLEAN verify,
       VERIFY_INFO *verifyInfo, U8 *data) {
   RETCODE err,err2;
   EMULATION_STATE runaccState;
   U32 regSave[2];


   if ((err = Sds2AbiRunaccStart(&runaccState,regSave)) != GOOD) return(err);
   err = Sds2AbiFillMemAction(offset,space,length,pLength,access,verify,verifyInfo,
      data);
   err2 = Sds2AbiRunaccFinish(runaccState,regSave);
   return(err?err:err2);
}

RETCODE EXPORT Sds2AbiFillMemAction(U32 offset, ADDR_SPACE space, U32 length,
       U32 pLength, ACCESS_SIZE access, BOOLEAN verify,
       VERIFY_INFO *verifyInfo, U8 *data) {
   BAD_MEMORY badMem;
   U32 tmpOffset;
   RETCODE err;
   U8 cmd[ABI_MAX_FILL];
   U8 temp[4];
   U16 pktLength,i;
   BOOLEAN  abortFromEsc;
   RETCODE  status;
   U32 misalignAmount, misalignLength, patOffset;
   /*
   ** Phase 1: If request is not aligned, read entire item, change bytes,
   **   then write entire item.
   */
   //err = Sds2AbiSetAccessSize(access);
   //if (err != GOOD) return(err);

   if (length == pLength) {
      err = iceSetMemN(offset, data, length);
      goto VERIFY;
   }

   misalignAmount = offset & ((U32)access-1);
   misalignLength = min(length, access-misalignAmount);
   patOffset = 0;
   if (misalignAmount > 0) {
      if ((err = Sds2AbiReadMemAction(offset-misalignAmount,space,access,access,temp))
	 != GOOD) goto VERIFY;
      for ( ; patOffset<misalignLength; patOffset++)
	temp[(U16)(patOffset+misalignAmount)] = data[(U16)(patOffset%pLength)];
      pktLength = (U16)access;
      offset -= misalignAmount;
      if ((err = iceFill(offset, pktLength, temp, pktLength)) != GOOD)
	 {
//	 err = iceMapError(err);
	 goto VERIFY;
	 }
      length -= misalignLength;
      offset += misalignLength;
   }
   if (length == 0) goto VERIFY;
   /*
   ** Phase 2: Write bulk of range, up to last item boundary
   */
   misalignAmount = length & ((U32)access-1);  /* bytes after last boundary */
   misalignLength = length - misalignAmount;
   for ( ; misalignLength>0;
	 length-=pktLength, misalignLength-=pktLength, offset+=pktLength) {
      U16 index;
      U32 fillLength = pktLength = (U16)min(ABI_MAX_FILL, misalignLength);

      for (index=0; fillLength>0;fillLength--,patOffset++) {
	 cmd[index++] = data[(U16)(patOffset%pLength)];
      }
      if ((err = iceFill(offset, pktLength, cmd, pktLength)) != GOOD)
	 {
//	 err = iceMapError(err);
	 goto VERIFY;
	 }

      if (misalignLength-pktLength > 0) {
	 err = TskCheckAbort(&abortFromEsc);
	 if(err!=GOOD) return err;
	 if (abortFromEsc!=0)
	    return(ER_FILL_ABORT);
      }

   }
   if (length == 0) goto VERIFY;
   /*
   ** Phase 3: Write final item by reading entire item, changing bytes in
   **   range, then writing entire item.
   */
   if ((err = Sds2AbiReadMemAction(offset,space,access,access,temp)) != GOOD)
      goto VERIFY;
   for (i=0; i<length; i++,patOffset++)
      temp[i] = data[(U16)(patOffset%pLength)];
   err = iceFill(offset, length, temp, length);

   /*
   ** Memory Verify.  Verify is done in the probe, but if a verify error
   ** occurs, we need to get the offset, exptected, and actual info.
   */
VERIFY:
   if (err != ICE_OK) {
      iceGetVerifyErrorInfo(&badMem);
      tmpOffset = badMem.offset;
      SdnWriteMember(SDN_VERIFY_OFFSET,&tmpOffset, GOOD);
//      tmpOffset = badMem.actual;
//      SdnWriteMember(SDN_VERIFY_ACTUAL,&tmpOffset, GOOD);
//      i = (badMem.offset - offset)%pLength;
//      tmpOffset = temp[i];
//      SdnWriteMember(SDN_VERIFY_EXPECTED,&tmpOffset, GOOD);
   }

   return(iceMapError(err));
}

/**************************************************************************
**
** Sds2AbiFwReadMem
**
**************************************************************************/
RETCODE EXPORT Sds2AbiFwReadMem(U32 offset, ADDR_SPACE space, U32 length,
			  ACCESS_SIZE access, U8 *data) {
   RETCODE err,err2;
   EMULATION_STATE runaccState;
   U32 regSave[2];

   if ((err = Sds2AbiRunaccStart(&runaccState,regSave)) != GOOD) return(err);
   err = Sds2AbiReadMemAction(offset,space,length,access,data);
   err2 = Sds2AbiRunaccFinish(runaccState,regSave);
   return(err?err:err2);
}

RETCODE  EXPORT Sds2AbiReadMemAction(U32 offset, ADDR_SPACE space, U32 length,
			  ACCESS_SIZE access, U8 *data) {
   RETCODE err;
   RETCODE status;
   U8 temp[4];
   U16 pktLength;
   U32 misalignAmount, misalignLength;

   //err = Sds2AbiSetAccessSize(access);
   //if (err != GOOD) return(err);

   /*
   ** Phase 1:  If start address is not aligned to boundary, read item
   **   at next lower boundary and extract bytes in requested range.
   */
   misalignAmount = offset & ((U32)access-1);
   misalignLength = min(length, access - misalignAmount);
   if (misalignAmount > 0)
      {
      pktLength = (U16)access;
      offset -= misalignAmount;
      if ((err = iceGetMemN(offset, temp, pktLength)) != GOOD)
          return(iceMapError(err));
      memcpy(data,temp+(U16)misalignAmount,(U16)misalignLength);
      data += (U16)misalignLength;
      offset += misalignLength;
      length -= misalignLength;
      }
   if (length == 0) return(GOOD);
   /*
   ** Phase 2: Read bulk of request, up to the last boundary in the range
   */
   misalignAmount = length & ((U32)access-1);  /* bytes after last boundary */
   misalignLength = length - misalignAmount;
   for ( ; misalignLength>0; length-=pktLength,
	  misalignLength-=pktLength, data+=pktLength, offset+=pktLength) {
      pktLength = (U16)min(ABI_MAX_READ, misalignLength);
      if ((err = iceGetMemN(offset, data, pktLength)) != GOOD)
	 return(iceMapError(err));
   }
   if (length == 0) return(GOOD);
   /*
   **  Phase 3: Finally, read item covering the last few bytes if the end
   **    address is not aligned.
   */
   pktLength = (U16)access;
   if ((err = iceGetMemN(offset, temp, pktLength)) != GOOD)
      return(iceMapError(err));
   memcpy(data,temp,(U16)length);

   return(GOOD);
}

RETCODE EXPORT SetReg(S16 regId, U32 regValue)
{
   status = iceSetReg(I86_REG, regId, regValue);
   return(iceMapError(status));
}

RETCODE EXPORT iceMapError(RETCODE status)
{
S16 status2;
EMULATION_STATE iceState;
BREAK_CAUSE cause;
RETCODE  err;
   status2 = (S16) status;
   switch (status2)
      {
      case ICE_NO_DIFF:               // No difference in memory compare
      case ICE_WARN_START:
      case ICE_OK:                  return(GOOD);
      case ICE_NOT_READY:           return(ER_BUS_TIMEOUT);
      case ICE_NO_VCC:              return(ER_TARGET_VCC);
      case ICE_BUS_REQUEST:         return(ER_BUS_TIMEOUT);
      case ICE_STEP_ERROR:          return(ER_STEP_TIMEOUT);
      case ICE_MICE_HALT:           return(ER_WAIT_EMOFF_TIMEOUT);
      case ICE_TARGET_RESET:        return(ER_RESET_UNIT_FAILED);
      case ICE_BANK_FULL:           return(ER_NO_FREE_MAP_BLOCKS);
      case ICE_ATTRIBUTE_MISMATCH:  return(ER_MAP_UNKNOWN_TYPE);
      case ICE_REC_TIME_OUT:        return(ER_COMM_PACKET_TIMEOUT);
      case ICE_HALT_USER:             // user pressed ^C
	 return(ER_USER_ABORT);
      case ICE_ERROR_WRITE:           // Memory write failure
	 return(ER_MEMORY_VERIFY);
      case ICE_BUFFER_EMPTY:          //
      case ICE_ERR_MN_CONFIG:         // Eric 2/4/98 for Bug ID#199
     return(ER_DQ_NO_FRAMES_AVAILABLE);
      case ICE_EVENT_FULL:            //
	 return(ER_TOO_MANY_EVENTS);  // need to redefined another error message
      case ICE_FILE_NOT_FOUND:
	 return (ER_FILE_NOT_FOUND); //
      case ICE_MICE_LIMIT:            // MICE limitation
	 return(ER_WAIT_BDM_TIMEOUT);//!!
      case ICE_ERROR_BOUN:            // error map boundary
	 return(ER_INPUT_OVERRUN);//!!
      case ICE_MAP_FAIL:              // memory map fail
      case ICE_EMM_SET_ERROR:         //
      case ICE_ADDR_RANGE_OVERFLOW: // return(ER_BLOCK_TOO_LARGE);
	 return(ER_INSUF_MAP_BLOCKS);     // error map
      case ICE_NO_FOUND:              // Not found in memory search
     return(ER_SEARCH_NOT_FOUND);
      case ICE_MEM_GUARD:             // Access the guarded memory
         cause=CAUSE_OVERLAY_ACCESS;
         SdnWriteMember(SDN_BREAK_CAUSE,(U8*)&cause,GOOD);
         iceState = EM_HALTED;
         err = SdnWriteMember(SDN_EMULATION_STATE,(U8*)&iceState,GOOD);
         SdnWriteMember(SDN_EMULATION_RESULT,(U8*)&err,GOOD);
	 return(status2);
      case ICE_MEM_PROTECT:           // Access the protected memory
         cause=CAUSE_DR_ACCESS;
         SdnWriteMember(SDN_BREAK_CAUSE,(U8*)&cause,GOOD);
         iceState = EM_HALTED;
         err = SdnWriteMember(SDN_EMULATION_STATE,(U8*)&iceState,GOOD);
         SdnWriteMember(SDN_EMULATION_RESULT,(U8*)&err,GOOD);
         return(status2);
      case ICE_INVALID_CPU:           // only usd at sw.
         return(ER_CPU_CANT_BE_ODD);
      case ICE_LINK_MICE_FAIL:        //
         return(ER_ABORT_SESSION);
      case ICE_NO_TRACE_MODULE:       //
      case ICE_ERROR_READ:            // Memory read failure
      case ICE_BREAK:                 // Break on memory access
      case ICE_BREAK_I:               // Break on instruction fetch
      case ICE_BAD_REG:               // Bad register number encountered
      case ICE_BAD_IN:                // Error encountered on user input
      case ICE_ERROR_COM:             // communication error
      case ICE_ERROR_MICE:            // linking incorrect MICE model
      case ICE_BAD_FRAME:             // invalid frame number
      case ICE_ABS_OVERFLOW:          // abs address overflow
      case ICE_TEST_FAIL:             // test failure
      case ICE_CPU_RUN:               // CPU free running
      case ICE_BROKE:                 // CPU stop
      case ICE_COMMAND_ERROR:         //
      case ICE_TIME_OUT:              //
      case ICE_BKPT_HALT:             //
      //case ICE_BKPT1_HALT:            //
      //case ICE_BKPT2_HALT:            //
      case ICE_VIOL_HALT:             //
      case ICE_RBW_HALT:              //
      case ICE_TRIG_HALT:             //
      case ICE_BANK_MISMATCH:         //
      case ICE_SPACE_MISMATCH:        //
      case ICE_ADDR_MISMATCH:         //
      case ICE_USER_CC:               //
      case ICE_NO_EMM:                //
      case ICE_CNT_ERROR:             //
      case ICE_TIMER_ERROR:           //
      case ICE_EP_PENDING:            //
      case ICE_MCE16A_FAIL:
      case ICE_EMM_FAIL:
      case ICE_TRACE_BOARD_FAIL:
      case ICE_COV_RBW_FAIL:
      case ICE_CPU_FLY:
      case ICE_INVALID_FLY_COMMAND:
      case ICE_INVALID_FIRMWARE:      // only usd at sw.
      default:
	 return(ER_INTERNAL);
      }
}

/****************************************************************************
**
**  Sds2AbiInitCoreMembers
**
**  Description:
**     
**     Initialize all the shared data members in sdinit.h.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT Sds2AbiInitCoreMembers(VOID) {
   RETCODE err;
//   DESCRIPTOR desc;
   TBIRD_STATUS tbirdStatus;
   BOOLEAN slotPresent;
   U8 sdData;
   PROBE_TYPE probeType;
   /*
   ** initialize configuration information
   */
   /*
   ** initialize motherboard configuration
   */
   slotPresent = TRUE;
   if((err = SdnWriteMember(SDN_MOM_PRESENT, &slotPresent, GOOD))!=GOOD)
      return(err);
   sdData = (U8)(1);
   if((err = SdnWriteMember(SDN_MOM_MAJOR_VERSION, &sdData, GOOD))!=GOOD)
      return(err);
   sdData = (U8)(0);
   if((err = SdnWriteMember(SDN_MOM_MINOR_VERSION,&sdData, GOOD))!=GOOD)
      return(err);
   sdData = (U8)(1);
   if((err = SdnWriteMember(SDN_MOM_COMPATIBILITY, &sdData, GOOD))!=GOOD)
      return(err);

   /*
   ** initialize SWAT present/version
   */
   slotPresent = FALSE;
   if((err = SdnWriteMember(SDN_SWAT_PRESENT, &slotPresent, GOOD))!=GOOD)
      return(err);
   if (slotPresent) {
      sdData = (U8)(1);
      if((err = SdnWriteMember(SDN_SWAT_MAJOR_VERSION, &sdData, GOOD))!=GOOD)
	 return(err);
      sdData = (U8)(0);
      if((err = SdnWriteMember(SDN_SWAT_MINOR_VERSION, &sdData, GOOD))!=GOOD)
	 return(err);
      sdData = (U8)(1);
      if((err = SdnWriteMember(SDN_SWAT_COMPATIBILITY, &sdData, GOOD))!=GOOD)
	 return(err);
   }

   /*
   ** initialize TMOD R present/version
   */
   slotPresent = TRUE;
   if((err =SdnWriteMember(SDN_TRACE_0_SLOT_PRESENT,&slotPresent,GOOD))!=GOOD)
      return(err);
   if (slotPresent) {
      sdData = (U8)(1);
      if((err = SdnWriteMember(SDN_TRACE_0_MAJOR_VERSION,&sdData,GOOD))!=GOOD)
	 return(err);
      sdData = (U8)(0);
      if((err = SdnWriteMember(SDN_TRACE_0_MINOR_VERSION,&sdData,GOOD))!=GOOD)
	 return(err);
      sdData = (U8)(1);
      if((err = SdnWriteMember(SDN_TRACE_0_COMPATIBILITY,&sdData,GOOD))!=GOOD)
	 return(err);
   }

   /*
   ** initialize TMOD S present/version
   */
   slotPresent = TRUE;
   if((err =SdnWriteMember(SDN_TRACE_1_SLOT_PRESENT,&slotPresent,GOOD))!=GOOD)
      return(err);
   if (slotPresent) {
      sdData = (U8)(1);
      if((err = SdnWriteMember(SDN_TRACE_1_MAJOR_VERSION,&sdData,GOOD))!=GOOD)
	 return(err);
      sdData = (U8)(0);
      if((err = SdnWriteMember(SDN_TRACE_1_MINOR_VERSION,&sdData,GOOD))!=GOOD)
	 return(err);
      sdData = (U8)(1);
      if((err = SdnWriteMember(SDN_TRACE_1_COMPATIBILITY,&sdData,GOOD))!=GOOD)
	 return(err);
   }

   /*
   ** initialize TMOD T present/version
   */
   slotPresent = TRUE;
   if((err =SdnWriteMember(SDN_TRACE_2_SLOT_PRESENT,&slotPresent,GOOD))!=GOOD)
      return(err);
   if (slotPresent) {
      sdData = (U8)(1);
      if((err = SdnWriteMember(SDN_TRACE_2_MAJOR_VERSION,&sdData,GOOD))!=GOOD)
	 return(err);
      sdData = (U8)(0);
      if((err = SdnWriteMember(SDN_TRACE_2_MINOR_VERSION,&sdData,GOOD))!=GOOD)
	 return(err);
      sdData = (U8)(1);
      if((err = SdnWriteMember(SDN_TRACE_2_COMPATIBILITY,&sdData,GOOD))!=GOOD)
	 return(err);
   }

   /*
   ** initialize TMOD U present/version
   */
   slotPresent = FALSE;    // MICEpack 306, 302 and 186 has less than 96 channels
   if((err =SdnWriteMember(SDN_TRACE_3_SLOT_PRESENT,&slotPresent,GOOD))!=GOOD)
      return(err);
   if (slotPresent) {
      sdData = (U8)(1);
      if((err = SdnWriteMember(SDN_TRACE_3_MAJOR_VERSION,&sdData,GOOD))!=GOOD)
	 return(err);
      sdData = (U8)(0);
      if((err = SdnWriteMember(SDN_TRACE_3_MINOR_VERSION,&sdData,GOOD))!=GOOD)
	 return(err);
      sdData = (U8)(1);
      if((err = SdnWriteMember(SDN_TRACE_3_COMPATIBILITY,&sdData,GOOD))!=GOOD)
	 return(err);
   }

   /*
   ** initialize probe type and version numbers
   */
   slotPresent = TRUE;
   {
      GetID(&probeType, &slotPresent);
      if((err = SdnWriteMember(SDN_PROBE_TYPE, (U8 *)&probeType, GOOD))!=GOOD)
	    return(err);
      if((err = SdnWriteMember(SDN_TRACE_0_SLOT_PRESENT, &slotPresent, GOOD))
         !=GOOD)  return(err);
   }
   /*
   ** initialize connecting
   */
   tbirdStatus = AT_RESET;
   if((err = SdnWriteMember(SDN_TBIRD_STATUS, (U8 *)&tbirdStatus, GOOD))!=GOOD)
      return(err);
   /*
   ** initialize the number of bytes in shared data
   */
   {
      U32 numBytes = BYTES_IN_SHARED_DATA;
      if((err = SdnWriteMember(SDN_NUM_SHARED_DATA_BYTES, (U8 *)&numBytes, GOOD))
	 !=GOOD) return(err);
   }

   {
      BOOLEAN true=TRUE;
      if ((err=SdnWriteMember(SDN_FW_TRACING_STATUS,&true,GOOD)) != GOOD)
	 return(err);
      if((err=SdnWriteMember(SDN_CLK_SIG,&true,GOOD)) != GOOD) return(err);
      if((err=SdnWriteMember(SDN_RESET_SIG,&true,GOOD)) !=GOOD) return(err);
   }

   {
      U32 temp;
      BREAK_CAUSE cause=CAUSE_NONE;
      EMULATION_STATE iceState = EM_HALTED;

      if ((err = Sds2AbiFwGetMapBlocks(&temp)) != GOOD) return(err);
      if((err=SdnWriteMember(SDN_NUM_MAP_BLOCKS,(U8*)&temp,GOOD))!=GOOD)
	 return(err);
      if ((err = Sds2AbiFwGetMapSize(&temp)) != GOOD) return(err);
      if((err=SdnWriteMember(SDN_SIZE_MAP_BLOCK,(U8*)&temp,GOOD))!=GOOD)
	 return(err);
      if ((err = Sds2AbiFwGetMapGranularity(&temp)) != GOOD) return(err);
      if((err=SdnWriteMember(SDN_GRAN_MAP_BLOCK,(U8*)&temp,GOOD))!=GOOD)
	 return(err);

      if ((err = Sds2AbiFwGetBreakCause(&cause)) != GOOD) return(err);
      if ((err=SdnWriteMember(SDN_BREAK_CAUSE,(U8*)&cause,GOOD)) != GOOD)
	 return(err);
      
      if ((err = Sds2AbiFwGetEmuState(&iceState)) != GOOD) return(err);
      if((err=SdnWriteMember(SDN_EMULATION_STATE,(U8*)(&iceState),GOOD))
	 != GOOD) return(err);
   }
   return(GOOD);
}

RETCODE EXPORT Sds2AbiConvertTraceMode(TRACE_MODE traceMode, U16 *mpTraceMode)
{
   switch (traceMode)
      {
      case TRACE_PRE:
	 *mpTraceMode = 1;
	 break;
      case TRACE_POST:
	 *mpTraceMode = 0;
	 break;
      case TRACE_CENTER:
	 *mpTraceMode = 2;
	 break;
      }
   return(GOOD);
}

RETCODE EXPORT Sds2AbiSetEvent(U16 evID, BUS_EVENT *bus)
{
   /* always 0xffffffff, only used for both range & mask address */
   bus->addrRangeMask = 0xffffffffl;//add for Am186
   status = iceSetEvent(evID, bus);
   return (iceMapError(status));
}

RETCODE EXPORT Sds2AbiClearEvent(U16 evID)
{
   status = iceClearEvent(evID);
   return (iceMapError(status));
}

RETCODE EXPORT Sds2AbiSetTrig(U16 trigLevel, MP_TRIGGER *trig)
{
   status = iceSetTrig(trigLevel, trig);
   return(iceMapError(status));
}

RETCODE EXPORT Sds2AbiClearTrig(U16 trigLevel)
{
   status = iceClearTrig(trigLevel);
   return(iceMapError(status));
}

RETCODE EXPORT Sds2AbiGetTraceInfo(U16 *lastBuf,
	 U16 *cnt0, U16 *cnt1, U16 *maxBuf)
{
U16   last, maxSubBuf;

   status = iceGetTraceInfo(&last, cnt0, cnt1, &maxSubBuf);
   if (status != ICE_OK) return(iceMapError(status));
   *maxBuf = last;
   *lastBuf = last-1;
   return(GOOD);
}

RETCODE EXPORT Sds2AbiGetTraceBufferInfo(U16 buffer, S32 *beforeFrames,
	    S32 *afterFrames, S32 *trigFrame)
{
S32   start, end;
   status = iceGetTraceBufferInfo(buffer, &start, &end);
   if (status != ICE_OK) return(iceMapError(status));
   *beforeFrames = start;
   *trigFrame = 0;
   *afterFrames = end;
   return(GOOD);
}

RETCODE EXPORT Sds2AbiGetTraceBufferLogicInfo(U16 buffer, S32 *start, S32 *end)
{
   status = iceGetTraceBufferInfo(buffer, start, end);
   return (iceMapError(status));
}

BOOLEAN EXPORT Sds2AbiIsTraceBufferEmpty(U16 buffer)
{
S32   start, end;
   status = iceGetTraceBufferInfo(buffer, &start, &end);
   if (status == ICE_BUFFER_EMPTY) return(TRUE);
   else return(FALSE);
}

U32 EXPORT Sds2AbiGetTriggerFrame(U16 buffer)
{
   U32   frame;
   status = iceGetTriggerFrame(buffer, &frame);
   return(frame);
}

RETCODE EXPORT Sds2AbiGetTraceFrames(U16 buffer, U32 frameNo,
	       U32 *framesRead, TRACE_INFO *frames)
{
MP_TRACE_INFO  traceData[64];
U32   num;
U8    frameLen;
QUALIFY_LIST   qList;
S32   start;
U32 tmp;
   start = (S32)frameNo;
   frameLen = *framesRead & 0xff;
   *framesRead = 0;
   qList.qFlag=0; /* Without qualifier */
   status = iceGetTraceFrame(buffer, start, &qList, &frameLen, &traceData);
   if (status != ICE_OK) return(iceMapError(status));
   if (frameLen == (U8)0) return(GOOD);
   *framesRead = (U32)frameLen;
   for (num = 0; num < *framesRead; num++)
      {
      frames->frameNumber = start++;
      frames->rGroup = traceData[num].addr;
      frames->tGroup = traceData[num].data;
      tmp = (U32) traceData[num].tbit;
      frames->sGroup = traceData[num].stat + (tmp << 16);
      frames->tsGroup = traceData[num].tstamp;
      frames->tshGroup= traceData[num].tstampMSB;
      frames->leGroup = (traceData[num].seqLevel<<8) + traceData[num].evtMatch;
      frames++;
      }
   return(GOOD);
}

VOID EXPORT Sds2AbiIsTraceBufferFull(U16 buffer, BOOLEAN *full)
{
   *full = FALSE;
}

RETCODE EXPORT Sds2AbiSetNumTraceBuffers(U16 bufNo)
{
   status = iceSetTraceBuffer(bufNo);
   return(iceMapError(status));
}

RETCODE EXPORT Sds2AbiSetTimerCounter(U16 tc, U32 tcValue, U32 tc2Value)
{
   status = iceSetTimerCounter(tc, tcValue, tc2Value);
   return(iceMapError(status));
}

RETCODE EXPORT Sds2AbiSetMap(DESCRIPTOR desc) {
   RETCODE err;
   MEMBER_INDEX index;
   BOOLEAN enable;
   U16   protect;       // this has beend redefined by Kevin to be
			// comtible with PoerPack which has type of
			// MAP_PROTECT and use only two least
			// significant bits (enum with 4 entities)
   U32 addr, addr2, length;
   U8 target;
   U16   attrib;

   err = SdGetMemberIndex(desc,&index);
   if (err) return(err);
   if ((err = SdnReadMember(SDN_MAP_LENGTH+index,&length)) != GOOD)
      return(err);
   if ((err = SdnReadMember(SDN_MAP_ENABLE+index,&enable)) != GOOD)
      return(err);
   if ((err = SdnReadMember(SDN_MAP_PROTECT+index,&protect)) != GOOD)
      return(err);
   if ((err = SdnReadMember(SDN_MAP_ADDR+index,&addr)) != GOOD) return(err);
   target = protect & 0x0080;
   attrib = protect & 0xff00;
   protect &= 0x007f;
   addr2 = addr + (length - 1);
   if (enable)
      {
      switch (protect)
	 {
	 case 0: // RAM
	    if (target) attrib |= 3;
	    else attrib |= 1;
	    break;
	 case 1: // ROM with break
	    if (target) attrib |= 2;
	    break;
	 case 3: // None
	    attrib |= 4;
	    break;
	 default:
	    return(ER_MAP_UNKNOWN_TYPE);
	 }
      }
   else attrib |= 3;
   err = iceSetMap(addr, addr2, attrib);
   err = iceMapError(err);
   return(SdnWriteMember(SDN_MAP_RESULTS+index, &err, err));
}

RETCODE EXPORT Sds2AbiSetBreakOnFull(BOOLEAN enable)
{
   return(iceMapError(iceSetTraceBreak(enable)));
}

RETCODE EXPORT Sds2AbiSetControl(U16 control)
{
   return (iceMapError(iceSetControl(control)));
}

RETCODE  EXPORT Sds2AbiGetControl(U16 *control)
{
   return (iceMapError(iceGetControl(control)));
}

RETCODE EXPORT Sds2AbiSetTimer(U16 timer)
{
   return (iceMapError(iceSetTimer(timer)));
}

RETCODE  EXPORT Sds2AbiGetTimer(U16 *timer)
{
   return (iceMapError(iceGetTimer(timer)));
}


RETCODE EXPORT Sds2AbiSetExtEvent(U16 ext)
{
   return (iceMapError(iceSetExtEvent(ext)));
}

RETCODE EXPORT SetID(PROBE_TYPE probeType)
{
U16 idType;
   switch (probeType) {
   case I80C188XL_MP:
      idType = 1;
      break;
   case I80C188EA_MP:
      idType = 2;
      break;
   case I80C188EB_MP:
      idType = 3;
      break;
   case I80C188EC_MP:
      idType = 4;
      break;
   case I80C186XL_MP:
      idType = 5;
      break;
   case I80C186EA_MP:
      idType = 6;
      break;
   case I80C186EB_MP:
      idType = 7;
      break;
   case I80C186EC_MP:
      idType = 8;
      break;
   case A80188EM_MP:
      idType = 9;
      break;
   case A80188ES_MP:
      idType = 10;
      break;
   case A80188ER_MP:
      idType = 11;
      break;
   case A80186EM_MP:
      idType = 12;
      break;
   case A80186ES_MP:
      idType = 13;
      break;
   case A80186ER_MP:
      idType = 14;
      break;
   case A80186ED_MP:
      idType = 15;
      break;
   default:
      idType = 12;
      break;
   }
   //idType = 9;
   return ( iceSetID(idType) );
}

RETCODE  EXPORT Sds2AbiMemTest(U32 offset,U32 length,BOOLEAN *result,U32 *retAddr)
{
BAD_MEMORY badMem;
RETCODE err;
   *result = TRUE;
   status = iceTest(offset,length);
   if (status != ICE_OK) {
      iceGetVerifyErrorInfo(&badMem);
      *retAddr = badMem.offset;
      if((err = SdnWriteMember(SDN_VERIFY_OFFSET,retAddr, GOOD))
         !=GOOD)  return(err);
      *result = FALSE;
   }
   return(iceMapError(status));
}

RETCODE  EXPORT Sds2AbiMemFill(U32 offset,U32 length,U8 *data,U16 pLength,
         ACCESS_SIZE size)
{
BAD_MEMORY badMem;
RETCODE err;
U32 tmpOffset;
U16 index;
   status = iceFill(offset,length,data,pLength);
   if (status != ICE_OK) {
      iceGetVerifyErrorInfo(&badMem);
      tmpOffset = badMem.offset;
      if((err = SdnWriteMember(SDN_VERIFY_OFFSET,&tmpOffset, GOOD))
         !=GOOD)  return(err);
      tmpOffset = badMem.actual;
      if((err = SdnWriteMember(SDN_VERIFY_ACTUAL,&tmpOffset, GOOD))
         !=GOOD)  return(err);
      index = (badMem.offset - offset)%pLength;
      tmpOffset = *(data+index);
      if((err = SdnWriteMember(SDN_VERIFY_EXPECTED,&tmpOffset, GOOD))
         !=GOOD)  return(err);
   }
   return(iceMapError(status));
}

RETCODE  EXPORT Sds2AbiMemSearch(U32 offset,U32 length,U8 *data,U16 pLength,
         BOOLEAN *found)
{
BAD_MEMORY badMem;
RETCODE err;
U32 tmpOffset;
   status = iceSearch(offset, length, data, pLength);
   if (status == ICE_MATCH) {
      iceGetVerifyErrorInfo(&badMem);
      tmpOffset = badMem.offset;
      if((err = SdnWriteMember(SDN_SEARCH_OFFSET,&tmpOffset, GOOD))
         !=GOOD)  return(err);
      *found = TRUE;
      if((err = SdnWriteMember(SDN_SEARCH_FOUND, found, GOOD))
         !=GOOD)  return(err);
   }
   return(iceMapError(status));
}

RETCODE  EXPORT Sds2AbiMemChecksum(U32 offset,U32 length,U32 *sum)
{
   return (iceMapError(iceChecksum(offset,length,sum)));
}

RETCODE  EXPORT Sds2AbiGetVerify(BOOLEAN *verify)
{
   status = iceGetVerify(verify);
   return(iceMapError(status));
}

RETCODE  EXPORT Sds2AbiSetVerify(BOOLEAN verify)
{
   status = iceSetVerify(verify);
   return(iceMapError(status));
}

RETCODE  EXPORT Sds2AbiInput(U16 addr, U16 len, U16 size, U8 *data)
{
   status = iceInput(addr, len, size, data);
   return(iceMapError(status));
}

RETCODE  EXPORT Sds2AbiOutput(U16 addr, U8 *data, U16 len, U16 size)
{
   status = iceOutput(addr, data, len, size);
   return(iceMapError(status));
}

RETCODE  EXPORT Sds2AbiMemCopy(U32 srcDesc,U32 len,BOOLEAN srcTarget,
         U32 destDesc)
{
BAD_MEMORY badMem;
RETCODE err;
U32 tmpOffset;
U32 tmpData;
   if (srcTarget == TRUE) destDesc = srcDesc;
   //status = iceCopy(srcDesc, len, destDesc);
   //add srcTarget by Eric 1/12/98
   status = iceCopy(srcDesc, len, destDesc, srcTarget);
      if (status != ICE_OK) {
      iceGetVerifyErrorInfo(&badMem);
      tmpOffset = badMem.offset;
      if((err = SdnWriteMember(SDN_VERIFY_OFFSET,&tmpOffset, GOOD))
         !=GOOD)  return(err);
      tmpOffset = badMem.actual;
      if((err = SdnWriteMember(SDN_VERIFY_ACTUAL,&tmpOffset, GOOD))
         !=GOOD)  return(err);
      tmpOffset = badMem.offset - destDesc + srcDesc;
      iceGetMem(tmpOffset,&tmpData);
      tmpData &= 0xff;
      if((err = SdnWriteMember(SDN_VERIFY_EXPECTED,&tmpData, GOOD))
         !=GOOD)  return(err);
   }
   return(iceMapError(status));
}

RETCODE  EXPORT Sds2AbiMemCompare(U32 srcDesc,U32 destDesc,U32 len,
                BOOLEAN *result, U32 *retAddr1,U32 *retAddr2, U16 *retData1, 
                U16 *retData2)
{
#define ICE_DIFF_FOUND 0
#define FALSE 0

RET_ADDR findAddr1, findAddr2;
   status = iceCompare(srcDesc, len, destDesc, &findAddr1, &findAddr2);
   if (status == ICE_DIFF_FOUND) {
      *result = FALSE;
      *retAddr1 = findAddr1.cs; 
      *retAddr1 = (*retAddr1 * 16) + findAddr1.ip; 
      *retAddr2 = findAddr2.cs; 
      *retAddr2 = (*retAddr2 * 16) + findAddr2.ip; 
      *retData1 = findAddr1.data;
      *retData2 = findAddr2.data;
   } else if (status == ICE_NO_DIFF) {
      *result = TRUE;
   }
   return(iceMapError(status));
}

RETCODE  EXPORT Sds2AbiSetAccessSize(ACCESS_SIZE size)
{
   if (size == 1) size = 0; else size = 1;
   status = iceSetAccessSize(size);
   return(iceMapError(status));
}

RETCODE  EXPORT Sds2AbiGetAccessSize(ACCESS_SIZE *size)
{
   status = iceGetAccessSize(size);
   if (*size) *size = 2; else *size = 1;
   return(iceMapError(status));
}

RETCODE  EXPORT Sds2AbiGetAllInternalRegs(U16 *internalRegBuffer)
{
   status = iceGetAllIntReg(internalRegBuffer);
   return(iceMapError(status));
}

RETCODE EXPORT Sds2AbiSetInternalReg(S16 regId, U32 regValue)
{
   status = iceSetReg(INTERNAL_REG, regId, regValue);
   return(iceMapError(status));
}

RETCODE EXPORT Sds2AbiGetInternalReg(S16 regId, U32 *regValue)
{
   status = iceGetReg(INTERNAL_REG, regId, regValue);
   return(iceMapError(status));
}

RETCODE EXPORT Sds2AbiSetReg(U16 regId, U32 regValue)
{
   status = iceSetReg(I86_REG, regMapTable186[regId], regValue);
   return(iceMapError(status));
}

/* <Judy 8/15/96> */
RETCODE EXPORT Sds2AbiSetTraceBreak(U8 enableBreak)
{
 U16 flag;
 flag=(U16)(enableBreak & 0x01);
 status=iceSetTraceBreak(flag);
 flag=(U16)((enableBreak & 0x02)>>1);
 status|=iceSetTraceOff(flag);
 return(iceMapError(status));
// return(GOOD);
}

/* <Judy 8/15/96> */
RETCODE EXPORT Sds2AbiSetTracing(U8 action)
{
   return(iceMapError(iceTraceAction((U8)action)));
// return(GOOD);
}

/* <Judy 8/15/96> */
RETCODE EXPORT Sds2AbiSetTrigOutAction(U8 action)
{
   return(iceMapError(iceSetTrigOutAction(action)));
// return(GOOD);
}

/* <Judy 8/26/96> */
RETCODE EXPORT Sds2AbiSpaSetRange(U8 type, U8 id, U32 start, U32 end)
{
 return(iceMapError(iceSPASetRange(type, id, start, end)));
}
/* <Judy 8/26/96> */
RETCODE EXPORT Sds2AbiSpaClearRange(U8 type)
{
 return(iceMapError(iceSPAClearRange(type)));
}
/* <Judy 8/26/96> */
RETCODE EXPORT Sds2AbiSpaGetMAInfo(U32 *stamp, MA_INFO_NODE *info,BOOLEAN *flag)
{
 return(iceMapError(iceSPAGetMAInfo(stamp, info, flag)));
}
/* <Judy 8/26/96> */
RETCODE EXPORT Sds2AbiSpaGetTAInfo(U32 *stamp, U16 *info,BOOLEAN *flag)
{
 return(iceMapError(iceSPAGetTAInfo(stamp, info, flag)));
}
/* <Judy 8/26/96> */
RETCODE EXPORT Sds2AbiSpaGetCCInfo(U32 start, U32 end, U8 FAR *ptr,BOOLEAN *flag)
{
 return(iceMapError(iceSPAGetCCInfo(start, end, ptr, flag)));
}
/* <Judy 8/26/96> */
RETCODE EXPORT Sds2AbiSpaGo(U8 type)
{
 return(iceMapError(iceGo((U16)type)));
}
/* <Judy 8/27/96> */
RETCODE EXPORT Sds2AbiReadFrameStamp(U16 bufID, U32 frameNo, U32 *stamp,U8 *stampMSB)
{
   return(iceMapError(iceReadFrameStamp(bufID, frameNo, stamp,stampMSB)));
}
RETCODE EXPORT Sds2AbiReadLastStamp(U16 bufID, U32 *stamp,U8 *stampMSB)
{
   return(iceMapError(iceReadLastStamp(bufID, stamp,stampMSB)));
}
RETCODE EXPORT Sds2AbiSpaClose()
{
 return(iceMapError(iceSPAClose()));
}
RETCODE EXPORT Sds2AbiSpaOpen()
{
 return(iceMapError(iceSPAOpen()));
}
RETCODE EXPORT Sds2AbiSpaSetBkpt(U8 flag, U32 addr)
{
 return(iceMapError(iceSPASetBkpt(flag ,addr)));
}
RETCODE EXPORT Sds2AbiReadFRom(U8 *data)
{
 return(iceMapError(iceRFROM(data)));
}
RETCODE EXPORT Sds2AbiWriteFRom(U8 *data)
{
 return(iceMapError(iceWFROM(data)));
}
/*
RETCODE EXPORT RelinkEP(VOID) {
S16 status;
U8 retID;
U32 memFailAddress;
PROBE_TYPE probeType;
INITIAL_INFO initInfo;

   ProcReturnSpecificProcessor(&probeType);
   status = CheckFwStatus();
   switch (status) {
      case DIAGNOSTIC_STATUS :
         DiagnosticFunction(END_DIAG, &memFailAddress,&retID);
         CheckFwStatus();
         DownLoadFirmware((U8 *)"main186.bin", 0x400, 0xff);
         break;
      case COLD_START :
         DownLoadFirmware((U8 *)"main186.bin", 0x400, 0xff);
         MapClear();
         break;
      case NORMAL_STATUS :
         status = ICE_WARN_START;
   }
   ReassignProcessorType(probeType);
   Sds2AbiFwUnloadRegisters(TRUE);
   return(GOOD);
} */
