/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the STKSERVR.DLL
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/stkservr/libmain.c_v  $
** 
**    Rev 1.0   20 Mar 1998 10:25:52   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 14:45:00   Judy
** Initial revision.
** 
**    Rev 1.3   13 Aug 1992 17:07:22   marilyn
** Added call to errdisplayerror if server fails to load.
** 
**    Rev 1.2   14 May 1992 16:43:06   marilyn
** Added call to ErrInitDLL.
** 
**    Rev 1.1   11 Mar 1992 10:47:06   marilyn
** No change.
** 
**    Rev 1.0   11 Feb 1992 16:03:14   marilyn
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_amd/stkservr/libmain.c_v   1.0   20 Mar 1998 10:25:52   Eric  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _STKCNTXT_
#include "stkcntxt.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

/* Handle of the DLL instance */
HANDLE hLib;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the VWSERVER.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {

    RETCODE err;

    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */

    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    /* initialize successfully */
    hLib = hInstance;
    ErrInitDLL(MODULE_STACK, "stkservr.dll");

    err = StkInitStackContext(); /* Stack init returns GOOD (hopefully) */
    if (GOOD != err)
       ErrDisplayError(err, FORCE_POPUP);
    return(TRUE);

}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**	Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
void FAR PASCAL WEP(int nParam) {

   switch(nParam) {
      case WEP_SYSTEMEXIT:
         /* System shutdown in progress. Respond accordingly */
         break;
      case WEP_FREE_DLL:
         /* The DLL use count is 0 */
         break;
      default:
         /* Undefined value - ignore */
         break;
   }
   return(TRUE);
}
#endif


/******************************** E O F ***********************************/
