/****************************************************************************
**
**  Name:  stkcntxt.h
**
**  Description:
**
**  Status:  PRELIMINARY | CODED
**
**  $Log:   S:/tbird/mt2_amd/stkservr/stkcntxt.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:25:52   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 14:44:58   Judy
** Initial revision.
** 
**    Rev 1.13   21 Oct 1994 17:10:00   marilyn
** Added a couple of fields to the stack session  STK_CONTEXT.
** 
**    Rev 1.12   16 Jul 1993 12:00:00   nghia
** PIP for Stack:
** - Moved STACK_CONTEXT typedef from source to header.
** - Move StkCheckAddrInStackRange() from private to public.
** 
**    Rev 1.11   26 Mar 1992 18:31:02   brucea
** Removed: StkCalcSymbolicInfo from header list
** 
**    Rev 1.10   12 Mar 1992 17:25:38   marilyn
** No change.
** 
**    Rev 1.9   11 Mar 1992 10:38:26   marilyn
** Added StkGetStackDirection
** 
**    Rev 1.8   09 Mar 1992 14:55:36   marilyn
** Added StkGetDefaultSessionId.
** 
**    Rev 1.7   03 Mar 1992 10:21:04   marilyn
** Changed StkGetSymbolicInfo to StkCalcSymbolicInfo to match .c file.
** 
**    Rev 1.6   03 Mar 1992 10:14:40   marilyn
** Added interface for StkInitStackContext.
** 
**    Rev 1.5   14 Feb 1992 18:13:00   brucea
** 
**    Rev 1.4   14 Feb 1992 13:24:28   brucea
** Removed: #include "stkwalk.h"
** 
**    Rev 1.3   14 Feb 1992 11:33:48   brucea
** Added: #include _STKCLI_
**        
** 
**    Rev 1.2   12 Feb 1992 09:02:36   brucea
** Implemented more of the context functions
** 
**    Rev 1.1   10 Feb 1992 15:25:06   brucea
** Initial implementation
** 
**    Rev 1.0   24 Jan 1992 12:08:50   brucea
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_amd/stkservr/stkcntxt.h_v   1.0   20 Mar 1998 10:25:52   Eric  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _STKCNTXT_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _CPU_
#include "cpu.h"
#endif

#ifndef _ENLIB_
#include "enlib.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef __MEM_H
#include "mem.h"
#endif

#ifndef _STKCLI_
#include "stkcli.h"
#endif

#ifndef _STKSERVR_
#include "stkservr.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef _TBIRDMEM_
#include "tbirdmem.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef struct STK_CONTEXT_TAG {
   /* generic information for the stack data structure */
   /* set equal to pointer to structure; test when accessing structure for */
   /* validity check */

   DESCRIPTOR sessionId;
   struct STK_CONTEXT_TAG *nextContext;  /* forward link */
   struct STK_CONTEXT_TAG *prevContext;  /* backward link */
   S8 name[32];   /* name assigned to stack; fixed length */
   U32 stkMaxAddress;
   U32 roundingMask[4];

   DESCRIPTOR stkCurrentPCAddrDesc;
   DESCRIPTOR stackBaseAddr;
   DESCRIPTOR highWaterMarkAddr;
   DESCRIPTOR alarmLimitAddr;

   /* init to invalid; set TRUE when StkSetStackBase called */
   BOOLEAN isValidStackBase;

   /* init to invalid; set TRUE when StkSetStackBase called */
   BOOLEAN isValidAlarmLimit;

   U32 stackSize;

   U32 alarmLimitPercent; /* percentage of the alarm limit setting */

   /* indicates the state of high water mark recalculation */
   BOOLEAN isHighWaterMarkCalculated;

   /* flag indicates whether the stack is filled for HWM calculation */
   BOOLEAN isStkFilled;

   /* present state of stack alarm */
   BOOLEAN alarmLimitReached;

   /* enable flags for stack calculations */
   BOOLEAN isAlarmLimitEnabled;
   BOOLEAN isHighWaterMarkEnabled;
}  STK_CONTEXT;
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/*------------------------------------------------------------------------
** StkCreateStack
**
** Purpose:
**   Allocates memory for a stack context, initializes it, then links it with
**   the other context linked list.
**
** Input parameters: none
**
** Output parameters:
**   stkSessionId: opaque handle to subsequently call other routines to set
**                 or get data from this stack context
*/
/*------------------------------------------------------------------------*/
RETCODE StkCreateStack(DESCRIPTOR *stkSessionId);


/*------------------------------------------------------------------------
** StkDestroyStack
**
** Purpose:
**   Removes stack context from linked list (and relinks list), then frees the
**   memory
**
** Input parameters:
**   stkSessionId: handle to stack context to obliterate
*/
/*------------------------------------------------------------------------*/
RETCODE StkDestroyStack(DESCRIPTOR stkSessionId);


/*------------------------------------------------------------------------
** StkGetDefaultSessionId
**
** Purpose :
**    Return the default context in the form of a descriptor.
**
** Input parameters:
**    none
**
** Output parameters:
**    Returns a descriptor.
**
**-----------------------------------------------------------------------*/
DESCRIPTOR StkGetDefaultSessionId(VOID);

/*------------------------------------------------------------------------
** StkGetDescFromName
**
** Purpose:
**    Looks up the passed stack name and returns the descriptor assigned to it
**
** Input parameters:
**    stackName: name to be looked up
**
** Output parameters:
**    stkSessionId: opaque descriptor to stack context; 0 if name not found.
*/
/*------------------------------------------------------------------------*/
RETCODE StkGetDescFromName(LPSTR stackName, DESCRIPTOR *stkSessionId);


/*------------------------------------------------------------------------
** StkInitStackContext
**
**	Purpose:
**    Initialize all the PRIVATE variables used in this module; only called
**    once when DLL loaded.  Also registers to receive event notification
**
**	Input parameters: none
**
**	Output parameters: none
*/
/*------------------------------------------------------------------------*/
RETCODE StkInitStackContext(VOID);

/*------------------------------------------------------------------------
** StkCheckAddrInStackRange
**
** Purpose:
**    Checks the input address (offset value) to see if it is within
**    the range of the stack as defined in the context variables.
**    Various error codes are returned depending on the result of the test.
**    Returns GOOD if address inside stack range.
**
** Input parameters:
**    stkSessionId: which stack context
**    addr: standard address descriptor of address offset to compare
*/
/*------------------------------------------------------------------------*/
RETCODE StkCheckAddrInStackRange(DESCRIPTOR stkSessionId,
                                 DESCRIPTOR addr,
                                 BOOLEAN    *inRange);

/******************************** E O F ***********************************/
