/****************************************************************************
**
**  Name:  libmain.cpp
**
**  Description:
**     Contains the main entry/exit point of the SYMBOL.DLL
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/symbol/libmain.cpv  $
** 
**    Rev 1.1   29 Jun 1998 15:53:16   Eric
** 
**    Rev 1.1   26 Feb 1997 11:42:54   Judy
** 
**    Rev 1.1   14 Jan 1997 15:30:46   Judy
** No change.
** 
**    Rev 1.0   14 Jun 1996 16:42:00   Judy
** Initial revision.
** 
**    Rev 1.15   25 Jul 1992 16:36:44   brucea
** Removed: WEP, moved InitCServer, removed includes that are no longer needed
** 
**    Rev 1.14   15 May 1992 14:31:30   brucea
** Added: ErrInitDLL call
** 
**    Rev 1.13   01 Apr 1992 23:42:10   brucea
** Fixed: compiler warnings
** 
**    Rev 1.12   04 Feb 1992 16:19:22   brucea
** Removed direct calls to initialize tables in symbol server and made them into
**    one call to SymInitialize.
** Created SymInitialize and place previous table init calls into it.
** 
**    Rev 1.11   29 Jan 1992 15:10:20   brucea
** Removed the address server initialization call from LibMain
** 
**    Rev 1.10   06 Jan 1992 16:05:10   john
** Unlocked DLL data segment
** 
**    Rev 1.9   16 Dec 1991 15:20:00   brucea
** Added #include "symutil.h"
** 
**    Rev 1.8   12 Dec 1991 14:11:24   john
** Added code to dealloc dynamic memory in WEP
** 
**    Rev 1.7   02 Dec 1991 11:35:52   brucea
** Changes follow:
**
** Added include "addr.h"
** Initialize the address server with call to AdrInitAddressServer
** 
**    Rev 1.6   08 Nov 1991 13:49:00   john
** Updated call to InitBasicTypes for new type table
** 
**    Rev 1.5   07 Nov 1991 15:32:56   john
** Changed EXPORT to FAR PASCAL to match the function prototype in
** windows.h.  This file compiled ok in c++ mode but not in 'C'
** mode due to the redeclaration.
** 
**    Rev 1.4   06 Nov 1991 13:29:50   john
** Removed compile time warnings w/max warning level enabled
** 
**    Rev 1.3   30 Oct 1991 15:39:56   john
** Moved dll initialization into libmain, instead of waiting for 
** the cli to do the initialization.
** 
**    Rev 1.2   03 Oct 1991 16:47:00   john
** moved structs from symadd back to symmgr
** 
**    Rev 1.1   03 Oct 1991 15:01:10   john
** Changed symmgr.h include to the renamed symadd.h
** 
**    Rev 1.0   03 Oct 1991 11:43:00   john
** Initial revision.
** 
**    Rev 1.0   25 Sep 1991 13:36:48   john
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_amd/symbol/libmain.cpv   1.1   29 Jun 1998 15:53:16   Eric  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

#define MODULE_NAME "symbl.dll"

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the DLL's
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
                              LPSTR lpszCmdLine) {

   RETCODE err;

   /* the LIBENTRY initializes the local heap by calling LocalInit() and
      then calls LibMain.  The LocalInit() locks the data segment of the
      library when initialize; therefore LibMain needs to unlock */
   if (cbHeapSize != 0)   /* the DLL Data segment is MOVEABLE */
      UnlockData(0);

   // the next function call returns RETCODE size error codes, but ;
   // LibMain can't pass back a RETCODE size error.  The entire ;
   // error code must be passed to make any sense.  Since this can't ;
   // be done just return FALSE. ;

   ErrInitDLL(MODULE_SYMBOLS, MODULE_NAME);  /* set up for error text */
    
   err = SymInitialize();
   if (GOOD != err)
      ErrDisplayError(err, FORCE_POPUP);

   return(TRUE);
}

/******************************** E O F ***********************************/
