/****************************************************************************
**
**  Name:  symcli.h
**
**  Description:
**     Prototype for the symbol server CLI parse routines
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/symbol/symcli.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:21:48   Eric
** Initial revision.
** 
**    Rev 1.1   26 Feb 1997 11:43:22   Judy
** 
**    Rev 1.1   14 Jan 1997 15:31:36   Judy
** No change.
** 
**    Rev 1.0   14 Jun 1996 16:42:14   Judy
** Initial revision.
** 
**    Rev 1.7   11 Oct 1994 18:10:32   nghia
** Added ConfigSymbols to header file.
** 
**    Rev 1.6   14 Jul 1994 01:52:36   brucea
** Added: declarations for output-to-file functions
** 
**    Rev 1.5   20 Jun 1994 10:23:50   nghia
** Added CreateLabelRanges routine.
** 
**    Rev 1.4   24 Sep 1993 10:21:58   nghia
** Added prototype for DisplayTypes routine - new shell command.
** 
**    Rev 1.3   25 Jul 1992 16:46:06   brucea
** Added: SendMessageToCli
** 
**    Rev 1.2   10 Jul 1992 18:40:32   brucea
** Added: Count(), Nameof(), AddressOf()
** Removed: SymLoad()
** 
**    Rev 1.1   30 Apr 1992 18:45:52   brucea
** Removed: RETCODE EXPORT DisplayModules (now a private function in symcli.cpp)
** 
**    Rev 1.0   04 Mar 1992 13:13:08   brucea
** Initial revision.
** 
**    Rev 1.2   11 Dec 1991 16:32:10   john
** Started adding new commands.  These are incomplete.
** Also added comments for all parser commands.
** 
**    Rev 1.1   09 Dec 1991 14:46:34   john
** Added prototype for RemoveSymbols.
** Changed prototypes on SymPrintSymbols.
** 
**    Rev 1.0   25 Sep 1991 13:35:16   john
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/symbol/symcli.h_v   1.0   20 Mar 1998 10:21:48   Eric  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _SYMCLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif


//--------------------------------------------------------------------------
// SendMessageToCli
//--------------------------------------------------------------------------
RETCODE SendMessageToCli(U8 FAR *msgPtr);


/***************************************************************************
** GetBase
**
** Description: Gets information about 1/all bases.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT GetBase(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
** RemoveSymbols
**
** Description: Removes all loaded symbols and reinitializes the symbol
**              table.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT RemoveSymbols(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
** SetBase
**
** Description: Sets the address of the base.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT SetBase(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
** DisplaySymbols
**
** Description: Prints all symbols in the symbol table.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT DisplaySymbols(LPSTR cmdString, U32 argc, U32 argv[]);


//--------------------------------------------------------------------------
// Count
//
// Displays the number of symbols in the various tables
//--------------------------------------------------------------------------
RETCODE EXPORT
Count(LPSTR cmdString, U32 argc, U32 argv[]);


//--------------------------------------------------------------------------
// NameOf
//
// Converts an address into a symbol and displays it
//--------------------------------------------------------------------------
RETCODE EXPORT
NameOf(LPSTR cmdString, U32 argc, U32 argv[]);


//--------------------------------------------------------------------------
// AddressOf
//
// Converts a symbol path and name into an address; uses #mod#func#var
//   naming convention
//--------------------------------------------------------------------------
RETCODE EXPORT
AddressOf(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// SymbolOpenFile
//
// Sets symbol output to go to <file>.
// Only one parameter is allowed - the path and filename
//--------------------------------------------------------------------------
RETCODE EXPORT
SymbolOpenFile(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// SymbolCloseFile
//
// Closes file opened by SymbolOpenFile
// No parameters are allowed.
//--------------------------------------------------------------------------
RETCODE EXPORT
SymbolCloseFile(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// DisplayTypes
//
// Diplay all types in symbol table.
//                    
//--------------------------------------------------------------------------
RETCODE EXPORT
DisplayTypes(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// CreateLabelRanges
//
// Diplay all types in symbol table.
//                    
//--------------------------------------------------------------------------
RETCODE EXPORT
CreateLabelRanges(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// ConfigSymbols
//
// Configure symbol bases for Intel protected mode
//                    
//--------------------------------------------------------------------------
RETCODE EXPORT ConfigSymbols(LPSTR cmdString, U32 argc, U32 argv[]);

#ifdef __cplusplus
}
#endif
/******************************** E O F ***********************************/
