/****************************************************************************
**
**  Name:  symmgr.h
**
**  Description:
**     Prototypes for the functions to manage the symbol memory pool
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/symbol/symmgr.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:21:50   Eric
** Initial revision.
** 
**    Rev 1.2   22 Jul 1997 10:10:54   Judy
** 
**    Rev 1.1   26 Feb 1997 11:43:30   Judy
** 
**    Rev 1.1   14 Jan 1997 15:32:10   Judy
** No change.
** 
**    Rev 1.0   14 Jun 1996 16:42:20   Judy
** Initial revision.
** 
**    Rev 1.18   24 Sep 1993 10:22:52   nghia
** Support forward reference types 
** Added sizeCalculated flag to defer sizeInMAU calculation for types.
** 
**    Rev 1.17   15 Jun 1992 09:06:20   brucea
** Changed enumValue from U16 to U32
** 
**    Rev 1.16   13 Jan 1992 17:19:06   john
** Added structures for variable lifetimes
** 
**    Rev 1.15   11 Dec 1991 16:10:50   brucea
** Comment changes
** 
**    Rev 1.14   29 Nov 1991 19:40:02   brucea
** changed VAR_BEGIN_ADDR_INFO to BEGIN_ADDR_INFO
**   same change for END_ADDR_INFO
** changed beginInfo, endInfo to beginAddrInfo, endAddrInfo
** 
**    Rev 1.12   18 Nov 1991 20:29:04   brucea
** Modified SYM_TYPE_VARIABLE by adding isValidAddr and
**    changing writeAccess to isConstant and changing it to
**    a BOOLEAN
** 
**    Rev 1.11   18 Nov 1991 15:22:02   brucea
** Added #include symutil.h;  moved SYMBOLS_LOADED into symutil.h
** 
**    Rev 1.10   15 Nov 1991 14:02:28   john
** Modified COMMON_SYMBOL_HEADER to allow for complex variable types
** 
**    Rev 1.9   11 Nov 1991 17:42:00   john
** Added structures for adding types
** 
**    Rev 1.8   11 Nov 1991 17:16:24   brucea
** Added #define SYMBOLS_LOADED to on-demand indicator
** Changed SYM_TYPE_MODULE with linenumOffsetStart and End
** Changed      "    moduleOffset to fileOffset
** Changed TYPE_HEADER_TYPE2: added recordSize and changed the name
**   of size to sizeInMAUs
** 
**    Rev 1.7   06 Nov 1991 15:01:34   brucea
** Added linenumIndexOffsetEnd to SYM_TYPE_MODULE
** 
**    Rev 1.6   01 Nov 1991 10:01:30   brucea
** Added moduleOffset comment
** 
**    Rev 1.5   03 Oct 1991 16:41:32   john
** prototypes moved to symadd.h
** 
**    Rev 1.4   25 Sep 1991 15:05:36   john
** Made changes to allow use of the cli server.
** Created a symbol specific type header.  This header needed to be different
** than a similar typedef in symblsvr.h.
** 
**    Rev 1.3   16 Sep 1991 14:23:24   john
** Removed the ordinal value from BASE types.
** Added comment to InitBasicTypes.
** 
**    Rev 1.2   12 Sep 1991 11:30:08   john
** Made changes to symbol headers to allow the by-address table code to work.
** Made changes to the baseSymbol class to remove a parameter that didn't 
** need to be passed.
** 
**    Rev 1.1   09 Sep 1991 16:53:14   john
** changed common header structs for by-address sorted table code
** 
**    Rev 1.0   06 Sep 1991 16:11:56   john
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/symbol/symmgr.h_v   1.0   20 Mar 1998 10:21:50   Eric  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _SYMMGR_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif
#ifndef _MEMMANAG_
#include "memmanag.h"
#endif

#ifndef _SYMUTIL_
#include "symutil.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef union {
   U32             startAddr;      // code symbol address
   AUTO_VAR_OFFSET autoVarOffset;  // var offset from stack frame
   STATIC_VAR_ADDR staticVarAddr;  // static (not global) variable address
   GLOBAL_VAR_ADDR globalVarAddr;  // global variable
   REG_INDEX       registerIndex;  // for ATN2 and ATN10 register vars
} BEGIN_ADDR_INFO;

typedef union {
   U32 endAddr;     // for code symbols and fixed address vars
   U32 varSize;        // for auto vars and register vars
} END_ADDR_INFO;

typedef struct {
   VAR_LIFETIME_INFO lifetimeInfo;
   TABLE_OFFSET nextLifetimeInfo;
} SYM_LIFETIME_INFO;

typedef struct {
   TABLE_OFFSET firstEntry;
   TABLE_OFFSET lastEntry;
} SYM_LIFETIME_START_INFO;

// defines action preformed on the last symbol
typedef enum {
   SYM_OPEN,
   SYM_CLOSE,
} SYM_ACTION;

typedef struct {
   SYM_TYPE_TYPE symType:4;
   BASE_INDEX baseIndex:12;  // must change MAX_BASE_INDEX_SIZE if more bits
} PACKED_TYPE_INDEX;         // are allowed for BASE_INDEX

// All variable symbols use this as their common header.
typedef struct {
   S16 segNum;
   U16 segment[MAX_SEG_NUM];
   U16 beginAddr[MAX_SEG_NUM];
   U16 endAddr[MAX_SEG_NUM];
   PACKED_TYPE_INDEX typeIndex;
   TABLE_OFFSET symbolNameOffset;
   TABLE_OFFSET symParentOffset;
   TABLE_OFFSET symSiblingOffset;
   BEGIN_ADDR_INFO beginAddrInfo;
   END_ADDR_INFO endAddrInfo;
   U32 ordinalVal;
} COMMON_SYMBOL_HEADER;

typedef struct {
   TABLE_OFFSET varListOffset;
   TABLE_OFFSET labelListOffset;
   TABLE_OFFSET constListOffset;
   TABLE_OFFSET miscListOffset;
} COMMON_LIST_HEADER;

// All block/function/module symbols use this as their common header.
typedef struct {
   COMMON_SYMBOL_HEADER symHeader;
   TABLE_OFFSET child;
   COMMON_LIST_HEADER list;
} COMMON_BLOCK_HEADER;

typedef struct {
   COMMON_BLOCK_HEADER symHeader;
   TABLE_OFFSET        linenumOffsetStart;
   TABLE_OFFSET        linenumOffsetEnd;
   TABLE_OFFSET        srcFilenameOffset;
   TIMESTAMP_TYPE      timestamp;
   U32                 fileOffset;
      /* offset to start of module record when onDemand state is TRUE;
         a value of 0 ==> all symbols are loaded for this module */ 
   U32                 typeDelta;
   U32                 auxFileOffset;
   LANGUAGE_TYPE       langType;
} SYM_TYPE_MODULE;

typedef struct {
   COMMON_BLOCK_HEADER symHeader;
   FUNC_CLASS funcClass;
   U32 stackSpace;
   U32 typeIndex;    /* temporary type cast */
   U16 segment;
} SYM_TYPE_FUNCTION;


typedef struct {
   COMMON_BLOCK_HEADER symHeader;
   U32 stackSpace;
} SYM_TYPE_BLOCK;

typedef struct {
   TABLE_OFFSET baseNameOffset;
   TABLE_OFFSET nextBaseOffset;
   U32 addressMin;
   U32 addressMax;
   U32 addressCount;
   U32 addrTable;
   BASE_ADDRESS baseAddress;
   U8 baseType;
   U8 addrTableDirty;
} SYM_BASE_ENTRY;

typedef struct {
   COMMON_SYMBOL_HEADER symHeader;
   TABLE_OFFSET         typeIndex;
   VAR_STORAGE_CLASS    storageClass;
   VAR_REGISTER_CLASS   registerClass;
   BOOLEAN              isConstant;    /* TRUE ==> read-only constant;   */
                                       /* FALSE==> read-write access     */
   BOOLEAN              isValidAddr;   /* TRUE ==> address is valid;     */
                                       /* FALSE==> address not known yet */
} SYM_TYPE_VARIABLE;

typedef struct {
    U16        recordSize;   /* bytes making up the entire type record */
    U16        memberCount;
    TYPE_CLASS typeChoice;   /* determines access to union */
    union {
        SIMPLE_TYPE simpleType;
        COMPLEX_TYPE complexType;
    } t;
    U32 sizeInMAUs;           /* number of MAUs making up type template */
    TABLE_OFFSET typeName;    /* empty string if type doesn't have name */
    BOOLEAN sizeCalculated;   /* Flag to indicates MAU calculated */
} TYPE_HEADER_TYPE2;

typedef struct {
   U32 attribute;
   U8 frameType;
   U32 pushMask;
   TYPE_INDEX returnType;     
   U8 argCount;
   U8 level;
   TABLE_OFFSET fatherName;
} FUNC_TYPE_HEADER;
   
typedef struct {
    TABLE_OFFSET nameOffset;
    TYPE_INDEX typeIndex;      
    U16 offset;
} TYPE_STRUCT_HEADER;

typedef struct {
   U32 enumValue;
   TABLE_OFFSET enumName;
} ENUM_TYPE_STRUCT;

/******************************** E O F ***********************************/
