/*----------------------------------------------------------------------------
** Name: typetbl.h
**
** Title: Type Table
**
** Purpose:
**  Create and manage all simple and complex data types
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/mt2_amd/symbol/typetbl.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:21:50   Eric
** Initial revision.
** 
**    Rev 1.1   18 Apr 1997 09:29:26   Judy
** 
**    Rev 1.1   14 Jan 1997 15:32:24   Judy
** No change.
** 
**    Rev 1.0   14 Jun 1996 16:42:26   Judy
** Initial revision.
** 
**    Rev 1.8   06 Nov 1992 07:15:36   brucea
** Cosmetic changes
** 
**    Rev 1.7   10 Jul 1992 18:41:24   brucea
** Fixed: return code from GetMaxTypeIndex to GOOD
** 
**    Rev 1.6   06 Dec 1991 16:59:28   john
** Added member function prototype to free the allocated for the 
** type table.
** 
**    Rev 1.5   20 Nov 1991 09:16:50   john
** Added a member variable to keep track of the largest type index
** used so far, and a member function to return its value.
** 
**    Rev 1.4   18 Nov 1991 15:23:20   brucea
** Added #include symutil.h
** 
**    Rev 1.3   12 Nov 1991 10:04:36   brucea
** Changed prototype/function to match TYPE_HEADER_TYPE2 struct
** 
**    Rev 1.2   11 Nov 1991 17:45:14   john
** Changed prototype for UpdateSizeInMAUs to match change in .cpp file
** 
**    Rev 1.1   11 Nov 1991 15:09:20   john
** Added prototypes for new functions.
** 
**    Rev 1.0   08 Nov 1991 14:10:52   john
** Initial revision.
** 
** $Header:   S:/tbird/mt2_amd/symbol/typetbl.h_v   1.0   20 Mar 1998 10:21:50   Eric  $
**
** Copyright (C) 1991 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#define _TYPETBL_

#ifndef _MEMMANAG_
#include "memmanag.h"
#endif

#ifndef _SYMUTIL_
#include "symutil.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/

#ifdef __cplusplus

class TypeTable : public Table {

private:

   TABLE_OFFSET availMemOffset;  // acts as ptr to start of available mem ;
                                 // also equals the number of bytes used ;
   U16 bytesThrownAway;          // measurement of memory loss ;
   TYPE_INDEX typeIndex;         // index to the last type header added. ;
                                 // all future put bytes will operate using ;
                                 // this index.
   TYPE_INDEX maxTypeIndex;      // holds the value of the largest type ;
                                 // index stored away so far. ;

public:
   // constructor ;
   TypeTable();

//---------------------------------------------------------------------------
// AllocBytes
//
// Purpose:
//    Allocate 1 to 64k bytes into table.  Returns offset to start of data.
//
// Input parameters:
//    size: number of bytes
//
// Output parameters:
//    tableDataOffset: offset to start of stored bytes.
//
// Error: Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold data
//
//------------------------------------------------------------------------
RETCODE AllocBytes(U16 size, TABLE_OFFSET& tableDataOffset);


//---------------------------------------------------------------------------
// GetAvailMemOffset
//
// Purpose:
//    Return the value of the variable that points to the next available
//    location in the table to add data.
//
//---------------------------------------------------------------------------
TABLE_OFFSET GetAvailMemOffset() {return availMemOffset;};


//---------------------------------------------------------------------------
// GetBytesThrownAway
//
// Purpose:
//    FOR TESTING.
//    Return the value of the variable holding the number of bytes that were
//    "discarded" when it crossed the allocated boundary (which required
//    ReAlloc)
//
//---------------------------------------------------------------------------
U16 GetBytesThrownAway() { return bytesThrownAway; };


// GetMaxTypeIndex
//
// Purpose:
//    Returns the largest type index used so far ;
//
//---------------------------------------------------------------------------
RETCODE GetMaxTypeIndex(TYPE_INDEX &typeIndexMax) { 
   typeIndexMax = maxTypeIndex;
   return GOOD;
};


//---------------------------------------------------------------------------
// GetTypeIndex
//
// Purpose:
//    Returns the type index of the current type header. ;
//
//---------------------------------------------------------------------------
U32 GetTypeIndex(VOID) { return typeIndex; };


//---------------------------------------------------------------------------
// IncrementMemberCount
//
// Purpose:
//    Every time a type is added to the table the member count in the type ;
//    header must be incremented.
//
//---------------------------------------------------------------------------
RETCODE IncrementMemberCount(VOID);


//---------------------------------------------------------------------------
// InitBasicTypes
//
// Purpose:
//    Initialize the builtin language types ;
//
//---------------------------------------------------------------------------
RETCODE InitBasicTypes(VOID);


//---------------------------------------------------------------------------
// ObliterateTable
//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
VOID ObliterateTable(VOID);


//---------------------------------------------------------------------------
// PutBytes
//
// Purpose:
//    Insert 1 to 64K bytes into table.  Uses type index from last type_hdr.
//    This routine is used for putting structures into the table by passing
//    a pointer to the structure with size = sizeof(struct).
//
// Input parameters:
//    inputDataPtr: pointer to data.
//    size: number of bytes
//
// Output parameters:
//    offset: offset to head of data just stored
//
// Error: Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold data
//
//------------------------------------------------------------------------
RETCODE PutBytes(U8 *inputDataPtr, U16 size, TABLE_OFFSET &offset);


//---------------------------------------------------------------------------
// PutHeader
//
// Purpose:
//    Insert a type header into the type table.  
//
// Input parameters:
//    inputDataPtr: pointer to data.
//    size: number of bytes
//    index: the index for the header to be added
//
// Output parameters:
//    none:
//
// Error: Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold data
//
//------------------------------------------------------------------------
RETCODE PutHeader(U8 *inputDataPtr, U16 size, TYPE_INDEX index);


//---------------------------------------------------------------------------
// SetAvailableMem
//
// Purpose:
//    TESTING ONLY!!  Positions the unused memory pointer to a new location.
//---------------------------------------------------------------------------
VOID SetAvailableMem(U32 setValue) {

   availMemOffset = min(setValue, tableSize);
}


//---------------------------------------------------------------------------
// UpdateMAUSize
//
// Purpose:
//    When a new type is added the size of the new type in MAU's needs to ;
//    be updated. ;
//---------------------------------------------------------------------------
RETCODE UpdateMAUSize(TYPE_INDEX prevIndex);


//---------------------------------------------------------------------------
// UpdateRecordSize
//
// Purpose:
//    When a new type is added the size of the entire type record needs to ;
//    be updated. ;
//---------------------------------------------------------------------------
RETCODE UpdateRecordSize(U16 setValue);

};  // end of class MemPool

#endif

/******************************** E O F *************************************/