/***************************************************************************
**
**    Name:    dq186.h
**
**    Description:
**        Internal definitions for the dequeuer server.
**
** 
** 
**    $Header:
*/

#define _DQ186_


                        /********************
                        **                 **
                        **  Includes       **
                        **                 **
                        ********************/


                        /**********************
                        **                   **
                        **  Definitions      **
                        **                   **
                        **********************/



typedef struct {
   BOOLEAN     frameValid;
   BOOLEAN     synched;
   BOOLEAN     programFrame;
   DESCRIPTOR  frameAddr;
   U16         data;
   U32         ifetch;
   S32         frameNo;
}FRAME_TYPE;


typedef enum {
   NO_INT,
   INT_88,
   INT_86
}INT_CYCLE_TYPE;

typedef enum{
   NORMAL_INST,
   BRANCH,
   TRAP,
   ILLEGAL,
   RETURN,
   TRANSFER_INST,
   SW_INT, // find wwwrr seq. cycles
   HW_INT  // fine wAwwrr seq. cycles
}INST_TYPE;


#define MAX_FRAME_NO        0x800L  // Max length of frame No : 2K.
#define MAX_FRAME_READ       0x40L  // Read 64 trace frames each times.
#define MAX_FRAME_MAP_NO     MAX_FRAME_NO/MAX_FRAME_READ // MAX_FRAME_NO/MAX_FRAME_READ

#define MAX_INST_LEN          6  // 6 bytes.
#define AVG_INST_LEN          2  // 2 bytes.

typedef enum { READ_NOSKIP, READ_SKIP }FRAME_READ_MODE;

typedef enum { PROGRAM_FRAME, DATA_FRAME }FRAME_READ_TYPE;

typedef enum {F_UD = 1, F_UP = 2, F_SD = 5, F_SP = 6, F_CPU = 7}FRAME_SPACE;

typedef enum {S_PROGRAM = 0x10, S_DATA, S_DONT_CARE}SPACE_TYPE;

typedef enum { QUEUE_INST,TRACE_INST, TRACE_TRANSFER_INST }CHECK_INST_TYPE;

//typedef struct {
//   S32 frameNo;
//   U32 addr;
//   U8  statusPin;
//   U16 data;
//   U8  timeStamp,
//       spare;
//}TRC_FRAME;

typedef struct {
   S32 frameNo;
   U32 addr;
   U32 statusPin;
   U32 data;
}TRC_FRAME;

typedef struct {
   S32 frameNo;
   U32 addr;
   U32 statusPin;
   // U32 data;
   U16 data;
   U16 highData;
}DQ_FRAME;

//typedef struct {
//   S32 frameNo;
//   U32 addr;
//   U16 data;
//   U8 statusPin;
//}DQ_FRAME;

typedef struct {
    DQ_FILTER       DqFilter;
    BOOLEAN         Search;
    U16             Offset;
    LPSTR           pattern;
    DESCRIPTOR      traceId;
    FRAME_TYPE      *dqFrame;

    U16 traceBufId;         // New add record for 306 DQ
    U16 traceBuffCount;
    S32 dqStartFrame,frameReadStart,
        frameStart,frameEnd;
    TRC_FRAME frameArray[MAX_FRAME_NO];
}DQ_STATE;



#define LOCAL   static

#define CYCLE(x)   (  (x) & 0x07  )
#define IS_BHE(x)  ( ((x) & 0x10) ? 1 : 0 )
#define ISDMA(x)   ( ((x) & 0x20) ? 1 : 0 )
#define ISFLUSH(x) ( ((x) & 0x40) ? 1 : 0 )
#define LSB(x)     (  (x) & 0x00FF  )
#define MSB(x)     ( ((x) & 0xFF00) >> 8 )

#define ACCESSSIZE88    1
#define ACCESSSIZE86    2
#define DEQSIZE88       5
#define DEQSIZE86       7
#define LISTFRAME       0
#define LISTINST        1
#define LISTSOURCE      2
#define NOBRANCH        0
#define CONDBRANCH      1
#define UNCONDBRANCH    2
#define FETCH_INST      4

#define CYCLE(x)   (  (x) & 0x07  )
#define IS_BHE(x)  ( ((x) & 0x10) ? 1 : 0 )
#define ISDMA(x)   ( ((x) & 0x20) ? 1 : 0 )
#define ISFLUSH(x) ( ((x) & 0x40) ? 1 : 0 )
#define LSB(x)     (  (x) & 0x00FF  )
#define MSB(x)     ( ((x) & 0xFF00) >> 8 )
//typedef enum
//{T_AK = 0x08,   T_INPUT = 0x09, T_OUTPUT = 0x0A, T_HALT = 0x0B,
// T_S  = 0X0C,    T_READ = 0x0D, T_WRITE  = 0x0E, T_DMA  = 0x20,
// READ_FLUSH = 0x4D, WRITE_FLUSH = 0x4E}
//TRACE_STATUS_PIN; //for 186
typedef enum
{T_AK = 0x00,   T_INPUT = 0x01, T_OUTPUT = 0x02, T_HALT = 0x03,
 T_S  = 0X04,    T_READ = 0x05, T_WRITE  = 0x06, T_DMA  = 0x20,
 READ_FLUSH = 0x4D, WRITE_FLUSH = 0x4E}
TRACE_STATUS_PIN;   //for Am186
/********************************* E O F *******************************/
