/***************************************************************************
**    $Log:   S:/tbird/mt2_amd/trace/spawdlg.c_v  $
** 
**    Rev 1.1   09 Jul 1998 16:04:54   Eric
** Fixed bug of range length in Code Coverage.
** 
**    Rev 1.8   24 Jun 1998 16:47:44   hera
** We can not limit the number of modules to 55(MAXLEN)
** 
**    Rev 1.7   12 Feb 1998 15:16:16   Eric
** Fixed bug for Multiple Segmemt.
** 
**    Rev 1.6   16 Jan 1998 08:55:14   Winky
** Fixed ProcessLineMarked function.
** 
**    Rev 1.5   19 Dec 1997 09:05:04   hera
** for ID:172
** 
**    Rev 1.4   12 Dec 1997 11:29:36   Winky
** 
**    Rev 1.3   21 Jul 1997 14:59:44   Judy
** 
**    Rev 1.2   27 May 1997 15:30:20   Judy
** 
**    Rev 1.19   24 Jan 1997 12:34:42   cjchen
** 
**    Rev 1.18   21 Jan 1997 11:27:00   cjchen
** 
**    Rev 1.17   17 Jan 1997 18:49:08   cjchen
** 
**    Rev 1.16   16 Jan 1997 10:16:12   cjchen
** 
**    Rev 1.15   09 Jan 1997 09:51:14   cjchen
** 
**    Rev 1.14   24 Dec 1996 17:34:16   cjchen
** 
**    Rev 1.13   24 Dec 1996 10:11:00   cjchen
** 
**    Rev 1.12   19 Dec 1996 09:05:50   cjchen
** 
**    Rev 1.11   12 Dec 1996 11:25:54   cjchen
** 
**    Rev 1.10   03 Dec 1996 09:23:24   cjchen
** 
**    Rev 1.9   22 Nov 1996 14:32:34   cjchen
** 
**    Rev 1.8   20 Nov 1996 15:52:44   cjchen
** 
**    Rev 1.8   20 Nov 1996 15:52:12   cjchen
** 
**    Rev 1.7   11 Nov 1996 16:14:16   cjchen
** 
**    Rev 1.6   07 Nov 1996 18:20:42   cjchen
** 
**    Rev 1.5   29 Oct 1996 16:21:32   cjchen
** 
**    Rev 1.4   11 Oct 1996 17:15:24   cjchen
** 
**    Rev 1.3   11 Oct 1996 09:18:46   cjchen
** 
**    Rev 1.2   09 Oct 1996 14:51:12   cjchen
** No change.
** 
**    Rev 1.1   08 Oct 1996 17:19:36   cjchen
** 
**    Rev 1.0   06 Sep 1996 16:51:54   cjchen
** Initial revision.
** 
**    Rev 1.2   20 Aug 1996 14:13:00   cjchen
** 
**    Rev 1.1   12 Aug 1996 08:52:18   cjchen
** 
**    Rev 1.0   01 Jul 1996 10:01:28   cjchen
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/trace/spawdlg.c_v   1.1   09 Jul 1998 16:04:54   Eric  $
*****************************************************************************/

                /************************
                *                       *
                *     INCLUDE FILE      *
                *                       *
                *************************/
#include "windows.h"
#include <commdlg.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

//Hera 6/24/98
#ifndef _SYMBLEXT_
#include "symblext.h"
#endif

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _SPAWDLG_
#include "spawdlg.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef _SPA_
#include "spa.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _CLIULIB_
#include "cliulib.h"
#endif

#ifndef _ADDR_
#include "addr.h"
#endif

#ifndef _DASM_
#include "dasm.h"
#endif

#ifndef _BKPTEXEC_
#include "bkptexec.h"
#endif

#include <ctype.h>


		/***********************
                *                      *
                *     DEFINITIONS      *
                *                      *
                ************************/
#define MAXLEN       55
#define FILEINI      "mp186.ini"


               /************************
               *                       *
               *     EXTERNAL          *
               *                       *
               *************************/
extern HINSTANCE hLib;

               /************************
               *                       *
               *       LOCAL           *
               *                       *
               *************************/


typedef struct {
   char isList; //-:list,+:noList
   char moduleName[MAXLEN];
} MODULELIST;

//MODULELIST mList[MAXLEN];
MODULELIST *mList;//Hera 6/24/98
PRIVATE BOOLEAN registeredClasses = FALSE;
char szAppName[MAXLEN];
char szModuleName[MAXLEN],szStartAddr[11*MAX_SEG_NUM],szAddRange[11*MAX_SEG_NUM];
char szFuncName[MAXLEN],szEndAddr[11*MAX_SEG_NUM],szBrkPoint[MAXLEN];
static HANDLE hInst;
HFONT hFont,hOldFont,hFontFixed;
HPEN  hGrayPen,hWhitePen,hOldPen;
HCURSOR hCursor,hOldCursor;
HLOCAL hWndOldMemTitleList,hWndNewMemTitleList;
LPSTR ptrMemCC;
HWND hWndSPA=NULL;
HWND hWndRange[5],hWndBsFunc[6];
HWND hWndBrk,hWndListBox;
HWND hWndDir,hWndTitleList,hWndBar;
PSTR ptxText,curPtr,oldptxText;
S16 nTop,nLeft, nSPAstatus=0;
int m_bCapture=0,numModule=0;
int orgLeft,orgRight;
FARPROC lpfnOldCombox,lpBrkProc,lpRangesProc,lpAddRangeProc;
FARPROC lpfnOldListBox,lpfnOldBar,lpfnOldFuncText,lpBrowseProc;
char bsName[5][10]={"&Start","S&top","&Range...","&Close","&Help"};
char bsName_Code[6][10]={"&Start","S&top",
                   "&Range...","&Asm","&Close","&Help"};
RECT barRect,invalidRect,listRect;
POINT orgPoint,nextPoint;
DWORD heightItem;
/* the position variable */
U16 heightCombo,heightListBox,heightBrk,heightRect,heightBsFunc;
U16 widthCombo,widthListBox,widthBrk,widthRect,widthBsFunc;
U16 heightDirRect,cxAveChar,cyChar,spaWidth,spaHeight;
U16 leftCombo,topCombo,leftBrk,topBrk,leftListBox,topListBox;
U16 leftRect,topRect,leftText,topText,topBsFunc;
U16 cxScreen,cyScreen,addWidth,addHeight;
// for code coverage asm vs source
char asmFlag='N',asmEnable='Y';
//DESCRIPTOR idDasm;
char ccmoduleName[MAXLEN],ccfuncName[MAXLEN];
U8 isRangedFlag=FALSE;
BOOLEAN startStop=FALSE;
U16 tabWidth;
//used for MA TA GET
U32 totalStamp;
SPA_MA_INFO dataInfo[4];
U32 timeStamp[3];
U16 dataCount[9];
U8 canGetCCFlag=FALSE;
//codecoverage
char selectedRangeName[MAXLEN],selectedFuncName[MAXLEN];
BOOLEAN noSymbol;

               /************************
               *                       *
               *       PROTOTYPE       *
               *                       *
               *************************/
void SetupModuleAnalysis(HWND);
void SetupTimeAnalysis(HWND);
void SetupCodeCoverage(HWND);
void WmPaintModuleAnalysis(HDC);
void WmPaintTimeAnalysis(HDC);
void WmPaintCodeCoverage(HDC);
void ClearUpWindow(int,HWND);
long FAR PASCAL SPAWndProc (HWND, UINT, UINT, LONG);
long FAR PASCAL ComboxProc(HWND, UINT, UINT, LONG);
long FAR PASCAL ListBoxProc(HWND, UINT ,UINT ,LONG );
long FAR PASCAL FuncTextProc(HWND,UINT,UINT,LONG);
long FAR PASCAL BarProc(HWND, UINT, UINT, LONG);
BOOL FAR PASCAL BrkDlgProc (HWND ,UINT ,UINT ,LONG );
BOOL FAR PASCAL RangesDlgProc (HWND ,UINT ,UINT ,LONG );
BOOL FAR PASCAL AddRangeDlgProc (HWND ,UINT ,UINT ,LONG );
BOOL FAR PASCAL BrowseDlgProc (HWND ,UINT ,UINT ,LONG );
RETCODE CreateSPAPresenter(HINSTANCE, S16, S16, S16, S16);
int nCwRegisterClasses(void);
DWORD CountListIndex(float);
void ReFillDirList(void);
RETCODE InitialModuleList(void);
RETCODE GetFuncContent(LONG);
void InitSPA(void);
void DeleteBlank(LPSTR, LPSTR);
RETCODE ModuleOpen(char *,DESCRIPTOR,int,int,int,char *,U8);
RETCODE GetStartAndEndAddr(char *, char *,char *,char *);
RETCODE ConvLinenum2AsmCode(DESCRIPTOR,int,DESCRIPTOR);
RETCODE ShowAsmCode(char *,int);
RETCODE GetFuncCode(char *,char *,char *);
RETCODE CheckAddressFormatL(LPSTR,LPSTR,LPSTR,LPSTR ,LPSTR );
RETCODE ProcessSpaMAGet(HDC);
RETCODE ProcessSpaTAGet(HDC);
RETCODE ProcessInvalidateRect(HWND);
RETCODE ProcessLineMarked(VOID);
RETCODE LineIsMarked(DESCRIPTOR,DESCRIPTOR,U32,BOOLEAN *);
RETCODE GetBrkPoint(VOID);
RETCODE GetLinenumByModuleAndFunc(char *,char *,U16 *,U16 *);
RETCODE GetLinenumByStartAndEndTextAddr(char *,char *,U16 *,U16 *,char *,char *,BOOLEAN *);
RETCODE ProcessIsFuncHasRange(char *,char *,BOOLEAN *,U32 *);
RETCODE ProcessTabInText(char *,char *);
RETCODE ListModuleAndFuncName(HWND,int,int,int);
RETCODE SelectModuleAndFuncName(HWND,int,int,int);
RETCODE ErrMessageBoxL(char *);
RETCODE InvalidateHwndListBox(VOID);
RETCODE BarInitialization(VOID);
RETCODE InvalidateMAorTACombo(VOID);
RETCODE CheckAddressEven(char *,char *);
RETCODE InitializeOpenFile(OPENFILENAME *);
RETCODE GetRangeTextBasedOnRangeName(char *,char *,char *);
RETCODE GetRangePercent(char *,char *,U16 *);
RETCODE GetAsmCode(char *,char *);
RETCODE GetModuleByRangeTextAddr(char *,char *,RANGE_MODE_TYPE,
   SYM_DESCRIPTOR *,DESCRIPTOR,char *);
/*RETCODE GetModuleByRangeTextAddr1(char *,char *,RANGE_MODE_TYPE,
   SYM_DESCRIPTOR *,DESCRIPTOR,char *);*/
//static HANDLE hInst;

               /************************
               *                       *
               *   Execution Code      *
               *                       *
               *************************/
/*****************************************************************************
**
**  CreateSPAPresenter
**
*****************************************************************************/
RETCODE CreateSPAPresenter(HINSTANCE hInstance, S16 left, S16 top,
                              S16 width, S16 height) {
//MSG msg;  // MSG structure to store your messages
int nRc;  // return value from Register Classes
char szString00[MAXLEN];

   nLeft=left;
   nTop=top;
   strcpy(szAppName, "SPA");
   hInst = hInstance;
   if(!registeredClasses) {
      /* register window classes if first instance of application */
      if ((nRc = nCwRegisterClasses()) == -1) {
         // TODO: Replace this with ErrDisplayFormattedError
         strcpy(szString00, "Error registering virtual listbox or peripheral");
         MessageBox(NULL, szString00, NULL, MB_ICONEXCLAMATION);
         return nRc;
      }
      registeredClasses = TRUE;
   }
   SpaCreate();
   if (!left && !width) {
      left = CW_USEDEFAULT;
      width = CW_USEDEFAULT;
   }
   
   /* create peripheral window */
   hWndSPA = CreateWindow((LPSTR) szAppName,    /* Window class name    */
                           (LPSTR)"SPA",  /* title                */
                           (WS_CAPTION     |     /* Title and Min/Max    */
                           /*WS_SYSMENU      |     Add system menu box  */
                           /*WS_MINIMIZEBOX  |     Add minimize box     */
                           /*WS_MAXIMIZEBOX  |   Add maximize box     */
                           /*WS_MAXIMIZE      |  maximize window */
                           WS_CLIPCHILDREN |    /* don't draw in child ares */
                           WS_OVERLAPPED),
                           left, top,
                           spaWidth, spaHeight,
                           NULL,                 /* Parent window's handle */
                           NULL,                 /* Default to Class Menu */
                           hInst,                /* Instance of window */
                           NULL);       /* Create struct for WM_CREATE */

   //ShowWindow (hWndSPA,SW_SHOWMAXIMIZED);
   UpdateWindow (hWndSPA);
   /*
   while (GetMessage(&msg, NULL, 0, 0)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
   */
   //return msg.wParam;
   return TRUE;
}

/*****************************************************************
*                                                                *
*        SPAWndProc                                         *
*                                                                *
******************************************************************/
long FAR PASCAL SPAWndProc (HWND hWnd, UINT message,
         UINT wParam, LONG lParam) {
HDC            hDc; 
PAINTSTRUCT    ps;
TEXTMETRIC     tm;
HMENU          hMenu;
static HCURSOR hWndOldCursor=NULL;

static short   cyInterLine;
static short   cxChar, cxLength;
static short   cxMaxChar;
static OPENFILENAME ofn;
LOGPEN lPen;
static POINT gCurPos;
int i,j;
static RECT tempRect;
U8 u8Count,u8Selected;
char szString00[MAXLEN],szString01[11*MAX_SEG_NUM],szString02[11*MAX_SEG_NUM];
char szString03[MAXLEN],str[MAXLEN];
char startText[11*MAX_SEG_NUM],endText[11*MAX_SEG_NUM];
DWORD nIndex;
RECT dynamicRect;
HWND tempHandle;
WORD tempControlId;
BOOLEAN flagStop;
RETCODE err;
LPSTR ptrMemTemp;

  switch (message) {
     case WM_CREATE:
        hDc = GetDC(hWnd);
        GetTextMetrics(hDc,&tm);
        cxScreen=GetSystemMetrics(SM_CXSCREEN);
        cyScreen=GetSystemMetrics(SM_CYFULLSCREEN);
        cxMaxChar = tm.tmMaxCharWidth;
        //cxAveChar=tm.tmAveCharWidth;
        cxAveChar=cxScreen/85;
        //cyChar = tm.tmHeight + 3 * tm.tmExternalLeading ;
        cyChar=cyScreen/28;
        cyInterLine = 0.5 * tm.tmHeight;
        cxLength = 10*cxChar;
        ReleaseDC(hWnd,hDc);
        //define some variable
        spaWidth=85*cxAveChar;
        spaHeight=28*cyChar;
        addWidth=(cxScreen-spaWidth)/2;
        addHeight=(cyScreen-spaHeight)/2;
        leftCombo=addWidth+6*cxAveChar;
        leftBrk=addWidth+6*cxAveChar;
        leftListBox=addWidth+16*cxAveChar;
        leftRect=addWidth+50*cxAveChar;
        leftText=addWidth+25*cxAveChar;
        topCombo=addHeight+2*cyChar;
        topBrk=addHeight+16*cyChar;
        topListBox=addHeight+18.5*cyChar;
        topRect=addHeight+1.5*cyChar;
        topText=addHeight+1.5*cyChar;
        topBsFunc=addHeight+23*cyChar;
        heightCombo=4*cyChar;
        heightBrk=2*cyChar;
        heightListBox=4*cyChar;
        heightBsFunc=2*cyChar;
        heightRect=cyChar;
        //heightDirRect=18*cyChar;
        heightDirRect=cyScreen-heightBsFunc-4.5*cyChar-heightBrk;
        widthRect=25*cxAveChar;
        widthBsFunc=10*cxAveChar;
        widthListBox=60*cxAveChar;
        widthBrk=12*cxAveChar;
        widthCombo=15*cxAveChar;

        hMenu=LoadMenu(hInst,
                 "SPAMainMenu");
        SetMenu(hWnd,hMenu);
        // create a new font
        hFont=CreateFont(cyChar,cxAveChar,0,0,
                 FW_NORMAL,0,0,0,ANSI_CHARSET,
                 OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
                 DEFAULT_QUALITY, FIXED_PITCH | FF_MODERN,
                 "Courier");
        hOldFont=SelectObject(hDc,hFont);
        hFontFixed=GetStockObject(SYSTEM_FIXED_FONT);
        //create new pens
        lPen.lopnStyle=PS_SOLID;
        lPen.lopnWidth.x=2;
        lPen.lopnWidth.y=0;
        lPen.lopnColor=RGB(225,225,225);
        hWhitePen=CreatePenIndirect(&lPen);
        lPen.lopnColor=RGB(100,100,100);
        hGrayPen=CreatePenIndirect(&lPen);
        hOldPen=SelectObject(hDc,hWhitePen);
        SelectObject(hDc,hOldPen);

        //RegisterHelpEntry(3,hWnd,HE_EVENT);
        nSPAstatus=0;
        SetupModuleAnalysis(hWnd);
        //nSPAstatus=0;

        // initialize the OPENFILENAME
        InitializeOpenFile(&ofn);
        InitSPA();

        //MoveWindow(hWnd,nLeft,nTop,spaWidth,spaHeight,TRUE);
        hCursor=LoadCursor(NULL ,IDC_SIZEWE);
        if ((err=GetBrkPoint())!=GOOD)
           szBrkPoint[0]='\0';
        SetWindowText(hWnd,"SPA  -  Module Analysis");
        break;
     case  WM_TIMER:
        //if (startStop==TRUE && nSPAstatus!=2) {
        if (startStop==TRUE) {
           KillTimer(hWnd,IDM_TIMER);
           if (nSPAstatus==0)
              SpaMAGet(&totalStamp,&dataInfo,&flagStop);
           if (nSPAstatus==1)
              SpaTAGet(timeStamp,dataCount,&flagStop);
           if (nSPAstatus==2) {
              flagStop=0;
              ptrMemTemp=(LPSTR)TMalloc(sizeof(U8));
              SpaCCGet("0000:0000","0000:0001",ptrMemTemp,&flagStop);
              TFree(ptrMemTemp);
           }
           SetTimer(hWnd,IDM_TIMER,3000,NULL);
           if (flagStop==TRUE) {
              KillTimer(hWnd,IDM_TIMER);
              startStop=FALSE;
              EnableWindow(hWndBsFunc[0],TRUE);
              EnableWindow(hWndBsFunc[1],FALSE);
           }
           if (nSPAstatus==2 && flagStop==TRUE) {
              canGetCCFlag=TRUE;
              SendMessage(hWndDir,LB_RESETCONTENT,0,0);
              ReFillDirList();
              SendMessage(hWndDir,LB_SETCURSEL,0,0L);
              if (selectedRangeName[0]!='\0')
                 ProcessLineMarked();
           }
        }
        if (nSPAstatus==0 || nSPAstatus==1) {
           SetRect(&dynamicRect,leftText,topText,leftText+60*cxAveChar,
              topText+20*cyChar);
           InvalidateRect(hWnd,&dynamicRect,TRUE);
           SetRect(&dynamicRect,1*cxAveChar,17*cyChar,80*cxAveChar,
              23*cyChar);
           InvalidateRect(hWnd,&dynamicRect,TRUE);
           //ProcessInvalidateRect(hWnd);
           UpdateWindow(hWnd);
        }
        if (hOldCursor!=NULL) {
           SetCursor(hWndOldCursor);
           hWndOldCursor=NULL;
        }
        break;
     case WM_SYSCOMMAND:
        switch(wParam) {
           case 0xF012:
           case 0xF122:
           case 0xF130:
               return 0;
           default:
              break;
        }
        /*
        if (wParam==0xF012 || wParam=0xF122 || wParam)
           return 0;
        else
           break;
        */
     case WM_LBUTTONDOWN:
        orgPoint=MAKEPOINT(lParam);
        if(PtInRect(&barRect,orgPoint)) {
          tempRect=barRect;
          hWndBar=CreateWindow("static","",
             WS_CHILD|WS_VISIBLE|SS_BLACKRECT,
             orgPoint.x-0.2*cxAveChar,cyChar,0.4*cxAveChar,heightDirRect,
             hWnd,IDE_BAR,GetWindowWord(hWnd,GWW_HINSTANCE),NULL);
          SetCapture(hWnd);
          m_bCapture=1;
          orgLeft=barRect.left;
          orgRight=barRect.right;
          InvalidateRect(hWnd,&barRect,TRUE);
          UpdateWindow(hWnd);
        }
        tempHandle=GetFocus();
        tempControlId=GetWindowWord(tempHandle,GWW_ID);
        if (tempControlId>=110 && tempControlId <=114)
           SendMessage(tempHandle,CB_SHOWDROPDOWN,FALSE,0);
        break;
     case WM_MOUSEMOVE:
        nextPoint=MAKEPOINT(lParam);
        if(PtInRect(&barRect,nextPoint))
           SetCursor(hCursor);
        if (m_bCapture==1) {

           if (nextPoint.x<cxAveChar) {
              SetCursorPos(gCurPos.x,gCurPos.y);
              nextPoint.x=cxAveChar;
           }
           if (nextPoint.x>cxScreen-cxAveChar) {
              SetCursorPos(gCurPos.x,gCurPos.y);
              nextPoint.x=cxScreen-cxAveChar;
           }
           if (nextPoint.x >cxAveChar && nextPoint.x <cxScreen-cxAveChar)
              GetCursorPos(&gCurPos);
           SetCursor(hCursor);
           orgPoint.x=nextPoint.x;
           orgPoint.y=nextPoint.y;
           barRect.left=orgPoint.x-0.5*cxAveChar;
           barRect.right=orgPoint.x+0.5*cxAveChar;
           //if (PtInRect(&tempRect,orgPoint))
              //InvalidateRect(hWnd,&tempRect,TRUE);
           MoveWindow(hWndBar,orgPoint.x-0.2*cxAveChar,cyChar,
              0.4*cxAveChar,heightDirRect,TRUE);
           UpdateWindow(hWnd);
        }
        break;
     case WM_LBUTTONUP:
        if (m_bCapture) {
           m_bCapture=0;
           ReleaseCapture();
           DestroyWindow(hWndBar);
           MoveWindow(hWndDir,cxAveChar,cyChar,
              orgPoint.x-1.5*cxAveChar,heightDirRect,TRUE);
           MoveWindow(hWndTitleList,orgPoint.x+0.5*cxAveChar,
              cyChar,cxScreen-orgPoint.x-1.5*cxAveChar,
              heightDirRect,TRUE);
           orgLeft=barRect.left;
           orgRight=barRect.right;
           InvalidateRect(hWnd,NULL,TRUE);
           UpdateWindow(hWnd);
        }
        break;
     case WM_SYSKEYDOWN:
        switch(wParam) {
           case VK_S:
              if ((HIWORD(lParam) && 0x2fff) >0 )
                 SendMessage(hWndSPA,WM_COMMAND,IDC_BSSTART,0);
              break;
           case VK_T:
              if ((HIWORD(lParam) && 0x2fff) > 0)
                 SendMessage(hWndSPA,WM_COMMAND,IDC_BSSTOP,0);
              break;
           case VK_R:
              if ((HIWORD(lParam) && 0x2fff) > 0)
                 SendMessage(hWndSPA,WM_COMMAND,IDC_BSRANGE,0);
              break;
           case VK_C:
              if ((HIWORD(lParam) && 0x2fff) > 0 )
                 SendMessage(hWndSPA,WM_COMMAND,IDC_BSCLOSE,0);
              break;
           case VK_H:
              if ((HIWORD(lParam) && 0x2fff) > 0)
                 SendMessage(hWnd,WM_COMMAND,IDC_BSHELP,0);
              break;
           case VK_B:
              if ((HIWORD(lParam) && 0x2fff) > 0)
                 SendMessage(hWnd,WM_COMMAND,IDC_BRK,0);
              break;
        }
        break;
     case WM_COMMAND:
        switch(wParam) {
           /*
           case IDE_TITLELIST:
              if (HIWORD(lParam)==LBN_SETFOCUS) {
                 SendMessage(hWndTitleList,LB_SETSEL,TRUE,MAKELONG(5,0));
                 SendMessage(hWndTitleList,LB_SETSEL,TRUE,MAKELONG(10,0));
                 //UpdateWindow(hWndTitleList);
                 SendMessage(hWndTitleList,WM_SETREDRAW,TRUE,0);
                 return 0;
              }
              else
                 break;
           */
           case IDM_SPAFEXIT:
              PostMessage(hWnd,WM_CLOSE,0,0);
              return 0;
           case IDM_SPAMODULA:
              if (startStop==TRUE) {
                 strcpy(str,"Can't switch. Must stop the analysis.");
                 ErrMessageBoxL(str);
              }
              else {
                 ClearUpWindow(0,hWnd);
                 SetupModuleAnalysis(hWnd);
                 SetWindowText(hWndSPA,"SPA  -  Module Analysis");
              }
              return 0;
           case IDM_SPATIME:
              if (startStop==TRUE) {
                 strcpy(str,"Can't switch. Must stop the analysis.");
                 ErrMessageBoxL(str);
              }
              else {
                 ClearUpWindow(1,hWnd);
                 SetupTimeAnalysis(hWnd);
                 SetWindowText(hWndSPA,"SPA  -  Time Analysis");
              }
              return 0;
           case IDM_SPACODE:
              if (startStop==TRUE) {
                 strcpy(str,"Can't switch. Must stop the analysis.");
                 ErrMessageBoxL(str);
              }
              else {
                 ClearUpWindow(2,hWnd);
		 SetupCodeCoverage(hWnd);	   
                 ProcessLineMarked();
                 SetWindowText(hWndSPA,"SPA  -  Code Coverage");
              }
              return 0;
           case IDC_BRK:
              /*
              if ((err=SymGetModuleListHead(&moduleDesc))!=GOOD) {
                 ErrDisplayError(err,FORCE_POPUP);
                 return 0;
              }
              */
              lpBrkProc=MakeProcInstance((FARPROC)BrkDlgProc,
                 hInst);
              i=DialogBox(hInst,"BreakPoint",hWnd,lpBrkProc);
              if (i==1)
                 if ((err=GetBrkPoint())!=GOOD)
                    szBrkPoint[0]='\0';
              InvalidateRect(hWnd,NULL,TRUE);
              UpdateWindow(hWnd);
              return 0;
           case IDC_BSSTART:
              if (nSPAstatus==2) {
                 SpaRangesCountGet(nSPAstatus,&u8Count);
                 if (u8Count==0) {
                    strcpy(str,"Can't start. Not any ranges be seted!!");
                    ErrMessageBoxL(str);
                    return 0;
                 }
              }
              if (nSPAstatus==0 || nSPAstatus==1) {
                 if (nSPAstatus==0)
                    j=4;
                 else
                    j=1;
                 for (i=0;i<j;i++) {
                    SpaRangesActionGet(nSPAstatus,i,szString00);
                    if (szString00[0]!='\0')
                       break;
                 }
                 if (i==j) {
                    strcpy(str,"Can't start. Not any ranges be selected!!");
                    ErrMessageBoxL(str);
                    return 0;
                 }
              }
              EnableWindow(hWndBsFunc[0],FALSE);
              EnableWindow(hWndBsFunc[1],TRUE);
              hWndOldCursor=SetCursor(LoadCursor(NULL,IDC_WAIT));
              SpaStart(nSPAstatus);
              SetTimer(hWnd,IDM_TIMER,3000,NULL);
              startStop=TRUE;
              SendMessage(hWndSPA,WM_TIMER,0,0);
              return 0;
           case IDC_BSSTOP:
              hWndOldCursor=SetCursor(LoadCursor(NULL,IDC_WAIT));
              SpaStop(nSPAstatus);
              SetCursor(hWndOldCursor);
              hWndOldCursor=NULL;
              SendMessage(hWnd,WM_TIMER,0,0);
              /*
              if (nSPAstatus==2) {
                 EnableWindow(hWndBsFunc[0],TRUE);
                 EnableWindow(hWndBsFunc[1],FALSE);
                 KillTimer(hWnd,IDM_TIMER);
                 startStop=FALSE;
                 canGetCCFlag=TRUE;
                 SendMessage(hWndDir,LB_RESETCONTENT,0,0);
                 ReFillDirList();
                 SendMessage(hWndDir,LB_SETCURSEL,0,0L);
                 if (selectedRangeName[0]!='\0')
                    ProcessLineMarked();
              }
              */
              return 0;
           case IDC_BSRANGE:
              lpRangesProc=MakeProcInstance((FARPROC)RangesDlgProc,
                 hInst);
              if (nSPAstatus!=2)
                 i=DialogBox(hInst,"Ranges",hWnd,lpRangesProc);
              else
                 i=DialogBox(hInst,"CCRanges",hWnd,lpRangesProc);
              if (nSPAstatus==2) {
                 SendMessage(hWndDir,LB_RESETCONTENT,0,0);
                 ReFillDirList();
                 SendMessage(hWndDir,LB_SETCURSEL,0,0L);
              }
              return 0;
           case IDC_BSCLOSE:
              PostMessage(hWnd,WM_CLOSE,0,0);
              return 0;
           case IDC_BSHELP:
              //xx=SendMessage(hWndTitleList,LB_SETSEL,TRUE,MAKELONG(1,0));
              //xx=SendMessage(hWndTitleList,LB_SETSEL,TRUE,MAKELONG(6,0));
              //SendMessage(hWndTitleList,WM_SETREDRAW,TRUE,0);
              //ProcessLineMarked();
              WinHelp(hWnd,"PWRVIEWS.HLP",HELP_CONTEXT,2080);
              return 0;
           case IDC_BSASM:
              if (asmFlag=='N') {
                 SetWindowText(hWndBsFunc[5],(LPSTR)"Source");
                 asmFlag='Y';
              }
              else {
                 SetWindowText(hWndBsFunc[5],(LPSTR)"Asm");
                 asmFlag='N';
	      }
	      if(selectedRangeName[0] != '\0'){ //For ID:172 Hera 12/17/97
                 GetRangeTextBasedOnRangeName(selectedRangeName,
                    startText,endText);
                 GetFuncCode(startText,endText,"");
		 ProcessLineMarked();
              }
              return 0;
           case IDC_RANGE00:
           case IDC_RANGE01:
           case IDC_RANGE02:
           case IDC_RANGE03:
           case IDC_RANGE04:
              if (HIWORD(lParam)==CBN_SETFOCUS) {
                 SpaRangesCountGet(nSPAstatus,&u8Count);
                 nIndex=SendMessage(LOWORD(lParam),CB_GETCURSEL,0,0);
                 SendMessage(LOWORD(lParam),CB_GETLBTEXT,(WPARAM)nIndex,
                    (LPARAM)(LPSTR)szString03);
                 SendMessage(LOWORD(lParam),CB_RESETCONTENT,0,0);
                 strcpy(szString00,"(Clear)");
                 SendMessage(LOWORD(lParam),CB_ADDSTRING,
                    0,(LPARAM)(LPSTR)szString00);
                 for (i=0;i<u8Count;i++) {
                    SpaRangesGetByIndex(i,nSPAstatus,szString00,
                       szString01,szString02,&u8Selected);
                    SendMessage(LOWORD(lParam),CB_ADDSTRING,
                       0,(LPARAM)(LPSTR)szString00);
                 }
                 SendMessage(LOWORD(lParam),CB_SELECTSTRING,0,
                    (LPARAM)(LPSTR)szString03);
              }
              if (HIWORD(lParam)==CBN_CLOSEUP) {
                 nIndex=SendMessage(LOWORD(lParam),CB_GETCURSEL,0,0);
                 SendMessage(LOWORD(lParam),CB_GETLBTEXT,(WPARAM)nIndex,
                    (LPARAM)(LPSTR)szString00);
                 if (nSPAstatus==0) {
                    for (i=0;i<4;i++) {
                       SpaRangesActionGet(nSPAstatus,i,szString01);
                       if (strcmp(szString00,szString01)==0) {
                          SpaRangesActionGet(nSPAstatus,wParam-110,szString02);
                          if (szString02[0]=='\0')
                             SendMessage(LOWORD(lParam),CB_SELECTSTRING,-1,
                                (LPARAM)(LPSTR)"(Clear)");
                          else
                             SendMessage(LOWORD(lParam),CB_SELECTSTRING,-1,
                                (LPARAM)(LPSTR)szString02);
                          if (strcmp(szString02,szString00)!=0)
                             MessageBox(hWnd,"duplicated range is set.","MP/SLD",
                                MB_OK);
                          return 0;
                       }
                    }
                    SpaRangesActionGet(0,wParam-110,szString01);
                    SpaRangesActionClear(szString01,0);
                 }
                 if (nSPAstatus==1) {
                    SpaRangesActionGet(nSPAstatus,0,szString01);
                    if (strcmp(szString00,szString01)==0) {
                       SpaRangesActionGet(nSPAstatus,0,szString02);
                       if (szString02[0]=='\0')
                          SendMessage(LOWORD(lParam),CB_SELECTSTRING,-1,
                             (LPARAM)(LPSTR)"(Clear)");
                       else
                          SendMessage(LOWORD(lParam),CB_SELECTSTRING,-1,
                             (LPARAM)(LPSTR)szString02);
                       if (strcmp(szString00,szString02)!=0)
                          MessageBox(hWnd,"duplicated range is set","MP/SLD",
                             MB_OK);
                       return 0;
                    }
                    SpaRangesActionGet(1,0,szString01);
                    SpaRangesActionClear(szString01,1);
                 }
                 if (strcmp(szString00,"(Clear)")!=0) {
                    //BarInitialization();
                    if (nSPAstatus==0)
                       SpaRangesActionSet(szString00,0,wParam-110);
                    if (nSPAstatus==1)
                       SpaRangesActionSet(szString00,1,0);
                 }
                 if (nSPAstatus==0) {
                    /*
                    SendMessage(hWndListBox,LB_RESETCONTENT,0,0);
                    for (i=0;i<4;i++) {
                       SpaRangesActionGet(nSPAstatus,i,szString00);
                       if (szString00[0]!='\0') {
                          SpaRangesGet(szString00,szString01,szString02);
                          wsprintf(szString03,"%-15s %-10s...%-10s",
                             szString00,szString01,szString02);
                          SendMessage(hWndListBox,LB_ADDSTRING,0,
                             (LPARAM)(LPSTR)szString03);
                       }
                    }
                    */
                    InvalidateHwndListBox();
                 }
              }
              break;
        }
        break;
     case WM_PAINT :
        hDc=BeginPaint(hWnd,&ps);
        SelectObject(hDc,hFont);
        if (nSPAstatus==0)
           WmPaintModuleAnalysis(hDc);
        else if (nSPAstatus==1)
           WmPaintTimeAnalysis(hDc);
        else
           WmPaintCodeCoverage(hDc);
        EndPaint(hWnd,&ps);
        break;
     case WM_CLOSE:
        DestroyWindow(hWnd);
        canGetCCFlag=FALSE;
        hWndSPA=NULL;
        SpaClose();
        break;
     case WM_DESTROY :
        hWndSPA=NULL;
        DeleteObject(hFontFixed);
        //PostQuitMessage (0);
        break;
  }
  return DefWindowProc (hWnd, message, wParam, lParam);
}
/************************************************************************
**
**          ComboxProc
**
*************************************************************************/
long FAR PASCAL ComboxProc(HWND hWnd, UINT message,
                         UINT wParam, LONG lParam) {
   if (message == WM_SYSKEYDOWN) {
      SendMessage(GetParent(hWnd),WM_SYSKEYDOWN,wParam,
          lParam);
   }
   return CallWindowProc(lpfnOldCombox,hWnd,message,wParam,lParam);
}
/*****************************************************************************
**
**  BarInitialization
**
*****************************************************************************/
RETCODE BarInitialization(VOID) {
U8 i;
   //if (nSPAstatus==0) {
      totalStamp=0;
      for (i=0;i<4;i++) {
         dataInfo[i].count=0;
         dataInfo[i].Stamp=0;
      }
   //}
   //if (nSPAstatus==1) {
      for (i=0;i<3;i++)
         timeStamp[i]=0;
      for (i=0;i<9;i++)
         dataCount[i]=0;
   //}
   return GOOD;
}
/*****************************************************************************
**
**  nCwRegisterClasses
**
*****************************************************************************/
int nCwRegisterClasses(VOID) {
   WNDCLASS   wndclass;    /* struct to define a window class */
   HINSTANCE hInstance;
   HWND hToolBar;
   memset(&wndclass, 0x00, sizeof(WNDCLASS));

  if (GetToolBarHandle((HANDLE FAR *) &hToolBar) == GOOD) {
     hInstance = ((HINSTANCE) GetWindowWord(hToolBar, GWW_HINSTANCE));
     wndclass.hIcon = LoadIcon(hInstance, "SPA");
  }

   /* load WNDCLASS with window's characteristics */
   wndclass.style = CS_HREDRAW | CS_VREDRAW; // | CS_BYTEALIGNWINDOW;
   wndclass.lpfnWndProc = SPAWndProc;

   /* Extra storage for Class and Window objects  */
   wndclass.cbClsExtra = 0;
   wndclass.cbWndExtra = 0;
   wndclass.hInstance = hInst;
   wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);

   /* Create brush for erasing background */
   //wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
   wndclass.hbrBackground = GetStockObject(LTGRAY_BRUSH);
   wndclass.lpszMenuName = "SPAMainMenu";   /* Menu Name is App Name */
   wndclass.lpszClassName = szAppName; /* Class Name is App Name */
   if (!RegisterClass(&wndclass))
      return -1;
   return(0);
}

/*****************************************************************************
**
**  SPAOpenWindow
**
*****************************************************************************/
RETCODE EXPORT SPAOpenWindow(int left,int top,int width,
     int height,DWORD dwStyle,DWORD dwExStyle,HWND *SPAWindow) {
RETCODE err=GOOD;

   if (hWndSPA == NULL) {
      err = CreateSPAPresenter(hLib, top,left,
               width, height);
      *SPAWindow = hWndSPA;
    }
    return err;
}

/*****************************************************************************
**
**  SPACloseWindow
**
*****************************************************************************/
RETCODE EXPORT SPACloseWindow() {
   if (hWndSPA != NULL) {
      //DestroyWindow(hWndSPA);
      hWndSPA = NULL;
   }
   return GOOD;
}

/*****************************************************************************
**
**  SPAExistsWindow
**
*****************************************************************************/
RETCODE EXPORT SPAExistsWindow(HWND *SPAHandle) {
   *SPAHandle = hWndSPA;
   return (GOOD);
}
/*****************************************************************************
**
**  SetupModuleAnalysis
**
*****************************************************************************/
void SetupModuleAnalysis(HWND hWnd) {
int i,j;
U8 u8Count,u8Selected;
char szString00[MAXLEN],szString01[11*MAX_SEG_NUM];
char szString02[11*MAX_SEG_NUM];

   SpaRangesCountGet(nSPAstatus,&u8Count);
   for (i=0;i<4;i++) {
      hWndRange[i] = CreateWindow( "combobox",NULL,
         WS_CHILD | WS_VISIBLE | WS_VSCROLL
         | CBS_DROPDOWNLIST |CBS_SORT,
         leftCombo,topCombo+i*3*cyChar,
         widthCombo, 1.5*heightCombo,
         hWnd, IDC_RANGE00+i,
         GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
         strcpy(szString00,"(Clear)");
         SendMessage(hWndRange[i],CB_ADDSTRING,
            0,(LPARAM)(LPSTR)szString00);
         for (j=0;j<u8Count;j++) {
            SpaRangesGetByIndex(j,nSPAstatus,szString00,szString01,
               szString02,&u8Selected);
            SendMessage(hWndRange[i],CB_ADDSTRING,
               0,(LPARAM)(LPSTR)szString00);
         }
         SpaRangesActionGet(0,i,szString00);
         if (szString00[0]=='\0')
            SendMessage(hWndRange[i],CB_SELECTSTRING,-1,
               (LPARAM)(LPSTR)"(Clear)");
         else
            SendMessage(hWndRange[i],CB_SELECTSTRING,-1,
               (LPARAM)(LPSTR)szString00);
   }
   hWndBrk = CreateWindow( "button", "&Breakpoint",
      WS_CHILD|WS_VISIBLE,
      leftBrk,topBrk,
      widthBrk,heightBrk,
      hWnd, IDC_BRK,
      GetWindowWord(hWnd,GWW_HINSTANCE), NULL);

   hWndListBox = CreateWindow( "listbox", "Ranges:",
      WS_CHILD|WS_VISIBLE|WS_BORDER | WS_VSCROLL,
      leftListBox,topListBox,
      widthListBox,heightListBox,
      hWnd, IDC_RANGELIST,
      GetWindowWord(hWnd,GWW_HINSTANCE), NULL);

   for (i=0;i<2;i++)
      hWndBsFunc[i] = CreateWindow( "button", bsName[i],
         WS_CHILD | WS_VISIBLE,
         addWidth+6*cxAveChar+i*(widthBsFunc+3*cxAveChar),topBsFunc,
         widthBsFunc,heightBsFunc,
         hWnd, IDC_BSSTART+i,
         GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   EnableWindow(hWndBsFunc[0],TRUE);
   EnableWindow(hWndBsFunc[1],FALSE);
   for (i=2;i<5;i++)
      hWndBsFunc[i] = CreateWindow( "button", bsName[i],
         WS_CHILD | WS_VISIBLE,
         addWidth+6*cxAveChar+i*(widthBsFunc+5*cxAveChar),topBsFunc,
         widthBsFunc,heightBsFunc,
         hWnd, IDC_BSSTART+i,
         GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   SendMessage(hWndListBox,WM_SETFONT,hFontFixed,0);
   InvalidateHwndListBox();
   UpdateWindow (hWnd);
}
/*****************************************************************************
**
**  InvalidateHwndListBox
**
*****************************************************************************/
RETCODE InvalidateHwndListBox(VOID){
U8 i;
char szString00[MAXLEN],szString01[MAXLEN],szString02[MAXLEN];
char szString03[11*MAX_SEG_NUM];
   SendMessage(hWndListBox,LB_RESETCONTENT,0,0);
   for (i=0;i<4;i++) {
      SpaRangesActionGet(nSPAstatus,i,szString00);
      if (szString00[0]!='\0') {
         SpaRangesGet(nSPAstatus,szString00,szString01,szString02);
         wsprintf(szString03,"%-15s %-10s...%-10s",
            szString00,szString01,szString02);
         SendMessage(hWndListBox,LB_ADDSTRING,0,
            (LPARAM)(LPSTR)szString03);
      }
   }
   return GOOD;
}
/*****************************************************************************
**
**  InvalidateMAorTACombo
**
*****************************************************************************/
RETCODE InvalidateMAorTACombo(VOID) {
   if (nSPAstatus==0) {
      ClearUpWindow(0,hWndSPA);
      SetupModuleAnalysis(hWndSPA);
   }
   else if (nSPAstatus==1) {
      ClearUpWindow(1,hWndSPA);
      SetupTimeAnalysis(hWndSPA);
   }
   else if (nSPAstatus==2) {
      SendMessage(hWndDir,LB_RESETCONTENT,0,0);
      ReFillDirList();
      SendMessage(hWndDir,LB_SETCURSEL,0,0L);
   }
   return GOOD;
}
/*****************************************************************************
**
**  SetupTimeAnalysis
**
*****************************************************************************/
void SetupTimeAnalysis(HWND hWnd) {
int i;
U8 u8Count,u8Selected;
char szString00[MAXLEN],szString01[11*MAX_SEG_NUM],szString02[11*MAX_SEG_NUM];
   SpaRangesCountGet(nSPAstatus,&u8Count);
   hWndRange[4] = CreateWindow( "combobox",NULL,
      WS_CHILD | WS_VISIBLE | WS_VSCROLL
      | CBS_DROPDOWNLIST |CBS_SORT,
      addWidth+5*cxAveChar,addHeight+2*cyChar,20*cxAveChar,1.5*heightCombo,
      hWnd, IDC_RANGE04,
      GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   strcpy(szString00,"(Clear)");
   SendMessage(hWndRange[4],CB_ADDSTRING,0,(LPARAM)(LPSTR)szString00);
   for (i=0;i<u8Count;i++) {
      SpaRangesGetByIndex(i,nSPAstatus,szString00,szString01,
         szString02,&u8Selected);
      SendMessage(hWndRange[4],CB_ADDSTRING,
         0,(LPARAM)(LPSTR)szString00);
   }
   SpaRangesActionGet(1,0,szString00);
   if (szString00[0]=='\0')
      SendMessage(hWndRange[4],CB_SELECTSTRING,-1,
         (LPARAM)(LPSTR)"(Clear)");
   else
      SendMessage(hWndRange[4],CB_SELECTSTRING,-1,
         (LPARAM)(LPSTR)szString00);
   hWndBrk = CreateWindow( "button", "&Breakpoint",
      WS_CHILD|WS_VISIBLE,
      addWidth+48*cxAveChar,addHeight+2*cyChar,
      12*cxAveChar,1.5*cyChar,
      hWnd, IDC_BRK,
      GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   for (i=0;i<2;i++)
      hWndBsFunc[i] = CreateWindow( "button", bsName[i],
         WS_CHILD | WS_VISIBLE,
         addWidth+6*cxAveChar+i*(widthBsFunc+3*cxAveChar),topBsFunc,
         widthBsFunc,heightBsFunc,
         hWnd, IDC_BSSTART+i,
         GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   EnableWindow(hWndBsFunc[0],TRUE);
   EnableWindow(hWndBsFunc[1],FALSE);
   for (i=2;i<5;i++)
      hWndBsFunc[i] = CreateWindow( "button", bsName[i],
         WS_CHILD | WS_VISIBLE,
         addWidth+6*cxAveChar+i*(widthBsFunc+5*cxAveChar),topBsFunc,
         widthBsFunc,heightBsFunc,
         hWnd, IDC_BSSTART+i,
         GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   InvalidateRect(hWnd,NULL,TRUE);
   UpdateWindow (hWnd);
}
/*****************************************************************************
**
**  SetupCodeCoverage
**
*****************************************************************************/
void SetupCodeCoverage(HWND hWnd) {
int i;
char szString00[MAXLEN],szString01[MAXLEN];
   //InitialModuleList();
   //canGetCCFlag=FALSE;
   SetRect(&barRect,22*cxAveChar,cyChar,
      23*cxAveChar,cyChar+heightDirRect);
   orgLeft=barRect.left;
   orgRight=barRect.right;
   SetRect(&listRect,0,0,cxAveChar,heightDirRect);
   //orgPoint.x=addWidth+22.5*cxAveChar;
   orgPoint.x=22.5*cxAveChar;
   hWndTitleList = CreateWindow( "listbox","",
      WS_CHILD | WS_VISIBLE | WS_BORDER|WS_CLIPSIBLINGS
      |WS_HSCROLL|WS_VSCROLL|LBS_MULTIPLESEL,
      /*|ES_READONLY|ES_NOHIDESEL|LBS_NOREDRAW|ES_MULTILINE*/
      23*cxAveChar,cyChar,cxScreen-1.5*cxAveChar-orgPoint.x,
      heightDirRect,
      hWnd, IDE_TITLELIST,
      GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   SendMessage(hWndTitleList,LB_SETHORIZONTALEXTENT,800,0);
   lpfnOldFuncText = (FARPROC)GetWindowLong(
      hWndTitleList,GWL_WNDPROC);
   SetWindowLong(hWndTitleList,GWL_WNDPROC,
      (LONG)MakeProcInstance((FARPROC)FuncTextProc,
      GetWindowWord(hWnd,GWW_HINSTANCE)));
   hWndDir = CreateWindow( "listbox","",
      WS_CHILD | WS_VISIBLE | WS_BORDER|WS_CLIPSIBLINGS|
      WS_VSCROLL,
      //addWidth+2*cxAveChar,addHeight+cyChar,orgPoint.x-addWidth-2.5*cxAveChar,
      //heightDirRect,
      cxAveChar,cyChar,orgPoint.x-1.5*cxAveChar,
      heightDirRect,
      hWnd, IDE_DIR,
      GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   ReFillDirList();
   heightItem=SendMessage(hWndDir,LB_GETITEMHEIGHT,0,0L);
   SendMessage(hWndDir,LB_SETCURSEL,0,0L);
   SendMessage(hWndDir,WM_SETFONT,hFontFixed,0);
   lpfnOldListBox = (FARPROC)GetWindowLong(
      hWndDir,GWL_WNDPROC);
   SetWindowLong(hWndDir,GWL_WNDPROC,
      (LONG)MakeProcInstance((FARPROC)ListBoxProc,
      GetWindowWord(hWnd,GWW_HINSTANCE)));
   hWndBrk = CreateWindow( "button", "&Breakpoint",
      WS_CHILD|WS_VISIBLE,
      leftBrk,cyScreen-heightBsFunc-2.5*cyChar-heightBrk,
      widthBrk,heightBrk,
      hWnd, IDC_BRK,
      GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   for (i=0;i<3;i++)
      hWndBsFunc[i] = CreateWindow( "button", bsName_Code[i],
         WS_CHILD | WS_VISIBLE,
         addWidth+4*cxAveChar+i*(widthBsFunc+3*cxAveChar),
         cyScreen-heightBsFunc-2*cyChar,
         widthBsFunc,heightBsFunc,
         hWnd, IDC_BSSTART+i,
         GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   i=3;
   hWndBsFunc[5] = CreateWindow( "button", bsName_Code[i],
      WS_CHILD | WS_VISIBLE,
      addWidth+4*cxAveChar+i*(widthBsFunc+3*cxAveChar),
      cyScreen-heightBsFunc-2*cyChar,
      widthBsFunc,heightBsFunc,
      hWnd, IDC_BSSTART+5,
      GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   for (i=4;i<6;i++)
      hWndBsFunc[i-1] = CreateWindow( "button", bsName_Code[i],
         WS_CHILD | WS_VISIBLE,
         addWidth+4*cxAveChar+i*(widthBsFunc+3*cxAveChar),
         cyScreen-heightBsFunc-2*cyChar,
         widthBsFunc,heightBsFunc,
         hWnd, IDC_BSSTART+i-1,
         GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
   EnableWindow(hWndBsFunc[0],TRUE);
   EnableWindow(hWndBsFunc[1],FALSE);
   if (asmFlag=='Y')
      SetWindowText(hWndBsFunc[5],(LPSTR)"Source");
   strcpy(szString00,ccmoduleName);
   strcpy(szString01,ccfuncName);
   if (ccmoduleName[0]!='\0')
      GetFuncCode(szString00,szString01,"");
   InvalidateRect(hWnd,NULL,TRUE);
   UpdateWindow(hWnd);
}
/*****************************************************************************
**
**  WmPaintModuleAnalysis
**
*****************************************************************************/
void WmPaintModuleAnalysis(HDC hDc) {
int i;
char           szString01[]="Count:";
char           szString02[]=" Time:";
char           szString03[]="TotalCount:";
char           szString04[]="Execution break at:";
char           szString05[]="Range:";
char           szString06[]="TotalTime:";
   MoveTo(hDc,addWidth+5*cxAveChar,addHeight+15*cyChar);
   SelectObject(hDc,hGrayPen);
   LineTo(hDc,addWidth+5*cxAveChar,addHeight+cyChar);
   LineTo(hDc,addWidth+80*cxAveChar,addHeight+cyChar);
   SelectObject(hDc,hWhitePen);
   LineTo(hDc,addWidth+80*cxAveChar,addHeight+15*cyChar);
   LineTo(hDc,addWidth+5*cxAveChar,addHeight+15*cyChar);
   SelectObject(hDc,hOldPen);
   for (i=0;i<8;i++)
      //leftRect=124,topRect=8+i*10
      //widthRect=100,heightRect=8
      Rectangle(hDc,leftRect,topRect+1.5*cyChar*i,leftRect+widthRect,
                       topRect+1.5*cyChar*i+heightRect);
   SetBkMode(hDc,TRANSPARENT);
   for (i=0;i<4;i++) {
      TextOut(hDc,leftText,topText+i*3*cyChar,
         szString01,strlen(szString01));
      TextOut(hDc,leftText,topText+i*3*cyChar+1.5*cyChar,
         szString02,strlen(szString02));
   }
   TextOut(hDc,leftText-15*cxAveChar,addHeight+13.5*cyChar,szString03,
      strlen(szString03));
   TextOut(hDc,leftText+15*cxAveChar,addHeight+13.5*cyChar,szString06,
      strlen(szString06));
   TextOut(hDc,leftBrk+widthBrk+2*cxAveChar,topBrk+0.5*cyChar,szString04,
      strlen(szString04));
   TextOut(hDc,leftBrk+widthBrk+28*cxAveChar,topBrk+0.5*cyChar,szBrkPoint,
      strlen(szBrkPoint));
   TextOut(hDc,leftListBox-10*cxAveChar,topListBox,szString05,
      strlen(szString05));
   ProcessSpaMAGet(hDc);
}

/*****************************************************************************
**
**  WmPaintTimeAnalysis
**
*****************************************************************************/
void WmPaintTimeAnalysis(HDC hDc) {
int i;
char szString00[]="Range";
char szString01[]="Execution break at";
char szString02[]="Time Range";
char szString03[]="Count";
char szString04[]="Average:";
char szString05[]="Longest:";
char szString06[]="Shortest:";
char szString07[]="~";
//char szString08[]="Execution Break at:";
char szString10[]="BreakPoint is:";
char szString11[]="us";
char szStringa[9][MAXLEN]={"       ",
                          "  10us ",
                          " 100us ",
                          "   1ms ",
                          "  10ms ",
                          " 100ms ",
                          "  1sec ",
                          " 10sec ",
                          "100sec "};
char szStringb[9][MAXLEN]={"   10us    ",
                          "  100us    ",
                          "    1ms    ",
                          "   10ms    ",
                          "  100ms    ",
                          "   1sec    ",
                          "  10sec    ",
                          " 100sec    ",
                          "           "};

   SetBkMode(hDc,TRANSPARENT);
   SelectObject(hDc,hGrayPen);
   //Rectangle(hDc,10,10,200,55);
   MoveTo(hDc,addWidth+3*cxAveChar,addHeight+cyChar);
   LineTo(hDc,addWidth+10*cxAveChar,addHeight+cyChar);
   MoveTo(hDc,addWidth+17*cxAveChar,addHeight+cyChar);
   LineTo(hDc,addWidth+40*cxAveChar,addHeight+cyChar);
   LineTo(hDc,addWidth+40*cxAveChar,addHeight+4*cyChar);
   LineTo(hDc,addWidth+3*cxAveChar,addHeight+4*cyChar);
   LineTo(hDc,addWidth+3*cxAveChar,addHeight+cyChar);
   TextOut(hDc,addWidth+10*cxAveChar,addHeight+0.5*cyChar,
      szString00,strlen(szString00));
   //Rectangle(hDc,220,10,410,55);
   MoveTo(hDc,addWidth+45*cxAveChar,addHeight+cyChar);
   LineTo(hDc,addWidth+52*cxAveChar,addHeight+cyChar);
   MoveTo(hDc,addWidth+75*cxAveChar,addHeight+cyChar);
   LineTo(hDc,addWidth+82*cxAveChar,addHeight+cyChar);
   LineTo(hDc,addWidth+82*cxAveChar,addHeight+4*cyChar);
   LineTo(hDc,addWidth+45*cxAveChar,addHeight+4*cyChar);
   LineTo(hDc,addWidth+45*cxAveChar,addHeight+cyChar);
   TextOut(hDc,addWidth+52*cxAveChar,addHeight+0.5*cyChar,
      szString01,strlen(szString01));
   TextOut(hDc,addWidth+10*cxAveChar,addHeight+5.5*cyChar,
      szString02,strlen(szString02));
   TextOut(hDc,addWidth+32*cxAveChar,addHeight+5.5*cyChar,
      szString03,strlen(szString03));
   //Rectangle(hDc,10,80,410,265);
   MoveTo(hDc,addWidth+3*cxAveChar,addHeight+19*cyChar);
   LineTo(hDc,addWidth+3*cxAveChar,addHeight+5*cyChar);
   LineTo(hDc,addWidth+82*cxAveChar,addHeight+5*cyChar);
   SelectObject(hDc,hWhitePen);
   LineTo(hDc,addWidth+82*cxAveChar,addHeight+19*cyChar);
   LineTo(hDc,addWidth+3*cxAveChar,addHeight+19*cyChar);
   for (i=0;i<9;i++) {
      //leftRect=124,topRect=8+i*10
      //widthRect=100,heightRect=8
      Rectangle(hDc,addWidth+50*cxAveChar,addHeight+7*cyChar+i*cyChar*1.2,
         addWidth+80*cxAveChar,addHeight+7.7*cyChar+i*1.2*cyChar);
      TextOut(hDc,addWidth+7*cxAveChar,addHeight+7*cyChar+i*cyChar*1.2,
         szStringa[i],strlen(szStringa[i]));
      TextOut(hDc,addWidth+15*cxAveChar,addHeight+7*cyChar+i*cyChar*1.2,
         szString07,strlen(szString07));
      TextOut(hDc,addWidth+16*cxAveChar,addHeight+7*cyChar+i*cyChar*1.2,
         szStringb[i],strlen(szStringb[i]));
   }
  TextOut(hDc,addWidth+5*cxAveChar,addHeight+20*cyChar,
     szString04,strlen(szString04));
  TextOut(hDc,addWidth+25*cxAveChar,addHeight+20*cyChar,
     szString11,strlen(szString11));
  TextOut(hDc,addWidth+30*cxAveChar,addHeight+20*cyChar,
     szString05,strlen(szString05));
  TextOut(hDc,addWidth+50*cxAveChar,addHeight+20*cyChar,
     szString11,strlen(szString11));
  TextOut(hDc,addWidth+55*cxAveChar,addHeight+20*cyChar,
     szString06,strlen(szString06));
  TextOut(hDc,addWidth+75*cxAveChar,addHeight+20*cyChar,
     szString11,strlen(szString11));
  TextOut(hDc,addWidth+62*cxAveChar,addHeight+1.5*cyChar,
     szString10,strlen(szString10));
  TextOut(hDc,addWidth+65*cxAveChar,addHeight+2.7*cyChar,
     szBrkPoint,strlen(szBrkPoint));
  ProcessSpaTAGet(hDc);
}

/*****************************************************************************
**
**  WmPaintCodeCoverage
**
*****************************************************************************/
void WmPaintCodeCoverage(HDC hDc) {
char           szString00[]="Execution break at:";
   //if (m_bCapture==0) {
      //shadow hwnddir
      SelectObject(hDc,hGrayPen);
      MoveTo(hDc,0.7*cxAveChar,1.3*cyChar+heightDirRect);
      LineTo(hDc,0.7*cxAveChar,0.7*cyChar);
      LineTo(hDc,orgLeft+0.2*cxAveChar,0.7*cyChar);
      SelectObject(hDc,hWhitePen);
      LineTo(hDc,orgLeft+0.2*cxAveChar,
         1.3*cyChar+heightDirRect);
      LineTo(hDc,0.7*cxAveChar,1.3*cyChar+heightDirRect);
      //shador titlelist
      SelectObject(hDc,hGrayPen);
      MoveTo(hDc,orgRight-0.3*cxAveChar,
         1.3*cyChar+heightDirRect);
      LineTo(hDc,orgRight-0.3*cxAveChar,0.7*cyChar);
      LineTo(hDc,cxScreen-0.7*cxAveChar,0.7*cyChar);
      SelectObject(hDc,hWhitePen);
      LineTo(hDc,cxScreen-0.7*cxAveChar,1.3*cyChar+heightDirRect);
      LineTo(hDc,orgRight-0.3*cxAveChar,1.3*cyChar+heightDirRect);
      SetBkMode(hDc,TRANSPARENT);
      SelectObject(hDc,hGrayPen);
      TextOut(hDc,leftBrk+widthBrk+2*cxAveChar,
         cyScreen-heightBsFunc-2*cyChar-heightBrk,szString00,
         strlen(szString00));
      TextOut(hDc,leftBrk+widthBrk+28*cxAveChar,
         cyScreen-heightBsFunc-2*cyChar-heightBrk,szBrkPoint,
         strlen(szBrkPoint));
   //}
}
/*****************************************************************************
**
**  ClearUpWindow()
**
*****************************************************************************/
void ClearUpWindow(int status,HWND hWnd) {
int i;
   if (nSPAstatus==0) {
      for (i=0;i<4;i++)
         DestroyWindow(hWndRange[i]);
      for (i=0;i<6;i++)
         DestroyWindow(hWndBsFunc[i]);
      DestroyWindow(hWndBrk);
      DestroyWindow(hWndListBox);
   }
   if (nSPAstatus==1) {
      for (i=0;i<6;i++)
         DestroyWindow(hWndBsFunc[i]);
      DestroyWindow(hWndBrk);
      DestroyWindow(hWndRange[4]);
   }
   if (nSPAstatus==2) {
      for (i=0;i<7;i++)
         DestroyWindow(hWndBsFunc[i]);
      //hWndOldMemTitleList=PostMessage(hWndTitleList,EM_GETHANDLE,0,0l);
      //LocalFree(hWndOldMemTitleList);
      DestroyWindow(hWndBrk);
      DestroyWindow(hWndDir);
      DestroyWindow(hWndTitleList);
      DestroyWindow(hWndBar);
   }
   nSPAstatus=status;
   //BarInitialization();
   InvalidateRect(hWnd,NULL,TRUE);
   UpdateWindow(hWnd);
}
/****************************************************************
**
**     BrkDlgProc
**
*****************************************************************/
BOOL FAR PASCAL BrkDlgProc (HWND hDlg, UINT message,
                UINT wParam, LONG lParam) {
PAINTSTRUCT ps;
char szString02[MAXLEN],szString00[MAXLEN],szString01[MAXLEN];
char tempString[MAXLEN];
DESCRIPTOR addrDesc;
HDC hDc;
RETCODE err;
U16 addrSegValue;
U32 addrOffset;
ADDR_SEGSEL_TYPE addrSegText;

   switch(message) {
      case WM_INITDIALOG:
         //get module name list
         ListModuleAndFuncName(hDlg,IDB_MODULES,IDB_FUNCTIONS,
            IDB_BRKPOINT);
         return 0;
      case WM_COMMAND:
         switch(wParam) {
            case IDB_MODULES:
            case IDB_FUNCTIONS:
               if (HIWORD(lParam)==CBN_SELCHANGE && wParam==IDB_MODULES) {
		  SelectModuleAndFuncName(hDlg,IDB_MODULES,IDB_FUNCTIONS,
                     IDB_BRKPOINT);
               }
               if (HIWORD(lParam)==CBN_CLOSEUP) {
                  szString02[0]='\0';
                  GetDlgItemText(hDlg,IDB_MODULES,szString00,sizeof(szString00));
                  if (IsWindowEnabled(GetDlgItem(hDlg,IDB_FUNCTIONS)))
                     GetDlgItemText(hDlg,IDB_FUNCTIONS,szString01,sizeof(szString01));
                  else
                     szString01[0]='\0';
                  if ((szString00[0]!='\0') && (szString01[0]!='\0'))
                     wsprintf(szString02,"#%s#%s",szString00,szString01);
                  else if (szString00[0]!='\0')
                      wsprintf(szString02,"#%s",szString00);
                  else if (szString01[0]!='\0')
                      wsprintf(szString02,"#%s",szString01);
                  SetDlgItemText(hDlg,IDB_BRKPOINT,szString02);
               }
               return 0;
            case IDB_OK:
               //err=BxRemoveAllBkpts();
               GetDlgItemText(hDlg,IDB_BRKPOINT,szString00,sizeof(szString00));
               //strcpy(szBrkPoint,szString00);
               strcpy(tempString,szString00);
               DeleteBlank(tempString,szString00);
               if (szString00[0]!='\0') {
                  if ((_fstrpbrk(szString00,":")==NULL) &&
                     (_fstrpbrk(szString00,"#")==NULL)) {
                     if ((szString00[strlen(szString00)-1]=='p') ||
                        (szString00[strlen(szString00)-1]=='P')) {
                        err=ER_ADR_TYPE_NOT_SUPPORTED;
                        ErrDisplayError(err,FORCE_POPUP);
                        return 0;
                      }
                      wsprintf(szString01,"CS:%s",szString00);
                      strcpy(szString00,szString01);
                  }
                  if ((err=AdrCreateAddressFromText(szString00,
                     NULL,&addrDesc))!=GOOD) {
                     ErrDisplayError(err,FORCE_POPUP);
                     szBrkPoint[0]='\0';
		     SetDlgItemText(hDlg,IDB_BRKPOINT,szBrkPoint);                  
                     return 0;
                  }
                  /* avoid the physical address*/
                  /*
                  if ((err=AdrGetAddrType(addrDesc,&addrType))!=GOOD)
                     return err;
                  if (addrType==ADDR_PHYSICAL) {
                     err=ER_ADR_TYPE_NOT_SUPPORTED;
                     ErrDisplayError(err,FORCE_POPUP);
                     return 0;
                  }
                  */
		  if ((err=AdrConvAddressToText(addrDesc,szString00))!=GOOD)
                     return 1;
                     //return err;
		  if ((err=AdrGetAddrOffset(addrDesc,&addrOffset))!=GOOD)
                     return 1;
                     //return err;
                  if ((err=AdrGetAddrSegmentSelector(addrDesc,&addrSegText,
		     &addrSegValue))!=GOOD)
		     return 1;
                     //return err;
                  AdrDestroyAddress(addrDesc);
                  //strcpy(szBrkPoint,szString00);
                  SpaSetBkpt(addrSegValue,addrOffset);
               }
               else
                  SpaSetBkpt(0xffffffffl,0xffffffffl);
               /*
               if ((err=BxSetBkpt(BX_ENABLED,BX_PERMANENT,addrDesc,
                  &brkDesc))!=GOOD) {
                  ErrDisplayError(err,FORCE_POPUP);
                  szBrkPoint[0]='\0';
                  SetDlgItemText(hDlg,IDB_BRKPOINT,szBrkPoint);
                  return 0;
               }
               */
               //AdrDestroyAddress(addrDesc);
               EndDialog(hDlg,TRUE);
               return 0;
            case IDSYSCANCEL:
            case IDB_CANCEL:
               EndDialog(hDlg,TRUE);
               return 0;
            case IDB_HELP:
               //EndDialog(hDlg,TRUE);
               WinHelp(hDlg,"PWRVIEWS.HLP",HELP_CONTEXT,2082);
               return 0;
          }
          break;
      case WM_PAINT:
         hDc=BeginPaint(hDlg,&ps);
         EndPaint(hDlg,&ps);
         return 0;
   }
   //return DefWindowProc (hDlg, message, wParam, lParam);
   return FALSE;
}
/****************************************************************
**
**     RangesDlgProc
**
*****************************************************************/
BOOL FAR PASCAL RangesDlgProc (HWND hDlg, UINT message,
                UINT wParam, LONG lParam) {
PAINTSTRUCT ps;
static OPENFILENAME ofn;
static char lpszFileName[_MAX_PATH],lpszTitleName[_MAX_FNAME+_MAX_EXT];
int resultInt;
DWORD nIndex,nCount,dwIndex;
char szString00[MAXLEN],szString01[11*MAX_SEG_NUM],szString02[11*MAX_SEG_NUM];
char szString03[MAXLEN],szString04[MAXLEN];
U8 u8Count,i,u8Selected;
HFILE hFile;
SPA_RANGE_TEMP spaRangeData;
RETCODE err;
LPSTR tempPtr;
char startTmp[MAXLEN],endTmp[MAXLEN];
char str[MAXLEN];
HDC hDc;

   switch(message) {
      case WM_INITDIALOG:
         // initialize the OPENFILENAME
         InitializeOpenFile(&ofn);
	 SendDlgItemMessage(hDlg,IDR_LISTBOX,WM_SETFONT,hFontFixed,0);
	 EnableWindow(GetDlgItem(hDlg,IDR_EDIT),FALSE);
         SpaRangesCountGet(nSPAstatus,&u8Count);
         if (u8Count==0)
            EnableWindow(GetDlgItem(hDlg,IDR_EDIT),FALSE);
         else
            EnableWindow(GetDlgItem(hDlg,IDR_EDIT),TRUE);
         for (i=0;i<u8Count;i++) {
            SpaRangesGetByIndex(i,nSPAstatus,szString00,szString01,
	       szString02,&u8Selected);
	    strncpy(startTmp,szString01,9);
	    strncpy(endTmp,szString02,9);
	    startTmp[9] = endTmp[9] = '\0';
	    if (nSPAstatus==2) {
               if (u8Selected)
                  strcpy(szString04,"Enable");
               else
                  strcpy(szString04,"Disable");
               wsprintf(szString03,"%-15s %-7s %-10s...%-10s",szString00,
                  szString04,startTmp,endTmp);
            }
            else
               wsprintf(szString03,"%-15s %-10s...%-10s",szString00,
		  startTmp,endTmp);
            SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_ADDSTRING,
	       0,(LPARAM)(LPSTR)szString03);
	 }
	    /*if (strlen(szString01) >= 10)
	       count = strlen(szString01)/10;
            else
	       count = 1; 
            index = 0;
	    while (index < count) {
	       strncpy(startTmp,szString01+(index*10),9);
	       strncpy(endTmp,szString02+(index*10),9);
	       startTmp[9] = endTmp[9] = '\0';
	       index++;
               if (nSPAstatus==2) {
                  if (u8Selected)
                     strcpy(szString04,"Enable");
                  else
		     strcpy(szString04,"Disable");
                  wsprintf(szString03,"%-15s %-7s %-10s...%-10s",szString00,
                     szString04,startTmp,endTmp);
               }
               else
                  wsprintf(szString03,"%-15s %-10s...%-10s",szString00,
                     startTmp,endTmp);
               SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_ADDSTRING,
		  0,(LPARAM)(LPSTR)szString03);
	     }
         }*/
	 SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_SETCURSEL,0,0L);
         return TRUE;
      case WM_COMMAND:
         switch(wParam) {
            case IDSYSCANCEL:
            case IDR_CLOSE:
               InvalidateMAorTACombo();
               canGetCCFlag=FALSE;
	       EndDialog(hDlg,TRUE);
               return 0;
            case IDR_HELP:
               WinHelp(hDlg,"PWRVIEWS.HLP",HELP_CONTEXT,2081);
               //EndDialog(hDlg,TRUE);
               return 0;
            case IDR_ENABLE:
            case IDR_DISABLE:
               nIndex=SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_GETCURSEL,
                  0,0);
               if (nIndex==LB_ERR)
                  return 0;
               SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_GETTEXT,
		  (WPARAM)nIndex,(LPARAM)(LPSTR)str);
               sscanf(str,"%s",&szString00);
               tempPtr=str+24;
               strcpy(szString02,tempPtr);
               SpaRangesActionSet(szString00,2,(wParam-IDR_DISABLE));
               if (wParam-IDR_DISABLE)
                  strcpy(szString01,"Enable");
               else
                  strcpy(szString01,"Disable");
               wsprintf(szString03,"%-15s %-7s %-25s",szString00,
                  szString01,szString02);
               SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_DELETESTRING,
                  (WPARAM)nIndex,0);
               SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_INSERTSTRING,
                  (WPARAM)nIndex,(LPARAM)(LPSTR)szString03);
               SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_SETCURSEL,
		  (WPARAM)nIndex,0);
               return 0;
            case IDR_ADD:
               lpAddRangeProc=MakeProcInstance((FARPROC)AddRangeDlgProc,
                  hInst);
               resultInt=DialogBoxParam(hInst,"Add_Range",hDlg,
                  lpAddRangeProc,MAKELPARAM(IDR_ADD,0));
               /*
               if (resultInt==1) {
                  dwIndex=SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_GETCURSEL,0,0);
                  SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_ADDSTRING,
                     0,(LPARAM)(LPSTR)szAddRange);
                  SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_SETCURSEL,
                     dwIndex,0);
                  EnableWindow(GetDlgItem(hDlg,IDR_EDIT),TRUE);
               }
               */
               return 0;
            case IDR_EDIT:
               lpAddRangeProc=MakeProcInstance((FARPROC)AddRangeDlgProc,
                  hInst);
               nIndex=SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_GETCURSEL,
                  0,0);
               if (nIndex==LB_ERR)
                  return 0;
               nCount=SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_GETCOUNT,
                  0,0);
               SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_GETTEXT,
                  (WPARAM)nIndex,(LPARAM)(LPSTR)str);
               sscanf(str,"%s",&szAddRange);
               resultInt=DialogBoxParam(hInst,"Add_Range",hDlg,
                  lpAddRangeProc,MAKELPARAM(IDR_EDIT,0));
               if (resultInt==1) {
                  dwIndex=SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_GETCURSEL,0,0);
                  SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_INSERTSTRING,
                     (WPARAM)nIndex,(LPARAM)(LPSTR)szAddRange);
                  SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_DELETESTRING,
                     (WPARAM)nIndex+1,0l);
                  SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_SETCURSEL,
                     (WPARAM)dwIndex,0);
                  /*
                  if (nSPAstatus==0)
                     InvalidateHwndListBox();
                  */
               }
               return 0;
            case IDR_DELETE:
               nIndex=SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_GETCURSEL,
                  0,0);
               if (nIndex==LB_ERR)
                  return 0;
               SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_GETTEXT,
                  (WPARAM)nIndex,(LPARAM)(LPSTR)str);
               sscanf(str,"%s",&szAddRange);
               if (nSPAstatus!=2) {
                  for (i=0;i<4;i++) {
                     SpaRangesActionGet(0,i,szString00);
                     if (strcmp(szString00,szAddRange)==0) {
                        strcpy(str,"Can't delete. Be used for module analysis or time analysis");
                        ErrMessageBoxL(str);
                        return 0;
                     }
                  }
                  SpaRangesActionGet(1,0,szString00);
                  if (strcmp(szString00,szAddRange)==0) {
                     strcpy(str,"Can't delete. Be used for module analysis or time analysis");
                     ErrMessageBoxL(str);
                     return 0;
                  }
               }
               if ((err=SpaRangesDelete(nSPAstatus,szAddRange))!=GOOD) {
                  ErrDisplayError(err,FORCE_POPUP);
                  return GOOD;
               }
               dwIndex=SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_GETCURSEL,0,0);
               SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_DELETESTRING,
                  (WPARAM)nIndex,0l);
               SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_SETCURSEL,
                  (WPARAM)dwIndex,0);
               SpaRangesCountGet(nSPAstatus,&u8Count);
               if (u8Count==0)
		  EnableWindow(GetDlgItem(hDlg,IDR_EDIT),FALSE);
	       memset(selectedRangeName,0,sizeof(selectedRangeName));
               memset(selectedFuncName,0,sizeof(selectedFuncName));
               return 0;
            case IDR_SAVE:
               ofn.hwndOwner=hDlg;
               if (nSPAstatus!=2) {
                  strcpy(lpszFileName,"*.mt");
                  strcpy(lpszTitleName,"*.mt");
               }
               else {
                  strcpy(lpszFileName,"*.cc");
                  strcpy(lpszTitleName,"*.mt");
               }
               ofn.lpstrFile=lpszFileName;
               ofn.lpstrFileTitle=lpszTitleName;
               ofn.Flags=OFN_SHOWHELP|OFN_OVERWRITEPROMPT;
	       if (GetSaveFileName(&ofn)) {
                  hFile=_lcreat(lpszFileName,0);
                  //hFile=_lopen("test",WRITE);
                  SpaRangesCountGet(nSPAstatus,&u8Count);
                  _lwrite(hFile,&u8Count,sizeof(U8));
                  for (i=0;i<u8Count;i++) {
                     SpaSaveDataGet(nSPAstatus,i,&spaRangeData);
                     _lwrite(hFile,&spaRangeData,sizeof(SPA_RANGE_TEMP));
                  }
                  _lclose(hFile);
               }
               return 0;
	    case IDR_RESTORE:	       
               ofn.hwndOwner=hDlg;
               if (nSPAstatus!=2) {
                  strcpy(lpszFileName,"*.mt");
                  strcpy(lpszTitleName,"*.mt");
               }
               else {
                  strcpy(lpszFileName,"*.cc");
                  strcpy(lpszTitleName,"*.mt");
               }
               ofn.lpstrFile=lpszFileName;
               ofn.lpstrFileTitle=lpszTitleName;
               ofn.Flags=OFN_CREATEPROMPT;
               if (GetOpenFileName(&ofn)) {
               }
               else
                  CommDlgExtendedError();
               SpaOpen(nSPAstatus,lpszFileName);
               SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_RESETCONTENT,0,0);
	       SendMessage(hDlg,WM_INITDIALOG,0,0);
	       memset(selectedRangeName,0,sizeof(selectedRangeName));
	       memset(selectedFuncName,0,sizeof(selectedFuncName));
               return 0;
          }
          break;
      case WM_PAINT:
         hDc=BeginPaint(hDlg,&ps);
         nCount=SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_GETCOUNT,0,0);
         if (nCount>0)
            SendDlgItemMessage(hDlg,IDR_LISTBOX,LB_SETSEL,TRUE,MAKELONG(1,0));
         EndPaint(hDlg,&ps);
         return 0;
   }
   return FALSE;
}
/****************************************************************
**
**     AddRangeDlgProc
**
*****************************************************************/
BOOL FAR PASCAL AddRangeDlgProc (HWND hDlg, UINT message,
		UINT wParam, LONG lParam) {
PAINTSTRUCT ps;
HDC hDc;
int resultInt;
HWND editHandle;
char szNameL[100];
char szStartAddrL[11*MAX_SEG_NUM],szEndAddrL[11*MAX_SEG_NUM];
char szStartAddrEL[11*MAX_SEG_NUM],szEndAddrEL[11*MAX_SEG_NUM];
char startTmp[20],endTmp[20];
RETCODE err;
static char flagAE;
SYM_DESCRIPTOR moduleDesc;
DWORD dwIndex;

   switch(message) {
      case WM_INITDIALOG:
         if (LOWORD(lParam)==IDR_ADD) {
            SendMessage(hDlg,WM_SETTEXT,0,(LPARAM)(LPSTR)"Add Range");
	    SendDlgItemMessage(hDlg,IDA_RANGENAME,EM_SETREADONLY,
               FALSE,0);
            flagAE='A';
         }
         else {
            SendMessage(hDlg,WM_SETTEXT,0,(LPARAM)(LPSTR)"Edit Range");
            SetDlgItemText(hDlg,IDA_RANGENAME,szAddRange);
            /*
            SendDlgItemMessage(hDlg,IDA_RANGENAME,EM_SETREADONLY,
               TRUE,0);
            */
            EnableWindow(GetDlgItem(hDlg,IDA_RANGENAME),FALSE);
            EnableWindow(GetDlgItem(hDlg,IDA_BROWER),FALSE);
            SpaRangesGet(nSPAstatus,szAddRange,szStartAddrL,szEndAddrL);
            SetDlgItemText(hDlg,IDA_STARTADDRESS,szStartAddrL);
            SetDlgItemText(hDlg,IDA_ENDADDRESS,szEndAddrL);
            SetFocus(GetDlgItem(hDlg,IDA_STARTADDRESS));
            flagAE='E';
         }
	 if ((err=SymGetModuleListHead(&moduleDesc))!=GOOD)
            EnableWindow(GetDlgItem(hDlg,IDA_BROWER),FALSE);
         return TRUE;
      case WM_COMMAND:
         switch(wParam) {
	    case IDA_OK:
	       GetDlgItemText(hDlg,IDA_RANGENAME,szNameL,
                  sizeof(szNameL));
	       if (szNameL[0]=='\0') {
                  //ErrDisplayError(err,FORCE_POPUP);
                  SetFocus(GetDlgItem(hDlg,IDA_RANGENAME));
                  return 0;
	       }
               GetDlgItemText(hDlg,IDA_STARTADDRESS,szStartAddrL,
                  11*MAX_SEG_NUM);
               GetDlgItemText(hDlg,IDA_ENDADDRESS,szEndAddrL,
		  11*MAX_SEG_NUM);
	       //Hera 12/19/97 -Check If a User define the segment
	       //If it is not,Getting the right code segment. ID:173
	       if ((err=CheckAddressFormatL(szNameL,szStartAddrL,
		  szEndAddrL,szStartAddrEL,szEndAddrEL))
		  !=GOOD) {
		  MessageBox(hDlg,"Invalid Address/Data Range Specified",
						     "Error Message",MB_OK);
		  //ErrDisplayError(err,FORCE_POPUP);
                  return 0;
	       }
               //CheckAddressEven(szStartAddrEL,szStartAddr);
	       //CheckAddressEven(szEndAddrEL,szEndAddr);
	       //strcpy(szEndAddr,szEndAddrEL);
	       strcpy(szEndAddrL,szEndAddrEL);
	       strcpy(szStartAddrL,szStartAddrEL);
	       if (flagAE=='A') {
		  if ((err=SpaRangesAdd(nSPAstatus,szNameL,szStartAddrL,szEndAddrL))
                     !=GOOD) {
                     ErrDisplayError(err,FORCE_POPUP);
                     return 0;
                  }
                  SpaRangesActionSet(szNameL,2,1);
               }
               else {
                  if ((err=SpaRangesEdit(nSPAstatus,szNameL,szStartAddrL,szEndAddrL))
                     !=GOOD) {
                     ErrDisplayError(err,FORCE_POPUP);
                     return 0;
                  }
	       }
	       strncpy(startTmp,szStartAddrL,9);
	       strncpy(endTmp,szEndAddrL,9);
               startTmp[9] = endTmp[9] ='\0';
	       if (nSPAstatus==2)
	         wsprintf(szAddRange,"%-15s %-7s %-10s...%-10s",szNameL,
					 "Enable",startTmp,endTmp);
	       else
                  wsprintf(szAddRange,"%-15s %-10s...%-10s",szNameL,
                     startTmp,endTmp);
               if (flagAE=='A') {
                  dwIndex=SendDlgItemMessage(GetParent(hDlg),
                     IDR_LISTBOX,LB_GETCURSEL,0,0);
                  SendDlgItemMessage(GetParent(hDlg),IDR_LISTBOX,LB_ADDSTRING,
                     0,(LPARAM)(LPSTR)szAddRange);
                  SendDlgItemMessage(GetParent(hDlg),IDR_LISTBOX,LB_SETCURSEL,
                     dwIndex,0);
                  EnableWindow(GetDlgItem(GetParent(hDlg),IDR_EDIT),TRUE);
               }
               else
		  EndDialog(hDlg,TRUE);
	       return 0;
            case IDSYSCANCEL:
	    case IDA_CANCEL:
	       EndDialog(hDlg,FALSE);
               return 0;
            case IDA_HELP:
               WinHelp(hDlg,"PWRVIEWS.HLP",HELP_CONTEXT,2080);
               //EndDialog(hDlg,FALSE);
               return 0;
            case IDA_BROWER:
               /*
               if ((err=SymGetModuleListHead(&moduleDesc))!=GOOD) {
                  ErrDisplayError(err,FORCE_POPUP);
                  return 0;
               }
               */
               lpBrowseProc=MakeProcInstance((FARPROC)BrowseDlgProc,
                  hInst);
               resultInt=DialogBox(hInst,"Browse",hDlg,lpBrowseProc);
               if (resultInt==1) {
                  editHandle=GetDlgItem(hDlg,IDA_STARTADDRESS);
                  SetWindowText(editHandle,(LPSTR)szStartAddr);
                  editHandle=GetDlgItem(hDlg,IDA_ENDADDRESS);
                  SetWindowText(editHandle,(LPSTR)szEndAddr);
                  /*
                  editHandle=GetDlgItem(hDlg,IDA_RANGENAME);
                  SetWindowText(editHandle,(LPSTR)szFuncName);
                  */
               }
               return 0;
          }
          break;
      case WM_PAINT:
	 hDc=BeginPaint(hDlg,&ps);
	 EndPaint(hDlg,&ps);
         return 0;
   }
   return FALSE;
}
/****************************************************************
**
**     BrowseDlgProc
**
*****************************************************************/
BOOL FAR PASCAL BrowseDlgProc (HWND hDlg, UINT message,
                UINT wParam, LONG lParam) {
PAINTSTRUCT ps;
HDC hDc;
DWORD dwIndex;
char moduleName[MAXLEN], funcName[MAXLEN];

   switch(message) {
      case WM_INITDIALOG:
         //get module name list
         ListModuleAndFuncName(hDlg,IDO_MODULE,IDO_FUNCTION,NULL);
         return TRUE;
      case WM_COMMAND:
         switch(wParam) {
            case IDO_MODULE:
               if (HIWORD(lParam)==CBN_SELCHANGE) {
                  SelectModuleAndFuncName(hDlg,IDO_MODULE,IDO_FUNCTION,NULL);
               }
               return 0;
            case IDO_OK:
               dwIndex=SendDlgItemMessage(hDlg,IDO_MODULE,
                  CB_GETCURSEL,0,0);
               SendDlgItemMessage(hDlg,IDO_MODULE,CB_GETLBTEXT,
                  dwIndex,(LPARAM)(LPSTR)szModuleName);
               dwIndex=SendDlgItemMessage(hDlg,IDO_FUNCTION,
                  CB_GETCURSEL,0,0);
               SendDlgItemMessage(hDlg,IDO_FUNCTION,CB_GETLBTEXT,
		  dwIndex,(LPARAM)(LPSTR)szFuncName);
	       strcpy(moduleName,szModuleName);
	       strcpy(funcName,szFuncName);
               if (strcmp(szFuncName,"All Functions")==0 ||
		  szFuncName[0]=='\0') {
                  szFuncName[0] = '\0';
		  funcName[0] = '\0';
                  strcat(moduleName, "(M)");
                  SetWindowText(GetDlgItem(GetParent(hDlg),IDA_RANGENAME),
                     (LPSTR)moduleName);
	       } 
	       else {		  
		  strcat(funcName, "(F)");
                  SetWindowText(GetDlgItem(GetParent(hDlg),IDA_RANGENAME),
		     (LPSTR)funcName);
	       }
	       GetStartAndEndAddr(szModuleName,szFuncName,
                  szStartAddr,szEndAddr);
               EndDialog(hDlg,TRUE);
               return 0;
            case IDSYSCANCEL:
            case IDO_CANCEL:
               EndDialog(hDlg,FALSE);
               return 0;
            case IDO_HELP:
               WinHelp(hDlg,"PWRVIEWS.HLP",HELP_CONTEXT,2080);
               //EndDialog(hDlg,FALSE);
               return 0;
          }
          break;
      case WM_PAINT:
         hDc=BeginPaint(hDlg,&ps);
         EndPaint(hDlg,&ps);
         return 0;
   }
   return FALSE;
}
/****************************************************************
**
**     SelectModuleAndFuncName
**
*****************************************************************/
RETCODE SelectModuleAndFuncName(HWND hDlg,int moduleID,int funcID,
   int resultID){
DWORD dwIndex;
RETCODE err;
char szString02[MAXLEN];
SYM_DESCRIPTOR moduleDesc;
SYM_DESCRIPTOR funcDesc,nextFuncDesc;
SYM_TYPE_TYPE symType=1;
DESCRIPTOR funcName;

      dwIndex=SendDlgItemMessage(hDlg,moduleID,
         CB_GETCURSEL,0,0);
      SendDlgItemMessage(hDlg,moduleID,CB_GETLBTEXT,
         dwIndex,(LPARAM)(LPSTR)szString02);
      if ((err=SymGetModuleDesc(szString02,0,&moduleDesc))!=GOOD)
         return GOOD;
      SymGetSymbolChild(moduleDesc,&symType,&funcDesc);
      SendDlgItemMessage(hDlg,funcID,CB_RESETCONTENT,
         0,0);
      if (funcDesc==NULL_SYMBOL)
         EnableWindow(GetDlgItem(hDlg,funcID),FALSE);
      else {
         EnableWindow(GetDlgItem(hDlg,funcID),TRUE);
         while(symType!=SYM_ROOT) {
            SymGetSymbolName(funcDesc,&funcName);
            SendDlgItemMessage(hDlg,funcID,CB_ADDSTRING,
               0,(LPARAM)(LPSTR)funcName);
            SymGetSymbolSibling(funcDesc,&symType,&nextFuncDesc);
            funcDesc=nextFuncDesc;
	 }
         if (resultID==NULL && nSPAstatus==2)
            SendDlgItemMessage(hDlg,funcID,CB_ADDSTRING,
               0,(LPARAM)(LPSTR)"All Functions");
      }
      SendDlgItemMessage(hDlg,funcID,CB_SETCURSEL,0,0);
      SendMessage(hDlg,WM_COMMAND,IDB_FUNCTIONS,MAKELONG(0,CBN_CLOSEUP));
      return GOOD;
}
/****************************************************************
**
**     ListModuleAndFuncName
**
*****************************************************************/
RETCODE ListModuleAndFuncName(HWND hDlg,int moduleID,int funcID,
   int resultID) {
U8 i;
RETCODE err;
SYM_DESCRIPTOR moduleDesc,nextModuleDesc;
SYM_DESCRIPTOR funcDesc,nextFuncDesc;
SYM_TYPE_TYPE symType=1;
DESCRIPTOR moduleName,funcName;
char szString02[MAXLEN],szString03[MAXLEN],szString04[MAXLEN];
   i=0;
   if ((err=SymGetModuleListHead(&moduleDesc))!=GOOD) {
      EnableWindow(GetDlgItem(hDlg,funcID),FALSE);
      EnableWindow(GetDlgItem(hDlg,moduleID),FALSE);
      return GOOD;
   }
   while(symType!=NULL_SYMBOL) {
      SymGetSymbolName(moduleDesc,&moduleName);
      SendDlgItemMessage(hDlg,moduleID,CB_ADDSTRING,
         i,moduleName);
      i=i+1;
      SymGetSymbolSibling(moduleDesc,&symType,&nextModuleDesc);
      moduleDesc=nextModuleDesc;
   }
   SendDlgItemMessage(hDlg,moduleID,CB_SETCURSEL,0,0);
   SendDlgItemMessage(hDlg,moduleID,CB_GETLBTEXT,
      0,(LPARAM)(LPSTR)szString02);
   SymGetModuleDesc(szString02,0,&moduleDesc);
   SymGetSymbolChild(moduleDesc,&symType,&funcDesc);
   if (funcDesc==NULL_SYMBOL)
      EnableWindow(GetDlgItem(hDlg,funcID),FALSE);
   else {
      EnableWindow(GetDlgItem(hDlg,funcID),TRUE);
      while(symType!=NULL_SYMBOL) {
         SymGetSymbolName(funcDesc,&funcName);
         SendDlgItemMessage(hDlg,funcID,CB_ADDSTRING,
            0,funcName);
         SymGetSymbolSibling(funcDesc,&symType,&nextFuncDesc);
         funcDesc=nextFuncDesc;
      }
      if (resultID==NULL && nSPAstatus==2)
         SendDlgItemMessage(hDlg,funcID,CB_ADDSTRING,
            0,"All Functions");
   }
   if (IsWindowEnabled(GetDlgItem(hDlg,funcID))) {
      SendDlgItemMessage(hDlg,funcID,CB_SETCURSEL,0,0);
      SendDlgItemMessage(hDlg,funcID,CB_GETLBTEXT,
         0,(LPARAM)(LPSTR)szString03);
   }
   else
      szString03[0]='\0';
   if (resultID!=NULL) {
      if (szString03[0]=='\0')
         wsprintf(szString04,"#%s",szString02);
      else
         wsprintf(szString04,"#%s#%s",szString02,szString03);
      SetWindowText(GetDlgItem(hDlg,resultID),(LPSTR)szString04);
   }
   return GOOD;
}
/****************************************************************
**
**     InitialModuleList
**
*****************************************************************/
RETCODE InitialModuleList() {
SYM_DESCRIPTOR moduleDesc,nextModuleDesc,funcDesc;
SYM_TYPE_TYPE symType=1;
DESCRIPTOR moduleName;
RETCODE err;

   numModule=0;
   if ((err=SymGetModuleListHead(&moduleDesc))!=GOOD)
      return err;
   while(symType!=NULL_SYMBOL) {
      SymGetSymbolName(moduleDesc,&moduleName);
      strcpy((mList+numModule)->moduleName,(LPSTR)moduleName);
      err=SymGetSymbolChild(moduleDesc,&symType,&funcDesc);
      if(funcDesc==0)
         (mList+numModule)->isList=' ';
      numModule++;
      SymGetSymbolSibling(moduleDesc,&symType,&nextModuleDesc);
      moduleDesc=nextModuleDesc;
   }
   return GOOD;
   /*
   */
}
/************************************************************************
**
**          ListBoxProc
**
*************************************************************************/
long FAR PASCAL ListBoxProc(HWND hWnd, UINT message,
                         UINT wParam, LONG lParam) {
int i;
DWORD nIndex;
char tempString[MAXLEN],rangeName[MAXLEN],szString00[MAXLEN],szString01[MAXLEN];
char startText[11*MAX_SEG_NUM],endText[11*MAX_SEG_NUM],moduleName[MAXLEN];
DWORD topIndex;
SYM_DESCRIPTOR  moduleDesc,funcDesc,nextFuncDesc;
SYM_TYPE_TYPE symType=1;
DESCRIPTOR funcName,moduleAddrDesc;
RETCODE err;
U16 percent;

   switch(message) {
      case WM_LBUTTONDOWN:
         orgPoint=MAKEPOINT(lParam);
         if(PtInRect(&listRect,orgPoint)) {
           topIndex=SendMessage(hWndDir,LB_GETTOPINDEX,0,0);
           nIndex=CountListIndex(orgPoint.y);
	   SendMessage(hWndDir,LB_GETTEXT,(WPARAM)nIndex,
              (LPARAM)(LPSTR)tempString);
           if ((tempString[0]=='+') || (tempString[0]=='-')) {
              i=5;
              while(tempString[i]!='\0') {
                 rangeName[i-5]=tempString[i];
                 i++;
              }
              rangeName[i-5]='\0';
              GetRangeTextBasedOnRangeName(rangeName,
                 startText,endText);
              GetRangePercent(startText,endText,&percent);
              if (tempString[0]=='+') {
                 SendMessage(hWndDir,LB_DELETESTRING,(WPARAM)nIndex,0);
                 wsprintf(szString01,"%u%%",percent);
                 wsprintf(szString00,"-%-4s%s",szString01,rangeName);
                 SendMessage(hWndDir,LB_INSERTSTRING,(WPARAM)nIndex,
                    (LPARAM)(LPSTR)szString00);
              }
              else {
                 SendMessage(hWndDir,LB_DELETESTRING,(WPARAM)nIndex,0);
                 wsprintf(szString01,"%u%%",percent);
                 wsprintf(szString00,"+%-4s%s",szString01,rangeName);
		 SendMessage(hWndDir,LB_INSERTSTRING,(WPARAM)nIndex,
                    (LPARAM)(LPSTR)szString00);
              }
              //GetRangeTextBasedOnRangeName(rangeName,
              //   startText,endText);
              AdrCreateAddress(&moduleAddrDesc);
              GetModuleByRangeTextAddr(startText,endText,
                 MODULE_MODE,&moduleDesc,moduleAddrDesc,moduleName);
              SymGetSymbolChild(moduleDesc,&symType,&funcDesc);
              while(symType!=NULL_SYMBOL) {
                 SymGetSymbolName(funcDesc,&funcName);
                 GetStartAndEndAddr(moduleName,funcName,
                    startText,endText);
                 GetRangePercent(startText,endText,&percent);
                 if (tempString[0]=='+') {
                    wsprintf(szString01,"%u%%",percent);
                    wsprintf(szString00,"    %-4s%s",szString01,funcName);
		    SendMessage(hWndDir,LB_INSERTSTRING,(WPARAM)++nIndex,
                       (LPARAM)(LPSTR)szString00);
                 }
                 else
                    SendMessage(hWndDir,LB_DELETESTRING,(WPARAM)nIndex+1,0);
                 SymGetSymbolSibling(funcDesc,&symType,&nextFuncDesc);
                 funcDesc=nextFuncDesc;
              }
              AdrDestroyAddress(moduleAddrDesc);
           }
           SendMessage(hWndDir,LB_SETTOPINDEX,(WPARAM)topIndex,0l);
         }
         break;
      case WM_LBUTTONDBLCLK:
         asmFlag='N';
         SetWindowText(hWndBsFunc[5],(LPSTR)"Asm");
         EnableWindow(hWndBsFunc[5],TRUE);
         asmEnable='Y';
         err=GetFuncContent(lParam);
         ProcessLineMarked();
         break;
   }
   return CallWindowProc(lpfnOldListBox,hWnd,message,wParam,lParam);
}
/************************************************************************
**
**         GetRangeTextBasedOnRangeName
**
*************************************************************************/
RETCODE GetRangeTextBasedOnRangeName(char *rangeName,char *startText,
   char *endText) {
U16 i;
U8 u8Count,u8Selected;
char tempName[11*MAX_SEG_NUM],startRangeAddrText[11*MAX_SEG_NUM];
char endRangeAddrText[11*MAX_SEG_NUM];
   SpaRangesCountGet(nSPAstatus,&u8Count);
   for (i=0;i<u8Count;i++){
      SpaRangesGetByIndex(i,nSPAstatus,tempName,
         startRangeAddrText,endRangeAddrText,&u8Selected);
      if (strcmp(rangeName,tempName)==0) {
         strcpy(startText,startRangeAddrText);
         strcpy(endText,endRangeAddrText);
         break;
      }
   }
   return GOOD;
}
/************************************************************************
**
**          FuncTextProc
**
*************************************************************************/
long FAR PASCAL FuncTextProc(HWND hWnd, UINT message,
                         UINT wParam, LONG lParam) {
   switch(message){
      case WM_LBUTTONDOWN:
         return 0;
      /*
      case WM_LBUTTONUP:
         SendMessage(hWndTitleList,LB_SETSEL,TRUE,MAKELONG(5,0));
         SendMessage(hWndTitleList,LB_SETSEL,TRUE,MAKELONG(10,0));
         //UpdateWindow(hWndTitleList);
         SendMessage(hWndTitleList,WM_SETREDRAW,TRUE,0);
         //InvalidateRect(hWndTitleList,NULL,TRUE);
        break;
      */
   }
   return CallWindowProc(lpfnOldFuncText,hWnd,message,wParam,lParam);
}
/*****************************************************************************
**
**  InitSPA
**
*****************************************************************************/
void InitSPA() {
int i;
U16 nummodule;
U32 numfunction, numpubliclabels, numuserlabels;

   //Hera 6/24/98 we can not limit number of modules to 55
   SymGetSymStats(&nummodule,&numfunction,&numpubliclabels,&numuserlabels);
   mList = (MODULELIST*)TMalloc(sizeof(MODULELIST)*nummodule);
   //Hera
   for (i = 0;i < nummodule;i++)
      (mList+i)->isList='+';
   InitialModuleList();
   ccmoduleName[0]='\0';
   ccfuncName[0]='\0';
   asmFlag='N';
   asmEnable='Y';
   startStop=FALSE;
   BarInitialization();
}
/*****************************************************************
**
**   InitializeOpenFile
**
*******************************************************************/
RETCODE InitializeOpenFile(OPENFILENAME *openFile) {
OPENFILENAME ofn;
   ofn.lStructSize=sizeof(OPENFILENAME);
   //ofn.hwndOwner=hWnd;
   ofn.hInstance=NULL;
   if (nSPAstatus!=2)
      ofn.lpstrFilter="SPA Files (*.MT)";
   else
      ofn.lpstrFilter="SPA Files (*.CC)";
   ofn.lpstrCustomFilter=NULL;
   ofn.nMaxCustFilter=0;
   ofn.nFilterIndex=0;
   ofn.lpstrFile=NULL;
   ofn.nMaxFile=_MAX_PATH;
   ofn.lpstrFileTitle=NULL;
   ofn.nMaxFileTitle=_MAX_FNAME+_MAX_EXT;
   ofn.lpstrInitialDir=NULL;
   ofn.lpstrTitle=NULL;
   ofn.Flags=0;
   ofn.nFileOffset=0;
   if (nSPAstatus!=2)
      ofn.lpstrDefExt="*.MT";
   else
      ofn.lpstrDefExt="*.CC";
   ofn.lCustData=0l;
   ofn.lpfnHook=NULL;
   ofn.lpTemplateName=NULL;
   *openFile=ofn;
   return GOOD;
}
/*****************************************************************
**
**   CheckAddressFormatL
**   --If a user define the segment exactly
**   --If no, get the right CODE SEGMENT === Hera 12/19/97 ID:173
**
*******************************************************************/
RETCODE CheckAddressFormatL(LPSTR rangeName,LPSTR startAddr,
   LPSTR endAddr,LPSTR ccstartAddr,LPSTR ccendAddr) {
RETCODE err;
DESCRIPTOR startAddrDesc,endAddrDesc;
U16 segsel;
ADDR_SEGSEL_TYPE type;
ADDR_COMPARE result;
char tempAddr00[11*MAX_SEG_NUM],tempAddr01[11*MAX_SEG_NUM];
char tempStartAddr[11*MAX_SEG_NUM],tempEndAddr[11*MAX_SEG_NUM];//Eric 2/11/98
BOOLEAN  MultiToken=FALSE;//Eric 2/11/98

   //Fixed bug for ID#193 by Eric 2/11/98
   if (strchr(startAddr,' ') != NULL) {
      MultiToken=TRUE;
      strcpy(tempStartAddr,startAddr);
      strcpy(tempEndAddr,endAddr);
   }
   //eof Eric 2/11/98
   if ((err=AdrCreateAddressFromText(startAddr,NULL,&startAddrDesc))
      !=GOOD)
      return err;
   if ((err=AdrConvAddressToText(startAddrDesc,startAddr))!=GOOD)
      return err;
   if ((err=AdrCreateAddressFromText(endAddr,NULL,&endAddrDesc))
      !=GOOD)
      return err;
   if ((err=AdrConvAddressToText(endAddrDesc,endAddr))!=GOOD)
      return err;

   /*
   if ((err=SymMapAddr2Symbol(startAddrDesc,&memoryClass,&symbolType,
      &offset,&outputSymbol,&ssFuncDesc,&ssModuleDesc))!=GOOD)
      return err;
   AdrCreateAddress(&adrFuncRangeDesc);
   if ((err=SymGetFunc(ssFuncDesc,szString00,&funcClass,
      &stackSize,adrFuncRangeDesc))!=GOOD)
      return err;
   AdrIsAddrInRange(endAddrDesc,adrFuncRangeDesc,&isInRange);
   AdrDestroyAddress(adrFuncRangeDesc);
   if (!(nSPAstatus!=2 && isInRange))
      return 1;
   */
   if (strchr(startAddr,'P') != NULL || strchr(startAddr,'p') != NULL ||
       strchr(endAddr,'P') != NULL || strchr(startAddr,'p') != NULL){
      AdrDestroyAddress(startAddrDesc);
      AdrDestroyAddress(endAddrDesc);
      return(ER_ADR_TYPE_NOT_SUPPORTED);
   }

   if ((err=AdrComparePhysicalAddresses(startAddrDesc,
                                              endAddrDesc,&result))!=GOOD){
      AdrDestroyAddress(startAddrDesc);
      AdrDestroyAddress(endAddrDesc);
      return  err;
   }
   if (result==FIRST_ADDR_GREATER)
      return ER_INVALID_RANGE_SPEC;
   if (_fstrstr(startAddr,"DS:")!=NULL) {
      //Hera 12/19/97 ID:172
      AdrSetAddrSegmentSelector(startAddrDesc,ADDR_USE_CS,NULL);
      AdrGetAddrSegmentSelector(startAddrDesc,&type,&segsel);
      wsprintf(tempAddr00,"%04X",segsel);
      _fstrcat((LPSTR)tempAddr00,_fstrchr(startAddr,':'));
      strcpy(ccstartAddr,tempAddr00);
   }
   else
      strcpy(ccstartAddr,startAddr);
   if (_fstrstr(endAddr,"DS:")!=NULL) {
      //Hera 12/19/97 ID172
      AdrSetAddrSegmentSelector(endAddrDesc,ADDR_USE_CS,NULL);
      AdrGetAddrSegmentSelector(endAddrDesc,&type,&segsel);
      wsprintf(tempAddr01,"%04X",segsel);
      _fstrcat((LPSTR)tempAddr01,_fstrchr(endAddr,':'));
      strcpy(ccendAddr,tempAddr01);
   }
   else
      strcpy(ccendAddr,endAddr);
   //Fixed bug ID#193 by Eric 2/11/98
   if (MultiToken) {
      strcpy(ccstartAddr,tempStartAddr);
      strcpy(ccendAddr,tempEndAddr);
   }
   //eof Eric 2/11/98
   AdrDestroyAddress(startAddrDesc);
   AdrDestroyAddress(endAddrDesc);
   return GOOD;
}
/*****************************************************************************
**
**  ConvLinenum2AsmCode
**
*****************************************************************************/
RETCODE ConvLinenum2AsmCode(SYM_DESCRIPTOR moduleDesc,int curLine,
   DESCRIPTOR idDasm) {
RETCODE err;
DESCRIPTOR addrRangeDesc;
LINENUM_TYPE actualLinenum;
COLUMN_TYPE actualColumn;
LINENUM_DESCRIPTOR nextIndex;
LPSTR resultBuf,tempPtr,startPtr;
U16 buflen;
//char lineText[200];

   if ((err=AdrCreateAddress(&addrRangeDesc))!=GOOD)
      return err;
   if ((err=SymGetLinenum(moduleDesc,curLine,addrRangeDesc,
      &actualLinenum,&actualColumn,&nextIndex))!=GOOD)
      return err;
   if (actualLinenum==curLine) {
      if ((DadDasmRangeOfInst(idDasm,addrRangeDesc,&resultBuf,
         &buflen))!=GOOD)
	 return err;
      startPtr=tempPtr=resultBuf;
      while(tempPtr!=NULL) {
         tempPtr=strstr(resultBuf,"\x0D\x0A");
         if (tempPtr!=NULL)
            *tempPtr='\0';
         SendMessage(hWndTitleList,LB_ADDSTRING,0,
            (LPARAM)(LPSTR)resultBuf);
         resultBuf=tempPtr+2;
      }
      /*
      strcpy(curPtr,resultBuf);
      curPtr=curPtr+buflen;
      strcpy(curPtr,"\x0D\x0A");
      curPtr=curPtr+2;
      */
      TFree(startPtr);
   }
   AdrDestroyAddress(addrRangeDesc);
   return GOOD;
}
/*****************************************************************************
**
**  GetStartAndEndAddr
**
*****************************************************************************/
RETCODE GetStartAndEndAddr(char *moduleName, char *funcName,
    char *startAddr,char *endAddr) {
DESCRIPTOR adrFuncRangeDesc;
DESCRIPTOR moduleDesc,funcDesc;
FUNC_CLASS funcClass;
U32 stackSize;
char szString00[MAXLEN];
RETCODE err;
int i;

   if ((err=SymGetModuleDesc(moduleName,0,&moduleDesc))!=GOOD)
      return err;
   if (strcmp(funcName,"")!=0) {
      if ((err=AdrCreateAddress(&adrFuncRangeDesc))!=GOOD)
         return err;
      if ((err=SymGetFuncByName(moduleDesc,(LPSTR)funcName,
         &funcDesc))!=GOOD)
         return err;
      if ((err=SymGetFunc(funcDesc,szString00,&funcClass,
         &stackSize,adrFuncRangeDesc))!=GOOD)
	 return err;
      // convert logical address to a string
      if ((err=AdrConvAddrRangeToText(adrFuncRangeDesc,
         FALSE,TRUE,RANGE_BOTH,(LPSTR)szString00))!=GOOD)
         return err;
      if ((err=AdrDestroyAddress(adrFuncRangeDesc))!=GOOD)
         return err;
      for (i=0;i<=8;i++)
         startAddr[i]=szString00[i];
      startAddr[9]='\0';
      for (i=0;i<=8;i++)
	 endAddr[i]=szString00[i+11];
      endAddr[i]='\0';
      return GOOD;
   }
   else {
      SEG_INFO segInfo;
      SymGetSegInfo(moduleDesc, &segInfo);
      memset(startAddr,0,sizeof(startAddr));
      memset(endAddr,0,sizeof(startAddr));
      for(i = 0 ; i < segInfo.segNum; i++) {
	 sprintf(startAddr+strlen(startAddr),"%04X:%04X ",segInfo.segment[i],
							  segInfo.beginAddr[i]);
	 sprintf(endAddr+strlen(endAddr),"%04X:%04X ",segInfo.segment[i],
	                                                  segInfo.endAddr[i]);
      }
   }
   return GOOD;
}
/*****************************************************************************
**
**  ModuleOpen
**
*****************************************************************************/
RETCODE ModuleOpen(char *moduleName,DESCRIPTOR idDasm,int startLine,
   int endLine,int startFuncL,char *funcName,U8 first) {
char szString01[MAXLEN];
char szString02[MAXLEN];
char lineText[200],tabLineText[200],findString[200];
LANGUAGE_TYPE langType;
U32 auxFileOffset;
SYM_DESCRIPTOR moduleDesc;
FILE *stream;
int i,j,pos,ttflag=0,numPath;
DWORD dwIndex;
   SymGetModuleDesc((LPSTR)moduleName,0,&moduleDesc);
   SymGetModuleExtraInfo(moduleDesc,&auxFileOffset,&langType);
   switch(langType) {
      case LANG_ASM:
	 strcat(moduleName,".asm");
         break;
      case LANG_C:
         strcat(moduleName,".c");
         break;
      case LANG_CPP:
         strcat(moduleName,".cpp");
         break;
      case LANG_PLM:
         strcat(moduleName,".plm");
         break;
      case LANG_UNKNOWN:
         ttflag=2;
         //strcat(moduleName,".c");
   };
   if (ttflag==2) {
      strcat(moduleName,".c");
      ttflag--;
   };
   stream=NULL;
   j=0;
   numPath=GetPrivateProfileInt("SourceInfo","NumAliasPath",1,FILEINI);
   while (stream==NULL) {
      wsprintf(szString02,"SourcePathAlias%d",j);
      GetPrivateProfileString("SourceInfo",szString02,"",
         szString01,sizeof(szString01),FILEINI);
      if (strlen(szString01)==0) {
           EnableWindow(hWndBsFunc[5],TRUE);
           asmEnable='Y';
           return ER_FILE_NOT_FOUND;
      }
      else {
         strcat(szString01,moduleName);
         stream=fopen(szString01,"r");
         if (j==numPath-1 && stream==NULL) {
            if (ttflag==1) {
               pos=0;
               while (1) {
		  if (moduleName[pos]=='.')
                     break;
                  pos++;
               }
               moduleName[pos]='\0';
               strcat(moduleName,".asm");
	       //EnableWindow(hWndBsFunc[5],FALSE);Hera,reason:UNKNOWN
               asmEnable='N';
               ttflag--;
               j=0;
            }
            else {
               EnableWindow(hWndBsFunc[5],TRUE);
               asmEnable='Y';
               return ER_FILE_NOT_FOUND;
            }
         }
         else
            j++;
      }
   }
   j=0;
   /*
   hWndOldMemTitleList=(HLOCAL)SendMessage(hWndTitleList,EM_GETHANDLE,0,0l);
   LocalFree(hWndOldMemTitleList);
   hWndNewMemTitleList=LocalAlloc(LMEM_MOVEABLE,32*1024);
   ptxText=curPtr=LocalLock(hWndNewMemTitleList);
   */
   SendMessage(hWndTitleList,WM_SETFONT,hFontFixed,0);
   if (first==0)
      SendMessage(hWndTitleList,LB_RESETCONTENT,0,0);
   tabWidth=GetPrivateProfileInt("SourceInfo","TabWidth",1,"mp186.ini");
   if (asmFlag=='N')
      while (1) {
         j++;
         fgets(lineText,sizeof(lineText),stream);
         if ((j>=startLine) && (j<=endLine)) {
            i=strlen(lineText);
            lineText[i-1]='\0';
	    ProcessTabInText(lineText,tabLineText);	 
            if (funcName[0]!='\0') 
	       if (j==startFuncL) 
		  strcpy(findString,tabLineText);
            SendMessage(hWndTitleList,LB_ADDSTRING,0,
               (LPARAM)(LPSTR)tabLineText);
         }
         if (j==endLine)
            break;
      }
   else
      while (1) {
         j++;
         fgets(lineText,sizeof(lineText),stream);
         if ((j>=startLine) && (j<=endLine)) {
            i=strlen(lineText);
            lineText[i-1]='\0';
            ProcessTabInText(lineText,tabLineText);
            if (funcName[0]!='\0')
               if (j==startFuncL)
		  strcpy(findString,tabLineText);
            SendMessage(hWndTitleList,LB_ADDSTRING,0,
               (LPARAM)(LPSTR)lineText);
            ConvLinenum2AsmCode(moduleDesc,j,idDasm);
         }
         if (j==endLine)
            break;
      }
   /*
   *curPtr='\0';
   LocalUnlock(hWndNewMemTitleList);
   SendMessage(hWndTitleList,EM_SETHANDLE,hWndNewMemTitleList,0l);
   */
   UpdateWindow(hWndTitleList);
   if (funcName[0]!='\0') {
      dwIndex=SendMessage(hWndTitleList,LB_FINDSTRING,
         0,(LPARAM)(LPSTR)findString);
      SendMessage(hWndTitleList,LB_SETTOPINDEX,(WPARAM)dwIndex,0);
   }
   fclose(stream);
   return GOOD;
}
/***************************************************************************
**
**    GetFuncCode(moduleString,funcString);
**
****************************************************************************/
RETCODE GetFuncCode(char *startText,char *endText,char *funcName)  {
char moduleName[MAXLEN],startFuncText[MAXLEN],endFuncText[MAXLEN];
char nextStart[MAXLEN];
char szString00[100],szString01[MAXLEN];
DESCRIPTOR startAddrDesc,idDasm;
U16 startLineNum = 0,endLineNum = 0,startFuncL,endFuncL;
U16 startLineTmp, endLineTmp;
RETCODE err;
BOOLEAN ending=FALSE;
U8 first=0;
int count,index;

   strcpy(szString01,startText);
   while (!ending) {
      count = 1;
      if (strlen(startText) >= 10)
         count = strlen(startText)/10;
      index = 0;
      while (index < count) {
         char startTmp[MAXLEN],endTmp[MAXLEN];
         strncpy(startTmp,startText+(index*10),9);
	 strncpy(endTmp,endText+(index*10),9);
         startTmp[9] = endTmp[9] = '\0'; 
         GetLinenumByStartAndEndTextAddr(startTmp,endTmp,&startLineTmp,
				  &endLineTmp,moduleName,nextStart,&ending);
	 if (index == 0) {
	    startLineNum = startLineTmp;
	    endLineNum = endLineTmp;
	 } else {
  	    startLineNum = min(startLineTmp, startLineNum);
	    endLineNum = max(endLineTmp, endLineNum);
	 }
	 index++;
      }
      if (moduleName[0]=='\0')
         break;
      if (funcName[0]!='\0') {
         GetStartAndEndAddr(moduleName,funcName,
             startFuncText,endFuncText);
         GetLinenumByStartAndEndTextAddr(startFuncText,endFuncText,&startFuncL,
            &endFuncL,moduleName,nextStart,&ending);
      }
      if (asmFlag=='Y') {
         AdrCreateAddress(&startAddrDesc);
         AdrSetAddrSegmentSelector(startAddrDesc,ADDR_USE_CS,NULL);
	 AdrSetAddrOffset(startAddrDesc,0);
	 DadDasmOpen(&idDasm,startAddrDesc);
         AdrDestroyAddress(startAddrDesc);
      }
      if ((err=ModuleOpen(moduleName,idDasm,(int)startLineNum,
         (int)endLineNum,(int)startFuncL,funcName,first))!=GOOD) {
         if (err==ER_FILE_NOT_FOUND) {
               strcpy(szString00,"File not found. You can modify or add path in source path dialog.");
               ErrMessageBoxL(szString00);
         }
         return GOOD;
      }
      // strcpy(startText,nextStart); /* Winky 12/12/97 szString01 --> startText*/
      if(nextStart != 0)
      ending = 1;
      first++;
   }
   if (asmFlag=='Y' && moduleName[0]!='\0')
      DadDasmClose(idDasm);
   return GOOD;
}
/***************************************************************************
**
**    GetAsmCode
**
****************************************************************************/
RETCODE GetAsmCode(char *startText,char *endText) {
DESCRIPTOR startAddrDesc,startDesc,endDesc,idDasm;
U32 length,nextOffset,numByte;
U16 buflen,instCount,lineCount,opSize;
LPSTR resultBuf,startPtr,tempPtr;
RETCODE err;
U32 startOffset,endOffset;//Eric 2/9/98

   //EnableWindow(hWndBsFunc[5],FALSE);-- Hera 12/17/97 for ID:173
   AdrCreateAddress(&startAddrDesc);
   AdrSetAddrSegmentSelector(startAddrDesc,ADDR_USE_CS,NULL);
   AdrSetAddrOffset(startAddrDesc,0);
   DadDasmOpen(&idDasm,startAddrDesc);
   AdrDestroyAddress(startAddrDesc);
   SendMessage(hWndTitleList,WM_SETFONT,hFontFixed,0);
   SendMessage(hWndTitleList,LB_RESETCONTENT,0,0);
   AdrCreateAddressFromText(startText,NULL,&startDesc);
   AdrCreateAddressFromText(endText,NULL,&endDesc);
   //AdrRangeOfAddresses(startDesc,endDesc,&length); //Eric 2/9/98
   //Fixed bug for multiple segment by Eric 2/9/98
   if (AdrRangeOfAddresses(startDesc,endDesc,&length) == ER_ADR_DIFFER_SEGMENTS) {
      AdrGetAddrPhysicalOffset(startDesc,&startOffset);
      AdrGetAddrPhysicalOffset(endDesc,&endOffset);
      if (startOffset < endOffset) length = endOffset - startOffset;
      else length = startOffset - endOffset;
   }
   //eof Eric 2/9/98
   AdrSetAddrRangeLength(startDesc,length);
   AdrDuplicateAddress(startDesc,&startAddrDesc);
   DadDasmGetRangeInstCount(idDasm,startAddrDesc,&instCount,&lineCount);
   while(instCount != 0 && ((U32)instCount) < 0xFFFF) {
      AdrDuplicateAddress(startDesc,&startAddrDesc);
      if ((err = DadDasmRangeOfInst(idDasm,startAddrDesc,&resultBuf,
         &buflen))!=GOOD) {
         AdrDestroyAddress(startDesc);
         AdrDestroyAddress(endDesc);
         return err;
      }
      startPtr=tempPtr=resultBuf;
      while(tempPtr!=NULL) {
	 LPSTR temp,endstr;
         CHAR offstr[5];
         tempPtr=strstr(resultBuf,"\x0D\x0A");
	 if (tempPtr!=NULL){
	    int i = 0;
	    *tempPtr = '\0';
	    temp = resultBuf;
            while(temp[i] != 0x20) i++;
	    while(temp[i] == 0x20) i++;
            opSize = 0;
	    while(temp[i++] != 0x20)
	       opSize++;
	    instCount--;

	 }
	 else if(instCount == 1) instCount--;
         if(strlen(resultBuf) != 0)
  	    SendMessage(hWndTitleList,LB_ADDSTRING,0,(LPARAM)(LPSTR)resultBuf);
	 temp = strstr(resultBuf,":");
         if(temp != NULL) {
	    strncpy(offstr,temp+1,4);
	    offstr[4] = '\0';
	    nextOffset = strtoul(offstr,&endstr,16);
	 }
	 resultBuf=tempPtr+2;
      }
      if (instCount != 0 && ((U32)instCount) < 0xFFFF) {
	 AdrSetAddrOffset(startDesc,nextOffset+(opSize/2));
	 TFree(startPtr);
	 //AdrRangeOfAddresses(startDesc,endDesc,&numByte); //Eric 2/9/98
	 //Fixed bug for multiple segment by Eric 2/9/98
	 if (AdrRangeOfAddresses(startDesc,endDesc,&numByte) == ER_ADR_DIFFER_SEGMENTS) {
	 AdrGetAddrPhysicalOffset(startDesc,&startOffset);
	 AdrGetAddrPhysicalOffset(endDesc,&endOffset);
	 if (startOffset < endOffset) numByte = endOffset - startOffset;
	 else numByte = startOffset - endOffset;
	 }
	 //eof Eric 2/9/98
	 AdrSetAddrRangeLength(startDesc,numByte);
      }
   }
   TFree(startPtr);
   DadDasmClose(idDasm);
   AdrDestroyAddress(startDesc);
   AdrDestroyAddress(endDesc);
   return GOOD;
}
/************************************************************************
**
**        GetFuncContent
**
*************************************************************************/
RETCODE GetFuncContent(LONG lParam) {
char tempString[MAXLEN],startText[11*MAX_SEG_NUM],endText[11*MAX_SEG_NUM];
char rangeName[MAXLEN],funcName[MAXLEN];
int i;
DWORD nIndex;
POINT ttPoint;
//char *tempChar;
   tempString[0]='\0';
   ttPoint=MAKEPOINT(lParam);
   nIndex=CountListIndex(ttPoint.y);
   SendMessage(hWndDir,LB_GETTEXT,(WPARAM)nIndex,
      (LPARAM)(LPSTR)tempString);
   if (tempString[0]=='\0')
      return GOOD;
   funcName[0]='\0';
   if (!(tempString[0]=='+' || tempString[0]=='-' || tempString[1]!=' ')) {
      i=8;
      while(tempString[i]!='\0') {
         funcName[i-8]=tempString[i];
         i++;
      }
      funcName[i-8]='\0';
      tempString[0]='\0';
      while (tempString[0]!='+' && tempString[0]!='-')
         SendMessage(hWndDir,LB_GETTEXT,(WPARAM)nIndex--,
            (LPARAM)(LPSTR)tempString);
   }
   i=5;
   while(tempString[i]!='\0') {
      rangeName[i-5]=tempString[i];
      i++;
   }
   rangeName[i-5]='\0';
   strcpy(selectedRangeName,rangeName);
   strcpy(selectedFuncName,funcName);
   GetRangeTextBasedOnRangeName(rangeName,startText,endText);
   GetFuncCode(startText,endText,funcName);
   return GOOD;
}
/************************************************************************
**
**          CountLinstIndex
**
*************************************************************************/
DWORD CountListIndex(float x) {
DWORD nIndex;
int i;
   nIndex=SendMessage(hWndDir,LB_GETTOPINDEX,0,0l);
   i=ceil(x/heightItem);
   return i+nIndex-1;
}
/****************************************************************
**
**     ReFillDirList
**
*****************************************************************/
void ReFillDirList() {
char rangeName[MAXLEN],startRangeAddrText[11*MAX_SEG_NUM];
char endRangeAddrText[11*MAX_SEG_NUM];
char tempString[MAXLEN],moduleName[MAXLEN];
char szString00[MAXLEN],szString01[MAXLEN],szString02[MAXLEN];
char startText[11*MAX_SEG_NUM],endText[11*MAX_SEG_NUM];
DESCRIPTOR moduleRangeDesc;
SYM_DESCRIPTOR moduleDesc,funcDesc;
U8 u8Count,i,u8Selected;
U16 percent;
SYM_TYPE_TYPE symType;
int  modFlag;
LPSTR strPtr;

   SpaRangesCountGet(nSPAstatus,&u8Count);
   AdrCreateAddress(&moduleRangeDesc);
   for (i=0;i<u8Count;i++){
      SpaRangesGetByIndex(i,nSPAstatus,rangeName,
      startRangeAddrText,endRangeAddrText,&u8Selected);
      if (u8Selected==1) {
         if (selectedRangeName[0]=='\0')
	    strcpy(selectedRangeName,rangeName);
         //AdrCreateAddress(&moduleRangeDesc);
         strncpy(szString00,startRangeAddrText,9);
	 strncpy(szString01,endRangeAddrText,9);
	 szString00[9] = szString01[9] = '\0';
         GetModuleByRangeTextAddr(szString00,szString01,
	    MODULE_MODE,&moduleDesc,moduleRangeDesc,moduleName);
	 strPtr = strchr(rangeName, '(');
         modFlag = 0;             /* Winky 12/11/97 */
         if (strPtr != '\0') {
         if (*(strPtr+1) == 'F')
            modFlag = 0;
         else if(*(strPtr+1) == 'M')
            modFlag = 1;
         }
	 if (moduleDesc!=NULL_SYMBOL && modFlag == 1) {
            SymGetSymbolChild(moduleDesc,&symType,&funcDesc);
            if (funcDesc==NULL_SYMBOL)
	       moduleDesc=NULL_SYMBOL;
	 }
         GetRangePercent(startRangeAddrText,endRangeAddrText,&percent);
         if (moduleDesc!=NULL_SYMBOL && modFlag == 1) {
               wsprintf(szString02,"%u%%",percent);
               wsprintf(tempString,"+%-4s%s",szString02,rangeName);
               SendMessage(hWndDir,LB_ADDSTRING,0,
                  (LPARAM)((LPSTR)tempString));
         }
	 else {
            wsprintf(szString02,"%u%%",percent);
            wsprintf(tempString," %-4s%s",szString02,rangeName);
            SendMessage(hWndDir,LB_ADDSTRING,0,
               (LPARAM)((LPSTR)tempString));
         }
      }
   }//FOR
   AdrDestroyAddress(moduleRangeDesc);
   if (selectedRangeName[0]!='\0' && u8Count>0) {      
      GetRangeTextBasedOnRangeName(selectedRangeName,startText,endText);
      GetFuncCode(startText,endText,"");
   }
}

/****************************************************************
**
**     GetModuleByRangeTextAddr
**
**     mode={INSTRUCTION_MODE,MODULE_MODE}
**     moduleRangeDesc: memory allocated by caller
**     output: moduleDesc
**             moduleRangeDesc, NULL if no relation
**             moduleName
*****************************************************************/
RETCODE GetModuleByRangeTextAddr(char *startText, char *endText,
   RANGE_MODE_TYPE mode,SYM_DESCRIPTOR *moduleDesc,
   DESCRIPTOR moduleRangeDesc,char *moduleName) {
SYM_DESCRIPTOR nextModuleDesc;
SYM_TYPE_TYPE symType;
DESCRIPTOR startDesc,endDesc;
static DESCRIPTOR moduleAddrDesc=NULL_SYMBOL;
static SYM_DESCRIPTOR tempModuleDesc=NULL_SYMBOL;
U32 length;
BOOLEAN isEqualOverlap;
char tempModuleName[MAXLEN];
RETCODE err;
U32 startOffset,endOffset;//Eric 3/9/98

   AdrCreateAddressFromText(startText,NULL,&startDesc);
   AdrCreateAddressFromText(endText,NULL,&endDesc);
   //AdrRangeOfAddresses(startDesc,endDesc,&length); //Eric 2/9/98
   //Fixed bug for multiple segment by Eric 2/9/98
   if (AdrRangeOfAddresses(startDesc,endDesc,&length) == ER_ADR_DIFFER_SEGMENTS) {
      AdrGetAddrPhysicalOffset(startDesc,&startOffset);
      AdrGetAddrPhysicalOffset(endDesc,&endOffset);
      if (startOffset < endOffset) length = endOffset - startOffset;
      else length = startOffset - endOffset;
   }
   //eof Eric 2/9/98
   AdrSetAddrRangeLength(startDesc,length);
   /*
   if ((mode==INSTRUCTION_MODE) && (tempModuleDesc!=NULL)) {
      AdrDoRangesOverlap(moduleAddrDesc,startDesc,&overlap);
      if (overlap) {
         strcpy(moduleName,tempModuleName);
         AdrCopyAddress(moduleAddrDesc,moduleRangeDesc);
         *moduleDesc=tempModuleDesc;
         return GOOD;
      }
   }
   if (moduleAddrDesc!=NULL)
      AdrDestroyAddress(moduleAddrDesc);
   */
   err=AdrCreateAddress(&moduleAddrDesc);
   if ((err=SymGetModuleListHead(&tempModuleDesc))!=GOOD) {
      AdrDestroyAddress(startDesc);
      AdrDestroyAddress(endDesc);
      *moduleDesc=NULL_SYMBOL;
      noSymbol=TRUE;
      return err;
   }
   else
      noSymbol=FALSE;
   while(1) {
      SymGetModule(tempModuleDesc,tempModuleName,moduleAddrDesc);
      if (mode==MODULE_MODE) 
	 AdrIsAddrInRange1(startDesc,moduleAddrDesc,&isEqualOverlap);
	 //AdrIsAddrRangeEqual(startDesc,moduleAddrDesc,&isEqualOverlap);
      if (mode==INSTRUCTION_MODE)
         AdrDoRangesOverlap(moduleAddrDesc,startDesc,&isEqualOverlap);
      if (isEqualOverlap==TRUE) {
	    AdrCopyAddress(moduleAddrDesc,moduleRangeDesc);
            strcpy(moduleName,tempModuleName);
	    *moduleDesc=tempModuleDesc;
            AdrDestroyAddress(startDesc);//Hera
            AdrDestroyAddress(endDesc);//Hera
            return GOOD;
      }
      SymGetSymbolSibling(tempModuleDesc,&symType,&nextModuleDesc);
      if (nextModuleDesc==NULL_SYMBOL)
         break;
      tempModuleDesc=nextModuleDesc;
   }
   if (isEqualOverlap!=TRUE) {
      *moduleDesc=NULL_SYMBOL;
      noSymbol=TRUE;
   }
   AdrDestroyAddress(startDesc);//Hera
   AdrDestroyAddress(endDesc); //Hera
   return GOOD;
}
/****************************************************************
**
**     ProcessSpaMAGet
**
*****************************************************************/
RETCODE ProcessSpaMAGet(HDC hDc) {
//U32 totalStamp,totalCount;
U32 totalCount;
//SPA_MA_INFO dataInfo[4]={{0,0},{0,0},{0,0},{0,0}};
U16 i,fillRectWidth,j;
static U16 percent=0;
HBRUSH hBrushBlue,hOldBrush;
char szString00[MAXLEN];

   totalCount=0;
   hBrushBlue=CreateSolidBrush(RGB(0,255,255));
   hOldBrush=SelectObject(hDc,hBrushBlue);
   for (i=0;i<4;i++)
      totalCount=totalCount+dataInfo[i].count;
   for (i=0;i<4;i++) {
      if (totalStamp!=0)
         percent=dataInfo[i].Stamp/(totalStamp/100.0);
      else
         percent=0;
      fillRectWidth=widthRect*percent/100;
      j=i*2+1;
      Rectangle(hDc,leftRect,topRect+1.5*cyChar*j,
         leftRect+fillRectWidth,topRect+1.5*cyChar*j+heightRect);
      //SetTextColor(hDc,RGB(255,255,0));
      wsprintf(szString00,"%d%%",percent);
      TextOut(hDc,leftRect+widthRect/2,topText+i*3*cyChar+1.5*cyChar,
         szString00,strlen(szString00));
      //SetTextColor(hDc,RGB(0,0,0));
      wsprintf(szString00,"%lu",dataInfo[i].Stamp/20);
      TextOut(hDc,leftText+10*cxAveChar,topText+i*3*cyChar+1.5*cyChar,
         szString00,strlen(szString00));
      strcpy(szString00,"us");
      TextOut(hDc,leftText+20*cxAveChar,topText+i*3*cyChar+1.5*cyChar,
         szString00,strlen(szString00));
   }
   for (i=0;i<4;i++) {
      if (totalCount!=0)
         percent=dataInfo[i].count/(totalCount/100.0);
      else
         percent=0;
      fillRectWidth=widthRect*percent/100;
      j=i*2;
      Rectangle(hDc,leftRect,topRect+1.5*cyChar*j,
         leftRect+fillRectWidth,topRect+1.5*cyChar*j+heightRect);
      //SetTextColor(hDc,RGB(200,200,0));
      wsprintf(szString00,"%d%%",percent);
      TextOut(hDc,leftRect+widthRect/2,topText+i*3*cyChar,
         szString00,strlen(szString00));
      //SetTextColor(hDc,RGB(0,0,0));
      wsprintf(szString00,"%u",dataInfo[i].count);
      TextOut(hDc,leftText+10*cxAveChar,topText+i*3*cyChar,
         szString00,strlen(szString00));
   }
   wsprintf(szString00,"%lu",totalCount);
   TextOut(hDc,leftText,addHeight+13.5*cyChar,szString00,
      strlen(szString00));
   wsprintf(szString00,"%lu",totalStamp/20);
   TextOut(hDc,leftText+31*cxAveChar,addHeight+13.5*cyChar,szString00,
      strlen(szString00));
   strcpy(szString00,"us");
   TextOut(hDc,leftText+43*cxAveChar,addHeight+13.5*cyChar,szString00,
      strlen(szString00));
   SelectObject(hDc,hOldBrush);
   DeleteObject(hBrushBlue);
   return GOOD;
}
/****************************************************************
**
**     ProcessSpaTAGet
**
*****************************************************************/
RETCODE ProcessSpaTAGet(HDC hDc) {
//U32 timeStamp[3],totalCount;
U32 totalCount;
//U16 dataCount[9];
HBRUSH hBrushBlue,hOldBrush;
static U16 percent=0;
U16 i,fillRectWidth;
char szString00[MAXLEN];
//BOOLEAN flagStop;
   totalCount=0;
   hBrushBlue=CreateSolidBrush(RGB(0,255,255));
   hOldBrush=SelectObject(hDc,hBrushBlue);
   for (i=0;i<9;i++)
      totalCount=totalCount+dataCount[i];
   for (i=0;i<9;i++) {
      if (totalCount!=0)
         percent=dataCount[i]/(totalCount/100.0);
      else
         percent=0;
      fillRectWidth=30*cxAveChar*percent/100;
      Rectangle(hDc,addWidth+50*cxAveChar,addHeight+7*cyChar+i*cyChar*1.2,
         addWidth+50*cxAveChar+fillRectWidth,addHeight+7.7*cyChar+i*1.2*cyChar);
      wsprintf(szString00,"%d%%",percent);
      TextOut(hDc,addWidth+48*cxAveChar+15*cxAveChar,
         addHeight+6.8*cyChar+i*cyChar*1.2,szString00,strlen(szString00));
      wsprintf(szString00,"%u",dataCount[i]);
      TextOut(hDc,addWidth+30*cxAveChar,addHeight+7*cyChar+i*cyChar*1.2,
         szString00,strlen(szString00));
   }
   if (totalCount!=0)
      wsprintf(szString00,"%lu",timeStamp[0]/(20*totalCount));
   else
      wsprintf(szString00,"%lu",timeStamp[0]);
   TextOut(hDc,addWidth+16*cxAveChar,addHeight+20*cyChar,
      szString00,strlen(szString00));
   wsprintf(szString00,"%lu",timeStamp[1]/20);
   TextOut(hDc,addWidth+41*cxAveChar,addHeight+20*cyChar,
      szString00,strlen(szString00));
   wsprintf(szString00,"%lu",timeStamp[2]/20);
   TextOut(hDc,addWidth+67*cxAveChar,addHeight+20*cyChar,
      szString00,strlen(szString00));
   SelectObject(hDc,hOldBrush);
   DeleteObject(hBrushBlue);
   return GOOD;
}
/****************************************************************
**
**     GetBrkPoint()
**
*****************************************************************/
RETCODE GetBrkPoint() {
char szString00[MAXLEN],szString01[MAXLEN],szString02[MAXLEN];
U32 addrOffset=0xffffffffL,addrSegment=0xffffffffL;
U16 i;

   SpaGetBkpt(&addrSegment,&addrOffset);
   if (addrSegment==0xffffffffl && addrOffset==0xffffffffl)
      szBrkPoint[0]='\0';
   else {
      ltoa(addrSegment,szString00,16);
      ltoa(addrOffset,szString01,16);
      wsprintf(szString02,"%04s:%04s",szString00,szString01);
      for (i=0;i<strlen(szString02);i++)
         szBrkPoint[i]=toupper(szString02[i]);
   }
   //strcpy(szBrkPoint,szString00);
   return GOOD;
}
/*****************************************************************************
**
**  ProcessLineMarked
**
*****************************************************************************/
RETCODE ProcessLineMarked(VOID) {
RETCODE err;
DESCRIPTOR addrRangeDesc,startAddrDesc,endAddrDesc,moduleDesc,curDesc;
DESCRIPTOR nextDesc,addrCopyRangeDesc,idDasm;
LINENUM_TYPE actualLinenum;
COLUMN_TYPE actualColumn;
LINENUM_DESCRIPTOR nextIndex;
U16 startL,endL,j,lineCount,instCount,startFuncL,endFuncL,baseLine;
U16 endLineTmp,startLineTmp;
int index,count;
U32 numByte,size,rangeSize/*,baseCount*/,numTmp,nextOffset=0;
int i;
char szString01[MAXLEN],szString02[MAXLEN];
char startFuncText[MAXLEN],endFuncText[MAXLEN];//,lineText[200];
char tempString[MAXLEN],startText[11*MAX_SEG_NUM],endText[11*MAX_SEG_NUM];
char tempStartText[MAXLEN],tempString1[MAXLEN];
char nextStart[MAXLEN],findString[200];
BOOLEAN ismark,flagStop,markedFlag,ending=FALSE,multiSeg=FALSE;
LPSTR resultBuf,tempPtr,startPtr,nextBuffer;
U16 buflen;
U8 addr12Flag;
S32 asmCount,funcCount,preAsmCount=0;
DWORD dwIndex;
char moduleName[MAXLEN];
U16 preEndLine = 0;  // Winky 01/15/98
U32 startOffset,endOffset;//Eric 3/9/98


   //if (canGetCCFlag!=TRUE || isRangedFlag!=TRUE)
   if (canGetCCFlag!=TRUE)
      return GOOD;

   GetRangeTextBasedOnRangeName(selectedRangeName,
      startText,endText);
   count = 1;
   if (strlen(startText) >= 10)
      count = strlen(startText)/10;
   index = 0;
   //baseCount=0;
   while(index < count) {
      strncpy(tempString,startText+(index*10),9); /*avoid startText be modified*/
      tempString[9] = '\0';
      AdrCreateAddressFromText(tempString,NULL,&startAddrDesc);
      strncpy(tempString,endText+(index*10),9);
      tempString[9] = '\0';
      AdrCreateAddressFromText(tempString,NULL,&endAddrDesc);
      DadDasmOpen(&idDasm,startAddrDesc);
      //AdrRangeOfAddresses(startAddrDesc,endAddrDesc,&numByte); //Eric 2/9/98
      //Fixed bug for multiple segment by Eric 2/9/98
      if (AdrRangeOfAddresses(startAddrDesc,endAddrDesc,&numByte) == ER_ADR_DIFFER_SEGMENTS) {
	 AdrGetAddrPhysicalOffset(startAddrDesc,&startOffset);
	 AdrGetAddrPhysicalOffset(endAddrDesc,&endOffset);
	 if (startOffset < endOffset) numByte = endOffset - startOffset;
	 else numByte = startOffset - endOffset;
      }
      //eof Eric 2/9/98
      ptrMemCC=(LPSTR)TMalloc((numByte/8+1)*sizeof(U8));
      flagStop=1;
      SpaCCGet(startText+(index*10),endText+(index*10),ptrMemCC,&flagStop);
      ending=FALSE;
      while (!ending) {
	 char startTmp[MAXLEN],endTmp[MAXLEN];
	 strncpy(startTmp,startText+(index*10),9);
	 strncpy(endTmp,endText+(index*10),9);
	 startTmp[9] = endTmp[9] = '\0';
	 GetLinenumByStartAndEndTextAddr(startTmp,endTmp,&startLineTmp,
					&endLineTmp,moduleName,nextStart,&ending);
    if(!ending)
      ending = 1;
    if (index == 0) {
    /* if (index == 0) //Hera 7/4/97   Winky 1/15/98 */
      if (preEndLine)
	 baseLine = baseLine + startLineTmp - preEndLine - 1;
      else
	 baseLine = startLineTmp;
      strcpy(tempString1,tempString);//Eric 2/11/98
    }
    else if (strcmp(tempString1,tempString)!=0) multiSeg = TRUE;//Eric 2/11/98

     startL = startLineTmp;
     preEndLine = endL = endLineTmp;

	 //} else {
	 //   startL = min(startLineTmp, startL);
	 //   endL = max(endLineTmp, endL);
	 //}
	 if (selectedFuncName[0]!='\0') {
            GetStartAndEndAddr(moduleName,selectedFuncName,
               startFuncText,endFuncText);
	    GetLinenumByStartAndEndTextAddr(startFuncText,endFuncText,&startFuncL,
	       &endFuncL,moduleName,nextStart,&ending);
	 }
	 if (moduleName[0]=='\0') {
	    AdrSetAddrRangeLength(startAddrDesc,numByte);
	    ending=TRUE;
	    startL=endL=0;
	    asmFlag='Y';
	    asmCount=-1;
	 }
	 else {
	    if ((err=SymGetModuleDesc(moduleName,0,&moduleDesc))!=GOOD)
	       return err;
	    //if ((err=AdrCreateAddress(&addrRangeDesc))!=GOOD)
	    //   return err;
	    asmCount=0;
	    if (multiSeg) asmCount += preAsmCount; //Eric 2/11/98
	 }
	 for (j=startL;j<=endL;j++) {
	    if (moduleName[0]!='\0') {
	       if ((err=AdrCreateAddress(&addrRangeDesc))!=GOOD)
                  return err;
               if ((err=SymGetLinenum(moduleDesc,j,addrRangeDesc,
		     &actualLinenum,&actualColumn,&nextIndex))!=GOOD)
                  return err;
	       j=actualLinenum;
	    }
	    else
	       AdrDuplicateAddress(startAddrDesc,&addrRangeDesc);
	    if (selectedFuncName[0]!='\0')
	       if (j==startFuncL)
                  funcCount=asmCount;
            //AdrConvAddressToText(addrRangeDesc,szString00);
            //AdrCreateAddressFromText(szString00,NULL,&curDesc);
	    AdrGetAddrRangeLength(addrRangeDesc,&rangeSize);
	    AdrDuplicateAddress(addrRangeDesc,&addrCopyRangeDesc);
	    DadDasmGetRangeInstCount(idDasm,addrRangeDesc,&instCount,
               &lineCount);
	    if ((DadDasmRangeOfInst(idDasm,addrCopyRangeDesc,&resultBuf,
               &buflen))!=GOOD)
	       return err;
Continue:
	    startPtr=tempPtr=nextBuffer=resultBuf;
            //AdrDestroyAddress(addrRangeDesc);
	    //AdrDestroyAddress(addrCopyRangeDesc);
	    for (i=0;i<instCount;i++) {
	       addr12Flag=0x00;
	       while(1) {
		  asmCount++;
		  tempPtr=strstr(resultBuf,"\x0D\x0A");
                  if (tempPtr!=NULL)
		     *tempPtr='\0';
                  sscanf(resultBuf,"%s",&szString01);
                  if (szString01[4]==':' ||
                                     szString01[2] == ':' /*Hera 12/17/97*/) {
		     CHAR offstr[5],*endstr;
		     addr12Flag=addr12Flag | 0x01;
		     if(szString01[4] == ':')
		        strncpy(offstr,&(szString01[5]),4);                        
		     else
		        strncpy(offstr,&(szString01[3]),4);
		     offstr[4] = '\0';
		     nextOffset = strtoul(offstr,&endstr,16);
		     break;
		  }
		  else
		     resultBuf=tempPtr+2;
	       }
	       if (addr12Flag==0x01) {
                  AdrCreateAddressFromText(szString01,NULL,&curDesc);
                  resultBuf=tempPtr+2;
		  while(1) {
		     if (i!=instCount-1) {
                        nextBuffer=tempPtr+2;
			//if (i!=instCount-2)
                        tempPtr=strstr(nextBuffer,"\x0D\x0A");
			if (tempPtr != NULL)		                        
			   *tempPtr='\0';
			//Hera 12/23/97 ID172
			else if(i != (instCount-2)){
			   AdrSetAddrOffset(startAddrDesc,nextOffset);
			   TFree(startPtr);
			   //AdrRangeOfAddresses(startAddrDesc,endAddrDesc,&numByte);//Eric 2/9/98
			   //Fixed bug for multiple segment by Eric 2/9/98
			   if (AdrRangeOfAddresses(startAddrDesc,endAddrDesc,&numByte) == ER_ADR_DIFFER_SEGMENTS) {
			      AdrGetAddrPhysicalOffset(startAddrDesc,&startOffset);
			      AdrGetAddrPhysicalOffset(endAddrDesc,&endOffset);
			      if (startOffset < endOffset) numByte = endOffset - startOffset;
			      else numByte = startOffset - endOffset;
			   }
			   //eof Eric 2/9/98
			   AdrSetAddrRangeLength(startAddrDesc,numByte);
		           AdrDuplicateAddress(startAddrDesc,&addrRangeDesc);
		           AdrDuplicateAddress(addrRangeDesc,&addrCopyRangeDesc);
          	           DadDasmGetRangeInstCount(idDasm,addrRangeDesc,&instCount,
	                                                       &lineCount);
		           if ((DadDasmRangeOfInst(idDasm,addrCopyRangeDesc,&resultBuf,
                                &buflen))!=GOOD)
 			      return err;
			   goto Continue;
			}
                        //Hera
			sscanf(nextBuffer,"%s",&szString02);
			if (szString02[4]==':' ||
				    szString02[2] == ':' /*Hera 12/17/97*/) {
			   CHAR offstr[5],*endstr;
			   addr12Flag=addr12Flag | 0x10;
			   if(szString02[4] == ':')
			      strncpy(offstr,&(szString02[5]),4);                        
			   else
			      strncpy(offstr,&(szString02[3]),4);
                           offstr[4] = '\0';
                           nextOffset = strtoul(offstr,&endstr,16);
                           break;
			}
			else
                           *tempPtr='\x0D';
                     }
		     else
                        break;
		  }
		  if (addr12Flag==0x11) {
		     AdrCreateAddressFromText(szString02,NULL,&nextDesc);
		     //AdrRangeOfAddresses(curDesc,nextDesc,&size); //Eric 2/9/98
		     //Fixed bug for multiple segment by Eric 2/9/98
		     if (AdrRangeOfAddresses(curDesc,nextDesc,&size) == ER_ADR_DIFFER_SEGMENTS) {
			AdrGetAddrPhysicalOffset(curDesc,&startOffset);
			AdrGetAddrPhysicalOffset(nextDesc,&endOffset);
			if (startOffset < endOffset) size = endOffset - startOffset;
			else size = startOffset - endOffset;
		     }
		     //eof Eric 2/9/98
		     size=size-1;
                     rangeSize=rangeSize-size;
                     AdrDestroyAddress(nextDesc);
                  }
                  else
		     size=rangeSize;
               }
	       if ((addr12Flag&0x01)==0x01) {
		  LineIsMarked(curDesc,startAddrDesc,size,&ismark);
		  if (asmFlag!='Y') {
		     if (ismark) {
			 markedFlag=TRUE;
			 break;
		     }
		     else
			markedFlag=FALSE;

		  }
		  else {
		     if (ismark)
			 SendMessage(hWndTitleList,LB_SETSEL,TRUE,
			    (U32)(j-baseLine+asmCount));
		  }
		  if (tempPtr!=NULL/*Hera 12/17/97*/
					 &&(i!=instCount-2 && i!=instCount-1))
		     *tempPtr='\x0D';
	       }
	      AdrDestroyAddress(curDesc);
	    }
	    if (asmFlag!='Y' && markedFlag==TRUE)
	       SendMessage(hWndTitleList,LB_SETSEL,TRUE,
		  MAKELONG(j-baseLine,0));
	    if (selectedFuncName[0]!='\0')
	       if (j==startFuncL) {
		  if (asmFlag!='Y')
		     SendMessage(hWndTitleList,LB_GETTEXT,(WPARAM)(j-baseLine),
			(LPARAM)(LPSTR)findString);
		  else
		     SendMessage(hWndTitleList,LB_GETTEXT,(WPARAM)(j-baseLine+funcCount),
			(LPARAM)(LPSTR)findString);
	       }
	    TFree(startPtr);
	 }
	 /*if (asmFlag!='Y')
	    baseCount=j-startL+1;
	 else
	    baseCount=j-startL+asmCount+1;*/
	 strcpy(startText,nextStart);
	 /* Winky 12/15/97 tempStartText --> startText */
	 preAsmCount = asmCount; //Eric 2/11/98
      }
      index++;
   } //while(index < count)
   DadDasmClose(idDasm);
   TFree(ptrMemCC);
   SendMessage(hWndTitleList,LB_SETTOPINDEX,0,0);
   if (selectedFuncName[0]!='\0') {
      dwIndex=SendMessage(hWndTitleList,LB_FINDSTRING,
         0,(LPARAM)(LPSTR)findString);
      SendMessage(hWndTitleList,LB_SETTOPINDEX,(WPARAM)dwIndex,0);
   }
   //AdrDestroyAddress(addrRangeDesc);
   AdrDestroyAddress(startAddrDesc);
   AdrDestroyAddress(endAddrDesc);
   /*DadDasmClose(idDasm);*/
   return GOOD;
}
/*****************************************************************************
**
**  LineIsMarked
**
*****************************************************************************/
RETCODE LineIsMarked(DESCRIPTOR curAddr,DESCRIPTOR startAddr,U32 size,
   BOOLEAN *ismark) {
RETCODE err;
U8 mod,divider,test=0x01,shiftBit;
U32 numByte,i,u32Offset;
LPSTR ptrTempMemCC;
U32 startOffset,endOffset;//Eric 2/9/98

   if ((err=AdrGetAddrOffset(startAddr,&u32Offset))!=GOOD)
      return err;
   u32Offset=u32Offset/8*8;
   if ((err=AdrSetAddrOffset(startAddr,u32Offset))!=GOOD)
      return err;
   //if ((err=AdrRangeOfAddresses(curAddr,startAddr,&numByte))!=GOOD) //Eric 2/9/98
   //   return err;
   //Fixed bug for multiple segment by Eric 2/9/98
   if ((err=AdrRangeOfAddresses(curAddr,startAddr,&numByte))!=GOOD) {
      if (err == ER_ADR_DIFFER_SEGMENTS) {
	AdrGetAddrPhysicalOffset(curAddr,&startOffset);
	AdrGetAddrPhysicalOffset(startAddr,&endOffset);
	if (startOffset < endOffset) numByte = endOffset - startOffset;
	else numByte = startOffset - endOffset;
      }
      else
	return err;
   }
   //eof Eric 2/9/98
   for (i=numByte;i<numByte+size;i++) {
      shiftBit=mod=i%8;
      divider=i/8;
      if (mod==0) {
         divider=divider-1;
         shiftBit=7;
      }
      else
         shiftBit=shiftBit-1;
      ptrTempMemCC=ptrMemCC+divider;
      if ((test << shiftBit) & (*ptrTempMemCC)) {
         *ismark=TRUE;
      }
      else {
         *ismark=FALSE;
         return GOOD;
      }
   }
   return GOOD;
}
/*****************************************************************************
**
**  CheckAddressEven
**
*****************************************************************************/
RETCODE CheckAddressEven(char *sourceAddr,char *destAddr) {
char szString01[20],*temp,szString02[20],szString03[20];
U8 i;
U32 itemp;
   for (i=0;i<4;i++)
      szString01[i]=sourceAddr[i+5];
   szString01[4]='\0';
   itemp=strtoul(szString01,&temp,16);
   for (i=0;i<4;i++)
      szString02[i]=sourceAddr[i];
   szString02[4]='\0';
   itemp=(itemp/2)*2;
   ultoa(itemp,szString01,16);
   wsprintf(szString03,"%04s:%04s",szString02,szString01);
   for (i=0;i<strlen(szString03);i++)
      destAddr[i]=toupper(szString03[i]);
   return GOOD;
}
/*****************************************************************************
**
**  GetLinenumByStartAndEndTextAddr
**
*****************************************************************************/
RETCODE GetLinenumByStartAndEndTextAddr(char *startText,char *endText,
  U16 *startLineNum,U16 *endLineNum,char *moduleName,char *nextStart,
  BOOLEAN *ending) {
SYM_DESCRIPTOR moduleDesc;
DESCRIPTOR moduleAddrDesc,startDesc,endDesc,addrRangeDesc;
BOOLEAN isInRange;
U32 offset;
char moduleStartAddr[11*MAX_SEG_NUM],moduleEndAddr[11*MAX_SEG_NUM];
U16 startL,endL;
COLUMN_TYPE column;
LINENUM_DESCRIPTOR index;
RETCODE err;
char szString00[11*MAX_SEG_NUM],szString01[11*MAX_SEG_NUM];
   AdrCreateAddress(&moduleAddrDesc);
   strcpy(szString00,startText);
   strcpy(szString01,endText);
   GetModuleByRangeTextAddr(szString00,szString01,INSTRUCTION_MODE,
      &moduleDesc,moduleAddrDesc,moduleName);
   if (moduleDesc==NULL_SYMBOL) {
      GetAsmCode(startText,endText);
      moduleName[0]='\0';
      return GOOD;
   }
   strcpy(szString00,endText);
   AdrCreateAddressFromText((LPSTR)szString00,NULL,&endDesc);
   AdrIsAddrInRange1(endDesc,moduleAddrDesc,&isInRange); //Hera
   AdrDestroyAddress(endDesc);
   AdrDestroyAddress(moduleAddrDesc);
   if (!isInRange) {
      if ((err=GetStartAndEndAddr(moduleName,"",moduleStartAddr,
         moduleEndAddr))!=GOOD)
         return err;
      //Eric 7/6/98
      //strcpy(szString01,moduleEndAddr);
      if(moduleEndAddr[0] == 0) {
         strcpy(szString01,endText);
         strcpy(moduleEndAddr,endText);
      }
      else
         strcpy(szString01,moduleEndAddr);
      //Eof Eric 7/6/98
      if ((err=AdrCreateAddressFromText((LPSTR)szString01,NULL,
         &endDesc))!=GOOD)
         return err;
      AdrGetAddrOffset(endDesc,&offset);
      offset=offset+1;
      AdrSetAddrOffset(endDesc,offset);
      if ((err=AdrConvAddressToText(endDesc,nextStart))!=GOOD)
         return err;
      AdrDestroyAddress(endDesc);
      *ending=FALSE;
   }
   else {
      *ending=TRUE;
      nextStart[0]='\0';
   }
   strcpy(szString00,startText);
   if ((err=AdrCreateAddressFromText((LPSTR)szString00,NULL,
      &startDesc))!=GOOD)
      return err;
   if (!isInRange) {
      strcpy(szString01,moduleEndAddr);
      if ((err=AdrCreateAddressFromText((LPSTR)szString01,
         NULL,&endDesc))!=GOOD)
         return err;
   }
   else  {
      if ((err=AdrCreateAddressFromText((LPSTR)endText,NULL,&endDesc))!=GOOD)
         return err;
   }
   if ((err=SymGetModuleDesc((LPSTR)moduleName,0,
      &moduleDesc))!=GOOD)
      return err;
   if ((err=AdrCreateAddress(&addrRangeDesc))!=GOOD)
      return err;
   if ((err=SymMapAddr2Linenum(startDesc,moduleDesc,moduleDesc,/*Hera 6/5/97*/
       &startL,&column,addrRangeDesc,&index))!=GOOD)
      return err;
   *startLineNum=(U16)startL;
   if ((err=SymMapAddr2Linenum(endDesc,moduleDesc,moduleDesc,/*Hera 6/5/97*/
       &endL,&column,addrRangeDesc,&index))!=GOOD)
      return err;
   *endLineNum=(U16)endL;
   if ((err=AdrDestroyAddress(endDesc))!=GOOD)
      return err;
   if ((err=AdrDestroyAddress(startDesc))!=GOOD)
      return err;
   if ((err=AdrDestroyAddress(addrRangeDesc))!=GOOD)
      return err;
   return GOOD;
}
/*****************************************************************************
**
**  GetLinenumByModuleAndFunc
**
*****************************************************************************/
RETCODE GetLinenumByModuleAndFunc(char *moduleString,char *funcString,
    U16 *startL, U16 *endL)  {
char startAddr[11*MAX_SEG_NUM],endAddr[11*MAX_SEG_NUM];
DESCRIPTOR startDesc,endDesc,moduleDesc,addrRangeDesc;
LINENUM_TYPE startLineNum,endLineNum;
COLUMN_TYPE column;
LINENUM_DESCRIPTOR index;
RETCODE err;

   if ((err=GetStartAndEndAddr(moduleString,funcString,
      startAddr,endAddr))!=GOOD)
      return err;
   if ((err=AdrCreateAddressFromText((LPSTR)startAddr,NULL,
      &startDesc))!=GOOD)
      return err;
   if ((err=AdrCreateAddressFromText((LPSTR)endAddr,NULL,&endDesc))!=GOOD)
      return err;
   if ((err=SymGetModuleDesc((LPSTR)moduleString,0,
      &moduleDesc))!=GOOD)
      return err;
   if ((err=AdrCreateAddress(&addrRangeDesc))!=GOOD)
      return err;
   if ((err=SymMapAddr2Linenum(startDesc,moduleDesc,moduleDesc,/*Hera 6/5/97*/
       &startLineNum,&column,addrRangeDesc,&index))!=GOOD)
      return err;
   *startL=(U16)startLineNum;
   if ((err=AdrDestroyAddress(addrRangeDesc))!=GOOD)
      return err;
   if ((err=AdrCreateAddress(&addrRangeDesc))!=GOOD)
      return err;
   if ((err=SymMapAddr2Linenum(endDesc,moduleDesc,moduleDesc,/*Hera 6/5/97*/
       &endLineNum,&column,addrRangeDesc,&index))!=GOOD)
      return err;
   *endL=(U16)endLineNum;
   if ((err=AdrDestroyAddress(endDesc))!=GOOD)
      return err;
   if ((err=AdrDestroyAddress(startDesc))!=GOOD)
      return err;
   if ((err=AdrDestroyAddress(addrRangeDesc))!=GOOD)
      return err;
   return GOOD;
}
/****************************************************************
**
**     ProcessIsModuleHasRange
**
*****************************************************************/
RETCODE ProcessIsFuncHasRange(char *moduleNameL,
   char *funcNameL,BOOLEAN *isWhat,U32 *pickRanges) {
char startRangeAddrText[11*MAX_SEG_NUM],endRangeAddrText[11*MAX_SEG_NUM];
char rangeName[MAXLEN];
char startFuncAddrText[11*MAX_SEG_NUM],endFuncAddrText[11*MAX_SEG_NUM];
U8 u8Selected,u8Count,i;
DESCRIPTOR startRangeAddrDesc,endRangeAddrDesc;
DESCRIPTOR startFuncAddrDesc,endFuncAddrDesc;
ADDR_COMPARE startResult,endResult;
   *pickRanges=0l;
   *(pickRanges+1)=0l;
   *isWhat=TRUE;
   SpaRangesCountGet(nSPAstatus,&u8Count);
   for (i=0;i<u8Count;i++) {
      if (i>0) {
         if (i<16)
            *pickRanges=*pickRanges<<1;
         else
            *(pickRanges+1)=*(pickRanges+1)<<1;
      }
      SpaRangesGetByIndex(i,nSPAstatus,rangeName,
         startRangeAddrText,endRangeAddrText,&u8Selected);
      AdrCreateAddressFromText(startRangeAddrText,NULL,
         &startRangeAddrDesc);
      AdrCreateAddressFromText(endRangeAddrText,NULL,
         &endRangeAddrDesc);
      GetStartAndEndAddr(moduleNameL,funcNameL,
         startFuncAddrText,endFuncAddrText);
      AdrCreateAddressFromText(startFuncAddrText,NULL,
         &startFuncAddrDesc);
      AdrCreateAddressFromText(endFuncAddrText,NULL,
         &endFuncAddrDesc);
      AdrComparePhysicalAddresses(startRangeAddrDesc,startFuncAddrDesc,
         &startResult);
      AdrComparePhysicalAddresses(endRangeAddrDesc,startFuncAddrDesc,
         &endResult);
      if ((startResult==SECOND_ADDR_GREATER) && (endResult==
	 SECOND_ADDR_GREATER))
         *isWhat=FALSE;
      AdrComparePhysicalAddresses(startRangeAddrDesc,endFuncAddrDesc,
         &startResult);
      AdrComparePhysicalAddresses(endRangeAddrDesc,endFuncAddrDesc,
         &endResult);
      if ((startResult==FIRST_ADDR_GREATER) && (endResult==
	 FIRST_ADDR_GREATER))
         *isWhat=FALSE;
      if (*isWhat) {
         if (i<16)
            *pickRanges=*pickRanges|0x0001;
         else
            *(pickRanges+1)=*(pickRanges+1)|0x0001;
      }
      else
         *isWhat=TRUE;
   }
   if (*pickRanges>0 || *(pickRanges+1)>0)
      *isWhat=TRUE;
   else
      *isWhat=FALSE;
   //Hera 12/19/97
   AdrDestroyAddress(startRangeAddrDesc);
   AdrDestroyAddress(endRangeAddrDesc);
   AdrDestroyAddress(startFuncAddrDesc);
   AdrDestroyAddress(endFuncAddrDesc);
   //Hera
   return GOOD;
}
/****************************************************************
**
**     ProcessTabInText
**
*****************************************************************/
RETCODE ProcessTabInText(char *orgStr,char *desStr) {
char *tempChar;
U8 i;
   tempChar=desStr;
   while (*orgStr!='\0') {
      if (*orgStr=='\t')
         for (i=0;i<tabWidth;i++) {
             *tempChar=' ';
             tempChar++;
         }
      else {
         *tempChar=*orgStr;
         tempChar++;
      }
      orgStr++;
  }
  *tempChar='\0';
  return GOOD;
}
/************************************************************************
**
**          ErrMessageBoxL
**
*************************************************************************/
RETCODE ErrMessageBoxL(char *displayString) {
static U16 callcount=0;

   if (callcount>0)
      return GOOD;
   callcount++;
   MessageBox(hWndSPA,displayString,"MP/SLD",MB_OK);
   callcount--;
   return GOOD;
}
/*****************************************************************************
**
**  GetRangePercent
**
*****************************************************************************/
RETCODE GetRangePercent(char *startText,char *endText,U16 *percent) {
U8 startBit;
//U16 i,j,count,numByte; //Eric 7/9/98 
U32 i,j,count,numByte;
LPSTR ptrMemPercent,tempPtrMem;
char tempStartText[11*MAX_SEG_NUM],tempEndText[11*MAX_SEG_NUM];
DESCRIPTOR startDesc,endDesc;
BOOLEAN flagStop;
U32 u32Offset;
RETCODE err;
U32 startOffset,endOffset;//Eric 2/9/98

   if (!canGetCCFlag) {
      *percent=0;
      return GOOD;
   }
   strcpy(tempStartText,startText);
   strcpy(tempEndText,endText);
   AdrCreateAddressFromText(tempStartText,NULL,&startDesc);
   AdrCreateAddressFromText(tempEndText,NULL,&endDesc);
   //AdrRangeOfAddresses(startDesc,endDesc,&numByte); //Eric 2/9/98
   //Fixed bug for multiple segment by Eric 2/9/98
   if (AdrRangeOfAddresses(startDesc,endDesc,&numByte) == ER_ADR_DIFFER_SEGMENTS) {
      AdrGetAddrPhysicalOffset(startDesc,&startOffset);
      AdrGetAddrPhysicalOffset(endDesc,&endOffset);
      if (startOffset < endOffset) numByte = endOffset - startOffset;
      else numByte = startOffset - endOffset;
   }
   //eof Eric 2/9/98
   ptrMemPercent=tempPtrMem=(LPSTR)TMalloc((numByte/8+1)*sizeof(U8));
   flagStop=1;
   SpaCCGet(startText,endText,tempPtrMem,&flagStop);
   if ((err=AdrGetAddrOffset(startDesc,&u32Offset))!=GOOD)
      return err;
   startBit=u32Offset%8;
   i=0;
   j=startBit;
   count=0;
   while (i<numByte) {
      if (j==8) {
         j=0;
         tempPtrMem=tempPtrMem+1;
      }
      if (*tempPtrMem&(0x01<<j))
         count++;
      j++;
      i++;
   }
   *percent=count*100/numByte;
   AdrDestroyAddress(startDesc);
   AdrDestroyAddress(endDesc);
   TFree(ptrMemPercent);
   return GOOD;
}
/***********************************************************
**
**              DeleteBlank
**
************************************************************/
void DeleteBlank(LPSTR lpszin, LPSTR lpszout) {
int i,j;

   j=0;
   for (i=0;i<lstrlen(lpszin);i++)
      if (lpszin[i]!=' ') {
         lpszout[j]=lpszin[i];
         j=j+1;
      }
   lpszout[j]='\0';
}
/********************************EOF*********************************/
